/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.export;

import com.hp.hpl.jena.ontology.OntModel;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.ExportPlugin;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.jena.JenaFilePanel;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.storage.ProtegeSaver;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Level;

public class JenaExportPlugin
implements ExportPlugin {
    public void dispose() {
    }

    public String getName() {
        return "OWL";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleExportRequest(Project project) {
        if (project.getKnowledgeBase() instanceof JenaOWLModel) {
            ProtegeUI.getModalDialogFactory().showMessageDialog((OWLModel)project.getKnowledgeBase(), "This project is already an OWL Files project.");
        } else {
            JenaFilePanel jenaFilePanel = new JenaFilePanel();
            int n = ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(project), jenaFilePanel, "OWL File to Export", 11);
            if (n == 1) {
                String string = jenaFilePanel.getOWLFilePath();
                WaitCursor waitCursor = new WaitCursor((Component)ProjectManager.getProjectManager().getMainPanel());
                try {
                    this.exportProject(project.getKnowledgeBase(), string);
                }
                catch (Exception exception) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                    ProtegeUI.getModalDialogFactory().showErrorMessageDialog(jenaFilePanel, "Export failed. Please see console for details.\n" + exception);
                }
                finally {
                    waitCursor.hide();
                }
            }
        }
    }

    private void exportProject(KnowledgeBase knowledgeBase, String string) {
        ArrayList arrayList = new ArrayList();
        JenaKnowledgeBaseFactory jenaKnowledgeBaseFactory = new JenaKnowledgeBaseFactory();
        Project project = Project.createNewProject((KnowledgeBaseFactory)jenaKnowledgeBaseFactory, arrayList);
        URI uRI = new File(string).toURI();
        project.setProjectURI(uRI);
        JenaOWLModel jenaOWLModel = (JenaOWLModel)project.getKnowledgeBase();
        if (knowledgeBase instanceof OWLDatabaseModel) {
            OntModel ontModel = ((OWLDatabaseModel)knowledgeBase).getOntModel();
            jenaOWLModel.save(uRI, "RDF/XML", arrayList, ontModel);
        } else {
            new ProtegeSaver(knowledgeBase, jenaOWLModel).run();
            jenaOWLModel.save(uRI, "RDF/XML-ABBREV", arrayList);
        }
        if (arrayList.size() == 0) {
            ProtegeUI.getModalDialogFactory().showMessageDialog(jenaOWLModel, "Project has been exported to " + string);
        } else {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(jenaOWLModel, "Export Failed: " + arrayList.iterator().next());
        }
    }
}

