/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.creator;

import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaNormalizer;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.creator.ProgressDisplay;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JenaCreator {
    private Map anonMap = new HashMap();
    private int classCount;
    private int classProgressCount;
    private boolean forReasoning;
    private boolean inferred;
    private boolean logging = false;
    private OWLModel owlModel;
    private OntModel ontModel;
    private Model owlFullModel;
    private ProgressDisplay progressDisplay;
    private Set systemOwnSlots = new HashSet();
    private Collection targetClses;
    private Map todoIndividualsWithObjectProperties = new HashMap();
    public static final String LOGGING_PROPERTY = JenaCreator.class.getName() + ".logging";

    public JenaCreator(OWLModel oWLModel, Collection collection, ProgressDisplay progressDisplay) {
        this(oWLModel, false, false, collection, progressDisplay);
    }

    public JenaCreator(OWLModel oWLModel, boolean bl, Collection collection, ProgressDisplay progressDisplay) {
        this(oWLModel, bl, false, collection, progressDisplay);
    }

    public JenaCreator(OWLModel oWLModel, boolean bl, boolean bl2, Collection collection, ProgressDisplay progressDisplay) {
        this.targetClses = collection;
        this.inferred = bl2;
        this.owlModel = oWLModel;
        this.forReasoning = bl;
        this.progressDisplay = progressDisplay;
        this.systemOwnSlots.add(oWLModel.getRDFProperty("owl:cardinality"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("owl:minCardinality"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("owl:maxCardinality"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("owl:allValuesFrom"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("owl:someValuesFrom"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("owl:hasValue"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("owl:onProperty"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("owl:imports"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty(":OWL-ONTOLOGY-PREFIXES"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("owl:complementOf"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("owl:intersectionOf"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("owl:unionOf"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("owl:equivalentClass"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("rdfs:subClassOf"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("rdf:type"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("protege:inferredSuperclassOf"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("protege:inferredSubclassOf"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("protege:inferredType"));
        this.systemOwnSlots.add(oWLModel.getRDFProperty("protege:classificationStatus"));
        this.logging = ApplicationProperties.getBooleanProperty((String)LOGGING_PROPERTY, (boolean)false);
    }

    private void addDisjointClasses(OWLNamedClass oWLNamedClass, OntClass ontClass) {
        for (RDFSClass rDFSClass : oWLNamedClass.getDisjointClasses()) {
            OntClass ontClass2 = this.getOntClass(rDFSClass);
            ontClass.addDisjointWith((Resource)ontClass2);
        }
    }

    private void addEquivalentClasses(OWLNamedClass oWLNamedClass, OntClass ontClass) {
        Collection collection = this.inferred ? oWLNamedClass.getInferredEquivalentClasses() : oWLNamedClass.getEquivalentClasses();
        for (RDFSClass rDFSClass : collection) {
            OntClass ontClass2 = this.getOntClass(rDFSClass);
            ontClass.addEquivalentClass((Resource)ontClass2);
        }
    }

    private void addEquivalentProperties(OWLProperty oWLProperty, OntProperty ontProperty) {
        for (OWLProperty oWLProperty2 : oWLProperty.getEquivalentProperties()) {
            OntProperty ontProperty2 = this.getOntProperty(oWLProperty2);
            ontProperty.addEquivalentProperty((Property)ontProperty2);
        }
    }

    private void addImports(OWLOntology oWLOntology, Ontology ontology) {
        String string = this.ontModel.getNsPrefixURI("");
        if (string.endsWith("#")) {
            string = string.substring(0, string.length() - 1);
        }
        this.ontModel.getDocumentManager().addIgnoreImport(string);
        for (String string2 : oWLOntology.getImports()) {
            ontology.addImport(this.ontModel.getResource(string2));
            this.ontModel.getDocumentManager().loadImport(this.ontModel, string2);
        }
    }

    private void addPropertyValues(RDFResource rDFResource, OntResource ontResource) {
        if (!this.forReasoning) {
            Collection collection = rDFResource.getPossibleRDFProperties();
            collection.add(this.owlModel.getRDFProperty(":SLOT-CONSTRAINTS"));
            for (RDFProperty rDFProperty : collection) {
                if (this.isSystemOwnSlot(rDFResource, rDFProperty) && !rDFProperty.isAnnotationProperty()) continue;
                if (rDFResource instanceof RDFIndividual && rDFProperty instanceof OWLObjectProperty && rDFResource.getPropertyValueCount(rDFProperty) > 0) {
                    ArrayList<RDFProperty> arrayList = (ArrayList<RDFProperty>)this.todoIndividualsWithObjectProperties.get(rDFResource);
                    if (arrayList == null) {
                        arrayList = new ArrayList<RDFProperty>();
                        this.todoIndividualsWithObjectProperties.put(rDFResource, arrayList);
                    }
                    arrayList.add(rDFProperty);
                    continue;
                }
                this.addPropertyValues(rDFResource, ontResource, rDFProperty);
            }
        }
    }

    private void addPropertyValues2(RDFResource rDFResource, OntResource ontResource) {
        List list = (List)this.todoIndividualsWithObjectProperties.get(rDFResource);
        for (RDFProperty rDFProperty : list) {
            this.addPropertyValues(rDFResource, ontResource, rDFProperty);
        }
    }

    private void addPropertyValues(RDFResource rDFResource, OntResource ontResource, RDFProperty rDFProperty) {
        Property property = this.getProperty(rDFProperty);
        RDFSDatatype rDFSDatatype = rDFProperty.getRangeDatatype();
        for (Object e : rDFResource.getPropertyValues(rDFProperty)) {
            Resource resource;
            if (e instanceof RDFResource) {
                resource = this.getResource((RDFResource)e);
                ontResource.addProperty(property, (RDFNode)resource);
                continue;
            }
            if (this.owlModel.getRDFXMLLiteralType().equals(rDFSDatatype)) {
                ontResource.addProperty(property, (RDFNode)this.ontModel.createTypedLiteral(e, XMLLiteralType.theXMLLiteralType));
                continue;
            }
            resource = JenaCreator.createLiteral(e, this.ontModel);
            ontResource.addProperty(property, (RDFNode)resource);
        }
    }

    private void addSuperclasses(RDFSNamedClass rDFSNamedClass, OntClass ontClass) {
        Cls cls;
        Collection collection = rDFSNamedClass.getPureSuperclasses();
        if (this.inferred && rDFSNamedClass instanceof OWLNamedClass) {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)rDFSNamedClass;
            Cls cls2 = collection.iterator();
            while (cls2.hasNext()) {
                cls = (Cls)cls2.next();
                if (!(cls instanceof RDFSNamedClass)) continue;
                cls2.remove();
            }
            collection.addAll(oWLNamedClass.getInferredSuperclasses());
            collection.removeAll(oWLNamedClass.getInferredEquivalentClasses());
        }
        if (!(collection.size() <= 0 || collection.size() <= 1 && collection.iterator().next().equals(this.owlModel.getOWLThingClass()))) {
            for (Cls cls2 : collection) {
                cls = (RDFSClass)cls2;
                OntClass ontClass2 = this.getOntClass((RDFSClass)cls);
                ontClass.addSuperClass((Resource)ontClass2);
            }
        }
    }

    private void addSuperproperties(RDFProperty rDFProperty, OntProperty ontProperty) {
        for (RDFProperty rDFProperty2 : rDFProperty.getSuperproperties(false)) {
            OntProperty ontProperty2 = this.getOntProperty(rDFProperty2);
            ontProperty.addSuperProperty((Property)ontProperty2);
        }
    }

    private void addTodoPropertyValues() {
        for (RDFResource rDFResource : this.todoIndividualsWithObjectProperties.keySet()) {
            OntResource ontResource = this.getOntResource(rDFResource);
            this.addPropertyValues2(rDFResource, ontResource);
        }
    }

    private void createAdditionalAnonymousSuperclassesOfIncludedClass(OWLNamedClass oWLNamedClass) {
        OntClass ontClass = this.ontModel.getOntClass(oWLNamedClass.getURI());
        for (Cls cls : oWLNamedClass.getSuperclasses(false)) {
            if (!(cls instanceof OWLAnonymousClass) || cls.isIncluded()) continue;
            OntClass ontClass2 = this.getOntClass((OWLAnonymousClass)cls);
            if (cls.hasDirectSuperclass((Cls)oWLNamedClass)) {
                ontClass.addEquivalentClass((Resource)ontClass2);
                continue;
            }
            ontClass.addSuperClass((Resource)ontClass2);
        }
    }

    private OntClass createAnonymousClass(OWLAnonymousClass oWLAnonymousClass) {
        if (oWLAnonymousClass instanceof OWLLogicalClass) {
            return this.createLogicalClass((OWLLogicalClass)oWLAnonymousClass);
        }
        if (oWLAnonymousClass instanceof OWLEnumeratedClass) {
            return this.createEnumeratedClass((OWLEnumeratedClass)oWLAnonymousClass);
        }
        return this.createRestriction((OWLRestriction)oWLAnonymousClass);
    }

    private Restriction createCardinalityRestriction(OWLCardinalityBase oWLCardinalityBase) {
        int n = oWLCardinalityBase.getCardinality();
        RDFProperty rDFProperty = oWLCardinalityBase.getOnProperty();
        OntProperty ontProperty = this.getOntProperty(rDFProperty);
        if (oWLCardinalityBase instanceof OWLMaxCardinality) {
            return this.ontModel.createMaxCardinalityRestriction(null, (Property)ontProperty, n);
        }
        if (oWLCardinalityBase instanceof OWLMinCardinality) {
            return this.ontModel.createMinCardinalityRestriction(null, (Property)ontProperty, n);
        }
        return this.ontModel.createCardinalityRestriction(null, (Property)ontProperty, n);
    }

    public static DataRange createDataRange(OWLDataRange oWLDataRange, OntModel ontModel) {
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        if (oWLDataRange.getOneOf() != null) {
            for (Object e : oWLDataRange.getOneOf().getValues()) {
                Literal literal = JenaCreator.createLiteral(e, ontModel);
                arrayList.add(literal);
            }
        }
        RDFList rDFList = ontModel.createList(arrayList.iterator());
        return ontModel.createDataRange(rDFList);
    }

    private static Literal createLiteral(Object object, OntModel ontModel) {
        if (object instanceof RDFSLiteral) {
            RDFSLiteral rDFSLiteral = (RDFSLiteral)object;
            if (rDFSLiteral.getLanguage() != null) {
                return ontModel.createLiteral(rDFSLiteral.getString(), rDFSLiteral.getLanguage());
            }
            return ontModel.createTypedLiteral(rDFSLiteral.getString(), XMLSchemaDatatypes.getRDFDatatype(rDFSLiteral.getDatatype()));
        }
        return ontModel.createTypedLiteral(object);
    }

    private OntProperty createDatatypeProperty(OWLDatatypeProperty oWLDatatypeProperty) {
        DatatypeProperty datatypeProperty = this.ontModel.createDatatypeProperty(oWLDatatypeProperty.getURI());
        this.adjustOntPropertyRDFType(oWLDatatypeProperty, (OntProperty)datatypeProperty);
        return datatypeProperty;
    }

    private EnumeratedClass createEnumeratedClass(OWLEnumeratedClass oWLEnumeratedClass) {
        RDFList rDFList = this.createOntResourceList(oWLEnumeratedClass.getOneOf());
        return this.ontModel.createEnumeratedClass(null, rDFList);
    }

    private HasValueRestriction createHasValueRestriction(OWLHasValue oWLHasValue) {
        OntProperty ontProperty = this.getOntProperty(oWLHasValue.getOnProperty());
        Object object = null;
        Object object2 = oWLHasValue.getHasValue();
        object = object2 instanceof RDFResource ? this.getIndividual((RDFResource)object2) : this.ontModel.createTypedLiteral(object2);
        return this.ontModel.createHasValueRestriction(null, (Property)ontProperty, (RDFNode)object);
    }

    private Individual createIndividual(RDFResource rDFResource, boolean bl) {
        if (this.logging) {
            this.log("Creating RDFIndividual for " + rDFResource.getBrowserText());
        }
        Iterator iterator = null;
        iterator = this.inferred && !rDFResource.getInferredTypes().isEmpty() ? rDFResource.getInferredTypes().iterator() : rDFResource.getProtegeTypes().iterator();
        RDFSClass rDFSClass = (RDFSClass)iterator.next();
        OntClass ontClass = this.getOntClass(rDFSClass);
        Individual individual = this.ontModel.getIndividual(rDFResource.getURI());
        if (individual == null) {
            String string = null;
            if (!rDFResource.isAnonymous() && !rDFSClass.equals(this.owlModel.getRDFListClass())) {
                string = rDFResource.getURI();
            }
            individual = this.ontModel.createIndividual(string, (Resource)ontClass);
            while (iterator.hasNext()) {
                RDFSClass rDFSClass2 = (RDFSClass)iterator.next();
                OntClass ontClass2 = this.getOntClass(rDFSClass2);
                if (ontClass2 == null) continue;
                individual.addRDFType((Resource)ontClass2);
            }
            if (bl) {
                this.anonMap.put(rDFResource, individual);
            }
            this.addPropertyValues(rDFResource, (OntResource)individual);
        }
        return individual;
    }

    private void createIndividuals() {
        Iterator iterator = this.getRDFSClassIterator();
        while (iterator.hasNext()) {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)iterator.next();
            for (Instance instance : rDFSNamedClass.getInstances(false)) {
                if (!(instance instanceof RDFResource) || instance instanceof RDFProperty) continue;
                RDFResource rDFResource = (RDFResource)instance;
                this.getOntResource(rDFResource);
            }
        }
    }

    private OntClass createLogicalClass(OWLLogicalClass oWLLogicalClass) {
        if (oWLLogicalClass instanceof OWLNAryLogicalClass) {
            ArrayList<OntClass> arrayList = new ArrayList<OntClass>();
            OWLNAryLogicalClass oWLNAryLogicalClass = (OWLNAryLogicalClass)oWLLogicalClass;
            for (RDFSClass rDFSClass : oWLNAryLogicalClass.getOperands()) {
                arrayList.add(this.getOntClass(rDFSClass));
            }
            if (oWLLogicalClass instanceof OWLIntersectionClass) {
                return this.ontModel.createIntersectionClass(null, this.ontModel.createList(arrayList.iterator()));
            }
            return this.ontModel.createUnionClass(null, this.ontModel.createList(arrayList.iterator()));
        }
        OWLComplementClass oWLComplementClass = (OWLComplementClass)oWLLogicalClass;
        RDFSClass rDFSClass = oWLComplementClass.getComplement();
        return this.ontModel.createComplementClass(null, (Resource)this.getOntClass(rDFSClass));
    }

    private OntClass createNamedClass(RDFSNamedClass rDFSNamedClass) {
        if (this.logging) {
            this.log("Creating named OntClass for " + rDFSNamedClass.getBrowserText());
        }
        ++this.classProgressCount;
        if (this.progressDisplay != null) {
            this.progressDisplay.setProgressValue((double)this.classProgressCount / (double)this.classCount);
        }
        OntClass ontClass = this.ontModel.createClass(rDFSNamedClass.getURI());
        if (!this.forReasoning) {
            for (RDFSClass rDFSClass : rDFSNamedClass.getRDFTypes()) {
                if (this.owlModel.getOWLNamedClassClass().equals(rDFSClass)) continue;
                ontClass.addRDFType((Resource)this.getOntClass(rDFSClass));
            }
        }
        if (rDFSNamedClass.isDeprecated()) {
            ontClass.addRDFType(OWL.DeprecatedClass);
        }
        this.addSuperclasses(rDFSNamedClass, ontClass);
        if (rDFSNamedClass instanceof OWLNamedClass) {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)rDFSNamedClass;
            this.addEquivalentClasses(oWLNamedClass, ontClass);
            this.addDisjointClasses(oWLNamedClass, ontClass);
        }
        this.addPropertyValues(rDFSNamedClass, (OntResource)ontClass);
        return ontClass;
    }

    private OntProperty createObjectProperty(OWLObjectProperty oWLObjectProperty) {
        ObjectProperty objectProperty = this.ontModel.createObjectProperty(oWLObjectProperty.getURI());
        this.adjustOntPropertyRDFType(oWLObjectProperty, (OntProperty)objectProperty);
        if (oWLObjectProperty.isSymmetric()) {
            objectProperty.addRDFType(OWL.SymmetricProperty);
        }
        if (oWLObjectProperty.isTransitive()) {
            objectProperty.addRDFType(OWL.TransitiveProperty);
        }
        if (oWLObjectProperty.getInverseProperty() instanceof OWLObjectProperty) {
            OWLObjectProperty oWLObjectProperty2 = (OWLObjectProperty)oWLObjectProperty.getInverseProperty();
            OntProperty ontProperty = this.getOntProperty(oWLObjectProperty2);
            objectProperty.setInverseOf((Property)ontProperty);
        }
        return objectProperty;
    }

    private void createOntClasses() {
        Iterator iterator = this.getRDFSClassIterator();
        while (iterator.hasNext()) {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)iterator.next();
            this.getOntClass(rDFSNamedClass);
            if (!(rDFSNamedClass instanceof OWLNamedClass) || !rDFSNamedClass.isIncluded()) continue;
            this.createAdditionalAnonymousSuperclassesOfIncludedClass((OWLNamedClass)rDFSNamedClass);
        }
    }

    public OntModel createOntModel() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM);
        ontModelSpec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec, null);
        Model model = Jena.addOWLFullModel(ontModel);
        this.run(ontModel, model);
        return ontModel;
    }

    public OntModel createOntModelWithoutOWLFullModel() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM);
        ontModelSpec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec, null);
        Model model = Jena.addOWLFullModel(ontModel);
        this.run(ontModel, model);
        ontModel.removeSubModel(model);
        return ontModel;
    }

    private void createOntologies() {
        for (OWLOntology oWLOntology : this.owlModel.getOWLOntologyClass().getInstances(false)) {
            if (oWLOntology.isIncluded() && !oWLOntology.equals(this.owlModel.getDefaultOWLOntology())) continue;
            String string = oWLOntology.getURI();
            Ontology ontology = this.ontModel.createOntology(string);
            this.addImports(oWLOntology, ontology);
            JenaNormalizer.assignRDFTypesToMetaclassInstances(this.ontModel, this.owlFullModel);
            this.addPropertyValues(oWLOntology, (OntResource)ontology);
        }
        Jena.ensureOWLFullModelIsLastModel(this.ontModel, this.owlFullModel);
    }

    OntProperty createOntProperty(RDFProperty rDFProperty) {
        if (this.logging) {
            this.log("Creating OntProperty for " + rDFProperty.getBrowserText());
        }
        OntProperty ontProperty = null;
        ontProperty = rDFProperty instanceof OWLDatatypeProperty ? this.createDatatypeProperty((OWLDatatypeProperty)rDFProperty) : (rDFProperty instanceof OWLObjectProperty ? this.createObjectProperty((OWLObjectProperty)rDFProperty) : this.createRDFProperty(rDFProperty));
        if (rDFProperty.isAnnotationProperty()) {
            ontProperty.addRDFType(OWL.AnnotationProperty);
        }
        if (rDFProperty.isDeprecated()) {
            ontProperty.addRDFType(OWL.DeprecatedProperty);
        }
        this.addSuperproperties(rDFProperty, ontProperty);
        this.addPropertyValues(rDFProperty, (OntResource)ontProperty);
        this.setPropertyDomain(rDFProperty, ontProperty);
        if (rDFProperty.isFunctional()) {
            ontProperty.addRDFType(OWL.FunctionalProperty);
        }
        if (rDFProperty instanceof OWLProperty) {
            OWLProperty oWLProperty = (OWLProperty)rDFProperty;
            if (oWLProperty.isInverseFunctional()) {
                ontProperty.addRDFType(OWL.InverseFunctionalProperty);
            }
            this.addEquivalentProperties(oWLProperty, ontProperty);
        }
        return ontProperty;
    }

    private void adjustOntPropertyRDFType(RDFProperty rDFProperty, OntProperty ontProperty) {
        if (!this.forReasoning && !rDFProperty.getProtegeType().isSystem()) {
            OntClass ontClass = this.getOntClass(rDFProperty.getProtegeType());
            ontProperty.setRDFType((Resource)ontClass);
            this.owlFullModel.add((Resource)ontProperty, RDF.type, (RDFNode)RDF.Property);
        }
    }

    private void createOntProperties() {
        for (RDFProperty rDFProperty : this.owlModel.getUserDefinedRDFProperties()) {
            if (!rDFProperty.isEditable()) continue;
            this.getOntProperty(rDFProperty);
        }
    }

    private RDFList createOntResourceList(Collection collection) {
        ArrayList<OntResource> arrayList = new ArrayList<OntResource>();
        for (RDFResource rDFResource : collection) {
            OntResource ontResource = this.getOntResource(rDFResource);
            arrayList.add(ontResource);
        }
        return this.ontModel.createList(arrayList.iterator());
    }

    private void createPrefixes(OntModel ontModel) {
        Set set = ontModel.getNsPrefixMap().keySet();
        for (Object object : set) {
            ontModel.removeNsPrefix((String)object);
        }
        String string = this.owlModel.getNamespaceManager().getDefaultNamespace();
        ontModel.setNsPrefix("", string);
        for (String string2 : this.owlModel.getNamespaceManager().getPrefixes()) {
            String string3 = this.owlModel.getNamespaceManager().getNamespaceForPrefix(string2);
            ontModel.setNsPrefix(string2, string3);
        }
    }

    private Restriction createQuantifierRestriction(OWLQuantifierRestriction oWLQuantifierRestriction) {
        OntProperty ontProperty = this.getOntProperty(oWLQuantifierRestriction.getOnProperty());
        RDFResource rDFResource = oWLQuantifierRestriction.getFiller();
        OntResource ontResource = null;
        if (rDFResource instanceof RDFSClass) {
            ontResource = this.getOntResource(oWLQuantifierRestriction.getFiller());
        } else if (rDFResource instanceof OWLDataRange) {
            ontResource = JenaCreator.createDataRange((OWLDataRange)rDFResource, this.ontModel);
        } else {
            String string = rDFResource.getURI();
            ontResource = this.ontModel.getResource(string);
        }
        if (oWLQuantifierRestriction instanceof OWLAllValuesFrom) {
            return this.ontModel.createAllValuesFromRestriction(null, (Property)ontProperty, (Resource)ontResource);
        }
        return this.ontModel.createSomeValuesFromRestriction(null, (Property)ontProperty, (Resource)ontResource);
    }

    private OntProperty createRDFProperty(RDFProperty rDFProperty) {
        OntProperty ontProperty = this.ontModel.createOntProperty(rDFProperty.getURI());
        this.adjustOntPropertyRDFType(rDFProperty, ontProperty);
        return ontProperty;
    }

    private Restriction createRestriction(OWLRestriction oWLRestriction) {
        if (oWLRestriction instanceof OWLQuantifierRestriction) {
            return this.createQuantifierRestriction((OWLQuantifierRestriction)oWLRestriction);
        }
        if (oWLRestriction instanceof OWLCardinalityBase) {
            return this.createCardinalityRestriction((OWLCardinalityBase)oWLRestriction);
        }
        return this.createHasValueRestriction((OWLHasValue)oWLRestriction);
    }

    private void ensureProtegeMetaOntologyImported() {
        Ontology ontology = this.getDefaultOntology();
        Resource resource = this.ontModel.getResource(ProtegeNames.FILE);
        if (!Jena.set((Iterator)ontology.listImports()).contains(resource)) {
            ontology.addImport(resource);
            this.ontModel.getDocumentManager().loadImport(this.ontModel, ProtegeNames.FILE);
        }
    }

    private Ontology getDefaultOntology() {
        return (Ontology)this.ontModel.listOntologies().next();
    }

    private Individual getIndividual(RDFResource rDFResource) {
        if (rDFResource.isAnonymous()) {
            Individual individual = (Individual)this.anonMap.get(rDFResource);
            if (individual != null) {
                return individual;
            }
            return this.createIndividual(rDFResource, true);
        }
        Individual individual = this.ontModel.getIndividual(rDFResource.getURI());
        if (individual == null) {
            individual = this.createIndividual(rDFResource, false);
        }
        return individual;
    }

    private Iterator getRDFSClassIterator() {
        Collection collection = null;
        if (this.targetClses != null) {
            collection = this.targetClses;
        } else {
            collection = this.owlModel.getUserDefinedRDFSNamedClasses();
            if (this.owlModel instanceof JenaOWLModel) {
                collection.add(this.owlModel.getRDFSNamedClass(":PAL-CONSTRAINT"));
            }
            collection.add(this.owlModel.getOWLThingClass());
        }
        this.classCount = collection.size();
        return collection.iterator();
    }

    private OntClass getOntClass(RDFSClass rDFSClass) {
        if (rDFSClass instanceof RDFSNamedClass) {
            Resource resource;
            if (rDFSClass.isIncluded() && !(resource = this.ontModel.getResource(rDFSClass.getURI())).hasProperty(RDF.type, (RDFNode)RDFS.Class) && !resource.hasProperty(RDF.type, (RDFNode)OWL.Class)) {
                this.owlFullModel.add(this.ontModel.getResource(rDFSClass.getURI()), RDF.type, (RDFNode)OWL.Class);
            }
            if ((resource = this.ontModel.getOntClass(rDFSClass.getURI())) == null) {
                resource = this.createNamedClass((RDFSNamedClass)rDFSClass);
            }
            return resource;
        }
        OntClass ontClass = this.createAnonymousClass((OWLAnonymousClass)rDFSClass);
        this.addPropertyValues(rDFSClass, (OntResource)ontClass);
        return ontClass;
    }

    public OntModel getOntModel() {
        return this.ontModel;
    }

    private OntProperty getOntProperty(RDFProperty rDFProperty) {
        String string = rDFProperty.getURI();
        Resource resource = this.ontModel.getResource(string);
        if (resource != null && resource.canAs(OntProperty.class)) {
            return (OntProperty)resource.as(OntProperty.class);
        }
        return this.createOntProperty(rDFProperty);
    }

    private OntResource getOntResource(RDFResource rDFResource) {
        if (rDFResource instanceof RDFSClass) {
            return this.getOntClass((RDFSClass)rDFResource);
        }
        if (rDFResource instanceof RDFProperty) {
            return this.getOntProperty((RDFProperty)rDFResource);
        }
        return this.getIndividual(rDFResource);
    }

    public Model getOWLFullModel() {
        return this.owlFullModel;
    }

    private Property getProperty(RDFProperty rDFProperty) {
        if (rDFProperty.isEditable()) {
            return this.getOntProperty(rDFProperty);
        }
        return this.ontModel.getProperty(rDFProperty.getURI());
    }

    private Resource getResource(RDFResource rDFResource) {
        if (rDFResource instanceof RDFSDatatype && !rDFResource.isEditable()) {
            return this.ontModel.getResource(rDFResource.getURI());
        }
        return this.getOntResource(rDFResource);
    }

    private boolean isSystemOwnSlot(Instance instance, Slot slot) {
        if (instance instanceof OWLEnumeratedClass && slot.getName().equals("owl:oneOf")) {
            return true;
        }
        return this.systemOwnSlots.contains(slot);
    }

    private void log(String string) {
        if (this.logging) {
            System.out.println("[JenaCreator] " + string);
        }
    }

    public void run(OntModel ontModel, Model model) {
        long l = System.currentTimeMillis();
        this.log("Starting JenaCreator...");
        this.ontModel = ontModel;
        this.owlFullModel = model;
        if (this.progressDisplay != null) {
            this.progressDisplay.start();
            this.progressDisplay.setProgressText("Creating classes...");
        }
        this.createPrefixes(ontModel);
        this.createOntologies();
        this.createOntClasses();
        if (this.targetClses == null) {
            if (this.progressDisplay != null) {
                this.progressDisplay.setProgressText("Creating properties...");
            }
            this.createOntProperties();
        }
        if (this.progressDisplay != null) {
            this.progressDisplay.setProgressText("Creating individuals...");
        }
        this.createIndividuals();
        this.addTodoPropertyValues();
        this.createAllDifferents();
        this.log("Terminated after " + (System.currentTimeMillis() - l) + " ms");
        if (this.progressDisplay != null) {
            this.progressDisplay.stop();
        }
    }

    private void createAllDifferents() {
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFSNamedClass("owl:AllDifferent");
        for (OWLAllDifferent oWLAllDifferent : rDFSNamedClass.getInstances(true)) {
            if (oWLAllDifferent.isIncluded()) continue;
            AllDifferent allDifferent = this.ontModel.createAllDifferent();
            for (RDFResource rDFResource : oWLAllDifferent.getDistinctMembers()) {
                Resource resource = this.getResource(rDFResource);
                allDifferent.addDistinctMember(resource);
            }
        }
    }

    private void setPropertyDomain(RDFProperty rDFProperty, OntProperty ontProperty) {
        if (this.owlModel.getOWLThingClass().equals(rDFProperty.getDomain(false))) {
            ontProperty.removeDomain((Resource)ontProperty.getDomain());
        }
    }
}

