/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.OntModelProvider;
import edu.stanford.smi.protegex.owl.jena.creator.JenaCreator;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.jena.protege2jena.Protege2Jena;
import edu.stanford.smi.protegex.owl.jena.triplestore.JenaTripleStoreModel;
import edu.stanford.smi.protegex.owl.jena.writersettings.JenaWriterSettings;
import edu.stanford.smi.protegex.owl.jena.writersettings.WriterSettings;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.resource.OWLText;
import edu.stanford.smi.protegex.owl.ui.widget.ModalProgressBarManager;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelAllTripleStoresWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.ProtegeWriterSettings;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterPreferences;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class JenaOWLModel
extends AbstractOWLModel
implements OntModelProvider {
    public static final String COPYRIGHT = "<!-- Created with Protege (with OWL Plugin " + OWLText.getVersion() + ", Build " + OWLText.getBuildNumber() + ")  http://protege.stanford.edu -->";
    public static boolean inUI = false;
    private TripleStoreModel tripleStoreModel;
    public static final String TEMPLATE_FILE_NAME = "plugins/owl/template.owl";
    public static final String DEFAULT_PREFIX = "default";
    public static final String WRITER_SETTINGS_PROPERTY = JenaOWLModel.class.getName() + ".writer";
    public static final String WRITER_PROTEGE = "protege";

    protected JenaOWLModel(KnowledgeBaseFactory knowledgeBaseFactory, NamespaceManager namespaceManager) {
        super(knowledgeBaseFactory, namespaceManager);
        OWLJavaFactoryUpdater.run(this);
        MergingNarrowFrameStore mergingNarrowFrameStore = MergingNarrowFrameStore.get((KnowledgeBase)this);
        mergingNarrowFrameStore.setTopFrameStore(mergingNarrowFrameStore.getActiveFrameStore().getName());
    }

    private void closeRDFLists() {
        for (Instance instance : this.getCls("rdf:List").getInstances()) {
            RDFList rDFList;
            if (!(instance instanceof RDFList) || !instance.isEditable() || (rDFList = (RDFList)instance).getRest() != null) continue;
            rDFList.setRest(this.getRDFNil());
        }
    }

    public void defaultNamespaceChanged(String string, String string2) {
        super.defaultNamespaceChanged(string, string2);
    }

    public RDFResource getRDFResource(Resource resource) {
        String string = resource.getURI();
        String string2 = this.getResourceNameForURI(string);
        if (string2 != null) {
            return (RDFResource)this.getFrame(string2);
        }
        return null;
    }

    public OntModel getOntModel() {
        return Protege2Jena.createOntModel(this);
    }

    public OntModel getOWLDLOntModel() {
        JenaCreator jenaCreator = new JenaCreator(this, true, null, inUI ? new ModalProgressBarManager("Preparing Ontology") : null);
        return jenaCreator.createOntModelWithoutOWLFullModel();
    }

    public String getOWLFilePath() {
        return this.getOWLProject().getSettingsMap().getString("owl_file_name");
    }

    public int getOWLSpecies() {
        OntModel ontModel = Protege2Jena.createOntModel(this);
        return Jena.getOWLSpecies(ontModel);
    }

    public OntModel getReasonerOntModel(String string) {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://foo.de#foo");
        model.add(resource, ReasonerVocabulary.EXT_REASONER_URL, string);
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", resource);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner((Reasoner)dIGReasoner);
        return Jena.cloneOntModel(this.getOntModel(), ontModelSpec);
    }

    public void setTripleStoreModel(TripleStoreModel tripleStoreModel) {
        this.tripleStoreModel = tripleStoreModel;
    }

    public TripleStoreModel getTripleStoreModel() {
        if (this.tripleStoreModel == null) {
            this.tripleStoreModel = new JenaTripleStoreModel(this);
        }
        return this.tripleStoreModel;
    }

    public WriterSettings getWriterSettings() {
        String string = this.getOWLProject().getSettingsMap().getString(WRITER_SETTINGS_PROPERTY);
        if (WRITER_PROTEGE.equals(string)) {
            return new ProtegeWriterSettings(this);
        }
        return new JenaWriterSettings(this);
    }

    public void initOWLFrameFactoryInvocationHandler() {
        this.setFrameFactory((FrameFactory)new OWLJavaFactory(this));
    }

    public void initPrefixes(OntModel ontModel) {
        NamespaceManager namespaceManager = this.getNamespaceManager();
        this.initPrefixes(namespaceManager, (PrefixMapping)ontModel);
        String string = ontModel.getNsPrefixURI("");
        if (string != null) {
            namespaceManager.setDefaultNamespace(string);
        }
        for (Graph graph : ontModel.getSubGraphs()) {
            PrefixMapping prefixMapping = graph.getPrefixMapping();
            this.initPrefixes(namespaceManager, prefixMapping);
        }
    }

    private void initPrefixes(NamespaceManager namespaceManager, PrefixMapping prefixMapping) {
        Map map = prefixMapping.getNsPrefixMap();
        for (String string : map.keySet()) {
            if (string.length() <= 0) continue;
            String string2 = (String)map.get(string);
            if (namespaceManager.getPrefix(string2) == null && namespaceManager.getNamespaceForPrefix(string) == null) {
                namespaceManager.setPrefix(string2, string);
                continue;
            }
            String string3 = namespaceManager.getNamespaceForPrefix(string);
            if (string3 == null || string3.equals(string2)) continue;
            System.err.println("[JenaOWLModel] Error: Conflicting prefix " + string + " (was: " + string3 + ") was redefined as " + string2);
        }
    }

    public void load(URI uRI, String string) throws Exception {
        ProtegeOWLParser protegeOWLParser = new ProtegeOWLParser(this, false);
        protegeOWLParser.run(uRI);
        TripleStoreUtil.sortSubclasses(this);
        this.copyFacetValuesIntoNamedClses();
    }

    public void load(InputStream inputStream, String string) throws Exception {
        ProtegeOWLParser protegeOWLParser = new ProtegeOWLParser(this, false);
        protegeOWLParser.run(inputStream, "http://dummy-ontologies.com/dummy.owl");
        TripleStoreUtil.sortSubclasses(this);
        this.copyFacetValuesIntoNamedClses();
    }

    public void load(Reader reader, String string) throws Exception {
        ProtegeOWLParser protegeOWLParser = new ProtegeOWLParser(this, false);
        protegeOWLParser.run(reader, "http://dummy-ontologies.com/dummy.owl");
        TripleStoreUtil.sortSubclasses(this);
        this.copyFacetValuesIntoNamedClses();
    }

    public void load(URI uRI, String string, Collection collection) {
        try {
            this.load(uRI, string);
        }
        catch (Throwable throwable) {
            Log.getLogger().log(Level.SEVERE, "Error at loading file " + uRI, throwable);
            Collection collection2 = ProtegeOWLParser.getErrors();
            if (collection2 != null && collection2.size() > 0) {
                collection.addAll(collection2);
            }
            collection.add(throwable);
            String string2 = "Errors at loading OWL file from " + uRI + "\n";
            string2 = string2 + "\nPlease consider running the file through an RDF or OWL validation service such as:";
            string2 = string2 + "\n  - RDF Validator: http://www.w3.org/RDF/Validator";
            string2 = string2 + "\n  - OWL Validator: http://phoebus.cs.man.ac.uk:9999/OWL/Validator";
            if (this.getNamespaceManager().getPrefix("http://protege.stanford.edu/system#") != null || this.getNamespaceManager().getPrefix("http://protege.stanford.edu/kb#") != null) {
                string2 = string2 + "\nThis file seems to have been created with the frame-based Protege RDF Backend. " + "Please try to use the RDF Backend of Protege to open this file and then export it to OWL " + "using Export to Format...";
            }
            collection.add(new MessageError(string2));
        }
        Collection collection3 = ProtegeOWLParser.getErrors();
        if (collection3 != null && collection3.size() > 0) {
            collection.addAll(collection3);
        }
    }

    public void namespaceChanged(String string, String string2, String string3) {
        super.namespaceChanged(string, string2, string3);
    }

    public void prefixAdded(String string) {
        super.prefixAdded(string);
    }

    public void prefixChanged(String string, String string2, String string3) {
        super.prefixChanged(string, string2, string3);
    }

    public void prefixRemoved(String string) {
        super.prefixRemoved(string);
    }

    public void save(URI uRI) throws Exception {
        Protege2Jena.saveAll(this, uRI, "RDF/XML-ABBREV");
    }

    public void save(URI uRI, String string, Collection collection) {
        if (this.getWriterSettings() instanceof JenaWriterSettings) {
            try {
                Protege2Jena.saveAll(this, uRI, string);
            }
            catch (Exception exception) {
                String string2 = "Failed to save file " + uRI + " using Protege2Jena.";
                Log.getLogger().log(Level.SEVERE, string2, exception);
                collection.add(new MessageError(exception, string2));
            }
        } else if (this.getWriterSettings() instanceof ProtegeWriterSettings) {
            ProtegeWriterSettings protegeWriterSettings = (ProtegeWriterSettings)this.getWriterSettings();
            try {
                boolean bl = protegeWriterSettings.getUseXMLEntities();
                XMLWriterPreferences.getInstance().setUseNamespaceEntities(bl);
                OWLModelAllTripleStoresWriter oWLModelAllTripleStoresWriter = new OWLModelAllTripleStoresWriter(this, uRI, protegeWriterSettings.isSortAlphabetically());
                oWLModelAllTripleStoresWriter.write();
            }
            catch (Exception exception) {
                String string3 = "Failed to save file " + uRI;
                Log.getLogger().log(Level.SEVERE, string3, exception);
                collection.add(new MessageError(exception, string3));
            }
        }
    }

    public void save(OutputStream outputStream, String string, Collection collection) {
        this.closeRDFLists();
        this.save(outputStream, string, collection, this.getOntModel());
    }

    public void save(URI uRI, String string, Collection collection, OntModel ontModel) {
        try {
            File file = new File(uRI);
            String string2 = this.getNamespaceManager().getDefaultNamespace();
            JenaOWLModel.save(file, ontModel, string, string2);
        }
        catch (Throwable throwable) {
            String string3 = "Failed to save file " + uRI;
            Log.getLogger().log(Level.SEVERE, string3, throwable);
            collection.add(new MessageError(new Exception(throwable), string3));
        }
    }

    public static void save(File file, OntModel ontModel, String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JenaOWLModel.save(fileOutputStream, ontModel, string, string2);
    }

    public void save(OutputStream outputStream, String string, Collection collection, OntModel ontModel) {
        try {
            String string2 = this.getNamespaceManager().getDefaultNamespace();
            JenaOWLModel.save(outputStream, ontModel, string, string2);
        }
        catch (Throwable throwable) {
            String string3 = "Failed to save file to output stream";
            Log.getLogger().log(Level.SEVERE, string3, throwable);
            collection.add(new MessageError(new Exception(throwable), string3));
        }
    }

    private static void save(OutputStream outputStream, OntModel ontModel, String string, String string2) throws IOException {
        JenaOWLModel.saveModel(outputStream, ontModel.getBaseModel(), string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveModel(OutputStream outputStream, Model model, String string, String string2) throws IOException {
        PrintStream printStream = new PrintStream(outputStream);
        RDFWriter rDFWriter = model.getWriter(string);
        Jena.prepareWriter(rDFWriter, string, string2);
        boolean bl = Jena.isXMLLanguage(string);
        if (bl) {
            String string3 = SystemUtilities.getFileEncoding();
            Set<String> set = Charset.availableCharsets().keySet();
            if (!set.contains(string3)) {
                string3 = "UTF-8";
            }
            rDFWriter.write(model, (Writer)new OutputStreamWriter((OutputStream)printStream, string3), string2);
        } else {
            model.removeNsPrefix("");
            model.setNsPrefix(DEFAULT_PREFIX, string2);
            try {
                rDFWriter.write(model, (OutputStream)printStream, string2);
            }
            finally {
                model.removeNsPrefix(DEFAULT_PREFIX);
                model.setNsPrefix("", string2);
            }
        }
        if (bl) {
            printStream.println();
            printStream.println(COPYRIGHT);
        }
        outputStream.close();
    }

    public void setProjectFileName(String string) {
        try {
            URI uRI = new URI(string);
            this.getOWLProject().getSettingsMap().setString("owl_file_language", "RDF/XML-ABBREV");
            this.getOWLProject().getSettingsMap().setString("owl_file_name", uRI.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
        }
    }

    public void setWriterSettings(WriterSettings writerSettings) {
        if (writerSettings instanceof ProtegeWriterSettings) {
            this.getOWLProject().getSettingsMap().setString(WRITER_SETTINGS_PROPERTY, WRITER_PROTEGE);
        } else {
            this.getOWLProject().getSettingsMap().remove(WRITER_SETTINGS_PROPERTY);
        }
    }
}

