/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.URIField;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JenaKnowledgeBaseSourcesEditor
extends KnowledgeBaseSourcesEditor {
    public static final String EXTENSION = "owl";
    private URIField owlFileURIField;
    private JComboBox languageComboBox;
    private boolean callback = false;

    public JenaKnowledgeBaseSourcesEditor(String string, final PropertyList propertyList) {
        super(string, propertyList);
        Object object;
        String[] stringArray = new String[]{JenaKnowledgeBaseFactory.fileLanguages[0], JenaKnowledgeBaseFactory.fileLanguages[1]};
        this.languageComboBox = new JComboBox<String>(stringArray);
        this.languageComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)JenaKnowledgeBaseSourcesEditor.this.languageComboBox.getSelectedItem();
                JenaKnowledgeBaseFactory.setOWLFileLanguage(propertyList, string);
                String string2 = JenaKnowledgeBaseSourcesEditor.this.getProjectPath();
                JenaKnowledgeBaseSourcesEditor.this.updatePath(string2);
            }
        });
        LabeledComponent labeledComponent = new LabeledComponent("Language", (Component)this.languageComboBox);
        String string2 = JenaKnowledgeBaseFactory.getOWLFilePath(this.getSources());
        if (string2 == null) {
            object = JenaKnowledgeBaseFactory.getOWLFileLanguage(propertyList);
            string2 = this.constructName(this.getProjectPath(), JenaKnowledgeBaseFactory.getExtension((String)object));
        }
        this.owlFileURIField = new URIField("OWL file name or URL", this.getURI(string2), EXTENSION, "Web Ontology Language (OWL) files");
        this.owlFileURIField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
            }
        });
        this.updateComboBox();
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout(8, 8));
        ((Container)object).add("North", (Component)this.owlFileURIField);
        ((Container)object).add("Center", (Component)labeledComponent);
        this.add((Component)object);
    }

    private String constructName(String string, String string2) {
        return FileUtilities.replaceExtension((String)string, (String)string2);
    }

    public JComponent createIncludedProjectsList() {
        return null;
    }

    public String getProjectPath() {
        String string = super.getProjectPath();
        if (string == null) {
            if (this.owlFileURIField != null) {
                URI uRI = this.owlFileURIField.getAbsoluteURI();
                if (uRI != null) {
                    string = uRI.toString();
                    string = FileUtilities.replaceExtension((String)string, (String)".pprj");
                } else {
                    string = "";
                }
            } else {
                string = "";
            }
        }
        return string;
    }

    private URI getURI(String string) {
        try {
            return new URI(string);
        }
        catch (Exception exception) {
            return URIUtilities.createURI((String)string);
        }
    }

    protected void onProjectPathChange(String string, String string2) {
        if (string2 != null) {
            this.updatePath(string2);
        }
    }

    public void saveContents() {
        URI uRI = this.owlFileURIField.getRelativeURI();
        String string = uRI != null ? uRI.toString() : "";
        String string2 = (String)this.languageComboBox.getSelectedItem();
        JenaKnowledgeBaseFactory.setOWLFileLanguage(this.getSources(), string2);
        JenaKnowledgeBaseFactory.setOWLFileName(this.getSources(), string);
    }

    private void updateComboBox() {
        URI uRI = this.owlFileURIField.getAbsoluteURI();
        if (uRI != null) {
            for (int i = 0; i < JenaKnowledgeBaseFactory.extensions.length; ++i) {
                String string = JenaKnowledgeBaseFactory.extensions[i];
                if (!uRI.toString().endsWith("." + string)) continue;
                this.callback = true;
                this.languageComboBox.setSelectedIndex(i);
                this.callback = false;
            }
        }
    }

    private void updatePath(String string) {
        if (this.getProjectPath() != null && !this.callback) {
            String string2 = (String)this.languageComboBox.getSelectedItem();
            String string3 = "." + JenaKnowledgeBaseFactory.getExtension(string2);
            int n = string.lastIndexOf(47);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            String string4 = new File(string).getName();
            String string5 = FileUtilities.replaceExtension((String)string4, (String)string3);
            this.owlFileURIField.setURI(this.getURI(string5));
        }
    }

    public boolean validateContents() {
        if (this.owlFileURIField.getRelativeURI() == null) {
            OWLUI.showErrorMessageDialog("You need to enter a valid URI for an OWL/RDF file.\nCurrently, these URIs should not contain spaces.", "Invalid URI");
            return false;
        }
        return true;
    }
}

