/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.tidy.Checker;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class Jena {
    public static final String DEFAULT_NAMESPACE_SEPARATOR = "#";
    public static final String OWL_DL = "DL";
    public static final String OWL_FULL = "Full";
    public static final String OWL_LITE = "Lite";
    public static final String XML_TAG_HIDDEN_PROPERTY = "edu.stanford.smi.protegex.owl.jena.XML-Tag-Hidden";
    private static final Set systemClasses = new HashSet();
    public static final String ROOT_FOLDER = "edu.stanford.smi.protegex.owl";
    public static final String DEFAULT_ONT_POLICY_FILE_PATH = new File(ProtegeOWL.getPluginFolder(), "ont-policy.rdf").toURI().toString();
    public static final String ONT_POLICY_PROPERTY = "edu.stanford.smi.protegex.owl.jena.loader.JenaLoader.ontPolicy";

    private static void addRDFTypes(Hashtable hashtable, OntProperty ontProperty) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        ExtendedIterator extendedIterator = ontProperty.listRDFTypes(true);
        while (extendedIterator.hasNext()) {
            Resource resource = (Resource)extendedIterator.next();
            arrayList.add(resource);
        }
        hashtable.put(ontProperty, arrayList);
    }

    public static DatatypeProperty asDatatypeProperty(Resource resource) {
        OntModel ontModel = (OntModel)resource.getModel();
        return (DatatypeProperty)ontModel.getResource(resource.getURI()).as(DatatypeProperty.class);
    }

    public static OntClass asOntClass(Resource resource) {
        if (resource.canAs(OntClass.class)) {
            return (OntClass)resource.as(OntClass.class);
        }
        OntModel ontModel = (OntModel)resource.getModel();
        OntClass ontClass = ontModel.getOntClass(resource.getURI());
        if (ontClass == null) {
            throw new IllegalArgumentException("Could not create OntClass");
        }
        return ontClass;
    }

    public static ObjectProperty asObjectProperty(Resource resource) {
        OntModel ontModel = (OntModel)resource.getModel();
        return (ObjectProperty)ontModel.getResource(resource.getURI()).as(ObjectProperty.class);
    }

    public static OntProperty asOntProperty(Resource resource) {
        OntModel ontModel = (OntModel)resource.getModel();
        return ontModel.getOntProperty(resource.getURI());
    }

    public static boolean canAs(RDFNode rDFNode, Resource resource) {
        if (rDFNode.canAs(OntResource.class)) {
            OntResource ontResource = (OntResource)rDFNode.as(OntResource.class);
            if (ontResource.hasRDFType(resource)) {
                return true;
            }
            if (resource instanceof EnhNode && ((EnhNode)resource).getGraph() != null && resource.canAs(OntClass.class)) {
                OntClass ontClass = (OntClass)resource.as(OntClass.class);
                ExtendedIterator extendedIterator = ontClass.listSubClasses(true);
                while (extendedIterator.hasNext()) {
                    Resource resource2 = (Resource)extendedIterator.next();
                    if (!Jena.canAs(rDFNode, (Resource)((OntClass)resource2.as(OntClass.class)))) continue;
                    return true;
                }
            } else if (ontResource.getModel() instanceof OntModel) {
                OntModel ontModel = (OntModel)ontResource.getModel();
                return Jena.canAs((RDFNode)ontResource, ontModel.getResource(resource.getURI()));
            }
        }
        return false;
    }

    public static boolean canAsDatatypeProperty(RDFNode rDFNode) {
        return Jena.canAs(rDFNode, OWL.DatatypeProperty);
    }

    public static boolean canAsOntClass(RDFNode rDFNode) {
        return rDFNode.canAs(OntClass.class) || Jena.canAs(rDFNode, OWL.Class) || Jena.canAs(rDFNode, RDFS.Class);
    }

    public static boolean canAsObjectProperty(RDFNode rDFNode) {
        return Jena.canAs(rDFNode, OWL.ObjectProperty);
    }

    public static boolean canAsOntProperty(RDFNode rDFNode) {
        return Jena.canAs(rDFNode, RDF.Property);
    }

    public static boolean canAsOWLProperty(RDFNode rDFNode) {
        return Jena.canAsObjectProperty(rDFNode) || Jena.canAsDatatypeProperty(rDFNode);
    }

    public static Iterator cloneIt(Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.iterator();
    }

    public static OntModel cloneOntModel(OntModel ontModel) {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM);
        ontModelSpec.setReasoner(null);
        return Jena.cloneOntModel(ontModel, ontModelSpec);
    }

    public static OntModel cloneOntModel(OntModel ontModel, OntModelSpec ontModelSpec) {
        String string = ontModel.getNsPrefixURI("");
        StringWriter stringWriter = new StringWriter();
        RDFWriter rDFWriter = ontModel.getWriter("RDF/XML-ABBREV");
        rDFWriter.setProperty("blockRules", (Object)"propertyAttr");
        rDFWriter.setProperty("relativeURIs", (Object)"same-document");
        rDFWriter.write(ontModel.getBaseModel(), (Writer)stringWriter, string);
        try {
            stringWriter.close();
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
        }
        String string2 = stringWriter.toString();
        OntModel ontModel2 = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec, null);
        StringReader stringReader = new StringReader(string2);
        ontModel2.read((Reader)stringReader, string, "RDF/XML-ABBREV");
        try {
            ((Reader)stringReader).close();
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
        }
        return ontModel2;
    }

    public static Hashtable convertTypedAnnotationPropertiesIntoUntyped(OntModel ontModel) {
        DatatypeProperty datatypeProperty2;
        Hashtable hashtable = new Hashtable();
        Resource resource = ontModel.getProfile().ANNOTATION_PROPERTY();
        Object object = ontModel.listDatatypeProperties();
        while (object.hasNext()) {
            datatypeProperty2 = (DatatypeProperty)object.next();
            if (!datatypeProperty2.canAs(AnnotationProperty.class)) continue;
            Jena.addRDFTypes(hashtable, (OntProperty)datatypeProperty2);
        }
        object = ontModel.listObjectProperties();
        while (object.hasNext()) {
            datatypeProperty2 = (ObjectProperty)object.next();
            if (!datatypeProperty2.canAs(AnnotationProperty.class)) continue;
            Jena.addRDFTypes(hashtable, (OntProperty)datatypeProperty2);
        }
        for (DatatypeProperty datatypeProperty2 : hashtable.keySet()) {
            List list = (List)hashtable.get(datatypeProperty2);
            for (Resource resource2 : list) {
                if (resource2.equals(resource)) continue;
                datatypeProperty2.removeRDFType(resource2);
                System.out.println("Temporarily removed type " + resource2 + " from " + datatypeProperty2);
            }
        }
        return hashtable;
    }

    public static void copyPropertyValues(Resource resource, Resource resource2) {
        StmtIterator stmtIterator = resource.listProperties();
        while (stmtIterator.hasNext()) {
            Property property = (Property)stmtIterator.next();
            StmtIterator stmtIterator2 = resource.listProperties(property);
            while (stmtIterator2.hasNext()) {
                Statement statement = stmtIterator2.nextStatement();
                resource2.addProperty(property, statement.getObject());
            }
        }
    }

    public static void dumpRDF(OntModel ontModel) {
        Jena.dumpRDF(ontModel, System.out);
    }

    public static void dumpRDF(OntModel ontModel, OutputStream outputStream) {
        String string = "RDF/XML-ABBREV";
        String string2 = ontModel.getNsPrefixURI("");
        RDFWriter rDFWriter = ontModel.getWriter(string);
        Jena.prepareWriter(rDFWriter, string, string2);
        rDFWriter.write(ontModel.getBaseModel(), outputStream, string2);
    }

    public static void dumpRDFTopLevel(OntModel ontModel) {
        String string = "RDF/XML-ABBREV";
        String string2 = ontModel.getNsPrefixURI("");
        RDFWriter rDFWriter = ontModel.getWriter(string);
        Jena.prepareWriter(rDFWriter, string, string2);
        rDFWriter.write((Model)ontModel, (OutputStream)System.out, string2);
    }

    public static Model addOWLFullModel(OntModel ontModel) {
        Model model = ModelFactory.createDefaultModel();
        model.add(OWL.Thing, RDF.type, (RDFNode)OWL.Class);
        model.add(OWL.Nothing, RDF.type, (RDFNode)OWL.Class);
        model.add(OWL.Class, RDF.type, (RDFNode)OWL.Class);
        model.add(RDF.Property, RDF.type, (RDFNode)OWL.Class);
        model.add(OWL.DatatypeProperty, RDF.type, (RDFNode)OWL.Class);
        model.add(OWL.ObjectProperty, RDF.type, (RDFNode)OWL.Class);
        model.add(RDFS.Class, RDF.type, (RDFNode)OWL.Class);
        model.add(RDF.List, RDF.type, (RDFNode)OWL.Class);
        model.add((Resource)RDF.first, RDF.type, (RDFNode)OWL.ObjectProperty);
        model.add((Resource)RDF.rest, RDF.type, (RDFNode)OWL.ObjectProperty);
        model.add(RDF.nil, RDF.type, (RDFNode)RDF.List);
        model.add((Resource)OWL.oneOf, RDF.type, (RDFNode)RDF.Property);
        model.add(RDFS.Literal, RDF.type, (RDFNode)OWL.Class);
        model.add(RDF.Statement, RDF.type, (RDFNode)RDFS.Class);
        model.add(RDFS.Container, RDF.type, (RDFNode)RDFS.Class);
        model.add(RDFS.Datatype, RDF.type, (RDFNode)RDFS.Class);
        model.add(OWL.AllDifferent, RDF.type, (RDFNode)RDFS.Class);
        model.add(OWL.DataRange, RDF.type, (RDFNode)RDFS.Class);
        model.add(OWL.DeprecatedClass, RDF.type, (RDFNode)RDFS.Class);
        model.add(OWL.DeprecatedClass, RDFS.subClassOf, (RDFNode)RDFS.Class);
        model.add(OWL.DeprecatedProperty, RDF.type, (RDFNode)RDFS.Class);
        model.add(OWL.DeprecatedProperty, RDFS.subClassOf, (RDFNode)RDF.Property);
        model.add(OWL.AnnotationProperty, RDF.type, (RDFNode)RDFS.Class);
        model.add(OWL.FunctionalProperty, RDF.type, (RDFNode)RDFS.Class);
        model.add(OWL.InverseFunctionalProperty, RDF.type, (RDFNode)RDFS.Class);
        model.add(OWL.SymmetricProperty, RDF.type, (RDFNode)RDFS.Class);
        model.add(OWL.TransitiveProperty, RDF.type, (RDFNode)RDFS.Class);
        model.add(OWL.Ontology, RDF.type, (RDFNode)OWL.Class);
        model.add(model.getResource(RDFS.getURI() + "Alt"), RDF.type, (RDFNode)RDFS.Class);
        model.add(model.getResource(RDFS.getURI() + "Bag"), RDF.type, (RDFNode)RDFS.Class);
        model.add(model.getResource(RDFS.getURI() + "Seq"), RDF.type, (RDFNode)RDFS.Class);
        model.add((Resource)RDF.type, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)RDF.value, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)RDF.subject, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)RDF.predicate, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)RDF.object, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)OWL.sameAs, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)OWL.differentFrom, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)RDFS.subClassOf, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)RDFS.subPropertyOf, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)OWL.equivalentProperty, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)RDFS.domain, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)RDFS.range, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)RDFS.seeAlso, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)RDFS.isDefinedBy, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)OWL.complementOf, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)OWL.intersectionOf, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)OWL.unionOf, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)OWL.imports, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)model.createProperty("http://www.w3.org/2002/07/owl#valuesFrom"), RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)RDFS.comment, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)RDFS.isDefinedBy, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)RDFS.label, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)RDFS.seeAlso, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)OWL.backwardCompatibleWith, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)OWL.incompatibleWith, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)OWL.priorVersion, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)OWL.versionInfo, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)OWL.onProperty, RDF.type, (RDFNode)RDF.Property);
        ontModel.addSubModel(model);
        return model;
    }

    public static void ensureOWLFullModelIsLastModel(OntModel ontModel, Model model) {
        ontModel.removeSubModel(model);
        ontModel.addSubModel(model);
    }

    public static Graph getHomeGraph(OntModel ontModel, OntResource ontResource) {
        Property property = RDF.type;
        Resource resource = ontResource.getRDFType();
        for (Graph graph : ontModel.getSubGraphs()) {
            if (!graph.contains(ontResource.getNode(), property.getNode(), resource.getNode())) continue;
            return graph;
        }
        return ontModel.getGraph();
    }

    public static String getImportSource(OntModel ontModel, OntResource ontResource) {
        Graph graph = Jena.getHomeGraph(ontModel, ontResource);
        if (graph != null) {
            return graph.getPrefixMapping().getNsPrefixURI("");
        }
        return null;
    }

    public static int getOWLSpecies(OntModel ontModel) {
        Checker checker = new Checker(false);
        checker.addGraphAndImports(ontModel.getGraph());
        String string = checker.getSubLanguage();
        if (string.equalsIgnoreCase(OWL_FULL)) {
            return 2;
        }
        if (string.equalsIgnoreCase(OWL_DL)) {
            return 1;
        }
        return 0;
    }

    public static String getOWLSpeciesString(int n) {
        if (n == 1) {
            return OWL_DL;
        }
        if (n == 0) {
            return OWL_LITE;
        }
        if (n == 2) {
            return OWL_FULL;
        }
        throw new IllegalArgumentException("Species constant must be on of OntModelProvider.OWL_xxx");
    }

    public static String getNamespaceFromURI(String string) {
        if (string.startsWith("urn:")) {
            if (!string.endsWith(":")) {
                string = string + ":";
            }
        } else if (!string.endsWith("/") && !string.endsWith(DEFAULT_NAMESPACE_SEPARATOR)) {
            string = string + DEFAULT_NAMESPACE_SEPARATOR;
        }
        return string;
    }

    public static String getNamespaceWithoutSeparator(String string) {
        return string.substring(0, string.length() - 1);
    }

    public static String getURIFromNamespace(String string) {
        if (string.length() > 1 && (string.endsWith(DEFAULT_NAMESPACE_SEPARATOR) || string.startsWith("urn:") && string.endsWith(":"))) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static boolean isDatatypeProperty(OntModel ontModel, OntProperty ontProperty) {
        Resource resource = ontModel.getResource(OWL.DatatypeProperty.getURI());
        return Jena.canAs((RDFNode)ontProperty, resource);
    }

    public static boolean isImportedResource(OntModel ontModel, Model model, OntResource ontResource) {
        Node node = ontResource.getNode();
        Node node2 = RDF.type.getNode();
        if (ontResource.getRDFType() != null) {
            Node node3 = ontResource.getRDFType().getNode();
            Model model2 = ontModel.getBaseModel();
            if (model2.getGraph().contains(node, node2, node3)) {
                return false;
            }
            ArrayList arrayList = new ArrayList(ontModel.getSubGraphs());
            arrayList.remove(model2.getGraph());
            for (Graph graph : arrayList) {
                if (!graph.contains(node, node2, node3)) continue;
                return true;
            }
        }
        return false;
    }

    private static Resource getBestType(OntResource ontResource) {
        String string;
        ExtendedIterator extendedIterator = ontResource.listRDFTypes(true);
        Resource resource = (Resource)extendedIterator.next();
        while (extendedIterator.hasNext() && ((string = resource.getNameSpace()).equals(OWL.getURI().toString()) || string.equals(RDFS.getURI().toString()) || string.equals(RDF.getURI().toString()))) {
            resource = (Resource)extendedIterator.next();
        }
        return resource;
    }

    public static boolean isNamespaceWithSeparator(String string) {
        if (string.length() > 0 && Util.splitNamespace((String)string) == string.length()) {
            try {
                new URI(string);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isObjectProperty(OntModel ontModel, OntProperty ontProperty) {
        Resource resource = ontModel.getResource(OWL.ObjectProperty.getURI());
        return Jena.canAs((RDFNode)ontProperty, resource);
    }

    public static boolean isSystemProperty(OntProperty ontProperty) {
        return Jena.isSystemResource((Resource)ontProperty) || ontProperty.hasDomain(OWL.Class) && ontProperty.getNameSpace().equals("http://www.w3.org/2002/07/owl#");
    }

    public static boolean isSystemResource(Resource resource) {
        String string = resource.getNameSpace();
        return string.equals(ProtegeNames.NS) && !"defaultLanguage".equals(resource.getLocalName()) && !"usedLanguage".equals(resource.getLocalName()) && !"todoPrefix".equals(resource.getLocalName()) && !"todoProperty".equals(resource.getLocalName()) && !"readOnly".equals(resource.getLocalName()) || string.equals(OWL.getURI()) || string.equals(RDFS.getURI()) || string.equals(RDF.getURI());
    }

    public static boolean isSystemClass(OntClass ontClass) {
        return systemClasses.contains(ontClass) || ontClass.getNameSpace().equals(ProtegeNames.NS);
    }

    public static boolean isValidNamespace(String string) {
        if (Jena.isNamespaceWithSeparator(string) && (string.startsWith("http:") || string.startsWith("urn:") || string.startsWith("file:"))) {
            try {
                URI uRI = new URI(string);
                return uRI.isAbsolute();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isXMLLanguage(String string) {
        return "RDF/XML-ABBREV".equals(string) || "RDF/XML".equals(string);
    }

    public static boolean isXMLTagHidden() {
        return ApplicationProperties.getBooleanProperty((String)XML_TAG_HIDDEN_PROPERTY, (boolean)false);
    }

    public static boolean namespaceEndsWithSeparator(String string) {
        return string.endsWith(DEFAULT_NAMESPACE_SEPARATOR) || string.endsWith(":");
    }

    public static void prepareWriter(RDFWriter rDFWriter, String string, String string2) {
        if ("RDF/XML-ABBREV".equals(string) || "RDF/XML".equals(string)) {
            rDFWriter.setProperty("showXmlDeclaration", (Object)("" + !Jena.isXMLTagHidden()));
            rDFWriter.setProperty("relativeURIs", (Object)"same-document");
            String string3 = string2;
            if (Jena.isNamespaceWithSeparator(string3) && !string2.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            rDFWriter.setProperty("xmlbase", (Object)string3);
            if ("RDF/XML-ABBREV".equals(string)) {
                rDFWriter.setProperty("blockRules", (Object)"propertyAttr");
            }
        }
    }

    public static void removePropertyValue(OntResource ontResource, Property property, String string) {
        StmtIterator stmtIterator = ontResource.listProperties(property);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            RDFNode rDFNode = statement.getObject();
            if (!rDFNode.toString().equals(string)) continue;
            ontResource.removeProperty(property, rDFNode);
            return;
        }
    }

    public static Resource renameResource(Resource resource, String string, Model model) {
        OntModel ontModel = (OntModel)resource.getModel();
        Resource resource2 = string == null ? ontModel.createResource() : ontModel.createResource(string);
        Model model2 = ontModel.getBaseModel();
        Jena.renameResourceInModel(model2, resource, resource2);
        if (model != null) {
            Jena.renameResourceInModel(model, resource, resource2);
        }
        return resource2;
    }

    public static Resource renameResource(OntModel ontModel, Resource resource, String string) {
        OntModel ontModel2 = (OntModel)resource.getModel();
        Resource resource2 = string == null ? ontModel2.createResource() : ontModel2.createResource(string);
        Jena.renameResourceInGraph(ontModel.getBaseModel().getGraph(), resource, resource2);
        for (Graph graph : ontModel.getSubGraphs()) {
            Jena.renameResourceInGraph(graph, resource, resource2);
        }
        return resource2;
    }

    public static void renameResourceInGraph(Graph graph, Resource resource, Resource resource2) {
        ArrayList arrayList = new ArrayList();
        Object object = graph.find(resource.getNode(), null, null);
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        object = graph.find(null, null, resource.getNode());
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        for (Triple triple : arrayList) {
            graph.delete(triple);
            Node node = triple.getSubject().equals((Object)resource.getNode()) ? resource2.getNode() : triple.getSubject();
            Node node2 = triple.getObject().equals((Object)resource.getNode()) ? resource2.getNode() : triple.getObject();
            graph.add(new Triple(node, triple.getPredicate(), node2));
        }
    }

    public static void renameResourceInModel(Model model, Resource resource, Resource resource2) {
        ArrayList arrayList = new ArrayList();
        Object object = model.listStatements(resource, null, (RDFNode)null);
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        object = model.listStatements(null, null, (RDFNode)resource);
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        for (Statement statement : arrayList) {
            statement.remove();
            Resource resource3 = statement.getSubject().equals(resource) ? resource2 : statement.getSubject();
            Resource resource4 = statement.getObject().equals(resource) ? resource2 : statement.getObject();
            model.add(resource3, statement.getPredicate(), (RDFNode)resource4);
        }
    }

    public static void saveOntModel(OWLModel oWLModel, File file, OntModel ontModel, String string) {
        try {
            String string2 = "RDF/XML-ABBREV";
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintStream printStream = new PrintStream(fileOutputStream);
            String string3 = ontModel.getNsPrefixURI("");
            RDFWriter rDFWriter = ontModel.getWriter(string2);
            Jena.prepareWriter(rDFWriter, string2, string3);
            rDFWriter.write(ontModel.getBaseModel(), (OutputStream)printStream, string3);
            ((OutputStream)fileOutputStream).close();
            ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, string);
        }
        catch (IOException iOException) {
            ProtegeUI.getModalDialogFactory().showThrowable(oWLModel, iOException);
        }
    }

    public static Set set(Iterator iterator) {
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    public static void set(Set set, Iterator iterator) {
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
    }

    public static void setXMLTagHidden(boolean bl) {
        ApplicationProperties.setString((String)XML_TAG_HIDDEN_PROPERTY, (String)("" + bl));
    }

    public static RDFNode getPropertyValue(Resource resource, Property property) {
        NodeIterator nodeIterator = Jena.listPropertyValues(resource, property);
        if (nodeIterator.hasNext()) {
            return nodeIterator.nextNode();
        }
        return null;
    }

    public static NodeIterator listPropertyValues(Resource resource, Property property) {
        return new NodeIteratorImpl((Iterator)resource.listProperties(property).mapWith((Map1)new ObjectMapper()), null);
    }

    public static Collection getDirectSubClasses(OntClass ontClass) {
        ArrayList<OntClass> arrayList = new ArrayList<OntClass>();
        ExtendedIterator extendedIterator = ontClass.listSubClasses(true);
        while (extendedIterator.hasNext()) {
            OntClass ontClass2 = (OntClass)extendedIterator.next();
            if (ontClass2.equals(ontClass)) continue;
            arrayList.add(ontClass2);
        }
        return arrayList;
    }

    public static Collection getDirectSuperClasses(OntClass ontClass) {
        ArrayList<OntClass> arrayList = new ArrayList<OntClass>();
        ExtendedIterator extendedIterator = ontClass.listSuperClasses(true);
        while (extendedIterator.hasNext()) {
            OntClass ontClass2 = (OntClass)extendedIterator.next();
            if (ontClass2.equals(ontClass)) continue;
            arrayList.add(ontClass2);
        }
        return arrayList;
    }

    public static Ontology getDefaultJenaOntology(String string, OntModel ontModel) {
        if (string.endsWith(DEFAULT_NAMESPACE_SEPARATOR)) {
            string = Jena.getNamespaceWithoutSeparator(string);
        }
        ExtendedIterator extendedIterator = ontModel.listOntologies();
        while (extendedIterator.hasNext()) {
            Ontology ontology = (Ontology)extendedIterator.next();
            String string2 = ontology.getURI();
            if (!string.equals(string2)) continue;
            return ontology;
        }
        return null;
    }

    public static String getOntPolicyFilePath(Project project) {
        if (project == null) {
            return DEFAULT_ONT_POLICY_FILE_PATH;
        }
        String string = project.getSources().getString(ONT_POLICY_PROPERTY);
        if (string == null) {
            return DEFAULT_ONT_POLICY_FILE_PATH;
        }
        return string;
    }

    public static void setOntPolicyFilePath(Project project, String string) {
        project.getSources().setString(ONT_POLICY_PROPERTY, string);
    }

    public static void removePropertyValue(Resource resource, Property property, RDFNode rDFNode) {
        StmtIterator stmtIterator = resource.getModel().listStatements(resource, property, rDFNode);
        if (stmtIterator.hasNext()) {
            stmtIterator.nextStatement().remove();
        }
        stmtIterator.close();
    }

    static {
        systemClasses.add(OWL.Class);
        systemClasses.add(OWL.ObjectProperty);
        systemClasses.add(OWL.DatatypeProperty);
        systemClasses.add(OWL.Nothing);
        systemClasses.add(OWL.Thing);
        systemClasses.add(OWL.DeprecatedClass);
        systemClasses.add(OWL.DeprecatedProperty);
    }

    protected static class ObjectMapper
    implements Map1 {
        protected ObjectMapper() {
        }

        public Object map1(Object object) {
            return object instanceof Statement ? ((Statement)object).getObject() : object;
        }
    }
}

