/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protegex.owl.javacode.JavaCodeGeneratorOptions;
import edu.stanford.smi.protegex.owl.javacode.RDFPropertyAtClassCode;
import edu.stanford.smi.protegex.owl.javacode.RDFSClassCode;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JavaCodeGenerator {
    private OWLModel owlModel;
    private JavaCodeGeneratorOptions options;
    private static Map primitiveTypesMap = new HashMap();

    public JavaCodeGenerator(OWLModel oWLModel, JavaCodeGeneratorOptions javaCodeGeneratorOptions) {
        String string;
        this.owlModel = oWLModel;
        this.options = javaCodeGeneratorOptions;
        File file = javaCodeGeneratorOptions.getOutputFolder();
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
        if ((string = javaCodeGeneratorOptions.getPackage()) != null) {
            string = string.replace('.', '/');
            File file2 = file == null ? new File(string) : new File(file, string);
            file2.mkdirs();
            File file3 = new File(file2, "impl");
            file3.mkdirs();
        } else {
            File file4 = file == null ? new File("impl") : new File(file, "impl");
            file4.mkdirs();
        }
    }

    public void createAll() throws IOException {
        for (RDFSNamedClass rDFSNamedClass : this.owlModel.getUserDefinedRDFSNamedClasses()) {
            this.createInterface(rDFSNamedClass);
            this.createImplementation(rDFSNamedClass);
        }
        this.createFactoryClass();
    }

    public void createFactoryClass() throws IOException {
        String string = this.options.getFactoryClassName();
        if (string != null && string.length() > 0) {
            File file = this.getInterfaceFile(string);
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.printFactoryClass(printWriter);
            fileWriter.close();
        }
    }

    private void printFactoryClass(PrintWriter printWriter) {
        this.printInterfacePackageStatement(printWriter);
        printWriter.println();
        printWriter.println("import edu.stanford.smi.protegex.owl.model.*;");
        printWriter.println();
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege-OWL  (http://protege.stanford.edu/plugins/owl).");
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        printWriter.println("public class " + this.options.getFactoryClassName() + " {");
        printWriter.println();
        printWriter.println("    private OWLModel owlModel;");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public " + this.options.getFactoryClassName() + "(OWLModel owlModel) {");
        printWriter.println("        this.owlModel = owlModel;");
        printWriter.println("    }");
        for (RDFSNamedClass rDFSNamedClass : this.owlModel.getUserDefinedRDFSNamedClasses()) {
            String string = this.getInterfaceName(rDFSNamedClass);
            printWriter.println();
            printWriter.println();
            printWriter.println("    public RDFSNamedClass get" + string + "Class() {");
            printWriter.println("        final String uri = \"" + rDFSNamedClass.getURI() + "\";");
            printWriter.println("        final String name = owlModel.getResourceNameForURI(uri);");
            printWriter.println("        return owlModel.getRDFSNamedClass(name);");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("    public " + string + " create" + string + "(String name) {");
            printWriter.println("        final RDFSNamedClass cls = get" + string + "Class();");
            printWriter.println("        return (" + string + ") cls.createInstance(name).as(" + string + ".class);");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("    public " + string + " get" + string + "(String name) {");
            printWriter.println("        return (" + string + ") owlModel.getRDFResource(name).as(" + string + ".class);");
            printWriter.println("    }");
        }
        printWriter.println("}");
    }

    public void createImplementation(RDFSNamedClass rDFSNamedClass) throws IOException {
        File file = this.getImplementationFile(rDFSNamedClass);
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.printImplementationCode(printWriter, rDFSNamedClass);
        fileWriter.close();
        if (this.options.getAbstractMode()) {
            this.createUserImplementation(rDFSNamedClass);
        }
    }

    public void createUserImplementation(RDFSNamedClass rDFSNamedClass) throws IOException {
        String string = this.getImplementationName(rDFSNamedClass);
        File file = this.getImplementationFile(string);
        if (!file.exists()) {
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.printUserImplementationCode(printWriter, rDFSNamedClass);
            fileWriter.close();
        }
    }

    public void printImplementationCode(PrintWriter printWriter, RDFSNamedClass rDFSNamedClass) {
        RDFSClassCode rDFSClassCode = new RDFSClassCode(rDFSNamedClass);
        if (this.options.getPackage() != null) {
            printWriter.println("package " + this.options.getPackage() + ".impl;");
        } else {
            printWriter.println("package impl;");
        }
        printWriter.println();
        printWriter.println("import edu.stanford.smi.protege.model.FrameID;");
        printWriter.println("import edu.stanford.smi.protegex.owl.model.*;");
        printWriter.println("import edu.stanford.smi.protegex.owl.model.impl.*;");
        this.perhapsAddImportJavaUtil(rDFSClassCode, printWriter);
        String string = this.options.getPackage();
        if (string != null) {
            printWriter.println("import " + string + ".*;");
            printWriter.println();
        }
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege-OWL  (http://protege.stanford.edu/plugins/owl).");
        printWriter.println(" * Source OWL Class: " + rDFSNamedClass.getURI());
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        String string2 = this.getImplementationNamePossiblyAbstract(rDFSNamedClass);
        printWriter.println("public class " + string2 + this.getImplementationExtendsCode(rDFSNamedClass));
        printWriter.println("         implements " + this.getInterfaceNamePossiblyAbstract(rDFSNamedClass) + " {");
        this.printConstructors(printWriter, string2);
        Iterator iterator = rDFSClassCode.getPropertyCodes().iterator();
        while (iterator.hasNext()) {
            printWriter.println();
            printWriter.println();
            RDFPropertyAtClassCode rDFPropertyAtClassCode = (RDFPropertyAtClassCode)iterator.next();
            this.printImplementationPropertyCode(printWriter, rDFPropertyAtClassCode);
        }
        printWriter.println("}");
    }

    public void printUserImplementationCode(PrintWriter printWriter, RDFSNamedClass rDFSNamedClass) {
        if (this.options.getPackage() != null) {
            printWriter.println("package " + this.options.getPackage() + ".impl;");
        } else {
            printWriter.println("package impl;");
        }
        printWriter.println();
        printWriter.println("import edu.stanford.smi.protege.model.FrameID;");
        printWriter.println("import edu.stanford.smi.protegex.owl.model.*;");
        printWriter.println("import edu.stanford.smi.protegex.owl.model.impl.*;");
        String string = this.options.getPackage();
        if (string != null) {
            printWriter.println("import " + string + ".*;");
            printWriter.println();
        }
        String string2 = this.getImplementationName(rDFSNamedClass);
        printWriter.println("public class " + string2 + " extends " + this.getImplementationNamePossiblyAbstract(rDFSNamedClass));
        printWriter.println("         implements " + this.getInterfaceName(rDFSNamedClass) + " {");
        this.printConstructors(printWriter, string2);
        printWriter.println("}");
    }

    private void printConstructors(PrintWriter printWriter, String string) {
        printWriter.println();
        printWriter.println("    public " + string + "(OWLModel owlModel, FrameID id) {");
        printWriter.println("        super(owlModel, id);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public " + string + "() {");
        printWriter.println("    }");
    }

    private String getImplementationExtendsCode(RDFSNamedClass rDFSNamedClass) {
        String string = " extends ";
        String string2 = this.getBaseImplementation(rDFSNamedClass);
        if (string2 == null) {
            return string + "DefaultRDFIndividual";
        }
        return string + string2;
    }

    public void createInterface(RDFSNamedClass rDFSNamedClass) throws IOException {
        File file = this.getInterfaceFile(rDFSNamedClass);
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.printInterfaceCode(printWriter, rDFSNamedClass);
        fileWriter.close();
        if (this.options.getAbstractMode()) {
            this.createUserInterface(rDFSNamedClass);
        }
    }

    private void createUserInterface(RDFSNamedClass rDFSNamedClass) throws IOException {
        String string = this.getInterfaceName(rDFSNamedClass);
        File file = this.getInterfaceFile(string);
        if (!file.exists()) {
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.printUserInterfaceCode(printWriter, rDFSNamedClass);
            fileWriter.close();
        }
    }

    public void printInterfaceCode(PrintWriter printWriter, RDFSNamedClass rDFSNamedClass) {
        RDFSClassCode rDFSClassCode = new RDFSClassCode(rDFSNamedClass);
        this.printInterfacePackageStatement(printWriter);
        printWriter.println("import edu.stanford.smi.protegex.owl.model.*;");
        printWriter.println();
        this.perhapsAddImportJavaUtil(rDFSClassCode, printWriter);
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege-OWL  (http://protege.stanford.edu/plugins/owl).");
        printWriter.println(" * Source OWL Class: " + rDFSNamedClass.getURI());
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        printWriter.println("public interface " + this.getInterfaceNamePossiblyAbstract(rDFSNamedClass) + this.getInterfaceExtendsCode(rDFSNamedClass) + " {");
        Iterator iterator = rDFSClassCode.getPropertyCodes().iterator();
        while (iterator.hasNext()) {
            RDFPropertyAtClassCode rDFPropertyAtClassCode = (RDFPropertyAtClassCode)iterator.next();
            this.createInterfacePropertyCode(printWriter, rDFPropertyAtClassCode);
            if (!iterator.hasNext()) continue;
            printWriter.println();
        }
        printWriter.println("}");
    }

    private void printInterfacePackageStatement(PrintWriter printWriter) {
        if (this.options.getPackage() != null) {
            printWriter.println("package " + this.options.getPackage() + ";");
            printWriter.println();
        }
    }

    public void printUserInterfaceCode(PrintWriter printWriter, RDFSNamedClass rDFSNamedClass) {
        this.printInterfacePackageStatement(printWriter);
        printWriter.println("public interface " + this.getInterfaceName(rDFSNamedClass) + " extends " + this.getInterfaceNamePossiblyAbstract(rDFSNamedClass) + " {");
        printWriter.println("}");
    }

    private String getInterfaceExtendsCode(RDFSNamedClass rDFSNamedClass) {
        String string = " extends ";
        String string2 = this.getBaseInterface(rDFSNamedClass);
        if (string2 == null) {
            return string + "RDFIndividual";
        }
        return string + string2;
    }

    public void printImplementationPropertyCode(PrintWriter printWriter, RDFPropertyAtClassCode rDFPropertyAtClassCode) {
        String string;
        String string2;
        RDFProperty rDFProperty = rDFPropertyAtClassCode.getRDFProperty();
        String string3 = rDFPropertyAtClassCode.getUpperCaseJavaName();
        String string4 = this.getJavaTypeName(rDFPropertyAtClassCode);
        String string5 = rDFPropertyAtClassCode.getJavaType();
        boolean bl = rDFPropertyAtClassCode.isMultiple();
        String string6 = "get" + string3 + "Property()";
        printWriter.println();
        printWriter.println("    // Property " + rDFProperty.getURI());
        printWriter.println();
        printWriter.println("    public " + string4 + " get" + string3 + "() {");
        if (bl) {
            if (this.options.getSetMode()) {
                if (rDFPropertyAtClassCode.isCustomType()) {
                    printWriter.println("        return new HashSet(getPropertyValuesAs(" + string6 + ", " + string5 + ".class));");
                } else {
                    printWriter.println("        return new HashSet(getPropertyValues(" + string6 + "));");
                }
            } else if (rDFPropertyAtClassCode.isCustomType()) {
                printWriter.println("        return getPropertyValuesAs(" + string6 + ", " + string5 + ".class);");
            } else {
                printWriter.println("        return getPropertyValues(" + string6 + ");");
            }
        } else if (rDFPropertyAtClassCode.isPrimitive()) {
            string2 = "" + Character.toUpperCase(string4.charAt(0)) + string4.substring(1);
            printWriter.println("        return getPropertyValueLiteral(" + string6 + ").get" + string2 + "();");
        } else if (rDFPropertyAtClassCode.isCustomType()) {
            printWriter.println("        return (" + string4 + ") getPropertyValueAs(" + string6 + ", " + string5 + ".class);");
        } else {
            printWriter.println("        return (" + string4 + ") getPropertyValue(" + string6 + ");");
        }
        printWriter.println("    }");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public RDFProperty get" + string3 + "Property() {");
        printWriter.println("        final String uri = \"" + rDFProperty.getURI() + "\";");
        printWriter.println("        final String name = getOWLModel().getResourceNameForURI(uri);");
        printWriter.println("        return getOWLModel().getRDFProperty(name);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public boolean has" + string3 + "() {");
        printWriter.println("        return getPropertyValueCount(" + string6 + ") > 0;");
        printWriter.println("    }");
        string2 = "new" + string3;
        if (bl) {
            printWriter.println();
            printWriter.println();
            printWriter.println("    public Iterator list" + string3 + "() {");
            if (rDFPropertyAtClassCode.isCustomType()) {
                printWriter.println("        return listPropertyValuesAs(" + string6 + ", " + string5 + ".class);");
            } else {
                printWriter.println("        return listPropertyValues(" + string6 + ");");
            }
            printWriter.println("    }");
            printWriter.println();
            printWriter.println();
            printWriter.println("    public void add" + string3 + "(" + string5 + " " + string2 + ") {");
            printWriter.println("        addPropertyValue(" + string6 + ", " + string2 + ");");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println();
            string = "old" + string3;
            printWriter.println("    public void remove" + string3 + "(" + string5 + " " + string + ") {");
            printWriter.println("        removePropertyValue(" + string6 + ", " + string + ");");
            printWriter.println("    }");
        }
        printWriter.println();
        printWriter.println();
        printWriter.println("    public void set" + string3 + "(" + string4 + " " + string2 + ") {");
        if (bl) {
            printWriter.println("        setPropertyValues(" + string6 + ", " + string2 + ");");
        } else if (rDFPropertyAtClassCode.isPrimitive()) {
            string = null;
            string = "int".equals(string4) ? "Integer" : ("boolean".equals(string4) ? "Boolean" : "Float");
            printWriter.println("        setPropertyValue(" + string6 + ", new " + string + "(" + string2 + "));");
        } else {
            printWriter.println("        setPropertyValue(" + string6 + ", " + string2 + ");");
        }
        printWriter.println("    }");
    }

    public void createInterfacePropertyCode(PrintWriter printWriter, RDFPropertyAtClassCode rDFPropertyAtClassCode) {
        RDFProperty rDFProperty = rDFPropertyAtClassCode.getRDFProperty();
        String string = rDFPropertyAtClassCode.getUpperCaseJavaName();
        String string2 = this.getJavaTypeName(rDFPropertyAtClassCode);
        printWriter.println();
        printWriter.println("    // Property " + rDFProperty.getURI());
        printWriter.println();
        printWriter.println("    " + string2 + " get" + string + "();");
        printWriter.println();
        printWriter.println("    RDFProperty get" + string + "Property();");
        printWriter.println();
        printWriter.println("    boolean has" + string + "();");
        if (rDFPropertyAtClassCode.isMultiple()) {
            String string3 = rDFPropertyAtClassCode.getJavaType();
            printWriter.println();
            printWriter.println("    Iterator list" + string + "();");
            printWriter.println();
            printWriter.println("    void add" + string + "(" + string3 + " new" + string + ");");
            printWriter.println();
            printWriter.println("    void remove" + string + "(" + string3 + " old" + string + ");");
        }
        printWriter.println();
        printWriter.println("    void set" + string + "(" + string2 + " new" + string + ");");
    }

    private String getJavaTypeName(RDFPropertyAtClassCode rDFPropertyAtClassCode) {
        if (rDFPropertyAtClassCode.isMultiple()) {
            return this.options.getSetMode() ? "Set" : "Collection";
        }
        return rDFPropertyAtClassCode.getJavaType();
    }

    public String getBaseImplementation(RDFSNamedClass rDFSNamedClass) {
        for (RDFSClass rDFSClass : rDFSNamedClass.getSuperclasses(false)) {
            String string = this.getSystemJavaClass(rDFSClass);
            if (string != null) {
                return "Default" + string;
            }
            if (!(rDFSClass instanceof RDFSNamedClass) || this.owlModel.getOWLThingClass().equals(rDFSClass)) continue;
            return this.getImplementationName((RDFSNamedClass)rDFSClass);
        }
        return null;
    }

    public String getBaseInterface(RDFSNamedClass rDFSNamedClass) {
        for (RDFSClass rDFSClass : rDFSNamedClass.getSuperclasses(false)) {
            String string = this.getSystemJavaClass(rDFSClass);
            if (string != null) {
                return string;
            }
            if (!(rDFSClass instanceof RDFSNamedClass) || this.owlModel.getOWLThingClass().equals(rDFSClass)) continue;
            return this.getInterfaceName((RDFSNamedClass)rDFSClass);
        }
        return rDFSNamedClass.getProtegeType() instanceof OWLNamedClass ? "OWLIndividual" : "RDFIndividual";
    }

    public File getImplementationFile(RDFSNamedClass rDFSNamedClass) {
        String string = this.getImplementationNamePossiblyAbstract(rDFSNamedClass);
        return this.getImplementationFile(string);
    }

    private File getImplementationFile(String string) {
        String string2 = this.options.getPackage();
        string2 = string2 != null ? string2.replace('.', '/') + "/" : "";
        return new File(this.options.getOutputFolder(), string2 + "impl/" + string + ".java");
    }

    public String getImplementationName(RDFSNamedClass rDFSNamedClass) {
        return "Default" + this.getInterfaceName(rDFSNamedClass);
    }

    public String getImplementationNamePossiblyAbstract(RDFSNamedClass rDFSNamedClass) {
        return "Default" + this.getInterfaceNamePossiblyAbstract(rDFSNamedClass);
    }

    public File getInterfaceFile(RDFSNamedClass rDFSNamedClass) {
        String string = this.getInterfaceNamePossiblyAbstract(rDFSNamedClass);
        return this.getInterfaceFile(string);
    }

    private File getInterfaceFile(String string) {
        String string2 = this.options.getPackage();
        string2 = string2 != null ? string2.replace('.', '/') + "/" : "";
        return new File(this.options.getOutputFolder(), string2 + string + ".java");
    }

    public String getInterfaceNamePossiblyAbstract(RDFSNamedClass rDFSNamedClass) {
        String string = new RDFSClassCode(rDFSNamedClass).getJavaName();
        if (this.options.getAbstractMode()) {
            string = string + "_";
        }
        return string;
    }

    public String getInterfaceName(RDFSNamedClass rDFSNamedClass) {
        return new RDFSClassCode(rDFSNamedClass).getJavaName();
    }

    private String getSystemJavaClass(RDFSClass rDFSClass) {
        if (rDFSClass.equals(this.owlModel.getOWLObjectPropertyClass())) {
            return "OWLObjectProperty";
        }
        if (rDFSClass.equals(this.owlModel.getOWLDatatypePropertyClass())) {
            return "OWLDatatypeProperty";
        }
        if (rDFSClass.equals(this.owlModel.getRDFPropertyClass())) {
            return "RDFProperty";
        }
        if (rDFSClass.equals(this.owlModel.getOWLNamedClassClass())) {
            return "OWLNamedClass";
        }
        if (rDFSClass.equals(this.owlModel.getRDFSNamedClassClass())) {
            return "RDFSNamedClass";
        }
        return null;
    }

    public static String getValidJavaName(String string) {
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            string = string.replace(c, '_');
        }
        return string;
    }

    private void perhapsAddImportJavaUtil(RDFSClassCode rDFSClassCode, PrintWriter printWriter) {
        for (RDFPropertyAtClassCode rDFPropertyAtClassCode : rDFSClassCode.getPropertyCodes()) {
            if (!rDFPropertyAtClassCode.isMultiple()) continue;
            printWriter.println("import java.util.*;");
            printWriter.println();
            return;
        }
    }

    static {
        primitiveTypesMap.put(Integer.class, Integer.TYPE);
        primitiveTypesMap.put(Float.class, Float.TYPE);
        primitiveTypesMap.put(Boolean.class, Boolean.TYPE);
    }
}

