/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.util;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class ReasonerUtil {
    private static ReasonerUtil instance;
    private HashMap namedClsesMap;
    private HashMap propertiesMap;
    private HashMap individualsMap;
    private ProjectListener projectListener = new ProjectAdapter(){

        public void projectClosed(ProjectEvent projectEvent) {
            Project project = (Project)projectEvent.getSource();
            project.removeProjectListener(ReasonerUtil.this.projectListener);
            ((OWLModel)project.getKnowledgeBase()).removeModelListener(ReasonerUtil.this.modelListener);
            ReasonerUtil.this.initHashMaps();
        }
    };
    private ModelListener modelListener = new ModelAdapter(){

        public void classCreated(RDFSClass rDFSClass) {
            ReasonerUtil.this.invalidateNamedClsCache(rDFSClass.getOWLModel());
        }

        public void classDeleted(RDFSClass rDFSClass) {
            ReasonerUtil.this.invalidateNamedClsCache(rDFSClass.getOWLModel());
        }

        public void propertyCreated(RDFProperty rDFProperty) {
            ReasonerUtil.this.invalidatePropertiesCache(rDFProperty.getOWLModel());
        }

        public void propertyDeleted(RDFProperty rDFProperty) {
            ReasonerUtil.this.invalidatePropertiesCache(rDFProperty.getOWLModel());
        }

        public void individualCreated(RDFResource rDFResource) {
            ReasonerUtil.this.invalidateIndividualsCache(rDFResource.getOWLModel());
        }

        public void individualDeleted(RDFResource rDFResource) {
            ReasonerUtil.this.invalidateIndividualsCache(rDFResource.getOWLModel());
        }
    };
    private long lastClassificationTime;

    protected ReasonerUtil() {
        this.initHashMaps();
        this.lastClassificationTime = 0L;
    }

    public static synchronized ReasonerUtil getInstance() {
        if (instance == null) {
            instance = new ReasonerUtil();
        }
        return instance;
    }

    private void initHashMaps() {
        this.namedClsesMap = new HashMap();
        this.propertiesMap = new HashMap();
        this.individualsMap = new HashMap();
    }

    public Collection getNamedClses(OWLModel oWLModel) {
        Collection collection;
        if (!this.namedClsesMap.containsKey(oWLModel)) {
            this.namedClsesMap.put(oWLModel, oWLModel.getUserDefinedOWLNamedClasses());
            oWLModel.addModelListener(this.modelListener);
            oWLModel.getProject().addProjectListener(this.projectListener);
        }
        if ((collection = (Collection)this.namedClsesMap.get(oWLModel)) == null) {
            collection = oWLModel.getUserDefinedOWLNamedClasses();
            this.namedClsesMap.put(oWLModel, collection);
        }
        return collection;
    }

    public Collection getProperties(OWLModel oWLModel) {
        Collection collection;
        if (!this.propertiesMap.containsKey(oWLModel)) {
            this.propertiesMap.put(oWLModel, oWLModel.getUserDefinedOWLProperties());
            oWLModel.addModelListener(this.modelListener);
        }
        if ((collection = (Collection)this.propertiesMap.get(oWLModel)) == null) {
            collection = oWLModel.getUserDefinedOWLProperties();
            this.propertiesMap.put(oWLModel, collection);
        }
        return collection;
    }

    public Collection getIndividuals(OWLModel oWLModel) {
        Collection collection;
        if (!this.individualsMap.containsKey(oWLModel)) {
            this.individualsMap.put(oWLModel, this.getOWLIndividuals(oWLModel));
            oWLModel.addModelListener(this.modelListener);
        }
        if ((collection = (Collection)this.individualsMap.get(oWLModel)) == null) {
            collection = this.getOWLIndividuals(oWLModel);
            this.individualsMap.put(oWLModel, collection);
        }
        return collection;
    }

    private Collection getOWLIndividuals(OWLModel oWLModel) {
        IndividualsFilter individualsFilter = new IndividualsFilter(oWLModel);
        return individualsFilter.getOWLIndividuals();
    }

    public void invalidateNamedClsCache(OWLModel oWLModel) {
        this.namedClsesMap.put(oWLModel, null);
    }

    public void invalidatePropertiesCache(OWLModel oWLModel) {
        this.propertiesMap.put(oWLModel, null);
    }

    public void invalidateIndividualsCache(OWLModel oWLModel) {
        this.individualsMap.put(oWLModel, null);
    }

    public long getLastClassificationTime() {
        return this.lastClassificationTime;
    }

    public void setLastClassificationTime() {
        this.lastClassificationTime = System.currentTimeMillis();
    }

    public OWLNamedClass getNamedReferent(OWLAnonymousClass oWLAnonymousClass) {
        OWLAnonymousClass oWLAnonymousClass2;
        OWLAnonymousClass oWLAnonymousClass3 = oWLAnonymousClass.getExpressionRoot();
        while ((oWLAnonymousClass2 = oWLAnonymousClass3.getExpressionRoot()) != oWLAnonymousClass3) {
            oWLAnonymousClass3 = oWLAnonymousClass2;
        }
        OWLNamedClass oWLNamedClass = null;
        Iterator iterator = oWLAnonymousClass.getNamedSubclasses().iterator();
        if (iterator.hasNext()) {
            oWLNamedClass = (OWLNamedClass)iterator.next();
        }
        return oWLNamedClass;
    }

    private class IndividualsFilter
    extends OWLModelVisitorAdapter {
        private Collection individuals;
        private OWLModel model;

        public IndividualsFilter(OWLModel oWLModel) {
            this.model = oWLModel;
        }

        public Collection getOWLIndividuals() {
            this.individuals = new ArrayList();
            for (RDFResource rDFResource : this.model.getRDFResources()) {
                rDFResource.accept(this);
            }
            return this.individuals;
        }

        public void visitOWLIndividual(OWLIndividual oWLIndividual) {
            this.individuals.add(oWLIndividual);
        }
    }
}

