/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.w3c.dom.Document;

public class UpdateInferredTypesTask
extends AbstractReasonerTask {
    private ProtegeOWLReasoner protegeOWLReasoner;

    public UpdateInferredTypesTask(ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.protegeOWLReasoner = protegeOWLReasoner;
    }

    public int getTaskSize() {
        return ReasonerUtil.getInstance().getIndividuals(this.protegeOWLReasoner.getKnowledgeBase()).size();
    }

    public void run() throws DIGReasonerException {
        Object object2;
        OWLModel oWLModel = this.protegeOWLReasoner.getKnowledgeBase();
        ReasonerLogRecordFactory reasonerLogRecordFactory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord reasonerLogRecord = reasonerLogRecordFactory.createInformationMessageLogRecord("Computing inferred types", null);
        this.postLogRecord(reasonerLogRecord);
        this.setDescription("Computing inferred types");
        this.setMessage("Building reasoner query");
        TimeDifference timeDifference = new TimeDifference();
        timeDifference.markStart();
        Document document = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        for (Object object2 : ReasonerUtil.getInstance().getIndividuals(oWLModel)) {
            this.getTranslator().createIndividualTypesQuery(document, object2.getName(), (RDFIndividual)object2);
        }
        timeDifference.markEnd();
        this.postLogRecord(reasonerLogRecordFactory.createInformationMessageLogRecord("Time to build query = " + timeDifference, reasonerLogRecord));
        this.setMessage("Querying reasoner...");
        timeDifference.markStart();
        object2 = this.protegeOWLReasoner.getDIGReasoner().performRequest(document);
        timeDifference.markEnd();
        this.postLogRecord(reasonerLogRecordFactory.createInformationMessageLogRecord("Time to query reasoner = " + timeDifference, reasonerLogRecord));
        this.setMessage("Updating Protege-OWL...");
        timeDifference.markStart();
        oWLModel.setGenerateEventsEnabled(false);
        oWLModel.beginTransaction("Compute and update inferred types");
        Iterator iterator = this.getTranslator().getDIGQueryResponseIterator(oWLModel, (Document)object2);
        RDFProperty rDFProperty = oWLModel.getRDFProperty("protege:inferredType");
        RDFProperty rDFProperty2 = ((AbstractOWLModel)oWLModel).getProtegeClassificationStatusProperty();
        while (iterator.hasNext()) {
            DIGQueryResponse dIGQueryResponse = (DIGQueryResponse)iterator.next();
            RDFIndividual rDFIndividual = oWLModel.getRDFIndividual(dIGQueryResponse.getID());
            if (rDFIndividual != null) {
                Collection collection = dIGQueryResponse.getConcepts();
                if (collection.size() == 0) {
                    collection.add(rDFIndividual.getOWLModel().getOWLThingClass());
                }
                Collection collection2 = rDFIndividual.getProtegeTypes();
                OWLModel oWLModel2 = oWLModel;
                oWLModel2.setOwnSlotValues((Frame)rDFIndividual, rDFProperty, collection);
                if (!collection.containsAll(collection2) && !collection2.containsAll(collection)) {
                    oWLModel2.setOwnSlotValues((Frame)rDFIndividual, rDFProperty2, Collections.singleton(new Integer(3)));
                } else {
                    oWLModel2.setOwnSlotValues((Frame)rDFIndividual, rDFProperty2, Collections.singleton(new Integer(1)));
                }
            }
            this.setProgress(this.getProgress() + 1);
            this.doAbortCheck();
        }
        oWLModel.endTransaction();
        oWLModel.setGenerateEventsEnabled(true);
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to update Protege-OWL = " + timeDifference, reasonerLogRecord));
        this.setTaskCompleted();
    }
}

