/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;

public class ResetInferredHierarchyTask
extends AbstractReasonerTask {
    private ProtegeOWLReasoner protegeOWLReasoner;

    public ResetInferredHierarchyTask(ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.protegeOWLReasoner = protegeOWLReasoner;
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws DIGReasonerException {
        this.setDescription("Resetting inferred hierarchy");
        this.setMessage("Clearing...");
        this.setProgressIndeterminate(true);
        OWLModel oWLModel = this.protegeOWLReasoner.getKnowledgeBase();
        oWLModel.setGenerateEventsEnabled(false);
        oWLModel.beginTransaction("Reset inferred hierarchy");
        OWLUtil.resetComputedSuperclasses(oWLModel);
        oWLModel.endTransaction();
        oWLModel.setGenerateEventsEnabled(true);
        this.setProgressIndeterminate(false);
        this.setTaskCompleted();
        this.setProgress(1);
    }
}

