/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.CollectionResultReasonerTask;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.w3c.dom.Document;

public class GetIndividualsBelongingToConceptTask
extends AbstractReasonerTask
implements CollectionResultReasonerTask {
    private OWLClass aClass;
    private ProtegeOWLReasoner protegeOWLReasoner;
    private HashSet individuals;

    public GetIndividualsBelongingToConceptTask(OWLClass oWLClass, ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.aClass = oWLClass;
        this.protegeOWLReasoner = protegeOWLReasoner;
        this.individuals = new HashSet();
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws DIGReasonerException {
        Object object;
        OWLModel oWLModel = this.protegeOWLReasoner.getKnowledgeBase();
        ReasonerLogRecordFactory reasonerLogRecordFactory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord reasonerLogRecord = reasonerLogRecordFactory.createInformationMessageLogRecord("Individuals belonging to: " + this.aClass.getBrowserText(), null);
        this.postLogRecord(reasonerLogRecord);
        this.setDescription("Computing individuals belonging to class");
        this.setMessage("Building reasoner query...");
        Document document = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        this.getTranslator().createInstancesOfConceptQuery(document, "q0", this.aClass);
        this.setMessage("Querying reasoner...");
        Document document2 = this.protegeOWLReasoner.getDIGReasoner().performRequest(document);
        Iterator iterator = this.getTranslator().getDIGQueryResponseIterator(oWLModel, document2);
        while (iterator.hasNext()) {
            object = (DIGQueryResponse)iterator.next();
            this.individuals.addAll(object.getIndividuals());
        }
        this.setProgress(1);
        object = this.individuals.iterator();
        while (object.hasNext()) {
            this.postLogRecord(ReasonerLogRecordFactory.getInstance().createOWLInstanceLogRecord((RDFResource)object.next(), reasonerLogRecord));
        }
        this.setTaskCompleted();
    }

    public Collection getResult() {
        return this.individuals;
    }
}

