/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskEvent;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskListener;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ResetInferredHierarchyTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.UpdateEquivalentClassesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.UpdateInconsistentClassesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.UpdateInferredHierarchyTask;

public class ClassifyTaxonomyTask
extends AbstractReasonerTask
implements ReasonerTaskListener {
    private ResetInferredHierarchyTask resetInferredHierarchyTask;
    private UpdateInconsistentClassesTask inconsistentClassesTask;
    private UpdateInferredHierarchyTask inferredHierarchyTask;
    private UpdateEquivalentClassesTask equivalentClassesTask;

    public ClassifyTaxonomyTask(ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.resetInferredHierarchyTask = new ResetInferredHierarchyTask(protegeOWLReasoner);
        this.resetInferredHierarchyTask.addTaskListener(this);
        this.inconsistentClassesTask = new UpdateInconsistentClassesTask(protegeOWLReasoner);
        this.inconsistentClassesTask.addTaskListener(this);
        this.inferredHierarchyTask = new UpdateInferredHierarchyTask(protegeOWLReasoner);
        this.inferredHierarchyTask.addTaskListener(this);
        this.equivalentClassesTask = new UpdateEquivalentClassesTask(protegeOWLReasoner);
        this.equivalentClassesTask.addTaskListener(this);
    }

    public int getTaskSize() {
        int n = this.resetInferredHierarchyTask.getTaskSize() + this.inconsistentClassesTask.getTaskSize() + this.inferredHierarchyTask.getTaskSize() + this.equivalentClassesTask.getTaskSize();
        return n;
    }

    public void run() throws DIGReasonerException {
        this.setProgress(0);
        this.doAbortCheck();
        this.resetInferredHierarchyTask.run();
        this.doAbortCheck();
        this.inconsistentClassesTask.run();
        this.doAbortCheck();
        this.inferredHierarchyTask.run();
        this.doAbortCheck();
        this.equivalentClassesTask.run();
        this.setDescription("Finished");
        this.setMessage("Classification complete");
        this.setTaskCompleted();
    }

    public void progressChanged(ReasonerTaskEvent reasonerTaskEvent) {
        int n = this.resetInferredHierarchyTask.getProgress() + this.inconsistentClassesTask.getProgress() + this.inferredHierarchyTask.getProgress() + this.equivalentClassesTask.getProgress();
        this.setProgress(n);
    }

    public void progressIndeterminateChanged(ReasonerTaskEvent reasonerTaskEvent) {
        this.setProgressIndeterminate(reasonerTaskEvent.getSource().isProgressIndeterminate());
    }

    public void descriptionChanged(ReasonerTaskEvent reasonerTaskEvent) {
        this.setDescription(reasonerTaskEvent.getSource().getDescription());
    }

    public void messageChanged(ReasonerTaskEvent reasonerTaskEvent) {
        this.setMessage(reasonerTaskEvent.getSource().getMessage());
    }

    public void taskFailed(ReasonerTaskEvent reasonerTaskEvent) {
        this.setMessage(reasonerTaskEvent.getSource().getMessage());
    }

    public void taskCompleted(ReasonerTaskEvent reasonerTaskEvent) {
    }

    public void addedToTask(ReasonerTaskEvent reasonerTaskEvent) {
    }

    public void setRequestAbort() {
        super.setRequestAbort();
        this.resetInferredHierarchyTask.setRequestAbort();
        this.inconsistentClassesTask.setRequestAbort();
        this.inferredHierarchyTask.setRequestAbort();
        this.equivalentClassesTask.setRequestAbort();
    }
}

