/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerIdentity;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGTranslator;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGTranslatorFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogger;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskEvent;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public abstract class AbstractReasonerTask
implements ReasonerTask {
    private static transient Logger log = Log.getLogger(AbstractReasonerTask.class);
    private ArrayList listeners;
    private int progress;
    private boolean progressIndeterminate;
    private String description;
    private String message;
    private ReasonerTaskEvent evt = new ReasonerTaskEvent(this);
    private boolean abortTask = false;
    private DIGTranslator translator;

    public AbstractReasonerTask(ProtegeOWLReasoner protegeOWLReasoner) {
        this.listeners = new ArrayList();
        this.translator = DIGTranslatorFactory.getInstance().createTranslator();
        try {
            DIGReasonerIdentity dIGReasonerIdentity = protegeOWLReasoner.getDIGReasoner().getIdentity();
            this.translator.setReasonerIdentity(dIGReasonerIdentity);
        }
        catch (DIGReasonerException dIGReasonerException) {
            Log.emptyCatchBlock((Throwable)dIGReasonerException);
        }
    }

    protected DIGTranslator getTranslator() {
        return this.translator;
    }

    protected void setProgress(int n) {
        this.progress = n;
        this.fireProgressChangedEvent();
    }

    protected void setProgressIndeterminate(boolean bl) {
        this.progressIndeterminate = bl;
        this.fireProgressIndeterminateChnaged();
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isProgressIndeterminate() {
        return this.progressIndeterminate;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String string) {
        this.description = string;
        this.fireDescriptionChangedEvent();
    }

    protected void setMessage(String string) {
        this.message = string;
        this.fireMessageChangedEvent();
    }

    public String getMessage() {
        return this.message;
    }

    protected void setTaskCompleted() {
        this.fireTaskCompletedEvent();
    }

    protected void setTaskFailed() {
        this.fireTaskFailedEvent();
    }

    public void addTaskListener(ReasonerTaskListener reasonerTaskListener) {
        for (WeakReference weakReference : this.listeners) {
            if (!weakReference.get().equals(reasonerTaskListener)) continue;
            return;
        }
        reasonerTaskListener.addedToTask(new ReasonerTaskEvent(this));
        this.listeners.add(new WeakReference<ReasonerTaskListener>(reasonerTaskListener));
    }

    public void removeTaskListener(ReasonerTaskListener reasonerTaskListener) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference.get() == null || !weakReference.get().equals(reasonerTaskListener)) continue;
            weakReference.clear();
            iterator.remove();
        }
    }

    protected void fireProgressChangedEvent() {
        Iterator iterator = new ArrayList(this.listeners).iterator();
        while (iterator.hasNext()) {
            ReasonerTaskListener reasonerTaskListener = (ReasonerTaskListener)((WeakReference)iterator.next()).get();
            if (reasonerTaskListener == null) continue;
            reasonerTaskListener.progressChanged(this.evt);
        }
    }

    protected void fireProgressIndeterminateChnaged() {
        Iterator iterator = new ArrayList(this.listeners).iterator();
        while (iterator.hasNext()) {
            ReasonerTaskListener reasonerTaskListener = (ReasonerTaskListener)((WeakReference)iterator.next()).get();
            if (reasonerTaskListener == null) continue;
            reasonerTaskListener.progressIndeterminateChanged(this.evt);
        }
    }

    protected void fireDescriptionChangedEvent() {
        Iterator iterator = new ArrayList(this.listeners).iterator();
        while (iterator.hasNext()) {
            ReasonerTaskListener reasonerTaskListener = (ReasonerTaskListener)((WeakReference)iterator.next()).get();
            if (reasonerTaskListener == null) continue;
            reasonerTaskListener.descriptionChanged(this.evt);
        }
    }

    protected void fireMessageChangedEvent() {
        Iterator iterator = new ArrayList(this.listeners).iterator();
        while (iterator.hasNext()) {
            ReasonerTaskListener reasonerTaskListener = (ReasonerTaskListener)((WeakReference)iterator.next()).get();
            if (reasonerTaskListener == null) continue;
            reasonerTaskListener.messageChanged(this.evt);
        }
    }

    protected void fireTaskFailedEvent() {
        Iterator iterator = new ArrayList(this.listeners).iterator();
        while (iterator.hasNext()) {
            ReasonerTaskListener reasonerTaskListener = (ReasonerTaskListener)((WeakReference)iterator.next()).get();
            if (reasonerTaskListener == null) continue;
            reasonerTaskListener.taskFailed(this.evt);
        }
    }

    protected void fireTaskCompletedEvent() {
        Iterator iterator = new ArrayList(this.listeners).iterator();
        while (iterator.hasNext()) {
            ReasonerTaskListener reasonerTaskListener = (ReasonerTaskListener)((WeakReference)iterator.next()).get();
            if (reasonerTaskListener == null) continue;
            reasonerTaskListener.taskCompleted(this.evt);
        }
    }

    protected void postLogRecord(ReasonerLogRecord reasonerLogRecord) {
        ReasonerLogger.getInstance().postLogRecord(reasonerLogRecord);
    }

    public void setRequestAbort() {
        this.abortTask = true;
    }

    public boolean isRequestAbort() {
        return this.abortTask;
    }

    protected void doAbortCheck() throws DIGReasonerException {
        if (this.isRequestAbort()) {
            this.setProgressIndeterminate(false);
            this.setTaskFailed();
            throw new DIGReasonerException("Task aborted");
        }
    }
}

