/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.dig.translator;

import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import java.util.Collection;
import java.util.HashSet;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefaultDIGQueryResponse
implements DIGQueryResponse {
    private Element element;
    private OWLModel kb;

    public DefaultDIGQueryResponse(OWLModel oWLModel) {
        this.kb = oWLModel;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public String getID() {
        return this.element.getAttribute("id");
    }

    public Collection getConcepts() {
        NodeList nodeList = this.element.getElementsByTagName("synonyms");
        HashSet<OWLNamedClass> hashSet = new HashSet<OWLNamedClass>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nodeList2 = ((Element)nodeList.item(i)).getElementsByTagName("catom");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                String string = ((Element)nodeList2.item(j)).getAttribute("name");
                OWLNamedClass oWLNamedClass = this.kb.getOWLNamedClass(string);
                if (oWLNamedClass == null) continue;
                hashSet.add(oWLNamedClass);
            }
            if (((Element)nodeList.item(i)).getElementsByTagName("top").getLength() == 0) continue;
            hashSet.add(this.kb.getOWLThingClass());
        }
        return hashSet;
    }

    public Collection getIndividuals() {
        HashSet<OWLIndividual> hashSet = new HashSet<OWLIndividual>();
        NodeList nodeList = this.element.getElementsByTagName("individual");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            OWLIndividual oWLIndividual = this.kb.getOWLIndividual(element.getAttribute("name"));
            if (oWLIndividual == null) continue;
            hashSet.add(oWLIndividual);
        }
        return hashSet;
    }

    public boolean getBoolean() {
        String string = this.element.getTagName();
        boolean bl = true;
        if (string.equals("false")) {
            bl = false;
        }
        return bl;
    }
}

