/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database.triplestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.ReferenceImpl;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameFactoryInvocationHandler;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AbstractTripleStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class DatabaseTripleStore
extends AbstractTripleStore {
    private OWLFrameFactoryInvocationHandler handler;
    private OWLJavaFactory javaFactory;

    public DatabaseTripleStore(OWLDatabaseModel oWLDatabaseModel, TripleStoreModel tripleStoreModel, NarrowFrameStore narrowFrameStore) {
        super(oWLDatabaseModel, tripleStoreModel, narrowFrameStore);
        this.javaFactory = new OWLJavaFactory(oWLDatabaseModel);
        this.handler = new OWLFrameFactoryInvocationHandler();
    }

    public boolean addValue(Instance instance, Slot slot, Object object) {
        this.addValueFast(instance, slot, object);
        return true;
    }

    public RDFResource getHomeResource(String string) {
        Set set = this.frameStore.getFrames(this.nameSlot, null, false, (Object)string);
        if (set.isEmpty()) {
            return null;
        }
        Instance instance = (Instance)set.iterator().next();
        return this.getRDFResource(instance);
    }

    private RDFResource getRDFResource(Instance instance) {
        if (instance instanceof RDFResource) {
            return (RDFResource)instance;
        }
        Collection collection = instance.getDirectTypes();
        Object object = null;
        if (collection.isEmpty()) {
            return new DefaultRDFProperty(this.owlModel, instance.getFrameID());
        }
        boolean bl = true;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof Cls) continue;
            bl = false;
        }
        if (bl) {
            object = instance instanceof Cls ? this.javaFactory.createCls(instance.getFrameID(), collection) : (instance instanceof Slot ? this.javaFactory.createSlot(instance.getFrameID(), collection) : this.javaFactory.createSimpleInstance(instance.getFrameID(), collection));
        }
        if (!(object instanceof RDFResource)) {
            return new DefaultRDFProperty(this.owlModel, instance.getFrameID());
        }
        return (RDFResource)object;
    }

    protected Collection getReferences(Object object) {
        Collection collection = super.getReferences(object);
        if (collection.isEmpty()) {
            return collection;
        }
        for (ReferenceImpl referenceImpl : collection) {
            Instance instance = this.handler.convertInstance((Instance)referenceImpl.getFrame());
            Slot slot = (Slot)this.handler.convertInstance((Instance)referenceImpl.getSlot());
            referenceImpl.set((Frame)instance, slot, referenceImpl.getFacet(), referenceImpl.isTemplate());
        }
        return collection;
    }

    public String getName() {
        return this.getNarrowFrameStore().getName();
    }

    protected Collection getValues(Instance instance, Slot slot) {
        return this.wrap(super.getValues(instance, slot));
    }

    public Iterator listObjects(RDFResource rDFResource, RDFProperty rDFProperty) {
        return this.wrap(super.listObjects(rDFResource, rDFProperty));
    }

    public Iterator listSubjects(RDFProperty rDFProperty) {
        return this.wrap(super.listSubjects(rDFProperty));
    }

    public Iterator listTriples() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public Iterator wrap(Iterator iterator) {
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            if (instance instanceof RDFResource) {
                arrayList.add(instance);
                continue;
            }
            RDFResource rDFResource = this.getRDFResource(instance);
            arrayList.add(rDFResource);
        }
        return arrayList.iterator();
    }

    public Collection wrap(Collection collection) {
        return this.handler.convertCollection(collection);
    }
}

