/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.framestore.EventGeneratorFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.database.triplestore.DatabaseTripleStoreModel;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.OntModelProvider;
import edu.stanford.smi.protegex.owl.jena.creator.JenaCreator;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.framestore.LocalClassificationFrameStore;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameFactoryInvocationHandler;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLNamespaceManager;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.widget.ModalProgressBarManager;
import java.util.List;
import java.util.logging.Logger;

public class OWLDatabaseModel
extends AbstractOWLModel
implements OntModelProvider {
    private static transient Logger log = Log.getLogger(OWLDatabaseModel.class);
    private TripleStoreModel tripleStoreModel;

    public OWLDatabaseModel(KnowledgeBaseFactory knowledgeBaseFactory) {
        super(knowledgeBaseFactory);
    }

    public void initializeClient() {
        this.getOWLSystemFramesArray();
        this.initialize();
    }

    public void initialize() {
        OWLNamespaceManager oWLNamespaceManager = new OWLNamespaceManager();
        super.initialize(oWLNamespaceManager);
        this.initCustomFrameStores();
        this.setFrameFactory((FrameFactory)new OWLJavaFactory(this));
        this.adjustThing();
        this.adjustSystemClasses();
        this.getNamespaceManager().update();
    }

    public OWLOntology getDefaultOWLOntology() {
        OWLOntology oWLOntology = super.getDefaultOWLOntology();
        if (oWLOntology == null) {
            this.createDefaultOWLOntologyReally();
            return super.getDefaultOWLOntology();
        }
        return oWLOntology;
    }

    public OntModel getOntModel() {
        long l = System.currentTimeMillis();
        JenaCreator jenaCreator = new JenaCreator(this, false, null, new ModalProgressBarManager("Converting Ontology"));
        OntModel ontModel = jenaCreator.createOntModel();
        long l2 = System.currentTimeMillis();
        System.out.println("[OWLDatabaseModel.getOntModel] Duration " + (l2 - l));
        return ontModel;
    }

    public OntModel getOWLDLOntModel() {
        long l = System.currentTimeMillis();
        JenaCreator jenaCreator = new JenaCreator(this, true, null, new ModalProgressBarManager("Preparing Ontology"));
        OntModel ontModel = jenaCreator.createOntModel();
        long l2 = System.currentTimeMillis();
        System.out.println("[OWLDatabaseModel.getOWLDLOntModel] Duration " + (l2 - l));
        return ontModel;
    }

    public int getOWLSpecies() {
        OntModel ontModel = this.getOntModel();
        return Jena.getOWLSpecies(ontModel);
    }

    public OntModel getReasonerOntModel(String string) {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://foo.de#foo");
        model.add(resource, ReasonerVocabulary.EXT_REASONER_URL, string);
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", resource);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner((Reasoner)dIGReasoner);
        OntModel ontModel = Jena.cloneOntModel(this.getOntModel(), ontModelSpec);
        return ontModel;
    }

    public String getNextAnonymousResourceName() {
        int n;
        String string;
        do {
            n = (int)(Math.random() * 1000000.0);
        } while (this.getFrame(string = "@" + n) != null);
        return string;
    }

    public TripleStoreModel getTripleStoreModel() {
        if (this.tripleStoreModel == null) {
            this.tripleStoreModel = new DatabaseTripleStoreModel(this);
        }
        return this.tripleStoreModel;
    }

    public void setTripleStoreModel(TripleStoreModel tripleStoreModel) {
        this.tripleStoreModel = tripleStoreModel;
    }

    public void initCustomFrameStores() {
        this.initOWLFrameStore();
    }

    public void initDefaultNamespaces() {
        NamespaceManager namespaceManager = this.getNamespaceManager();
        namespaceManager.setPrefix(OWL.getURI(), "owl");
        namespaceManager.setPrefix(RDF.getURI(), "rdf");
        namespaceManager.setPrefix(RDFS.getURI(), "rdfs");
        namespaceManager.setPrefix("http://www.w3.org/2001/XMLSchema#", "xsd");
        namespaceManager.setModifiable("owl", false);
        namespaceManager.setModifiable("rdf", false);
        namespaceManager.setModifiable("rdfs", false);
        namespaceManager.setModifiable("xsd", false);
    }

    public void initOWLFrameFactoryInvocationHandler() {
        Class<OWLFrameFactoryInvocationHandler> clazz = OWLFrameFactoryInvocationHandler.class;
        FrameStore frameStore = AbstractFrameStoreInvocationHandler.newInstance(clazz, (KnowledgeBase)this);
        List list = this.getFrameStores();
        int n = 0;
        while (!(list.get(n) instanceof EventGeneratorFrameStore)) {
            ++n;
        }
        this.insertFrameStore(frameStore, n - 1);
    }

    public void resetTripleStoreModel() {
        this.tripleStoreModel = null;
    }

    public void setProject(Project project) {
        super.setProject(project);
        if (!project.isMultiUserServer()) {
            int n = this.getFrameStores().size() - 1;
            if (!(this.getFrameStores().get(n) instanceof LocalClassificationFrameStore)) {
                this.insertFrameStore((FrameStore)new LocalClassificationFrameStore(this), n);
            }
        }
    }
}

