/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryFileManager;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;

public class ProtegeOWL {
    public static String PLUGIN_FOLDER = "edu.stanford.smi.protegex.owl";

    public static JenaOWLModel createJenaOWLModel() {
        JenaKnowledgeBaseFactory jenaKnowledgeBaseFactory = new JenaKnowledgeBaseFactory();
        ArrayList arrayList = new ArrayList();
        Project project = Project.createNewProject((KnowledgeBaseFactory)jenaKnowledgeBaseFactory, arrayList);
        return (JenaOWLModel)project.getKnowledgeBase();
    }

    public static JenaOWLModel createJenaOWLModelFromInputStream(InputStream inputStream) throws Exception {
        JenaOWLModel jenaOWLModel = ProtegeOWL.createJenaOWLModel();
        jenaOWLModel.load(inputStream, "RDF/XML-ABBREV");
        return jenaOWLModel;
    }

    public static JenaOWLModel createJenaOWLModelFromReader(Reader reader) throws Exception {
        JenaOWLModel jenaOWLModel = ProtegeOWL.createJenaOWLModel();
        jenaOWLModel.load(reader, "RDF/XML-ABBREV");
        return jenaOWLModel;
    }

    public static JenaOWLModel createJenaOWLModelFromURI(String string) throws Exception {
        JenaOWLModel jenaOWLModel = ProtegeOWL.createJenaOWLModel();
        Project project = jenaOWLModel.getProject();
        if (project != null) {
            JenaKnowledgeBaseFactory.setOWLFileName(project.getSources(), string);
        }
        ProtegeOWL.loadRepositories(jenaOWLModel);
        jenaOWLModel.load(new URI(string), "RDF/XML-ABBREV");
        return jenaOWLModel;
    }

    private static void loadRepositories(OWLModel oWLModel) {
        RepositoryFileManager repositoryFileManager = new RepositoryFileManager(oWLModel);
        repositoryFileManager.loadProjectRepositories();
    }

    public static File getPluginFolder() {
        return new File(new File(ApplicationProperties.getApplicationDirectory(), "plugins"), PLUGIN_FOLDER);
    }

    public static void initProject(Project project, String string, String string2) {
        JenaKnowledgeBaseFactory.setOWLFileLanguage(project.getSources(), string2);
        JenaKnowledgeBaseFactory.setOWLFileName(project.getSources(), string);
    }

    public static void main(String[] stringArray) {
        Application.main((String[])stringArray);
    }
}

