/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;

public class Util {
    public static void checkJavaIdentifier(String pName) {
        if (pName.length() == 0) {
            throw new IllegalArgumentException("A valid Java identifier must not be empty.");
        }
        char c = pName.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            throw new IllegalArgumentException("The identifier " + pName + " is no valid Java identifier, because its first character is " + c);
        }
        for (int i = 1; i < pName.length(); ++i) {
            if (Character.isJavaIdentifierPart(c)) continue;
            throw new IllegalArgumentException("The identifier " + pName + " is no valid Java identifier, because it contains the character " + c);
        }
    }

    public static String asJavaIdentifier(String pIdentifier) {
        if (pIdentifier == null || pIdentifier.length() == 0) {
            throw new IllegalArgumentException("A null or empty String cannot be converted into a valid Java identifier.");
        }
        StringBuffer sb = new StringBuffer();
        char c = pIdentifier.charAt(0);
        sb.append(Character.isJavaIdentifierStart(c) ? c : (char)'_');
        for (int i = 1; i < pIdentifier.length(); ++i) {
            c = pIdentifier.charAt(i);
            sb.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
        }
        return sb.toString();
    }

    public static JavaSource newJavaSource(JavaSourceFactory pFactory, Class pClass) {
        Field[] fields;
        Method[] methods;
        Constructor<?>[] constructors;
        Class<?>[] interfaces;
        JavaQName qName = JavaQNameImpl.getInstance(pClass);
        int modifiers = pClass.getModifiers();
        JavaSource js = pFactory.newJavaSource(qName, JavaSource.Protection.valueOf(modifiers));
        js.setAbstract(Modifier.isAbstract(modifiers));
        js.setStatic(Modifier.isStatic(modifiers));
        js.setType(Modifier.isInterface(modifiers) ? JavaSource.INTERFACE : JavaSource.CLASS);
        Class superClass = pClass.getSuperclass();
        if (superClass != null) {
            js.addExtends(superClass);
        }
        if ((interfaces = pClass.getInterfaces()) != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                js.addImplements(interfaces[i]);
            }
        }
        if ((constructors = pClass.getConstructors()) != null) {
            for (int i = 0; i < constructors.length; ++i) {
                js.newJavaConstructor(constructors[i]);
            }
        }
        if ((methods = pClass.getMethods()) != null) {
            for (int i = 0; i < methods.length; ++i) {
                js.newJavaMethod(methods[i]);
            }
        }
        if ((fields = pClass.getFields()) != null) {
            for (int i = 0; i < fields.length; ++i) {
                js.newJavaField(fields[i]);
            }
        }
        return js;
    }
}

