/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ws.jaxme.js.IndentationTarget;

public class JavaComment {
    boolean forJavaDoc;
    private List authors;
    private String version;
    private String returns;
    private List see = new ArrayList();
    private ArrayList lines = new ArrayList();
    private List params = new ArrayList();
    private List throwsList = new ArrayList();

    JavaComment() {
        this.forJavaDoc = true;
    }

    JavaComment(boolean javaDoc) {
        this.forJavaDoc = javaDoc;
    }

    public List getAuthors() {
        return this.authors;
    }

    public void addAuthor(String author) {
        if (this.authors == null) {
            this.authors = new ArrayList();
        }
        this.authors.add(author);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String pVersion) {
        this.version = pVersion != null && pVersion.length() > 0 ? pVersion : null;
    }

    public String getReturn() {
        return this.returns;
    }

    public void setReturn(String pReturns) {
        this.returns = pReturns != null && pReturns.length() > 0 ? pReturns : null;
    }

    public List getSee() {
        return this.see;
    }

    public void addSee(String pSee) {
        this.see.add(pSee);
    }

    public ArrayList getLines() {
        return this.lines;
    }

    public void addLine(String s) {
        if (s == null) {
            s = "";
        }
        boolean done = false;
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.length() > 0 && t.charAt(t.length() - 1) == '\r') {
                t = t.substring(0, t.charAt(t.length() - 1));
            }
            this.lines.add(t);
            done = true;
        }
        if (!done) {
            this.lines.add("");
        }
    }

    public List getParams() {
        return this.params;
    }

    public void addParam(String s) {
        this.params.add(s);
    }

    public List getThrows() {
        return this.throwsList;
    }

    public void addThrows(String s) {
        this.throwsList.add(s);
    }

    public void write(IndentationTarget pTarget) throws IOException {
        int i;
        String sep = "/*" + (this.forJavaDoc ? "* " : " ");
        String othersep = " * ";
        if (this.lines.size() > 0) {
            for (i = 0; i < this.lines.size(); ++i) {
                if (i > 0) {
                    pTarget.indent(0);
                }
                pTarget.write(sep);
                pTarget.write(this.lines.get(i).toString());
                pTarget.write();
                sep = othersep;
            }
        } else {
            pTarget.write(sep);
            pTarget.write();
            sep = othersep;
        }
        pTarget.indent(0);
        pTarget.write(sep);
        pTarget.write();
        for (i = 0; i < this.params.size(); ++i) {
            pTarget.indent(0);
            pTarget.write(sep);
            pTarget.write("@param ");
            pTarget.write(this.params.get(i).toString());
            pTarget.write();
        }
        if (this.returns != null) {
            pTarget.indent(0);
            pTarget.write(sep);
            pTarget.write("@return ");
            pTarget.write(this.returns);
            pTarget.write();
        }
        for (i = 0; i < this.throwsList.size(); ++i) {
            pTarget.indent(0);
            pTarget.write(sep);
            pTarget.write("@throws ");
            pTarget.write(this.throwsList.get(i).toString());
            pTarget.write();
        }
        for (i = 0; i < this.see.size(); ++i) {
            pTarget.indent(0);
            pTarget.write(sep);
            pTarget.write("@see ");
            pTarget.write(this.see.get(i).toString());
            pTarget.write();
        }
        List myAuthors = this.getAuthors();
        if (myAuthors != null) {
            Iterator iter = myAuthors.iterator();
            while (iter.hasNext()) {
                pTarget.indent(0);
                pTarget.write(sep);
                pTarget.write("@author ");
                pTarget.write((String)iter.next());
                pTarget.write();
            }
        }
        if (this.version != null) {
            pTarget.indent(0);
            pTarget.write(sep);
            pTarget.write("@version ");
            pTarget.write(this.version);
            pTarget.write();
        }
        pTarget.indent(0);
        pTarget.write(" */");
        pTarget.write();
    }
}

