/*
 * Decompiled with CFR 0.152.
 */
package org.shetline.io;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class GIFOutputStream
extends FilterOutputStream {
    public static final int ORIGINAL_COLOR = 0;
    public static final int BLACK_AND_WHITE = 1;
    public static final int GRAYSCALE_16 = 2;
    public static final int GRAYSCALE_256 = 3;
    public static final int STANDARD_16_COLORS = 4;
    public static final int STANDARD_256_COLORS = 5;
    public static final int DITHERED_216_COLORS = 6;
    public static final int NO_ERROR = 0;
    public static final int IMAGE_LOAD_FAILED = 1;
    public static final int TOO_MANY_COLORS = 2;
    public static final int INVALID_COLOR_MODE = 3;
    protected static final int BLACK_INDEX = 0;
    protected static final int WHITE_INDEX = 1;
    protected static final int[] standard16 = new int[]{0, 0xFF0000, 65280, 255, 65535, 0xFF00FF, 0xFFFF00, 0x800000, 32768, 128, 32896, 0x800080, 0x808000, 0x808080, 0xC0C0C0, 0xFFFFFF};
    protected static final int[] standard256 = new int[256];
    protected static int[][] ditherPattern = new int[][]{{8, 184, 248, 216}, {120, 56, 152, 88}, {40, 232, 24, 200}, {168, 104, 136, 72}};
    protected int errorStatus = 0;
    protected int rl_pixel;
    protected int rl_basecode;
    protected int rl_count;
    protected int rl_table_pixel;
    protected int rl_table_max;
    protected boolean just_cleared;
    protected int out_bits;
    protected int out_bits_init;
    protected int out_count;
    protected int out_bump;
    protected int out_bump_init;
    protected int out_clear;
    protected int out_clear_init;
    protected int max_ocodes;
    protected int code_clear;
    protected int code_eof;
    protected int obuf;
    protected int obits;
    protected byte[] oblock = new byte[256];
    protected int oblen;
    protected static final int GIFBITS = 12;

    public static int writeGIF(OutputStream outputStream, Image image) throws IOException {
        return GIFOutputStream.writeGIF(outputStream, image, 0, null);
    }

    public static int writeGIF(OutputStream outputStream, Image image, int n) throws IOException {
        return GIFOutputStream.writeGIF(outputStream, image, n, null);
    }

    public static int writeGIF(OutputStream outputStream, Image image, int n, Color color) throws IOException {
        GIFOutputStream gIFOutputStream = new GIFOutputStream(outputStream);
        gIFOutputStream.write(image, n, color);
        return gIFOutputStream.getErrorStatus();
    }

    public GIFOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public int getErrorStatus() {
        return this.errorStatus;
    }

    public void write(Image image) throws IOException {
        this.write(image, 0, null);
    }

    public void write(Image image, int n) throws IOException {
        this.write(image, n, null);
    }

    public void write(Image image, Color color) throws IOException {
        this.write(image, 0, color);
    }

    public void write(Image image, int n, Color color) throws IOException {
        this.errorStatus = 0;
        if (image == null) {
            return;
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            this.errorStatus = 1;
            return;
        }
        if ((pixelGrabber.status() & 0x80) != 0) {
            this.errorStatus = 1;
            return;
        }
        int[] nArray = (int[])pixelGrabber.getPixels();
        int n2 = pixelGrabber.getWidth();
        int n3 = pixelGrabber.getHeight();
        int n4 = 0;
        int[] nArray2 = null;
        byte[] byArray = null;
        switch (n) {
            case 0: {
                Hashtable hashtable = this.getColorSet(nArray);
                n4 = hashtable.size();
                if (n4 > 256) {
                    this.errorStatus = 2;
                    return;
                }
                nArray2 = this.createColorTable(hashtable, n4);
                byArray = this.createBytePixels(nArray, hashtable);
                break;
            }
            case 1: {
                n4 = 2;
                nArray2 = this.createBWTable();
                byArray = this.createBWBytePixels(nArray);
                break;
            }
            case 2: {
                n4 = 16;
                nArray2 = this.create16GrayTable();
                byArray = this.create16GrayBytePixels(nArray);
                break;
            }
            case 3: {
                n4 = 256;
                nArray2 = this.create256GrayTable();
                byArray = this.create256GrayBytePixels(nArray);
                break;
            }
            case 4: {
                n4 = 16;
                nArray2 = this.createStd16ColorTable();
                byArray = this.createStd16ColorBytePixels(nArray);
                break;
            }
            case 5: {
                n4 = 256;
                nArray2 = this.createStd256ColorTable();
                byArray = this.createStd256ColorBytePixels(nArray, n2, false);
                break;
            }
            case 6: {
                n4 = 216;
                nArray2 = this.createStd216ColorTable();
                byArray = this.createStd256ColorBytePixels(nArray, n2, true);
                break;
            }
            default: {
                this.errorStatus = 3;
                return;
            }
        }
        nArray = null;
        int n5 = n4 - 1;
        int n6 = 0;
        while (n5 != 0) {
            ++n6;
            n5 >>= 1;
        }
        this.writeGIFHeader(n2, n3, n6);
        this.writeColorTable(nArray2, n6);
        if (color != null) {
            this.writeGraphicControlExtension(color, nArray2);
        }
        this.writeImageDescriptor(n2, n3);
        this.writeCompressedImageData(byArray, n6);
        this.write(0);
        this.write(59);
    }

    protected Hashtable getColorSet(int[] nArray) {
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        boolean[] blArray = new boolean[nArray.length];
        int n = nArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length && n > 0) {
            if (!blArray[n3]) {
                int n4 = nArray[n3] & 0xFFFFFF;
                blArray[n3] = true;
                --n;
                Integer n5 = new Integer(n4);
                hashtable.put(n5, new Integer(n2));
                if (++n2 > 256) break;
                int n6 = n3 + 1;
                while (n6 < nArray.length) {
                    if ((nArray[n6] & 0xFFFFFF) == n4) {
                        blArray[n6] = true;
                        --n;
                    }
                    ++n6;
                }
            }
            ++n3;
        }
        if (n2 == 1) {
            if (hashtable.get(new Integer(0)) == null) {
                hashtable.put(new Integer(0), new Integer(1));
            } else {
                hashtable.put(new Integer(0xFFFFFF), new Integer(1));
            }
        }
        return hashtable;
    }

    protected int[] createColorTable(Hashtable hashtable, int n) {
        int[] nArray = new int[n];
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            nArray[((Integer)hashtable.get((Object)n2)).intValue()] = n2;
        }
        return nArray;
    }

    protected byte[] createBytePixels(int[] nArray, Hashtable hashtable) {
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            Integer n2 = new Integer(nArray[n] & 0xFFFFFF);
            int n3 = (Integer)hashtable.get(n2);
            byArray[n] = (byte)n3;
            ++n;
        }
        return byArray;
    }

    protected int[] createBWTable() {
        int[] nArray = new int[]{0, 0xFFFFFF};
        return nArray;
    }

    protected byte[] createBWBytePixels(int[] nArray) {
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            byArray[n] = this.grayscaleValue(nArray[n]) < 128 ? (byte)0 : 1;
            ++n;
        }
        return byArray;
    }

    protected int[] create16GrayTable() {
        int[] nArray = new int[16];
        int n = 0;
        while (n < 16) {
            nArray[n] = 0x111111 * n;
            ++n;
        }
        return nArray;
    }

    protected byte[] create16GrayBytePixels(int[] nArray) {
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            byArray[n] = (byte)(this.grayscaleValue(nArray[n]) / 16);
            ++n;
        }
        return byArray;
    }

    protected int[] create256GrayTable() {
        int[] nArray = new int[256];
        int n = 0;
        while (n < 256) {
            nArray[n] = 65793 * n;
            ++n;
        }
        return nArray;
    }

    protected byte[] create256GrayBytePixels(int[] nArray) {
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            byArray[n] = (byte)this.grayscaleValue(nArray[n]);
            ++n;
        }
        return byArray;
    }

    protected int[] createStd16ColorTable() {
        int[] nArray = new int[16];
        int n = 0;
        while (n < 16) {
            nArray[n] = standard16[n];
            ++n;
        }
        return nArray;
    }

    protected byte[] createStd16ColorBytePixels(int[] nArray) {
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2] & 0xFFFFFF;
            int n4 = -1;
            int n5 = 0;
            while (n5 < 16) {
                int n6 = this.colorMatchError(n3, standard16[n5]);
                if (n6 < n || n4 < 0) {
                    n = n6;
                    n4 = n5;
                }
                ++n5;
            }
            byArray[n2] = (byte)n4;
            ++n2;
        }
        return byArray;
    }

    protected int[] createStd256ColorTable() {
        int[] nArray = new int[256];
        int n = 0;
        while (n < 256) {
            nArray[n] = standard256[n];
            ++n;
        }
        return nArray;
    }

    protected int[] createStd216ColorTable() {
        int[] nArray = new int[216];
        nArray[0] = 0;
        int n = 1;
        while (n < 216) {
            nArray[n] = standard256[n + 40];
            ++n;
        }
        return nArray;
    }

    protected byte[] createStd256ColorBytePixels(int[] nArray, int n, boolean bl) {
        byte[] byArray = new byte[nArray.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = nArray[n3] & 0xFFFFFF;
            int n5 = -1;
            int n6 = (n4 & 0xFF0000) >> 16;
            int n7 = (n4 & 0xFF00) >> 8;
            int n8 = n4 & 0xFF;
            int n9 = n6 / 51;
            int n10 = n7 / 51;
            int n11 = n8 / 51;
            if (bl) {
                int n12 = n3 % n;
                int n13 = n3 / n;
                int n14 = ditherPattern[n12 % 4][n13 % 4] / 5;
                if (n9 < 5 && n6 % 51 >= n14) {
                    ++n9;
                }
                if (n10 < 5 && n7 % 51 >= n14) {
                    ++n10;
                }
                if (n11 < 5 && n8 % 51 >= n14) {
                    ++n11;
                }
                byArray[n3] = (byte)(n9 * 36 + n10 * 6 + n11);
            } else {
                int n15;
                int n16;
                int n17;
                int n18;
                int n19 = n9;
                while (n19 <= n9 + 1 && n19 < 6) {
                    n18 = n10;
                    while (n18 <= n10 + 1 && n18 < 6) {
                        n17 = n11;
                        while (n17 <= n11 + 1 && n17 < 6) {
                            n16 = 40 + n19 * 36 + n18 * 6 + n17;
                            if (n16 == 40) {
                                n16 = 0;
                            }
                            if ((n15 = this.colorMatchError(n4, standard256[n16])) < n2 || n5 < 0) {
                                n2 = n15;
                                n5 = n16;
                            }
                            ++n17;
                        }
                        ++n18;
                    }
                    ++n19;
                }
                if (n6 > n7 && n6 > n8) {
                    n18 = 30;
                    n17 = (n6 + 8) / 17;
                } else if (n7 > n6 && n7 > n8) {
                    n18 = 20;
                    n17 = (n7 + 8) / 17;
                } else {
                    n18 = 10;
                    n17 = (n8 + 8) / 17;
                }
                if (n17 > 0 && ((n15 = this.colorMatchError(n4, standard256[n16 = n18 + (n17 -= n17 / 3)])) < n2 || n5 < 0)) {
                    n2 = n15;
                    n5 = n16;
                }
                if ((n17 = (this.grayscaleValue(n4) + 8) / 17) > 0 && ((n15 = this.colorMatchError(n4, standard256[n16 = (n17 -= n17 / 3)])) < n2 || n5 < 0)) {
                    n2 = n15;
                    n5 = n16;
                }
                byArray[n3] = (byte)n5;
            }
            ++n3;
        }
        return byArray;
    }

    protected int grayscaleValue(int n) {
        int n2 = (n & 0xFF0000) >> 16;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = n & 0xFF;
        return (n2 * 30 + n3 * 59 + n4 * 11) / 100;
    }

    protected int colorMatchError(int n, int n2) {
        int n3 = (n & 0xFF0000) >> 16;
        int n4 = (n & 0xFF00) >> 8;
        int n5 = n & 0xFF;
        int n6 = (n2 & 0xFF0000) >> 16;
        int n7 = (n2 & 0xFF00) >> 8;
        int n8 = n2 & 0xFF;
        int n9 = (n6 - n3) * 30;
        int n10 = (n7 - n4) * 59;
        int n11 = (n8 - n5) * 11;
        return (n9 * n9 + n10 * n10 + n11 * n11) / 100;
    }

    protected void writeGIFHeader(int n, int n2, int n3) throws IOException {
        this.write(71);
        this.write(73);
        this.write(70);
        this.write(56);
        this.write(57);
        this.write(97);
        this.writeGIFWord(n);
        this.writeGIFWord(n2);
        int n4 = 128;
        this.write(n4 |= n3 - 1 << 4 | n3 - 1);
        this.write(0);
        this.write(0);
    }

    protected void writeColorTable(int[] nArray, int n) throws IOException {
        int n2 = 1 << n;
        int n3 = 0;
        while (n3 < n2) {
            if (n3 < nArray.length) {
                this.writeGIFColor(nArray[n3]);
            } else {
                this.writeGIFColor(0);
            }
            ++n3;
        }
    }

    protected void writeGraphicControlExtension(Color color, int[] nArray) throws IOException {
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] == (color.getRGB() & 0xFFFFFF)) {
                this.write(33);
                this.write(249);
                this.write(4);
                this.write(1);
                this.write(0);
                this.write(0);
                this.write(n);
                this.write(0);
            }
            ++n;
        }
    }

    protected void writeImageDescriptor(int n, int n2) throws IOException {
        this.write(44);
        this.writeGIFWord(0);
        this.writeGIFWord(0);
        this.writeGIFWord(n);
        this.writeGIFWord(n2);
        this.write(0);
    }

    protected void writeGIFWord(short s) throws IOException {
        this.writeGIFWord((int)s);
    }

    protected void writeGIFWord(int n) throws IOException {
        this.write(n & 0xFF);
        this.write((n & 0xFF00) >> 8);
    }

    protected void writeGIFColor(Color color) throws IOException {
        this.writeGIFColor(color.getRGB());
    }

    protected void writeGIFColor(int n) throws IOException {
        this.write((n & 0xFF0000) >> 16);
        this.write((n & 0xFF00) >> 8);
        this.write(n & 0xFF);
    }

    protected void writeCompressedImageData(byte[] byArray, int n) throws IOException {
        int n2 = n;
        if (n2 < 2) {
            n2 = 2;
        }
        this.write(n2);
        this.obuf = 0;
        this.obits = 0;
        this.oblen = 0;
        this.code_clear = 1 << n2;
        this.code_eof = this.code_clear + 1;
        this.rl_basecode = this.code_eof + 1;
        this.out_bump_init = (1 << n2) - 1;
        this.out_clear_init = n2 <= 2 ? 9 : this.out_bump_init - 1;
        this.out_bits_init = n2 + 1;
        this.max_ocodes = 4096 - ((1 << this.out_bits_init - 1) + 3);
        this.did_clear();
        this.output(this.code_clear);
        this.rl_count = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            int n4 = byArray[n3];
            if (n4 < 0) {
                n4 += 256;
            }
            if (this.rl_count > 0 && n4 != this.rl_pixel) {
                this.rl_flush();
            }
            if (this.rl_pixel == n4) {
                ++this.rl_count;
            } else {
                this.rl_pixel = n4;
                this.rl_count = 1;
            }
            ++n3;
        }
        if (this.rl_count > 0) {
            this.rl_flush();
        }
        this.output(this.code_eof);
        this.output_flush();
    }

    protected void write_block() throws IOException {
        this.write(this.oblen);
        this.write(this.oblock, 0, this.oblen);
        this.oblen = 0;
    }

    protected void block_out(int n) throws IOException {
        this.oblock[this.oblen++] = (byte)n;
        if (this.oblen >= 255) {
            this.write_block();
        }
    }

    protected void block_flush() throws IOException {
        if (this.oblen > 0) {
            this.write_block();
        }
    }

    protected void output(int n) throws IOException {
        this.obuf |= n << this.obits;
        this.obits += this.out_bits;
        while (this.obits >= 8) {
            this.block_out(this.obuf & 0xFF);
            this.obuf >>= 8;
            this.obits -= 8;
        }
    }

    protected void output_flush() throws IOException {
        if (this.obits > 0) {
            this.block_out(this.obuf);
        }
        this.block_flush();
    }

    protected void did_clear() throws IOException {
        this.out_bits = this.out_bits_init;
        this.out_bump = this.out_bump_init;
        this.out_clear = this.out_clear_init;
        this.out_count = 0;
        this.rl_table_max = 0;
        this.just_cleared = true;
    }

    protected void output_plain(int n) throws IOException {
        this.just_cleared = false;
        this.output(n);
        ++this.out_count;
        if (this.out_count >= this.out_bump) {
            ++this.out_bits;
            this.out_bump += 1 << this.out_bits - 1;
        }
        if (this.out_count >= this.out_clear) {
            this.output(this.code_clear);
            this.did_clear();
        }
    }

    protected int isqrt(int n) {
        if (n < 2) {
            return n;
        }
        int n2 = n;
        int n3 = 1;
        while (n2 != 0) {
            n2 >>= 2;
            n3 <<= 1;
        }
        while ((n2 = (n / n3 + n3) / 2) != n3 && n2 != n3 + 1) {
            n3 = n2;
        }
        return n3;
    }

    protected int compute_triangle_count(int n, int n2) {
        int n3 = 0;
        int n4 = n2 * (n2 + 1) / 2;
        while (n >= n4) {
            n3 += n2;
            n -= n4;
        }
        if (n > 0) {
            int n5 = this.isqrt(n);
            while (n5 * (n5 + 1) >= 2 * n) {
                --n5;
            }
            while (n5 * (n5 + 1) < 2 * n) {
                ++n5;
            }
            n3 += n5;
        }
        return n3;
    }

    protected void max_out_clear() {
        this.out_clear = this.max_ocodes;
    }

    protected void reset_out_clear() throws IOException {
        this.out_clear = this.out_clear_init;
        if (this.out_count >= this.out_clear) {
            this.output(this.code_clear);
            this.did_clear();
        }
    }

    protected void rl_flush_fromclear(int n) throws IOException {
        this.max_out_clear();
        this.rl_table_pixel = this.rl_pixel;
        int n2 = 1;
        while (n > 0) {
            if (n2 == 1) {
                this.rl_table_max = 1;
                this.output_plain(this.rl_pixel);
                --n;
            } else if (n >= n2) {
                this.rl_table_max = n2;
                this.output_plain(this.rl_basecode + n2 - 2);
                n -= n2;
            } else if (n == 1) {
                ++this.rl_table_max;
                this.output_plain(this.rl_pixel);
                n = 0;
            } else {
                ++this.rl_table_max;
                this.output_plain(this.rl_basecode + n - 2);
                n = 0;
            }
            if (this.out_count == 0) {
                n2 = 1;
                continue;
            }
            ++n2;
        }
        this.reset_out_clear();
    }

    /*
     * Unable to fully structure code
     */
    protected void rl_flush_clearorrep(int var1_1) throws IOException {
        block1: {
            var2_2 = 1 + this.compute_triangle_count(var1_1, this.max_ocodes);
            if (var2_2 >= var1_1) ** GOTO lbl9
            this.output(this.code_clear);
            this.did_clear();
            this.rl_flush_fromclear(var1_1);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.output_plain(this.rl_pixel);
                --var1_1;
lbl9:
                // 2 sources

                ** while (var1_1 > 0)
            }
        }
    }

    protected void rl_flush_withtable(int n) throws IOException {
        int n2;
        int n3 = n / this.rl_table_max;
        int n4 = n % this.rl_table_max;
        int n5 = n2 = n4 != 0 ? 1 : 0;
        if (this.out_count + n3 + n2 > this.max_ocodes) {
            n3 = this.max_ocodes - this.out_count;
            n4 = n - n3 * this.rl_table_max;
            n2 = 1 + this.compute_triangle_count(n4, this.max_ocodes);
        }
        if (1 + this.compute_triangle_count(n, this.max_ocodes) < n3 + n2) {
            this.output(this.code_clear);
            this.did_clear();
            this.rl_flush_fromclear(n);
            return;
        }
        this.max_out_clear();
        while (n3 > 0) {
            this.output_plain(this.rl_basecode + this.rl_table_max - 2);
            --n3;
        }
        if (n4 != 0) {
            if (this.just_cleared) {
                this.rl_flush_fromclear(n4);
            } else if (n4 == 1) {
                this.output_plain(this.rl_pixel);
            } else {
                this.output_plain(this.rl_basecode + n4 - 2);
            }
        }
        this.reset_out_clear();
    }

    protected void rl_flush() throws IOException {
        if (this.rl_count == 1) {
            this.output_plain(this.rl_pixel);
            this.rl_count = 0;
            return;
        }
        if (this.just_cleared) {
            this.rl_flush_fromclear(this.rl_count);
        } else if (this.rl_table_max < 2 || this.rl_table_pixel != this.rl_pixel) {
            this.rl_flush_clearorrep(this.rl_count);
        } else {
            this.rl_flush_withtable(this.rl_count);
        }
        this.rl_count = 0;
    }

    static {
        GIFOutputStream.standard256[0] = 0;
        int n = 40;
        int n2 = 0;
        while (n2 < 6) {
            int n3 = 0;
            while (n3 < 6) {
                int n4 = 0;
                while (n4 < 6) {
                    GIFOutputStream.standard256[n++] = 0x330000 * n2 | 13056 * n3 | 51 * n4;
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        n = 1;
        int n5 = 0;
        while (n5 < 10) {
            GIFOutputStream.standard256[n5 + 1] = 0x111111 * n;
            GIFOutputStream.standard256[n5 + 11] = 17 * n;
            GIFOutputStream.standard256[n5 + 21] = 4352 * n;
            GIFOutputStream.standard256[n5 + 31] = 0x110000 * n;
            if (++n % 3 == 0) {
                ++n;
            }
            ++n5;
        }
    }
}

