/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.ws.jaxme.JMUnmarshaller;
import org.apache.ws.jaxme.impl.JMControllerImpl;
import org.apache.ws.jaxme.impl.JMUnmarshallerHandlerImpl;
import org.apache.ws.jaxme.util.DOMSerializer;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JMUnmarshallerImpl
extends JMControllerImpl
implements JMUnmarshaller {
    private static final SAXParserFactory spf = SAXParserFactory.newInstance();
    private boolean validating;

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean pValidating) {
        this.validating = pValidating;
    }

    public Object unmarshal(URL pURL) throws JAXBException {
        InputSource isource;
        try {
            isource = new InputSource(pURL.openStream());
            isource.setSystemId(pURL.toString());
        }
        catch (IOException e) {
            throw new UnmarshalException("Failed to open URL " + pURL, (Throwable)e);
        }
        return this.unmarshal(isource);
    }

    public Object unmarshal(File pFile) throws JAXBException {
        InputSource isource;
        try {
            isource = new InputSource(new FileInputStream(pFile));
            isource.setSystemId(pFile.toURL().toString());
        }
        catch (IOException e) {
            throw new UnmarshalException("Failed to open file " + pFile, (Throwable)e);
        }
        return this.unmarshal(isource);
    }

    public Object unmarshal(InputStream pStream) throws JAXBException {
        return this.unmarshal(new InputSource(pStream));
    }

    public Object unmarshal(InputSource pSource) throws JAXBException {
        UnmarshallerHandler uh = this.getUnmarshallerHandler();
        try {
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            xr.setContentHandler((ContentHandler)uh);
            xr.parse(pSource);
        }
        catch (SAXException e) {
            if (e.getException() != null) {
                throw new UnmarshalException((Throwable)e.getException());
            }
            throw new UnmarshalException((Throwable)e);
        }
        catch (IOException e) {
            throw new UnmarshalException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new UnmarshalException((Throwable)e);
        }
        return uh.getResult();
    }

    public Object unmarshal(Node pNode) throws JAXBException {
        UnmarshallerHandler uh = this.getUnmarshallerHandler();
        DOMSerializer ds = new DOMSerializer();
        try {
            ds.serialize(pNode, (ContentHandler)uh);
        }
        catch (SAXException e) {
            if (e.getException() != null) {
                throw new UnmarshalException((Throwable)e.getException());
            }
            throw new UnmarshalException((Throwable)e);
        }
        return uh.getResult();
    }

    public Object unmarshal(Source pSource) throws JAXBException {
        if (pSource instanceof SAXSource) {
            SAXSource ss = (SAXSource)pSource;
            InputSource is = ss.getInputSource();
            if (is == null) {
                throw new UnmarshalException("The SAXResult doesn't have its InputSource set.");
            }
            XMLReader xr = ss.getXMLReader();
            if (xr == null) {
                return this.unmarshal(is);
            }
            UnmarshallerHandler uh = this.getUnmarshallerHandler();
            xr.setContentHandler((ContentHandler)uh);
            try {
                xr.parse(is);
            }
            catch (IOException e) {
                throw new JAXBException((Throwable)e);
            }
            catch (SAXException e) {
                if (e.getException() != null) {
                    throw new JAXBException((Throwable)e.getException());
                }
                throw new JAXBException((Throwable)e);
            }
            return uh.getResult();
        }
        if (pSource instanceof StreamSource) {
            StreamSource ss = (StreamSource)pSource;
            InputSource iSource = new InputSource();
            iSource.setPublicId(ss.getPublicId());
            iSource.setSystemId(ss.getSystemId());
            Reader r = ss.getReader();
            if (r == null) {
                InputStream is = ss.getInputStream();
                if (is == null) {
                    throw new IllegalArgumentException("The StreamSource doesn't have its Reader or InputStream set.");
                }
                iSource.setByteStream(is);
            } else {
                iSource.setCharacterStream(r);
            }
            return this.unmarshal(iSource);
        }
        if (pSource instanceof DOMSource) {
            Node node = ((DOMSource)pSource).getNode();
            if (node == null) {
                throw new IllegalArgumentException("The DOMSource doesn't have its Node set.");
            }
            return this.unmarshal(node);
        }
        throw new IllegalArgumentException("Unknown type of Source: " + pSource.getClass().getName() + ", only SAXSource, StreamSource and DOMSource are supported.");
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return new JMUnmarshallerHandlerImpl(this);
    }

    static {
        spf.setValidating(false);
        spf.setNamespaceAware(true);
    }
}

