/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.simulation.montecarlo.sampling;

import java.util.ArrayList;
import java.util.List;
import unbbayes.prs.Node;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonteCarloSampling {
    protected ProbabilisticNetwork pn;
    protected int nTrials;
    protected List<Node> samplingNodeOrderQueue;
    protected byte[][] sampledStatesMatrix;

    public List<Node> getSamplingNodeOrderQueue() {
        return this.samplingNodeOrderQueue;
    }

    public byte[][] getSampledStatesMatrix() {
        return this.sampledStatesMatrix;
    }

    public MonteCarloSampling(ProbabilisticNetwork pn, int nTrials) {
        this.pn = pn;
        this.nTrials = nTrials;
    }

    public void start() {
        this.samplingNodeOrderQueue = new ArrayList<Node>();
        this.createSamplingOrderQueue();
        this.sampledStatesMatrix = new byte[this.nTrials][this.pn.getNodeCount()];
        int i = 0;
        while (i < this.nTrials) {
            this.simulate(this.sampledStatesMatrix, i);
            ++i;
        }
    }

    protected void createSamplingOrderQueue() {
        boolean[] nodeAddedList = new boolean[this.pn.getNodeCount()];
        this.initSamplingOrderQueue(nodeAddedList);
        int i = 0;
        while (i < this.samplingNodeOrderQueue.size()) {
            Node node = this.samplingNodeOrderQueue.get(i);
            this.addToSamplingOrderQueue(node.getChildren(), nodeAddedList);
            ++i;
        }
    }

    protected void initSamplingOrderQueue(boolean[] nodeAddedList) {
        int i = 0;
        while (i < this.pn.getNodeCount()) {
            if (this.pn.getNodeAt(i).getParents().size() == 0) {
                nodeAddedList[i] = true;
                this.samplingNodeOrderQueue.add(this.pn.getNodeAt(i));
            }
            ++i;
        }
    }

    protected void addToSamplingOrderQueue(ArrayList<Node> children, boolean[] nodeAddedList) {
        int i = 0;
        while (i < children.size()) {
            Node n1 = children.get(i);
            int j = 0;
            while (j < this.pn.getNodeCount()) {
                Node n2 = this.pn.getNodeAt(j);
                if (n1.getName().equals(n2.getName()) && !nodeAddedList[j]) {
                    this.samplingNodeOrderQueue.add(n1);
                    nodeAddedList[j] = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void simulate(byte[][] sampledStatesMatrix, int nTrial) {
        ArrayList<Integer> parentsIndexes = new ArrayList();
        int[] sampledStates = new int[this.samplingNodeOrderQueue.size()];
        int i = 0;
        while (i < this.samplingNodeOrderQueue.size()) {
            ProbabilisticNode node = (ProbabilisticNode)this.samplingNodeOrderQueue.get(i);
            parentsIndexes = this.getParentsIndexesInQueue(node);
            double[] pmf = this.getProbabilityMassFunction(sampledStates, parentsIndexes, node);
            sampledStates[i] = this.getState(pmf);
            sampledStatesMatrix[nTrial][i] = (byte)sampledStates[i];
            ++i;
        }
    }

    protected List<Integer> getParentsIndexesInQueue(ProbabilisticNode node) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Node> parents = node.getParents();
        int i = 0;
        while (i < parents.size()) {
            Node parentNode = parents.get(i);
            indexes.add(this.getIndexInQueue(parentNode));
            ++i;
        }
        return indexes;
    }

    protected Integer getIndexInQueue(Node node) {
        int i = 0;
        while (i < this.samplingNodeOrderQueue.size()) {
            if (node.getName().equals(this.samplingNodeOrderQueue.get(i).getName())) {
                return i;
            }
            ++i;
        }
        return null;
    }

    protected int getState(double[] pmf) {
        double numero = Math.random();
        double[][] cdf = this.getCumulativeDistributionFunction(pmf);
        int i = 0;
        while (i < cdf.length) {
            if (i == 0 ? numero <= cdf[i][1] : numero <= cdf[i][1] && numero > cdf[i][0]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected double[][] getCumulativeDistributionFunction(double[] pmf) {
        double[][] cdf = new double[pmf.length][2];
        double atual = 0.0;
        int i = 0;
        while (i < pmf.length) {
            cdf[i][0] = atual;
            cdf[i][1] = pmf[i] + atual;
            atual = cdf[i][1];
            ++i;
        }
        return cdf;
    }

    protected double[] getProbabilityMassFunction(int[] sampledStates, List<Integer> parentsIndexes, ProbabilisticNode node) {
        PotentialTable pt = node.getPotentialTable();
        int statesSize = node.getStatesSize();
        double[] pmf = new double[statesSize];
        int[] coordinates = new int[parentsIndexes.size() + 1];
        ArrayList<Node> parents = new ArrayList<Node>();
        int i = 0;
        while (i < node.getStatesSize()) {
            coordinates[0] = i;
            if (i == 0) {
                int j = 0;
                while (j < parentsIndexes.size()) {
                    int nodeIndex = parentsIndexes.get(j);
                    parents.add(this.samplingNodeOrderQueue.get(nodeIndex));
                    coordinates[j + 1] = sampledStates[nodeIndex];
                    ++j;
                }
            }
            pmf[i] = pt.getValue(coordinates);
            ++i;
        }
        return pmf;
    }
}

