/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.msbn;

import java.util.ArrayList;
import java.util.List;
import unbbayes.prs.Network;
import unbbayes.prs.Node;
import unbbayes.prs.msbn.Linkage;
import unbbayes.prs.msbn.SubNetwork;
import unbbayes.util.SetToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMSBN
extends Network {
    protected List<SubNetwork> nets;
    protected List<Linkage> links;
    protected String id;

    public AbstractMSBN(String id) {
        super(id);
        this.id = id;
        this.nets = new ArrayList<SubNetwork>();
        this.links = new ArrayList<Linkage>();
    }

    public int getNetCount() {
        return this.nets.size();
    }

    public SubNetwork getNetAt(int index) {
        return this.nets.get(index);
    }

    public void addNetwork(SubNetwork net) {
        this.nets.add(net);
    }

    public void remove(int index) {
        this.nets.remove(index);
    }

    public void compile() throws Exception {
        this.compile(this.nets.get(0));
    }

    public void compile(SubNetwork activeNet) throws Exception {
        SubNetwork net;
        this.links.clear();
        int i = this.nets.size() - 1;
        while (i >= 0) {
            net = this.nets.get(i);
            net.adjacents.clear();
            net.parent = null;
            net.verifyConsistency();
            --i;
        }
        this.hyperTree();
        this.verifyCycles();
        this.distributedMoralization();
        this.cooperativeTriangulation();
        i = this.nets.size() - 1;
        while (i >= 0) {
            net = this.nets.get(i);
            net.compileJunctionTree();
            --i;
        }
        i = this.links.size() - 1;
        while (i >= 0) {
            Linkage link = this.links.get(i);
            link.makeLinkageTree();
            --i;
        }
        this.initBeliefs();
    }

    protected abstract void initBeliefs() throws Exception;

    protected void coletBeliefs(SubNetwork net) throws Exception {
        int i = net.adjacents.size() - 1;
        while (i >= 0) {
            SubNetwork netAdj = net.adjacents.get(i);
            if (netAdj.getAdjacentsSize() > 0) {
                this.coletBeliefs(netAdj);
            }
            this.updateBelief(net, netAdj);
            --i;
        }
    }

    protected void distributeBelief(SubNetwork net) throws Exception {
        int i = net.adjacents.size() - 1;
        while (i >= 0) {
            SubNetwork netAdj = net.adjacents.get(i);
            this.updateBelief(netAdj, net);
            if (netAdj.getAdjacentsSize() > 0) {
                this.distributeBelief(netAdj);
            }
            --i;
        }
    }

    protected void updateBelief(SubNetwork net1, SubNetwork net2) throws Exception {
        int i = this.links.size() - 1;
        while (i >= 0) {
            Linkage l = this.links.get(i);
            if (l.getNet1() == net1 && l.getNet2() == net2) {
                l.absorb(true);
                return;
            }
            if (l.getNet2() == net1 && l.getNet1() == net2) {
                l.absorb(false);
                return;
            }
            --i;
        }
    }

    protected void distributedMoralization() {
        int i = this.nets.size() - 1;
        while (i >= 0) {
            SubNetwork net = this.nets.get(i);
            net.localMoralize();
            --i;
        }
        SubNetwork raiz = this.nets.get(0);
        raiz.distributeArcs();
    }

    protected void hyperTree() throws Exception {
        int netsSize = this.nets.size();
        if (netsSize < 2) {
            return;
        }
        ArrayList<Node>[][] inters = this.makeIntersection();
        boolean[] naArvore = new boolean[netsSize];
        naArvore[0] = true;
        int i = 0;
        while (i < netsSize - 1) {
            this.insertLink(inters, naArvore);
            ++i;
        }
    }

    private ArrayList<Node>[][] makeIntersection() {
        int netsSize = this.nets.size();
        ArrayList[][] interseccoes = new ArrayList[netsSize][netsSize];
        int i = 0;
        while (i < netsSize - 1) {
            SubNetwork n1 = this.nets.get(i);
            int j = i + 1;
            while (j < netsSize) {
                ArrayList<Node> inter;
                SubNetwork n2 = this.nets.get(j);
                ArrayList<Node> arrayList = inter = SetToolkit.intersection(n1.getNodes(), n2.getNodes());
                interseccoes[j][i] = arrayList;
                interseccoes[i][j] = arrayList;
                ++j;
            }
            ++i;
        }
        return interseccoes;
    }

    private void insertLink(ArrayList<Node>[][] inters, boolean[] naArvore) throws Exception {
        int netsSize = this.nets.size();
        int max = 0;
        int kMax = -1;
        int iMax = -1;
        int i = 0;
        while (i < netsSize) {
            if (naArvore[i]) {
                int k = 1;
                while (k < netsSize) {
                    if (!naArvore[k] && inters[i][k].size() > max) {
                        iMax = i;
                        kMax = k;
                        max = inters[iMax][kMax].size();
                    }
                    ++k;
                }
            }
            ++i;
        }
        if (max == 0) {
            throw new Exception("N\ufffdo forma Hiper\ufffdrvore");
        }
        int j = 0;
        while (j < netsSize) {
            if (naArvore[j] && !this.isDSepSet(j, kMax, inters[j][kMax])) {
                throw new Exception("Erro na contru\ufffd\ufffdo da Hyper\ufffdrvore");
            }
            ++j;
        }
        SubNetwork ni = this.nets.get(iMax);
        SubNetwork nk = this.nets.get(kMax);
        naArvore[kMax] = true;
        this.links.add(new Linkage(ni, nk));
    }

    private boolean isDSepSet(int j, int k, ArrayList<Node> inter) {
        SubNetwork nj = this.nets.get(j);
        SubNetwork nk = this.nets.get(k);
        int i = 0;
        while (i < inter.size()) {
            ArrayList<Node> pais = inter.get(i).getParents();
            if (!nj.getNodes().containsAll(pais) && !nk.getNodes().containsAll(pais)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected final void verifyCycles() throws Exception {
        SubNetwork net;
        int i = this.nets.size() - 1;
        while (i >= 0) {
            net = this.nets.get(i);
            net.initVisited();
            --i;
        }
        i = this.nets.size() - 1;
        while (i >= 0) {
            net = this.nets.get(i);
            net.distributedCycle();
            --i;
        }
    }

    protected void cooperativeTriangulation() {
        this.initTriangulation();
        this.coTriag();
        boolean inseriu = false;
        int i = this.nets.size() - 1;
        while (i >= 0) {
            SubNetwork net = this.nets.get(i);
            int j = net.getAdjacentsSize() - 1;
            while (j >= 0) {
                SubNetwork net2 = net.adjacents.get(j);
                if (net.elimine(net2)) {
                    inseriu = true;
                }
                --j;
            }
            --i;
        }
        if (inseriu) {
            this.coTriag();
        }
    }

    private void coTriag() {
        System.out.println("coTriag");
        SubNetwork a1 = this.nets.get(0);
        a1.elimineProfundidade(null);
        a1.distributeArcs();
    }

    private void initTriangulation() {
        int i = this.nets.size() - 1;
        while (i >= 0) {
            SubNetwork net = this.nets.get(i);
            net.initTriangulation();
            --i;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }
}

