/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.ssbn.util;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import unbbayes.io.LogManager;
import unbbayes.io.XMLBIFIO;
import unbbayes.prs.Edge;
import unbbayes.prs.mebn.ssbn.OVInstance;
import unbbayes.prs.mebn.ssbn.SSBNNode;
import unbbayes.util.Debug;

public class SSBNDebugInformationUtil {
    public static void printNetworkInformation(LogManager logManager, SSBNNode queryNode, long stepCount, String queryName) {
        String stepCountFormated = "";
        stepCountFormated = stepCount < 10L ? "00" + stepCount : (stepCount < 100L ? "0" + stepCount : "" + stepCount);
        String netName = String.valueOf(queryName) + " - Step " + stepCountFormated;
        queryNode.getProbabilisticNetwork().setName(netName);
        String nameDirectory = "examples" + File.separator + "MEBN" + File.separator + "SSBN" + File.separator + queryName;
        File directory = new File(nameDirectory);
        if (!directory.exists()) {
            directory.mkdir();
        }
        File file = new File(String.valueOf(nameDirectory) + File.separator + netName + ".xml");
        System.out.println("Saved: " + file.getAbsolutePath());
        logManager.appendln("\n");
        logManager.appendln("  |-------------------------------------------------------");
        logManager.appendln("  |Network: ");
        logManager.appendln("  |" + netName);
        logManager.appendln("  | (" + file.getAbsolutePath() + ")");
        logManager.appendln("  |\n  |Current node's branch: ");
        logManager.appendln("  |" + queryNode.getName());
        SSBNDebugInformationUtil.printParents(logManager, queryNode, 0);
        logManager.appendln("  |\n  |Edges:");
        for (Edge edge : queryNode.getProbabilisticNetwork().getEdges()) {
            logManager.appendln("  |" + edge.toString());
        }
        logManager.appendln("  |\n  |Nodes:");
        int i = 0;
        while (i < queryNode.getProbabilisticNetwork().getNodes().size()) {
            logManager.appendln("  |" + queryNode.getProbabilisticNetwork().getNodeAt(i).toString());
            ++i;
        }
        logManager.appendln("  |-------------------------------------------------------");
        logManager.appendln("\n");
        XMLBIFIO netIO = new XMLBIFIO();
        try {
            netIO.save(file, queryNode.getProbabilisticNetwork());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        try {
            logManager.writeToDisk("teste.txt", false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void printParents(LogManager logManager, SSBNNode node, int nivel) {
        for (SSBNNode parent : node.getParents()) {
            int i = 0;
            while (i <= nivel) {
                if (i == 0) {
                    logManager.append("  |   ");
                } else {
                    logManager.append("   ");
                }
                ++i;
            }
            logManager.appendln(parent.toString());
            SSBNDebugInformationUtil.printParents(logManager, parent, nivel + 1);
        }
    }

    public static void printNodeStructureBeforeCPT(SSBNNode ssbnNode) {
        Debug.println("--------------------------------------------------");
        Debug.println("- Node: " + ssbnNode.toString());
        Debug.println("- Parents: ");
        for (SSBNNode parent : ssbnNode.getParents()) {
            Debug.println("-    " + parent.getName());
            Debug.println("-            Arguments: ");
            for (OVInstance ovInstance : parent.getArguments()) {
                Debug.println("-                " + ovInstance.toString());
            }
        }
        Debug.println("--------------------------------------------------");
    }
}

