/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.ssbn;

import java.util.List;
import java.util.ResourceBundle;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.ssbn.SSBNNode;

public class SSBNWarning {
    private SSBNNode nodeCause;
    private Exception exception;
    private Object[] arguments;
    private int code;
    private ResourceBundle resource = ResourceBundle.getBundle("unbbayes.prs.mebn.ssbn.resources.Resources");
    public static final int ENTYTY_FAULT = 1;
    public static final int OV_FAULT_EVALUATION_OF_CONTEXT_FOR_INPUT_INSTANCE = 2;
    public static final int OV_FAULT_RESIDENT_CHILD = 3;

    public SSBNWarning(int code, Exception e, SSBNNode nodeCause, Object ... args) {
        this.code = code;
        this.exception = e;
        this.nodeCause = nodeCause;
        this.arguments = args;
    }

    public SSBNNode getNodeCause() {
        return this.nodeCause;
    }

    public String getExplanation() {
        switch (this.code) {
            case 1: {
                return this.resource.getString("OVProblem");
            }
            case 2: {
                return this.resource.getString("contextInputNodeProblem");
            }
            case 3: {
                return this.resource.getString("contextInputNodeProblem");
            }
        }
        return "";
    }

    public String getDetalhedExplanation() {
        StringBuilder explanation = new StringBuilder();
        switch (this.code) {
            case 1: {
                if (this.arguments.length <= 0) break;
                explanation.append("Ordinary Variables:" + (List)this.arguments[0]);
                break;
            }
            case 2: {
                if (this.arguments.length <= 0) break;
                explanation.append("Input Node in MFrag:" + ((InputNode)this.arguments[0]).getMFrag());
                break;
            }
            case 3: {
                if (this.arguments.length <= 0) break;
                explanation.append("Input Node in MFrag:" + ((ResidentNode)this.arguments[0]).getMFrag() + "\n");
                explanation.append("Resident Node Child:" + (ResidentNode)this.arguments[0]);
                break;
            }
        }
        return explanation.toString();
    }
}

