/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.ssbn;

import java.util.HashMap;
import java.util.Map;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ssbn.LiteralEntityInstance;

public class MFragInstance {
    private MFrag mFragOrigin;
    private boolean useDefaultDistribution;
    private Map<OrdinaryVariable, LiteralEntityInstance> ordinaryVariableEvaluationState;
    private Map<ContextNode, ContextNodeEvaluationState> contextNodeEvaluationState;

    public MFragInstance(MFrag mFragOrigin) {
        this.mFragOrigin = mFragOrigin;
        this.contextNodeEvaluationState = new HashMap<ContextNode, ContextNodeEvaluationState>();
        for (ContextNode contextNode : mFragOrigin.getContextNodeList()) {
            this.contextNodeEvaluationState.put(contextNode, ContextNodeEvaluationState.NOT_EVALUATED_YET);
        }
        this.ordinaryVariableEvaluationState = new HashMap<OrdinaryVariable, LiteralEntityInstance>();
        for (OrdinaryVariable ordinaryVariable : mFragOrigin.getOrdinaryVariableList()) {
            this.ordinaryVariableEvaluationState.put(ordinaryVariable, null);
        }
    }

    public void setContextNodeEvaluationState(ContextNode context, ContextNodeEvaluationState state) {
        this.contextNodeEvaluationState.put(context, state);
    }

    public void setOrdinaryVariableEvaluationState(OrdinaryVariable ov, LiteralEntityInstance instance) {
        this.ordinaryVariableEvaluationState.put(ov, instance);
    }

    public boolean isUsingDefaultDistribution() {
        return this.useDefaultDistribution;
    }

    public void setUseDefaultDistribution(boolean useDefaultDistribution) {
        this.useDefaultDistribution = useDefaultDistribution;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContextNodeEvaluationState {
        EVALUATION_OK,
        EVALUATION_FAIL,
        EVALUATION_SEARCH,
        NOT_EVALUATED_YET;

    }
}

