/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.ssbn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import unbbayes.io.LogManager;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.entity.ObjectEntity;
import unbbayes.prs.mebn.entity.ObjectEntityInstanceOrdereable;
import unbbayes.prs.mebn.exception.MEBNException;
import unbbayes.prs.mebn.kb.KnowledgeBase;
import unbbayes.prs.mebn.ssbn.ContextFatherSSBNNode;
import unbbayes.prs.mebn.ssbn.ContextNodeAvaliator;
import unbbayes.prs.mebn.ssbn.ISSBNGenerator;
import unbbayes.prs.mebn.ssbn.LiteralEntityInstance;
import unbbayes.prs.mebn.ssbn.OVInstance;
import unbbayes.prs.mebn.ssbn.SSBNNode;
import unbbayes.prs.mebn.ssbn.SSBNNodeJacket;
import unbbayes.prs.mebn.ssbn.SSBNNodeList;
import unbbayes.prs.mebn.ssbn.SSBNWarning;
import unbbayes.prs.mebn.ssbn.exception.ImplementationRestrictionException;
import unbbayes.prs.mebn.ssbn.exception.InvalidContextNodeFormulaException;
import unbbayes.prs.mebn.ssbn.exception.InvalidOperationException;
import unbbayes.prs.mebn.ssbn.exception.OVInstanceFaultException;
import unbbayes.prs.mebn.ssbn.exception.SSBNNodeGeneralException;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSSBNGenerator
implements ISSBNGenerator {
    public static LogManager logManager = new LogManager();
    private KnowledgeBase knowledgeBase;
    protected SSBNNodeList ssbnNodeList;
    protected Map<String, SSBNNode> ssbnNodesMap;
    protected List<SSBNWarning> warningList;
    private ContextNodeAvaliator contextNodeAvaliator;
    private ResourceBundle resource = ResourceBundle.getBundle("unbbayes.prs.mebn.ssbn.resources.Resources");

    protected void generateCPTForAllSSBNNodes(SSBNNode root) throws MEBNException, SSBNNodeGeneralException {
        this.generateCPTForAllSSBNNodes(root, 0);
    }

    private void generateCPTForAllSSBNNodes(SSBNNode root, int level) throws MEBNException, SSBNNodeGeneralException {
        if (root.isCptAlreadyGenerated()) {
            return;
        }
        for (SSBNNode parent : root.getParents()) {
            this.generateCPTForAllSSBNNodes(parent, level + 1);
        }
        if (root.isCptAlreadyGenerated()) {
            return;
        }
        this.generateCPT(root);
        root.setCptAlreadyGenerated(true);
        for (SSBNNode child : root.getChildren()) {
            this.generateCPTForAllSSBNNodes(child, level + 1);
        }
    }

    private void generateCPT(SSBNNode ssbnNode) throws MEBNException, SSBNNodeGeneralException {
        ssbnNode.changeArgumentsToResidentMFrag();
        for (SSBNNode parent : ssbnNode.getParents()) {
            parent.turnArgumentsForMFrag(ssbnNode.getResident().getMFrag());
        }
        logManager.appendln("---- CPT for node: " + ssbnNode.getUniqueName() + "-----");
        logManager.appendln("Parents:");
        for (SSBNNode parent : ssbnNode.getParents()) {
            logManager.appendln(parent.toString());
        }
        logManager.appendln("Init");
        if (ssbnNode.isPermanent()) {
            if (ssbnNode.getContextFatherSSBNNode() != null) {
                try {
                    this.generateCPTForNodeWithContextFather(ssbnNode);
                }
                catch (InvalidOperationException e1) {
                    e1.printStackTrace();
                    throw new SSBNNodeGeneralException(e1.getMessage());
                }
            } else {
                ssbnNode.getCompiler().generateCPT(ssbnNode);
            }
        }
        logManager.appendln("End");
    }

    protected void removeNotPermanentNodes(Collection<SSBNNode> listSSBNNode) {
        logManager.appendln("...Removing not permanent nodes begin");
        ArrayList<SSBNNode> nodesToDelete = new ArrayList<SSBNNode>();
        for (SSBNNode node : listSSBNNode) {
            if (node.isPermanent()) continue;
            nodesToDelete.add(node);
        }
        for (SSBNNode node : nodesToDelete) {
            logManager.appendln("...Removing node " + node.getName());
            node.delete();
            listSSBNNode.remove(node);
        }
        logManager.appendln("...Removing not permanent nodes end");
    }

    protected List<OrdinaryVariable> getOVForWhichNotExistOVInstance(Collection<OrdinaryVariable> ordVariableList, Collection<OVInstance> ovInstanceList) {
        ArrayList<OrdinaryVariable> ovProblemList = new ArrayList<OrdinaryVariable>();
        for (OrdinaryVariable ov : ordVariableList) {
            boolean found = false;
            for (OVInstance ovInstance : ovInstanceList) {
                if (!ov.equals(ovInstance.getOv())) continue;
                found = true;
                break;
            }
            if (found) continue;
            ovProblemList.add(ov);
        }
        return ovProblemList;
    }

    private boolean verifyOVFaultList(List<OrdinaryVariable> ovFaultList, List<OVInstance> ovInsntanceList) {
        ArrayList<OrdinaryVariable> tempOVList = new ArrayList<OrdinaryVariable>();
        tempOVList.addAll(ovFaultList);
        for (OVInstance ov : ovInsntanceList) {
            tempOVList.remove(ov.getOv());
        }
        return tempOVList.size() == 0;
    }

    protected List<SSBNNode> createSSBNNodesOfEntitiesSearchForResidentNode(MFrag mFrag, SSBNNode originNode, ResidentNode fatherNode, List<OrdinaryVariable> ovList, List<OVInstance> ovInstances, boolean searchIfNotFound) throws ImplementationRestrictionException, SSBNNodeGeneralException, InvalidParentException {
        List<OVInstance> listResultSearchContextNode = this.getContextNodeAvaliator().evaluateSearchContextNode(mFrag, ovList, ovInstances);
        if (listResultSearchContextNode == null || listResultSearchContextNode.isEmpty()) {
            if (searchIfNotFound) {
                if (ovList.size() > 1) {
                    throw new ImplementationRestrictionException(this.resource.getString("OrdVariableProblemLimit"));
                }
                OrdinaryVariable ovProblematic = ovList.get(0);
                Collection<ContextNode> contextNodeList = mFrag.getSearchContextByOVCombination(ovList);
                if (contextNodeList.size() > 1) {
                    throw new ImplementationRestrictionException(String.valueOf(this.resource.getString("MoreThanOneContextNodeSearh")) + ": " + contextNodeList);
                }
                if (contextNodeList.size() < 1) {
                    throw new SSBNNodeGeneralException(this.resource.getString("NoContextNodeFather"));
                }
                ContextNode context = contextNodeList.toArray(new ContextNode[contextNodeList.size()])[0];
                ContextNodeAvaliator avaliator = new ContextNodeAvaliator(this.getKnowledgeBase());
                List<String> result = null;
                try {
                    result = avaliator.evalutateSearchContextNode(context, ovInstances);
                }
                catch (OVInstanceFaultException e) {
                    throw new ImplementationRestrictionException(this.resource.getString("OrdVariableProblemLimit"));
                }
                catch (InvalidContextNodeFormulaException e) {
                    throw new ImplementationRestrictionException(this.resource.getString("InvalidContextNodeFormula"));
                }
                if (result != null && result.size() > 0) {
                    ArrayList<SSBNNode> nodes = new ArrayList<SSBNNode>();
                    for (String entity : result) {
                        SSBNNode node = this.createSSBNNodeForEntitySearch(originNode.getProbabilisticNetwork(), fatherNode, ovInstances, ovProblematic, entity);
                        nodes.add(node);
                    }
                    return nodes;
                }
                logManager.appendln("Evaluate Search Context Node for " + context + "[" + ovInstances + "]" + "return null");
                if (originNode.getContextFatherSSBNNode() != null) {
                    ContextFatherSSBNNode contextFatherSSBNNode = originNode.getContextFatherSSBNNode();
                    if (contextFatherSSBNNode.getOvProblematic().equals(ovProblematic)) {
                        ArrayList<SSBNNode> nodes = new ArrayList<SSBNNode>();
                        for (LiteralEntityInstance entity : contextFatherSSBNNode.getPossibleValues()) {
                            SSBNNode node = this.createSSBNNodeForEntitySearch(originNode.getProbabilisticNetwork(), fatherNode, ovInstances, ovProblematic, entity.getInstanceName());
                            nodes.add(node);
                        }
                        return nodes;
                    }
                    throw new ImplementationRestrictionException(this.resource.getString("MoreThanOneContextNodeFather"));
                }
                ArrayList<SSBNNode> nodes = new ArrayList<SSBNNode>();
                ContextFatherSSBNNode contextFatherSSBNNode = new ContextFatherSSBNNode(originNode.getProbabilisticNetwork(), context);
                contextFatherSSBNNode.setOvProblematic(ovProblematic);
                originNode.setContextFatherSSBNNode(contextFatherSSBNNode);
                result = this.getKnowledgeBase().getEntityByType(ovProblematic.getValueType().getName());
                for (String entity : result) {
                    SSBNNode node = this.createSSBNNodeForEntitySearch(originNode.getProbabilisticNetwork(), fatherNode, ovInstances, ovProblematic, entity);
                    contextFatherSSBNNode.addPossibleValue(LiteralEntityInstance.getInstance(entity, ovProblematic.getValueType()));
                    nodes.add(node);
                }
                return nodes;
            }
            throw new SSBNNodeGeneralException(this.resource.getString("IncompleteInformation"));
        }
        logManager.appendln("Result list for evaluate search node: " + listResultSearchContextNode);
        ArrayList<SSBNNode> nodes = new ArrayList<SSBNNode>();
        SSBNNode node = this.createSSBNNodeForEntitySearch(originNode.getProbabilisticNetwork(), fatherNode, ovInstances, listResultSearchContextNode);
        nodes.add(node);
        return nodes;
    }

    protected List<SSBNNodeJacket> createSSBNNodesOfEntitiesSearchForInputNode(SSBNNode originNode, InputNode fatherNode, List<OrdinaryVariable> ovProblemList, List<OVInstance> ovInstances) throws SSBNNodeGeneralException, ImplementationRestrictionException, InvalidParentException {
        List<OVInstance> listResultSearchContextNode = this.getContextNodeAvaliator().evaluateSearchContextNode(fatherNode.getMFrag(), ovProblemList, ovInstances);
        if (listResultSearchContextNode == null || listResultSearchContextNode.isEmpty()) {
            MFrag mFrag = fatherNode.getMFrag();
            ContextNodeAvaliator avaliator = new ContextNodeAvaliator(this.getKnowledgeBase());
            if (ovProblemList.size() > 1) {
                throw new ImplementationRestrictionException(this.resource.getString("OrdVariableProblemLimit"));
            }
            Collection<ContextNode> contextNodeList = mFrag.getSearchContextByOVCombination(ovProblemList);
            int size = contextNodeList.size();
            if (size > 1) {
                throw new ImplementationRestrictionException(this.resource.getString("MoreThanOneContextNodeSearh"));
            }
            if (size < 1) {
                throw new SSBNNodeGeneralException(this.resource.getString("MoreThanOneContextNodeSearh"));
            }
            ContextNode context = contextNodeList.toArray(new ContextNode[size])[0];
            OrdinaryVariable ov = ovProblemList.get(0);
            List<String> result = null;
            try {
                result = avaliator.evalutateSearchContextNode(context, ovInstances);
            }
            catch (OVInstanceFaultException e) {
                throw new ImplementationRestrictionException(this.resource.getString("OrdVariableProblemLimit"));
            }
            catch (InvalidContextNodeFormulaException e) {
                throw new ImplementationRestrictionException(this.resource.getString("InvalidContextNodeFormula"));
            }
            if (result != null && result.size() > 0) {
                ArrayList<SSBNNodeJacket> nodes = new ArrayList<SSBNNodeJacket>();
                for (String entity : result) {
                    SSBNNodeJacket ssbnNodeJacket = this.createSSBNNodeForEntitySearch(originNode, fatherNode, ov, entity);
                    nodes.add(ssbnNodeJacket);
                }
                return nodes;
            }
            logManager.appendln("Context Node: " + context.getLabel());
            if (originNode.getContextFatherSSBNNode() != null) {
                ContextFatherSSBNNode contextFatherSSBNNode = originNode.getContextFatherSSBNNode();
                if (contextFatherSSBNNode.getOvProblematic().equals(ov)) {
                    ArrayList<SSBNNodeJacket> nodes = new ArrayList<SSBNNodeJacket>();
                    for (LiteralEntityInstance entity : contextFatherSSBNNode.getPossibleValues()) {
                        SSBNNodeJacket ssbnNodeJacket = this.createSSBNNodeForEntitySearch(originNode, fatherNode, ov, entity.getInstanceName());
                        nodes.add(ssbnNodeJacket);
                    }
                    return nodes;
                }
                throw new ImplementationRestrictionException(this.resource.getString("TwoContextFathersError"));
            }
            ArrayList<SSBNNodeJacket> nodes = new ArrayList<SSBNNodeJacket>();
            logManager.appendln("Result is empty");
            ContextFatherSSBNNode contextFatherSSBNNode = new ContextFatherSSBNNode(originNode.getProbabilisticNetwork(), context);
            contextFatherSSBNNode.setOvProblematic(ov);
            result = avaliator.getEntityByType(ov.getValueType().getName());
            logManager.appendln("Search returns " + result.size() + " results");
            for (String entity : result) {
                SSBNNodeJacket ssbnNodeJacket = this.createSSBNNodeForEntitySearch(originNode, fatherNode, ov, entity);
                contextFatherSSBNNode.addPossibleValue(LiteralEntityInstance.getInstance(entity, ov.getValueType()));
                nodes.add(ssbnNodeJacket);
            }
            originNode.setContextFatherSSBNNode(contextFatherSSBNNode);
            return nodes;
        }
        ArrayList<SSBNNodeJacket> nodes = new ArrayList<SSBNNodeJacket>();
        SSBNNodeJacket ssbnNodeJacket = this.createSSBNNodeForEntitySearch(originNode, fatherNode, listResultSearchContextNode);
        nodes.add(ssbnNodeJacket);
        return nodes;
    }

    private SSBNNode createSSBNNodeForEntitySearch(ProbabilisticNetwork probabilisticNetwork, ResidentNode residentNode, List<OVInstance> ovInstances, OrdinaryVariable ov, String entity) {
        List<OVInstance> arguments = this.filterArgumentsForNode(ovInstances, residentNode);
        arguments.add(OVInstance.getInstance(ov, LiteralEntityInstance.getInstance(entity, ov.getValueType())));
        SSBNNode testSSBNNode = this.ssbnNodesMap.get(SSBNNode.getUniqueNameFor(residentNode, arguments));
        if (testSSBNNode == null) {
            testSSBNNode = SSBNNode.getInstance(probabilisticNetwork, residentNode);
            for (OVInstance ovInstance : arguments) {
                testSSBNNode.addArgument(ovInstance);
            }
            this.ssbnNodeList.add(testSSBNNode);
            this.ssbnNodesMap.put(testSSBNNode.getUniqueName(), testSSBNNode);
        }
        return testSSBNNode;
    }

    private SSBNNode createSSBNNodeForEntitySearch(ProbabilisticNetwork probabilisticNetwork, ResidentNode residentNode, List<OVInstance> ovInstances, List<OVInstance> ovInstancesSearched) {
        List<OVInstance> arguments = this.filterArgumentsForNode(ovInstances, residentNode);
        arguments.addAll(ovInstancesSearched);
        SSBNNode testSSBNNode = this.ssbnNodesMap.get(SSBNNode.getUniqueNameFor(residentNode, arguments));
        if (testSSBNNode == null) {
            testSSBNNode = SSBNNode.getInstance(probabilisticNetwork, residentNode);
            for (OVInstance ovInstance : arguments) {
                testSSBNNode.addArgument(ovInstance);
            }
            this.ssbnNodeList.add(testSSBNNode);
            this.ssbnNodesMap.put(testSSBNNode.getUniqueName(), testSSBNNode);
        }
        return testSSBNNode;
    }

    protected List<OVInstance> filterArgumentsForNode(Collection<OVInstance> ovInstanceList, ResidentNode node) {
        ArrayList<OVInstance> ret = new ArrayList<OVInstance>();
        for (OVInstance ovInstance : ovInstanceList) {
            if (node.getOrdinaryVariableByName(ovInstance.getOv().getName()) == null) continue;
            ret.add(ovInstance);
        }
        return ret;
    }

    protected SSBNNodeJacket getPreviousNode(SSBNNode currentNode, SSBNNodeList seen, ProbabilisticNetwork net, ResidentNode residentNode, InputNode inputNode) throws SSBNNodeGeneralException, ImplementationRestrictionException {
        logManager.appendln("Build Previous Node");
        List<OrdinaryVariable> ovOrdereableList = residentNode.getOrdinaryVariablesOrdereables();
        if (ovOrdereableList.size() > 1) {
            throw new ImplementationRestrictionException(this.resource.getString("MoreThanOneOrdereableVariable"));
        }
        if (ovOrdereableList.size() < 1) {
            throw new ImplementationRestrictionException(this.resource.getString("RVNotRecursive"));
        }
        OrdinaryVariable ovOrdereableResident = ovOrdereableList.get(0);
        logManager.appendln("Ov Ordereable found:" + ovOrdereableResident);
        ObjectEntity objectEntityOrdereable = currentNode.getResident().getMFrag().getMultiEntityBayesianNetwork().getObjectEntityContainer().getObjectEntityByType(ovOrdereableResident.getValueType());
        OVInstance ovInstanceOrdereable = null;
        for (OVInstance ovInstance : currentNode.getArguments()) {
            if (ovInstance.getOv() != ovOrdereableResident) continue;
            ovInstanceOrdereable = ovInstance;
            break;
        }
        if (ovInstanceOrdereable == null) {
            throw new SSBNNodeGeneralException();
        }
        String nameEntity = ovInstanceOrdereable.getEntity().getInstanceName();
        ObjectEntityInstanceOrdereable objectEntityInstanceOrdereable = (ObjectEntityInstanceOrdereable)objectEntityOrdereable.getInstanceByName(nameEntity);
        if (objectEntityInstanceOrdereable == null) {
            throw new SSBNNodeGeneralException();
        }
        ObjectEntityInstanceOrdereable prev = objectEntityInstanceOrdereable.getPrev();
        if (prev == null) {
            return null;
        }
        SSBNNode ssbnNode = SSBNNode.getInstance(net, residentNode, new ProbabilisticNode());
        SSBNNodeJacket ssbnNodeJacket = new SSBNNodeJacket(ssbnNode);
        for (OVInstance instance : currentNode.getArguments()) {
            if (instance != ovInstanceOrdereable) {
                if (residentNode.getOrdinaryVariableByName(instance.getOv().getName()) == null) continue;
                ssbnNodeJacket.addOVInstanceOfInputMFrag(instance);
                ssbnNodeJacket.addOVInstanceOfResidentMFrag(instance);
                continue;
            }
            OVInstance newOVInstance = OVInstance.getInstance(ovOrdereableResident, LiteralEntityInstance.getInstance(prev.getName(), ovOrdereableResident.getValueType()));
            ssbnNodeJacket.addOVInstanceOfResidentMFrag(newOVInstance);
            int index = residentNode.getOrdinaryVariableList().indexOf(ovOrdereableResident);
            OrdinaryVariable ovOrdereableInput = inputNode.getOrdinaryVariableByIndex(index);
            newOVInstance = OVInstance.getInstance(ovOrdereableInput, LiteralEntityInstance.getInstance(prev.getName(), ovOrdereableResident.getValueType()));
            ssbnNodeJacket.addOVInstanceOfInputMFrag(newOVInstance);
        }
        ssbnNodeJacket.setResidentMFragArguments();
        SSBNNode alreadyExistentSSBNNode = this.ssbnNodesMap.get(SSBNNode.getUniqueNameFor(residentNode, ssbnNode.getArguments()));
        if (alreadyExistentSSBNNode != null) {
            alreadyExistentSSBNNode.setRecursiveOVInstanceList(ssbnNodeJacket.getInputMFragOvInstances());
            ssbnNodeJacket.getSsbnNode().delete();
            ssbnNodeJacket.setSsbnNode(alreadyExistentSSBNNode);
        } else {
            ssbnNode.setRecursiveOVInstanceList(ssbnNodeJacket.getInputMFragOvInstances());
            this.ssbnNodeList.add(ssbnNode);
            this.ssbnNodesMap.put(ssbnNode.getUniqueName(), ssbnNode);
        }
        logManager.appendln("Build Previous Node End");
        return ssbnNodeJacket;
    }

    protected SSBNNode getProcNode(SSBNNode currentNode, SSBNNodeList seen, ProbabilisticNetwork net, ResidentNode residentNode, List<OVInstance> listOvInstancesInput, InputNode inputNode) throws SSBNNodeGeneralException, ImplementationRestrictionException {
        logManager.appendln("Build Proc. Node");
        List<OrdinaryVariable> ovOrdereableList = residentNode.getOrdinaryVariablesOrdereables();
        if (ovOrdereableList.size() > 1) {
            throw new ImplementationRestrictionException(this.resource.getString("MoreThanOneOrdereableVariable"));
        }
        if (ovOrdereableList.size() < 1) {
            throw new ImplementationRestrictionException(this.resource.getString("RVNotRecursive"));
        }
        OrdinaryVariable ovOrdereableResident = ovOrdereableList.get(0);
        logManager.appendln("Ov Ordereable found:" + ovOrdereableResident);
        ObjectEntity objectEntityOrdereable = currentNode.getResident().getMFrag().getMultiEntityBayesianNetwork().getObjectEntityContainer().getObjectEntityByType(ovOrdereableResident.getValueType());
        OVInstance ovInstanceOrdereable = null;
        for (OVInstance ovInstance : currentNode.getArguments()) {
            if (ovInstance.getOv() != ovOrdereableResident) continue;
            ovInstanceOrdereable = ovInstance;
            break;
        }
        if (ovInstanceOrdereable == null) {
            throw new SSBNNodeGeneralException();
        }
        String nameEntity = ovInstanceOrdereable.getEntity().getInstanceName();
        ObjectEntityInstanceOrdereable objectEntityInstanceOrdereable = (ObjectEntityInstanceOrdereable)objectEntityOrdereable.getInstanceByName(nameEntity);
        if (objectEntityInstanceOrdereable == null) {
            throw new SSBNNodeGeneralException();
        }
        ObjectEntityInstanceOrdereable proc = objectEntityInstanceOrdereable.getProc();
        if (proc == null) {
            logManager.appendln("Proc is null... no action to do");
            return null;
        }
        SSBNNode ssbnNode = SSBNNode.getInstance(net, residentNode, new ProbabilisticNode());
        for (OVInstance instance : currentNode.getArguments()) {
            if (instance != ovInstanceOrdereable) {
                if (residentNode.getOrdinaryVariableByName(instance.getOv().getName()) == null) continue;
                ssbnNode.addArgument(instance);
                listOvInstancesInput.add(instance);
                continue;
            }
            OVInstance newOVInstance = OVInstance.getInstance(ovOrdereableResident, LiteralEntityInstance.getInstance(proc.getName(), ovOrdereableResident.getValueType()));
            ssbnNode.addArgument(newOVInstance);
            int index = residentNode.getOrdinaryVariableList().indexOf(ovOrdereableResident);
            OrdinaryVariable ovOrdereableInput = inputNode.getOrdinaryVariableByIndex(index);
            newOVInstance = OVInstance.getInstance(ovOrdereableInput, LiteralEntityInstance.getInstance(objectEntityInstanceOrdereable.getName(), ovOrdereableResident.getValueType()));
            listOvInstancesInput.add(newOVInstance);
            logManager.appendln("\n\n created:" + ovOrdereableResident + " " + proc.getName());
        }
        logManager.append("Search for " + ssbnNode.getUniqueName() + " = " + this.ssbnNodesMap.get(ssbnNode.getUniqueName()));
        SSBNNode testSSBNNode = this.ssbnNodesMap.get(ssbnNode.getUniqueName());
        if (testSSBNNode != null) {
            ssbnNode.delete();
            ssbnNode = testSSBNNode;
        } else {
            this.ssbnNodeList.add(ssbnNode);
            this.ssbnNodesMap.put(ssbnNode.getUniqueName(), ssbnNode);
        }
        logManager.appendln("Build Proc Node End: Node created:" + ssbnNode);
        return ssbnNode;
    }

    protected boolean evaluateRelatedContextNodes(ResidentNode residentNode, List<OVInstance> ovInstances) throws OVInstanceFaultException {
        return this.evaluatedRelatedContextNodes(residentNode.getMFrag(), ovInstances, residentNode.getOrdinaryVariableList());
    }

    protected boolean evaluateRelatedContextNodes(InputNode inputNode, List<OVInstance> ovInstances) throws OVInstanceFaultException {
        return this.evaluatedRelatedContextNodes(inputNode.getMFrag(), ovInstances, inputNode.getOrdinaryVariableList());
    }

    private boolean evaluatedRelatedContextNodes(MFrag mFrag, List<OVInstance> ovInstances, Collection<OrdinaryVariable> ovList) throws OVInstanceFaultException {
        if (mFrag.isUsingDefaultCPT()) {
            return false;
        }
        ContextNodeAvaliator avaliator = new ContextNodeAvaliator(this.getKnowledgeBase());
        Collection<ContextNode> contextNodeList = mFrag.getContextByOVCombination(ovList);
        for (ContextNode context : contextNodeList) {
            logManager.appendln("Context Node: " + context.getLabel());
            if (!avaliator.evaluateContextNode(context, ovInstances)) {
                mFrag.setAsUsingDefaultCPT(true);
                logManager.appendln("Result = FALSE. Use default distribution ");
                return false;
            }
            logManager.appendln("Result = TRUE.");
        }
        return true;
    }

    private SSBNNodeJacket createSSBNNodeForEntitySearch(SSBNNode originNode, InputNode fatherNode, OrdinaryVariable ov, String entityName) throws SSBNNodeGeneralException {
        SSBNNode ssbnNode = SSBNNode.getInstance(originNode.getProbabilisticNetwork(), fatherNode.getResidentNodePointer().getResidentNode(), new ProbabilisticNode());
        SSBNNodeJacket ssbnNodeJacket = new SSBNNodeJacket(ssbnNode);
        ssbnNodeJacket.addArgument(fatherNode, OVInstance.getInstance(ov, LiteralEntityInstance.getInstance(entityName, ov.getValueType())));
        for (OVInstance instance : originNode.getArguments()) {
            ssbnNodeJacket.addArgument(fatherNode, instance);
        }
        ssbnNodeJacket.setResidentMFragArguments();
        SSBNNode test = this.ssbnNodesMap.get(ssbnNode.getUniqueName());
        if (test != null) {
            ssbnNodeJacket.getSsbnNode().delete();
            ssbnNodeJacket.setSsbnNode(test);
        }
        this.ssbnNodeList.add(ssbnNodeJacket.getSsbnNode());
        this.ssbnNodesMap.put(ssbnNodeJacket.getSsbnNode().getUniqueName(), ssbnNodeJacket.getSsbnNode());
        logManager.appendln(" ");
        logManager.appendln("SSBNNode created:" + ssbnNodeJacket.getSsbnNode());
        logManager.appendln("Input MFrag Arguments: " + ssbnNodeJacket.getInputMFragOvInstances());
        logManager.appendln("Resident MFrag Arguments: " + ssbnNodeJacket.getResidentMFragOvInstances());
        logManager.appendln(" ");
        return ssbnNodeJacket;
    }

    private SSBNNodeJacket createSSBNNodeForEntitySearch(SSBNNode originNode, InputNode fatherNode, List<OVInstance> ovInstanceList) throws SSBNNodeGeneralException {
        SSBNNode ssbnNode = SSBNNode.getInstance(originNode.getProbabilisticNetwork(), fatherNode.getResidentNodePointer().getResidentNode(), new ProbabilisticNode());
        SSBNNodeJacket ssbnNodeJacket = new SSBNNodeJacket(ssbnNode);
        for (OVInstance ovInstance : ovInstanceList) {
            ssbnNodeJacket.addArgument(fatherNode, ovInstance);
        }
        for (OVInstance instance : originNode.getArguments()) {
            ssbnNodeJacket.addArgument(fatherNode, instance);
        }
        ssbnNodeJacket.setResidentMFragArguments();
        SSBNNode test = this.ssbnNodesMap.get(ssbnNode.getUniqueName());
        if (test != null) {
            ssbnNodeJacket.getSsbnNode().delete();
            ssbnNodeJacket.setSsbnNode(test);
        }
        this.ssbnNodeList.add(ssbnNodeJacket.getSsbnNode());
        this.ssbnNodesMap.put(ssbnNodeJacket.getSsbnNode().getUniqueName(), ssbnNodeJacket.getSsbnNode());
        logManager.appendln(" ");
        logManager.appendln("SSBNNode created:" + ssbnNodeJacket.getSsbnNode());
        logManager.appendln("Input MFrag Arguments: " + ssbnNodeJacket.getInputMFragOvInstances());
        logManager.appendln("Resident MFrag Arguments: " + ssbnNodeJacket.getResidentMFragOvInstances());
        logManager.appendln(" ");
        return ssbnNodeJacket;
    }

    @Deprecated
    protected SSBNNode checkForDoubleSSBNNode(SSBNNode ssbnnode) {
        SSBNNode testSSBNNode = this.getSSBNNodeIfItAlreadyExists(ssbnnode.getResident(), ssbnnode.getArguments(), this.ssbnNodeList);
        if (testSSBNNode != null) {
            ssbnnode.delete();
            ssbnnode = testSSBNNode;
        }
        return ssbnnode;
    }

    protected OVInstance getListArgumentsOfInputVariableInOriginalMFrag(InputNode inputNode, OVInstance ovInstanceInputMFrag) {
        ResidentNode residentNode = inputNode.getResidentNodePointer().getResidentNode();
        OrdinaryVariable ovInputMFrag = ovInstanceInputMFrag.getOv();
        int index = inputNode.getResidentNodePointer().getOrdinaryVariableIndex(ovInputMFrag);
        if (index > -1) {
            OrdinaryVariable ovResidentMFrag = residentNode.getOrdinaryVariableList().get(index);
            return OVInstance.getInstance(ovResidentMFrag, ovInstanceInputMFrag.getEntity());
        }
        return null;
    }

    protected void generateCPTForNodeWithContextFather(SSBNNode ssbnNode) throws SSBNNodeGeneralException, MEBNException, InvalidOperationException {
        logManager.appendln("\nGenerate table for node (with context father): " + ssbnNode);
        logManager.appendln("Parents:");
        for (SSBNNode parent : ssbnNode.getParents()) {
            logManager.appendln("  " + parent);
        }
        HashMap mapParentsByEntity = new HashMap();
        HashMap<String, PotentialTable> mapCPTByEntity = new HashMap<String, PotentialTable>();
        ContextFatherSSBNNode contextFather = ssbnNode.getContextFatherSSBNNode();
        OrdinaryVariable ovProblematic = contextFather.getOvProblematic();
        for (LiteralEntityInstance entity : contextFather.getPossibleValues()) {
            mapParentsByEntity.put(entity.getInstanceName(), new ArrayList());
        }
        ssbnNode.getContextFatherSSBNNode().generateCPT();
        Collection<SSBNNode> parents = ssbnNode.getParents();
        ArrayList<SSBNNode> generalParents = new ArrayList<SSBNNode>();
        for (SSBNNode parent : parents) {
            if (!parent.getOVs().contains(ovProblematic)) {
                generalParents.add(parent);
                continue;
            }
            String entity = parent.getArgumentByOrdinaryVariable(ovProblematic).getEntity().getInstanceName();
            ((List)mapParentsByEntity.get(entity)).add(parent);
        }
        int sizeCPTOfEntity = 0;
        PotentialTable cptResidentNode = ssbnNode.getProbNode().getPotentialTable();
        int position = 1;
        for (LiteralEntityInstance entity : contextFather.getPossibleValues()) {
            int index;
            ArrayList<SSBNNode> groupParents = new ArrayList<SSBNNode>();
            groupParents.addAll((Collection)mapParentsByEntity.get(entity.getInstanceName()));
            List parentsByEntity = (List)mapParentsByEntity.get(entity.getInstanceName());
            for (SSBNNode node : parentsByEntity) {
                index = cptResidentNode.getVariableIndex(node.getProbNode());
                cptResidentNode.moveVariableWithoutMoveData(index, position);
                ++position;
            }
            groupParents.addAll(generalParents);
            for (SSBNNode node : generalParents) {
                index = cptResidentNode.getVariableIndex(node.getProbNode());
                cptResidentNode.moveVariableWithoutMoveData(index, position);
                ++position;
            }
            SSBNNode tempNode = SSBNNode.getInstance(ssbnNode.getResident());
            for (SSBNNode parent : groupParents) {
                tempNode.addParent(parent, false);
            }
            PotentialTable cpt = tempNode.getCompiler().generateCPT(tempNode);
            sizeCPTOfEntity = cpt.tableSize();
            for (SSBNNode parent : groupParents) {
                parent.getProbNode().getChildren().remove(tempNode.getProbNode());
                parent.getChildren().remove(tempNode);
            }
            mapCPTByEntity.put(entity.getInstanceName(), cpt);
            Debug.println("Tabela armazenada: " + entity.getInstanceName() + " " + cpt.tableSize());
        }
        int variablesSize = cptResidentNode.getVariablesSize();
        int indexContext = cptResidentNode.getVariableIndex(ssbnNode.getContextFatherSSBNNode().getProbNode());
        cptResidentNode.moveVariableWithoutMoveData(indexContext, variablesSize - 1);
        Debug.println("Gerando tabela para o n\u00f3 residente");
        int columnsByEntity = cptResidentNode.tableSize() / ssbnNode.getResident().getPossibleValueListIncludingEntityInstances().size();
        Debug.println("Colunas por entidade= " + (columnsByEntity /= contextFather.getProbNode().getStatesSize()));
        int rows = ssbnNode.getProbNode().getStatesSize();
        int i = 0;
        while (i < contextFather.getProbNode().getStatesSize()) {
            Debug.println("\n i = " + i);
            String entity = contextFather.getProbNode().getStateAt(i);
            Debug.println("Entity = " + entity);
            PotentialTable cptEntity = (PotentialTable)mapCPTByEntity.get(entity);
            List parentsByEntity = (List)mapParentsByEntity.get(entity);
            ProbabilisticNode pnEntity = ((SSBNNode)parentsByEntity.get(0)).getProbNode();
            int indexEntityInCptResidentNode = cptResidentNode.getVariableIndex(pnEntity) - 1;
            int entityIndex = (indexEntityInCptResidentNode + parentsByEntity.size() - 1) / parentsByEntity.size();
            Debug.println("Entity Index=" + entityIndex);
            int positionTableEntity = 0;
            int positionTableResident = entityIndex * columnsByEntity * rows;
            int repColum = 1;
            int index = indexEntityInCptResidentNode;
            while (index >= 1) {
                repColum *= cptResidentNode.getVariableAt(index).getStatesSize();
                --index;
            }
            int repAll = 1;
            int index2 = indexEntityInCptResidentNode + parentsByEntity.size();
            while (index2 < cptResidentNode.getVariablesSize() - 2) {
                repAll *= cptResidentNode.getVariableAt(index2).getStatesSize();
                ++index2;
            }
            int inOrder = 1;
            for (SSBNNode node : parentsByEntity) {
                inOrder *= node.getResident().getPossibleValueList().size();
            }
            Debug.println("Index = " + indexEntityInCptResidentNode);
            Debug.println("Repeti\u00e7\u00f5es = " + repColum);
            Debug.println("Posi\u00e7\u00e3o na tabela do residente = " + positionTableResident);
            Debug.println("Posi\u00e7\u00e3o na tabela da entidade = " + positionTableEntity);
            Debug.println("Linhas = " + rows);
            Debug.println("Repiti\u00e7\u00f5es de tudo = " + repAll);
            Debug.println("Em Ordem = " + inOrder);
            while (positionTableEntity < cptEntity.tableSize() - 1) {
                int positionTableEntityFinal = -1;
                int rAll = 0;
                while (rAll < repAll) {
                    int positionTableEntityInitial = positionTableEntity;
                    int order = 0;
                    while (order < inOrder) {
                        int rCol = 0;
                        while (rCol < repColum) {
                            int positionAuxEntity = positionTableEntityInitial;
                            int k = 0;
                            while (k < rows) {
                                cptResidentNode.setValue(positionTableResident, cptEntity.getValue(positionAuxEntity));
                                ++positionTableResident;
                                ++positionAuxEntity;
                                ++k;
                            }
                            ++rCol;
                        }
                        positionTableEntityInitial += rows;
                        ++order;
                    }
                    positionTableEntityFinal = positionTableEntityInitial;
                    ++rAll;
                }
                positionTableEntity = positionTableEntityFinal;
            }
            ++i;
        }
        logManager.appendln("CPT OK\n");
    }

    protected SSBNNode getSSBNNodeIfItAlreadyExists(ResidentNode residentNode, Collection<OVInstance> ovInstanceList, Collection<SSBNNode> ssbnNodeList) {
        boolean i = false;
        for (SSBNNode ssbnNode : ssbnNodeList) {
            if (ssbnNode.getResident() != residentNode) continue;
            Collection<OVInstance> ssbnNodeArguments = ssbnNode.getArguments();
            if (ovInstanceList.size() != ssbnNodeArguments.size()) {
                logManager.append("size different!!!");
                return null;
            }
            boolean j = false;
            for (OVInstance ovInstance : ovInstanceList) {
                boolean find = false;
                boolean k = false;
                for (OVInstance ssbnNodeArgument : ssbnNodeArguments) {
                    if (!ssbnNodeArgument.equals(ovInstance)) continue;
                    find = true;
                    break;
                }
                if (find) continue;
                logManager.append("Not find!!!");
                return null;
            }
            logManager.append("getSSBNNode return that the node " + residentNode.getName() + "[" + ovInstanceList.toString() + "] already exists!");
            return ssbnNode;
        }
        logManager.appendln("getSSBNNode return that the node " + residentNode.getName() + "[" + ovInstanceList.toString() + "] DON'T exists!");
        return null;
    }

    private String getSpaceForLevel(int level) {
        StringBuilder string = new StringBuilder();
        int i = 0;
        while (i < level) {
            string.append(' ');
            string.append(' ');
            string.append('-');
            string.append(' ');
            ++i;
        }
        return string.toString();
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public void setKnowledgeBase(KnowledgeBase kb) {
        this.knowledgeBase = kb;
    }

    public ContextNodeAvaliator getContextNodeAvaliator() {
        return this.contextNodeAvaliator;
    }

    public void setContextNodeAvaliator(ContextNodeAvaliator contextNodeAvaliator) {
        this.contextNodeAvaliator = contextNodeAvaliator;
    }
}

