/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import unbbayes.prs.Node;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.compiler.ICompiler;
import unbbayes.prs.mebn.compiler.exception.InconsistentTableSemanticsException;
import unbbayes.prs.mebn.compiler.exception.InstanceException;
import unbbayes.prs.mebn.compiler.exception.InvalidConditionantException;
import unbbayes.prs.mebn.compiler.exception.InvalidProbabilityRangeException;
import unbbayes.prs.mebn.compiler.exception.NoDefaultDistributionDeclaredException;
import unbbayes.prs.mebn.compiler.exception.SomeStateUndeclaredException;
import unbbayes.prs.mebn.compiler.exception.TableFunctionMalformedException;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.exception.MEBNException;
import unbbayes.prs.mebn.ssbn.OVInstance;
import unbbayes.prs.mebn.ssbn.SSBNNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler
implements ICompiler {
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.prs.mebn.compiler.resources.Resources");
    private char look;
    private int index = 0;
    private char[] text = null;
    private String[] kwlist = new String[]{"IF", "ELSE", "ALL", "ANY", "HAVE"};
    private char[] kwcode = new char[]{'i', 'l', 'a', 'y', 'h'};
    private char token;
    private String value = "";
    private String noCaseChangeValue = "";
    private MultiEntityBayesianNetwork mebn = null;
    private ResidentNode node = null;
    private PotentialTable cpt = null;
    private SSBNNode ssbnnode = null;
    private TempTable tempTable = null;
    private TempTableHeaderCell currentHeader = null;
    private int originalTextLength = 0;

    private Compiler() {
        this.tempTable = new TempTable();
        this.originalTextLength = 0;
    }

    public Compiler(ResidentNode node) {
        this.setNode(node);
        this.cpt = null;
        this.tempTable = new TempTable();
    }

    public Compiler(ResidentNode node, SSBNNode ssbnnode) {
        this.setNode(node);
        this.ssbnnode = ssbnnode;
        if (this.ssbnnode != null && this.ssbnnode.getProbNode() != null) {
            this.cpt = this.ssbnnode.getProbNode().getPotentialTable();
        }
        this.tempTable = new TempTable();
    }

    @Override
    public void init(String text) {
        this.originalTextLength = 0;
        if (text == null) {
            this.originalTextLength = 0;
            this.text = null;
            return;
        }
        if (text.length() == 0) {
            this.originalTextLength = 0;
            this.text = null;
            return;
        }
        this.index = 0;
        this.originalTextLength = text.length();
        text = text.replaceAll("\\s+", " ");
        this.text = text.toCharArray();
        this.nextChar();
        this.tempTable = new TempTable();
    }

    public void init(SSBNNode ssbnnode) {
        this.setSSBNNode(ssbnnode);
        this.mebn = this.node.getMFrag().getMultiEntityBayesianNetwork();
        String pseudocode = this.node.getTableFunction();
        if (this.ssbnnode.getProbNode() != null) {
            this.setPotentialTable(this.ssbnnode.getProbNode().getPotentialTable());
        }
        this.init(pseudocode);
    }

    @Override
    public void parse() throws MEBNException {
        if (this.text == null) {
            return;
        }
        this.skipWhite();
        this.table();
    }

    public void parse(String table) throws MEBNException {
        this.init(table);
        this.parse();
    }

    /*
     * WARNING - void declaration
     */
    protected PotentialTable getCPT() throws InconsistentTableSemanticsException, InvalidProbabilityRangeException, InstanceException {
        void var6_12;
        if (this.ssbnnode == null) {
            return null;
        }
        if (this.tempTable == null) {
            return null;
        }
        if (this.ssbnnode.getProbNode() == null) {
            return null;
        }
        if (this.text == null || this.tempTable.isEmptyNestedClauses()) {
            this.generateLinearDistroCPT(this.ssbnnode.getProbNode());
            return this.ssbnnode.getProbNode().getPotentialTable();
        }
        try {
            this.tempTable.cleanUpKnownValues(this.getSSBNNode());
        }
        catch (NullPointerException e) {
            throw new InstanceException((Throwable)e);
        }
        this.cpt = this.ssbnnode.getProbNode().getPotentialTable();
        ArrayList<Object> parents = null;
        try {
            parents = new ArrayList<SSBNNode>(this.ssbnnode.getParents());
        }
        catch (NullPointerException e) {
            parents = new ArrayList();
        }
        catch (Exception e) {
            throw new InconsistentTableSemanticsException((Throwable)e);
        }
        ArrayList<Entity> possibleValues = new ArrayList<Entity>(this.ssbnnode.getActualValues());
        if (this.ssbnnode.getProbNode().getStatesSize() != possibleValues.size()) {
            throw new InconsistentTableSemanticsException();
        }
        HashMap<String, List<EntityAndArguments>> map = null;
        ArrayList<Iterator<Entity>> valueCombinationIterators = new ArrayList<Iterator<Entity>>();
        for (SSBNNode sSBNNode : parents) {
            valueCombinationIterators.add(sSBNNode.getActualValues().iterator());
        }
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        for (Iterator iterator : valueCombinationIterators) {
            arrayList.add((Entity)iterator.next());
        }
        boolean bl = false;
        while (var6_12 < this.cpt.tableSize()) {
            void var7_22;
            void var7_20;
            map = new HashMap<String, List<EntityAndArguments>>();
            for (SSBNNode sSBNNode : parents) {
                if (map.containsKey(sSBNNode.getResident().getName())) continue;
                map.put(sSBNNode.getResident().getName(), new ArrayList());
            }
            boolean bl2 = false;
            while (var7_20 < parents.size()) {
                EntityAndArguments val = new EntityAndArguments((Entity)arrayList.get((int)var7_20), new ArrayList<OVInstance>(((SSBNNode)parents.get((int)var7_20)).getArguments()));
                ((List)map.get(((SSBNNode)parents.get((int)var7_20)).getResident().getName())).add(val);
                ++var7_20;
            }
            boolean bl3 = false;
            while (var7_22 < valueCombinationIterators.size()) {
                if (((Iterator)valueCombinationIterators.get((int)var7_22)).hasNext()) {
                    arrayList.set((int)var7_22, (Entity)((Iterator)valueCombinationIterators.get((int)var7_22)).next());
                    break;
                }
                valueCombinationIterators.set((int)var7_22, ((SSBNNode)parents.get((int)var7_22)).getActualValues().iterator());
                if (((Iterator)valueCombinationIterators.get((int)var7_22)).hasNext()) {
                    arrayList.set((int)var7_22, (Entity)((Iterator)valueCombinationIterators.get((int)var7_22)).next());
                }
                ++var7_22;
            }
            Object var7_23 = null;
            boolean thereAreNoParents = false;
            if (this.getSSBNNode().getParents() == null) {
                thereAreNoParents = true;
            } else if (this.getSSBNNode().getParents().size() == 0) {
                thereAreNoParents = true;
            }
            if (thereAreNoParents || this.getSSBNNode().isUsingDefaultCPT()) {
                TempTableHeaderCell tempTableHeaderCell = this.tempTable.getDefaultClause();
                if (!tempTableHeaderCell.isDefault()) {
                    throw new InconsistentTableSemanticsException();
                }
            } else {
                TempTableHeaderCell tempTableHeaderCell = this.tempTable.getFirstTrueClause(map);
            }
            int j2 = 0;
            while (j2 < possibleValues.size()) {
                void var7_26;
                float value = -1.0f;
                for (TempTableProbabilityCell cell : var7_26.getCellList()) {
                    if (!cell.getPossibleValue().getName().equalsIgnoreCase(possibleValues.get(j2).getName())) continue;
                    value = cell.getProbabilityValue();
                    break;
                }
                if (value < 0.0f || value > 1.0f) {
                    throw new InvalidProbabilityRangeException();
                }
                this.cpt.setValue((int)(var6_12 + j2), value);
                ++j2;
            }
            var6_12 += this.ssbnnode.getProbNode().getStatesSize();
        }
        return this.cpt;
    }

    protected PotentialTable generateCPT() throws MEBNException {
        return this.generateCPT(this.getSSBNNode());
    }

    @Override
    public PotentialTable generateCPT(SSBNNode ssbnnode) throws MEBNException {
        if (ssbnnode == null) {
            return null;
        }
        this.init(ssbnnode);
        this.parse();
        return this.getCPT();
    }

    @Override
    public PotentialTable generateLinearDistroCPT(ProbabilisticNode probNode) {
        float value = 1.0f / (float)probNode.getStatesSize();
        PotentialTable table = probNode.getPotentialTable();
        int i = 0;
        while (i < probNode.getPotentialTable().tableSize()) {
            table.setValue(i, value);
            ++i;
        }
        return table;
    }

    private void table() throws NoDefaultDistributionDeclaredException, InvalidConditionantException, SomeStateUndeclaredException, InvalidProbabilityRangeException, TableFunctionMalformedException {
        if (this.look == '[') {
            this.currentHeader = new TempTableHeaderCell(null, true, true, this.ssbnnode);
            this.tempTable.addNestedClause(this.currentHeader);
            this.statement(this.currentHeader);
        } else {
            this.ifStatement(this.tempTable);
        }
        this.skipWhite();
        if (this.look != ' ') {
            this.expected("end of declaration");
        }
    }

    private void ifStatement(INestedIfElseClauseContainer upperIf) throws NoDefaultDistributionDeclaredException, InvalidConditionantException, SomeStateUndeclaredException, InvalidProbabilityRangeException, TableFunctionMalformedException {
        this.scan();
        this.matchString("IF");
        this.scan();
        switch (this.token) {
            case 'a': {
                this.currentHeader = new TempTableHeaderCell(new ArrayList<TempTableHeaderParent>(), false, false, this.ssbnnode);
                break;
            }
            case 'y': {
                this.currentHeader = new TempTableHeaderCell(new ArrayList<TempTableHeaderParent>(), true, false, this.ssbnnode);
                break;
            }
            default: {
                this.expected("ALL or ANY");
            }
        }
        TempTableHeaderCell currentIfContainer = this.currentHeader;
        if (upperIf == null) {
            upperIf = this.tempTable;
        }
        upperIf.addNestedClause(this.currentHeader);
        String varSetName = this.varsetname();
        this.currentHeader.setVarsetname(varSetName);
        this.scan();
        this.matchString("HAVE");
        this.match('(');
        ICompilerBooleanValue expressionTree = null;
        try {
            expressionTree = this.bExpression();
        }
        catch (TableFunctionMalformedException e) {
            throw new InvalidConditionantException((Throwable)e);
        }
        this.match(')');
        if (expressionTree == null) {
            throw new InvalidConditionantException();
        }
        this.currentHeader.setBooleanExpressionTree(expressionTree);
        try {
            this.statement(currentIfContainer);
        }
        catch (TableFunctionMalformedException e) {
            throw new InvalidProbabilityRangeException("[" + this.getNode().getName() + "]", e);
        }
        if (this.index < this.text.length) {
            try {
                this.scan();
            }
            catch (TableFunctionMalformedException e) {
                throw new NoDefaultDistributionDeclaredException((Throwable)e);
            }
        } else {
            throw new NoDefaultDistributionDeclaredException();
        }
        if (this.token != 'l') {
            throw new NoDefaultDistributionDeclaredException();
        }
        this.else_statement(upperIf);
    }

    private String varsetname() throws TableFunctionMalformedException {
        String ret = "";
        do {
            this.scanNoSkip();
            if (this.token == 'x') {
                ret = String.valueOf(ret) + this.noCaseChangeValue;
            } else {
                this.expected("Identifier");
            }
            if (this.look != '.') break;
            this.nextChar();
            ret = this.ssbnnode != null ? String.valueOf(ret) + this.ssbnnode.getStrongOVSeparator() : String.valueOf(ret) + ".";
        } while (this.index < this.text.length);
        this.skipWhite();
        return ret;
    }

    private ICompilerBooleanValue bExpression() throws InvalidConditionantException, TableFunctionMalformedException {
        ICompilerBooleanValue val1 = this.bTerm();
        if (this.look == '|') {
            this.match('|');
            ICompilerBooleanValue val2 = this.bTerm();
            return new CompilerOrValue(val1, val2);
        }
        return val1;
    }

    private ICompilerBooleanValue bTerm() throws InvalidConditionantException, TableFunctionMalformedException {
        ICompilerBooleanValue val1 = this.notFactor();
        if (this.look == '&') {
            this.match('&');
            ICompilerBooleanValue val2 = this.notFactor();
            return new CompilerAndValue(val1, val2);
        }
        return val1;
    }

    private ICompilerBooleanValue notFactor() throws InvalidConditionantException, TableFunctionMalformedException {
        ICompilerBooleanValue factor;
        boolean isNot = false;
        if (this.look == '~') {
            isNot = true;
            this.match('~');
        }
        if ((factor = this.bFactor()) == null) {
            throw new TableFunctionMalformedException();
        }
        if (isNot) {
            return new CompilerNotValue(factor);
        }
        return factor;
    }

    private ICompilerBooleanValue bFactor() throws InvalidConditionantException, TableFunctionMalformedException {
        ResidentNode resident;
        String conditionantName = null;
        if (this.look == '(') {
            this.match('(');
            ICompilerBooleanValue ret = this.bExpression();
            this.match(')');
            return ret;
        }
        this.scan();
        if (this.token == 'x') {
            conditionantName = this.noCaseChangeValue;
            if (this.node != null && !this.isValidConditionant(this.mebn, this.node, conditionantName)) {
                throw new InvalidConditionantException();
            }
        } else {
            try {
                this.expected("Identifier");
            }
            catch (TableFunctionMalformedException e) {
                throw new InvalidConditionantException((Throwable)e);
            }
        }
        this.match('=');
        this.scan();
        if (this.token == 'x') {
            if (this.node != null && !this.isValidConditionantValue(this.mebn, conditionantName, this.noCaseChangeValue)) {
                throw new InvalidConditionantException();
            }
        } else {
            try {
                this.expected("Identifier");
            }
            catch (TableFunctionMalformedException e) {
                throw new InvalidConditionantException((Throwable)e);
            }
        }
        if ((resident = this.mebn.getDomainResidentNode(conditionantName)) == null) {
            try {
                this.expected("Identifier");
            }
            catch (TableFunctionMalformedException e) {
                throw new InvalidConditionantException((Throwable)e);
            }
        }
        Entity condvalue = null;
        for (Entity possibleValue : resident.getPossibleValueListIncludingEntityInstances()) {
            if (!possibleValue.getName().equalsIgnoreCase(this.value)) continue;
            condvalue = possibleValue;
            break;
        }
        if (condvalue == null) {
            try {
                this.expected("Identifier");
            }
            catch (TableFunctionMalformedException e) {
                throw new InvalidConditionantException((Throwable)e);
            }
        }
        TempTableHeaderParent headerParent = new TempTableHeaderParent(resident, condvalue);
        this.currentHeader.addParent(headerParent);
        return headerParent;
    }

    private void else_statement(INestedIfElseClauseContainer upperIf) throws NoDefaultDistributionDeclaredException, InvalidConditionantException, SomeStateUndeclaredException, InvalidProbabilityRangeException, TableFunctionMalformedException {
        if (this.look == '[') {
            this.currentHeader = new TempTableHeaderCell(null, true, true, this.ssbnnode);
            if (upperIf == null) {
                this.tempTable.addNestedClause(this.currentHeader);
            } else {
                upperIf.addNestedClause(this.currentHeader);
            }
            this.statement(this.currentHeader);
        } else {
            this.ifStatement(upperIf);
        }
    }

    private void statement(INestedIfElseClauseContainer upperIf) throws NoDefaultDistributionDeclaredException, InvalidConditionantException, SomeStateUndeclaredException, InvalidProbabilityRangeException, TableFunctionMalformedException {
        if (this.look == '[') {
            this.match('[');
            this.assignmentOrIf(upperIf);
            this.match(']');
        } else {
            this.expected("[");
        }
    }

    private void assignmentOrIf(INestedIfElseClauseContainer upperIf) throws InvalidProbabilityRangeException, TableFunctionMalformedException, SomeStateUndeclaredException, NoDefaultDistributionDeclaredException, InvalidConditionantException {
        try {
            if (this.tokenLookAhead() == this.kwcode[this.lookup("IF")]) {
                this.ifStatement(upperIf);
            } else {
                ArrayList<Entity> declaredStates = new ArrayList<Entity>();
                List<Entity> possibleStates = null;
                if (this.node != null) {
                    possibleStates = this.node.getPossibleValueListIncludingEntityInstances();
                }
                this.assignment(declaredStates, possibleStates);
                if (this.node != null && !declaredStates.containsAll(possibleStates)) {
                    throw new SomeStateUndeclaredException();
                }
                if (!this.currentHeader.isSumEquals1() && !Float.isNaN(this.currentHeader.getProbCellSum())) {
                    throw new InvalidProbabilityRangeException();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException(resource.getString("FatalError"), e);
        }
    }

    private IProbabilityValue assignment(List<Entity> declaredStates, List<Entity> possibleStates) throws InvalidProbabilityRangeException, TableFunctionMalformedException, SomeStateUndeclaredException {
        TempTableProbabilityCell currentCell = new TempTableProbabilityCell(null, null);
        this.scan();
        if (this.token == 'x') {
            if (this.node != null) {
                Entity possibleValue = null;
                try {
                    possibleValue = possibleStates.get(this.node.getPossibleValueIndex(this.noCaseChangeValue));
                }
                catch (Exception e) {
                    throw new TableFunctionMalformedException((Throwable)e);
                }
                if (possibleValue == null) {
                    throw new TableFunctionMalformedException();
                }
                declaredStates.add(possibleValue);
                currentCell.setPossibleValue(possibleValue);
            }
        } else {
            this.expected("Identifier");
        }
        this.match('=');
        IProbabilityValue ret = this.expression();
        float retValue = ret.getProbability();
        boolean hasUnknownValue = Float.isNaN(retValue);
        currentCell.setProbability(ret);
        if (currentCell.getPossibleValue() != null) {
            this.currentHeader.addCell(currentCell);
        }
        if ((double)retValue < 0.0 || 1.0 < (double)retValue) {
            throw new InvalidProbabilityRangeException();
        }
        if (this.look == ',') {
            this.match(',');
            IProbabilityValue temp = this.assignment(declaredStates, possibleStates);
            float tempValue = temp.getProbability();
            boolean bl = hasUnknownValue = hasUnknownValue || Float.isNaN(tempValue);
            retValue = hasUnknownValue ? Float.NaN : (retValue += temp.getProbability());
        }
        if (retValue < 0.0f) {
            throw new InvalidProbabilityRangeException();
        }
        return new SimpleProbabilityValue(retValue);
    }

    private IProbabilityValue expression() throws TableFunctionMalformedException, InvalidProbabilityRangeException, SomeStateUndeclaredException {
        IProbabilityValue temp1 = this.term();
        IProbabilityValue temp2 = null;
        Float temp1Value = null;
        Float temp2Value = null;
        switch (this.look) {
            case '+': {
                this.match('+');
                temp2 = this.term();
                temp1Value = Float.valueOf(temp1.getProbability());
                temp2Value = Float.valueOf(temp2.getProbability());
                if (Float.isNaN(temp1Value.floatValue()) || Float.isNaN(temp2Value.floatValue())) break;
                temp1 = new AddOperationProbabilityValue(temp1.isFixedValue ? new SimpleProbabilityValue(temp1Value.floatValue()) : temp1, temp2.isFixedValue ? new SimpleProbabilityValue(temp2Value.floatValue()) : temp2);
                break;
            }
            case '-': {
                this.match('-');
                temp2 = this.term();
                temp1Value = Float.valueOf(temp1.getProbability());
                temp2Value = Float.valueOf(temp2.getProbability());
                if (Float.isNaN(temp1Value.floatValue()) || Float.isNaN(temp2Value.floatValue())) break;
                temp1 = new SubtractOperationProbabilityValue(temp1.isFixedValue ? new SimpleProbabilityValue(temp1Value.floatValue()) : temp1, temp2.isFixedValue ? new SimpleProbabilityValue(temp2Value.floatValue()) : temp2);
            }
        }
        return temp1;
    }

    private IProbabilityValue term() throws TableFunctionMalformedException, InvalidProbabilityRangeException, SomeStateUndeclaredException {
        IProbabilityValue temp1 = this.signedFactor();
        IProbabilityValue temp2 = null;
        Float temp1Value = null;
        Float temp2Value = null;
        switch (this.look) {
            case '*': {
                this.match('*');
                temp2 = this.signedFactor();
                temp1Value = Float.valueOf(temp1.getProbability());
                temp2Value = Float.valueOf(temp2.getProbability());
                if (Float.isNaN(temp1Value.floatValue()) || Float.isNaN(temp2Value.floatValue())) break;
                return new MultiplyOperationProbabilityValue(temp1.isFixedValue ? new SimpleProbabilityValue(temp1Value.floatValue()) : temp1, temp2.isFixedValue ? new SimpleProbabilityValue(temp2Value.floatValue()) : temp2);
            }
            case '/': {
                this.match('/');
                temp2 = this.signedFactor();
                temp1Value = Float.valueOf(temp1.getProbability());
                temp2Value = Float.valueOf(temp2.getProbability());
                if (Float.isNaN(temp1Value.floatValue()) || Float.isNaN(temp2Value.floatValue())) break;
                return new DivideOperationProbabilityValue(temp1.isFixedValue ? new SimpleProbabilityValue(temp1Value.floatValue()) : temp1, temp2.isFixedValue ? new SimpleProbabilityValue(temp2Value.floatValue()) : temp2);
            }
        }
        return temp1;
    }

    private IProbabilityValue signedFactor() throws TableFunctionMalformedException, InvalidProbabilityRangeException, SomeStateUndeclaredException {
        boolean isMinus = false;
        if (this.isAddOp(this.look)) {
            if (this.isMinus(this.look)) {
                isMinus = true;
            }
            this.nextChar();
            this.skipWhite();
        }
        if (isMinus) {
            return new NegativeOperationProbabilityValue(this.factor());
        }
        return this.factor();
    }

    private IProbabilityValue factor() throws TableFunctionMalformedException, InvalidProbabilityRangeException, SomeStateUndeclaredException {
        IProbabilityValue ret = null;
        if (this.look == '(') {
            this.match('(');
            ret = this.expression();
            this.match(')');
        } else {
            ret = this.isAlpha(this.look) ? this.function() : this.getNum();
        }
        return ret;
    }

    private void getName() throws TableFunctionMalformedException {
        this.value = "";
        if (!this.isAlpha(this.look)) {
            this.expected("Name");
        }
        while (this.isAlphaNumeric(this.look)) {
            this.value = String.valueOf(this.value) + this.look;
            this.nextChar();
        }
        this.noCaseChangeValue = this.value;
        this.value = this.value.toUpperCase();
        this.token = (char)120;
    }

    private IProbabilityValue possibleVal() throws TableFunctionMalformedException, SomeStateUndeclaredException {
        this.getName();
        SimpleProbabilityValue ret = new SimpleProbabilityValue(Float.NaN);
        if (this.currentHeader != null) {
            for (TempTableProbabilityCell cell : this.currentHeader.getCellList()) {
                if (!cell.getPossibleValue().getName().equalsIgnoreCase(this.value)) continue;
                return cell.getProbability();
            }
        } else {
            throw new SomeStateUndeclaredException();
        }
        return ret;
    }

    private IProbabilityValue getNum() throws TableFunctionMalformedException {
        this.value = "";
        if (!(this.isNumeric(this.look) || this.look == '.' && this.value.indexOf(46) == -1)) {
            this.expected("Number");
        }
        while (this.isNumeric(this.look) || this.look == '.' && this.value.indexOf(46) == -1) {
            this.value = String.valueOf(this.value) + this.look;
            this.nextChar();
        }
        this.token = (char)35;
        this.skipWhite();
        return new SimpleProbabilityValue(Float.parseFloat(this.value));
    }

    private void scan() throws TableFunctionMalformedException {
        this.getName();
        this.skipWhite();
        int kw = this.lookup(this.value);
        this.token = kw == -1 ? (char)120 : this.kwcode[kw];
    }

    private void scanNoSkip() throws TableFunctionMalformedException {
        this.getName();
        int kw = this.lookup(this.value);
        this.token = kw == -1 ? (char)120 : this.kwcode[kw];
    }

    private char tokenLookAhead() throws TableFunctionMalformedException {
        int originalIndex = this.index;
        char originalLook = this.look;
        String originalValue = new String(this.value);
        String originalNoCaseChangeValue = new String(this.noCaseChangeValue);
        char originalToken = this.token;
        char returnedToken = ' ';
        this.scan();
        returnedToken = this.token;
        this.index = originalIndex;
        this.look = originalLook;
        this.value = originalValue;
        this.noCaseChangeValue = originalNoCaseChangeValue;
        this.token = originalToken;
        return returnedToken;
    }

    private int lookup(String s) {
        int i = 0;
        while (i < this.kwlist.length) {
            if (this.kwlist[i].equalsIgnoreCase(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void nextChar() {
        this.look = (char)(this.index < this.text.length ? this.text[this.index++] : 32);
    }

    private void skipWhite() {
        while (this.index < this.text.length && this.look == ' ') {
            this.nextChar();
        }
    }

    private void expected(String error) throws TableFunctionMalformedException {
        System.err.println("Error: " + error + " expected!");
        throw new TableFunctionMalformedException();
    }

    private void match(char c) throws TableFunctionMalformedException {
        if (this.look != c) {
            this.expected("" + c);
        }
        this.nextChar();
        this.skipWhite();
    }

    private void matchString(String s) throws TableFunctionMalformedException {
        if (!this.value.equalsIgnoreCase(s)) {
            this.expected(s);
        }
    }

    private boolean isAlpha(char c) {
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        return c == '_';
    }

    private boolean isAlphaNumeric(char c) {
        if (this.isAlpha(c)) {
            return true;
        }
        return this.isNumeric(c);
    }

    private boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isAddOp(char c) {
        return c == '+' || c == '-';
    }

    private boolean isMinus(char c) {
        return c == '-';
    }

    public ResidentNode getNode() {
        if (this.ssbnnode != null) {
            this.node = this.ssbnnode.getResident();
        }
        return this.node;
    }

    public void setNode(ResidentNode node) {
        this.node = node;
        if (this.node != null) {
            this.mebn = node.getMFrag().getMultiEntityBayesianNetwork();
        }
    }

    private boolean isValidConditionant(MultiEntityBayesianNetwork mebn, ResidentNode node, String conditionantName) {
        Node conditionant = mebn.getNode(conditionantName);
        if (conditionant != null) {
            if (node.getParents().contains(conditionant)) {
                return true;
            }
            ArrayList<Node> parents = node.getParents();
            int i = 0;
            while (i < parents.size()) {
                if (parents.get(i) instanceof InputNode && ((InputNode)parents.get(i)).getInputInstanceOf().equals(conditionant)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isValidConditionantValue(MultiEntityBayesianNetwork mebn, String conditionantName, String conditionantValue) {
        Node conditionant = mebn.getNode(conditionantName);
        if (conditionant == null) {
            return false;
        }
        if (conditionant instanceof ResidentNode) {
            return ((ResidentNode)conditionant).getPossibleValueByName(conditionantValue) != null;
        }
        return false;
    }

    private IProbabilityValue function() throws TableFunctionMalformedException, InvalidProbabilityRangeException, SomeStateUndeclaredException {
        IProbabilityValue ret = this.possibleVal();
        this.skipWhite();
        if (this.look == '(') {
            if (this.value.equalsIgnoreCase("CARDINALITY")) {
                return this.cardinality();
            }
            if (this.value.equalsIgnoreCase("MIN")) {
                return this.min();
            }
            if (this.value.equalsIgnoreCase("MAX")) {
                return this.max();
            }
            throw new TableFunctionMalformedException(String.valueOf(resource.getString("UnexpectedTokenFound")) + ": " + this.value);
        }
        return ret;
    }

    private IProbabilityValue cardinality() throws TableFunctionMalformedException {
        CardinalityProbabilityValue ret = null;
        this.match('(');
        String var = this.varsetname();
        this.skipWhite();
        ret = new CardinalityProbabilityValue(this.currentHeader, var);
        this.match(')');
        return ret;
    }

    private IProbabilityValue min() throws TableFunctionMalformedException, InvalidProbabilityRangeException, SomeStateUndeclaredException {
        IProbabilityValue ret1 = null;
        IProbabilityValue ret2 = null;
        this.match('(');
        ret1 = this.expression();
        this.match(';');
        ret2 = this.expression();
        this.match(')');
        return new ComparisionProbabilityValue(ret1, ret2, false);
    }

    private IProbabilityValue max() throws TableFunctionMalformedException, InvalidProbabilityRangeException, SomeStateUndeclaredException {
        IProbabilityValue ret1 = null;
        IProbabilityValue ret2 = null;
        this.match('(');
        ret1 = this.expression();
        this.match(';');
        ret2 = this.expression();
        this.match(')');
        return new ComparisionProbabilityValue(ret1, ret2, true);
    }

    @Override
    public int getIndex() {
        try {
            return (int)((float)this.index * ((float)this.originalTextLength / (float)this.text.length));
        }
        catch (Exception e) {
            return this.index;
        }
    }

    protected PotentialTable getPotentialTable() {
        return this.cpt;
    }

    public void setPotentialTable(PotentialTable cpt) {
        this.cpt = cpt;
    }

    public SSBNNode getSSBNNode() {
        return this.ssbnnode;
    }

    public void setSSBNNode(SSBNNode ssbnnode) {
        this.ssbnnode = ssbnnode;
        if (this.ssbnnode != null) {
            this.setNode(this.ssbnnode.getResident());
        }
    }

    protected TempTable getTempTable() {
        return this.tempTable;
    }

    private class AddOperationProbabilityValue
    extends MathOperationProbabilityValue {
        AddOperationProbabilityValue(IProbabilityValue op1, IProbabilityValue op2) {
            this.op1 = op1;
            this.op2 = op2;
            this.isFixedValue = op1.isFixedValue ? op2.isFixedValue : false;
        }

        public float getProbability() throws InvalidProbabilityRangeException {
            return this.op1.getProbability() + this.op2.getProbability();
        }
    }

    private class CardinalityProbabilityValue
    extends IProbabilityValue {
        private String varSetName;
        private TempTableHeaderCell currentHeader;

        CardinalityProbabilityValue(TempTableHeaderCell currentHeader, String varsetname) {
            this.varSetName = null;
            this.currentHeader = null;
            this.currentHeader = currentHeader;
            this.varSetName = varsetname;
            this.isFixedValue = false;
        }

        public float getProbability() throws InvalidProbabilityRangeException {
            if (this.currentHeader == null) {
                return Float.NaN;
            }
            if (Compiler.this.getSSBNNode() == null) {
                return Float.NaN;
            }
            TempTableHeaderCell matchingHeader = this.currentHeader;
            while (!matchingHeader.getVarsetname().equalsIgnoreCase(this.varSetName)) {
                try {
                    matchingHeader = (TempTableHeaderCell)matchingHeader.getUpperClause();
                }
                catch (ClassCastException e) {
                    return 0.0f;
                }
            }
            return matchingHeader.getValidParentSetCount();
        }
    }

    private class ComparisionProbabilityValue
    extends IProbabilityValue {
        private IProbabilityValue arg0;
        private IProbabilityValue arg1;
        private boolean isMax;

        ComparisionProbabilityValue(IProbabilityValue arg0, IProbabilityValue arg1, boolean isMax) {
            this.arg0 = null;
            this.arg1 = null;
            this.isMax = false;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.isMax = isMax;
            this.isFixedValue = arg0.isFixedValue ? arg1.isFixedValue : false;
        }

        public float getProbability() throws InvalidProbabilityRangeException {
            Float prob0 = Float.valueOf(this.arg0.getProbability());
            if (Float.isNaN(prob0.floatValue())) {
                return prob0.floatValue();
            }
            Float prob1 = Float.valueOf(this.arg1.getProbability());
            if (Float.isNaN(prob1.floatValue())) {
                return prob1.floatValue();
            }
            if (this.isMax == prob0.floatValue() > prob1.floatValue()) {
                return prob0.floatValue();
            }
            return prob1.floatValue();
        }
    }

    private class CompilerAndValue
    implements ICompilerBooleanValue {
        private ICompilerBooleanValue value1 = null;
        private ICompilerBooleanValue value2 = null;

        public CompilerAndValue(ICompilerBooleanValue value1, ICompilerBooleanValue value2) {
            this.value1 = value1;
            this.value2 = value2;
        }

        public ICompilerBooleanValue getValue1() {
            return this.value1;
        }

        public void setValue1(ICompilerBooleanValue value1) {
            this.value1 = value1;
        }

        public ICompilerBooleanValue getValue2() {
            return this.value2;
        }

        public void setValue2(ICompilerBooleanValue value2) {
            this.value2 = value2;
        }

        public boolean evaluate() {
            return this.value1.evaluate() && this.value2.evaluate();
        }
    }

    private class CompilerNotValue
    implements ICompilerBooleanValue {
        private ICompilerBooleanValue value = null;

        public CompilerNotValue(ICompilerBooleanValue value) {
            this.value = value;
        }

        public ICompilerBooleanValue getValue() {
            return this.value;
        }

        public void setValue(ICompilerBooleanValue value) {
            this.value = value;
        }

        public boolean evaluate() {
            return !this.value.evaluate();
        }
    }

    private class CompilerOrValue
    implements ICompilerBooleanValue {
        private ICompilerBooleanValue value1 = null;
        private ICompilerBooleanValue value2 = null;

        public CompilerOrValue(ICompilerBooleanValue value1, ICompilerBooleanValue value2) {
            this.value1 = value1;
            this.value2 = value2;
        }

        public ICompilerBooleanValue getValue1() {
            return this.value1;
        }

        public void setValue1(ICompilerBooleanValue value1) {
            this.value1 = value1;
        }

        public ICompilerBooleanValue getValue2() {
            return this.value2;
        }

        public void setValue2(ICompilerBooleanValue value2) {
            this.value2 = value2;
        }

        public boolean evaluate() {
            return this.value1.evaluate() || this.value2.evaluate();
        }
    }

    private class DivideOperationProbabilityValue
    extends MathOperationProbabilityValue {
        DivideOperationProbabilityValue(IProbabilityValue op1, IProbabilityValue op2) {
            this.op1 = op1;
            this.op2 = op2;
            this.isFixedValue = op1.isFixedValue ? op2.isFixedValue : false;
        }

        public float getProbability() throws InvalidProbabilityRangeException {
            return this.op1.getProbability() / this.op2.getProbability();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntityAndArguments {
        public Entity entity = null;
        public List<OVInstance> arguments = null;

        public EntityAndArguments(Entity entity, List<OVInstance> arguments) {
            this.entity = entity;
            this.arguments = arguments;
        }
    }

    private static interface ICompilerBooleanValue {
        public boolean evaluate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface INestedIfElseClauseContainer {
        public void addNestedClause(TempTableHeaderCell var1);

        public TempTableHeaderCell getFirstTrueClause(Map<String, List<EntityAndArguments>> var1);

        public boolean isEmptyNestedClauses();

        public List<TempTableHeaderCell> getNestedClauses();

        public INestedIfElseClauseContainer getUpperClause();

        public void setUpperClause(INestedIfElseClauseContainer var1);

        public void cleanUpKnownValues(SSBNNode var1);
    }

    private abstract class IProbabilityValue {
        public boolean isFixedValue = true;

        private IProbabilityValue() {
        }

        public abstract float getProbability() throws InvalidProbabilityRangeException;
    }

    private abstract class MathOperationProbabilityValue
    extends IProbabilityValue {
        protected IProbabilityValue op1 = null;
        protected IProbabilityValue op2 = null;

        private MathOperationProbabilityValue() {
        }

        public abstract float getProbability() throws InvalidProbabilityRangeException;
    }

    private class MultiplyOperationProbabilityValue
    extends MathOperationProbabilityValue {
        MultiplyOperationProbabilityValue(IProbabilityValue op1, IProbabilityValue op2) {
            this.op1 = op1;
            this.op2 = op2;
            this.isFixedValue = op1.isFixedValue ? op2.isFixedValue : false;
        }

        public float getProbability() throws InvalidProbabilityRangeException {
            return this.op1.getProbability() * this.op2.getProbability();
        }
    }

    private class NegativeOperationProbabilityValue
    extends MathOperationProbabilityValue {
        NegativeOperationProbabilityValue(IProbabilityValue op1) {
            this.op1 = op1;
            this.op2 = op1;
            this.isFixedValue = op1.isFixedValue;
        }

        public float getProbability() throws InvalidProbabilityRangeException {
            return -this.op1.getProbability();
        }
    }

    private class SimpleProbabilityValue
    extends IProbabilityValue {
        private float value = Float.NaN;

        SimpleProbabilityValue(float value) {
            this.value = value;
        }

        public float getProbability() throws InvalidProbabilityRangeException {
            return this.value;
        }
    }

    private class SubtractOperationProbabilityValue
    extends MathOperationProbabilityValue {
        SubtractOperationProbabilityValue(IProbabilityValue op1, IProbabilityValue op2) {
            this.op1 = op1;
            this.op2 = op2;
            this.isFixedValue = op1.isFixedValue ? op2.isFixedValue : false;
        }

        public float getProbability() throws InvalidProbabilityRangeException {
            return this.op1.getProbability() - this.op2.getProbability();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TempTable
    implements INestedIfElseClauseContainer {
        private List<TempTableHeaderCell> clauses = new ArrayList<TempTableHeaderCell>();

        @Override
        public void addNestedClause(TempTableHeaderCell nestedClause) {
            this.clauses.add(nestedClause);
            nestedClause.setUpperClause(this);
        }

        @Override
        public List<TempTableHeaderCell> getNestedClauses() {
            return this.clauses;
        }

        @Override
        public boolean isEmptyNestedClauses() {
            return this.clauses.size() == 0;
        }

        public TempTableHeaderCell getDefaultClause() {
            if (this.isEmptyNestedClauses()) {
                return null;
            }
            return this.getNestedClauses().get(this.getNestedClauses().size() - 1).getDefaultClause();
        }

        @Override
        public TempTableHeaderCell getFirstTrueClause(Map<String, List<EntityAndArguments>> valuesOnCPTColumn) {
            if (this.isEmptyNestedClauses()) {
                return null;
            }
            for (TempTableHeaderCell clause : this.getNestedClauses()) {
                if (!clause.evaluateBooleanExpressionTree(valuesOnCPTColumn)) continue;
                return clause.getFirstTrueClause(valuesOnCPTColumn);
            }
            return null;
        }

        @Override
        public INestedIfElseClauseContainer getUpperClause() {
            return null;
        }

        @Override
        public void setUpperClause(INestedIfElseClauseContainer upper) {
        }

        @Override
        public void cleanUpKnownValues(SSBNNode ssbnnode) {
            for (TempTableHeaderCell clause : this.getNestedClauses()) {
                clause.cleanUpKnownValues(ssbnnode);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TempTableHeaderCell
    implements INestedIfElseClauseContainer {
        private ICompilerBooleanValue booleanExpressionTree = null;
        private List<TempTableHeaderParent> parents = null;
        private String varsetname = "";
        private boolean isAny = true;
        private boolean isDefault = false;
        private List<TempTableProbabilityCell> cellList = null;
        private int validParentSetCount = 0;
        float leastCellValue = Float.NaN;
        SSBNNode currentSSBNNode = null;
        private List<TempTableHeaderCell> nestedIfs = null;
        private INestedIfElseClauseContainer upperContainer = null;

        TempTableHeaderCell(List<TempTableHeaderParent> parents, boolean isAny, boolean isDefault, SSBNNode currentSSBNNode) {
            this.parents = parents;
            this.isAny = isAny;
            this.isDefault = isDefault;
            this.cellList = new ArrayList<TempTableProbabilityCell>();
            this.validParentSetCount = 0;
            this.currentSSBNNode = currentSSBNNode;
            this.nestedIfs = new ArrayList<TempTableHeaderCell>();
        }

        public List<TempTableHeaderParent> getParents() {
            return this.parents;
        }

        public int getValidParentSetCount() {
            return this.validParentSetCount;
        }

        public void setValidParentSetCount(int validParentSetCount) {
            this.validParentSetCount = validParentSetCount;
        }

        public void increaseValidParentSetCount() {
            ++this.validParentSetCount;
        }

        public void setParents(List<TempTableHeaderParent> parents) {
            this.parents = parents;
        }

        public void addParent(TempTableHeaderParent parent) {
            this.parents.add(parent);
        }

        public boolean isAny() {
            return this.isAny;
        }

        public void setAny(boolean isAny) {
            this.isAny = isAny;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }

        public boolean isParentSetName(String varsetname) {
            return this.currentSSBNNode.getParentSetByStrongOVWithWeakOVCheck(varsetname.split("\\.")).size() > 0;
        }

        public String getVarsetname() {
            return this.varsetname;
        }

        public void setVarsetname(String varsetname) {
            this.varsetname = varsetname;
        }

        protected List<TempTableProbabilityCell> getCellList() {
            return this.cellList;
        }

        protected void setCellList(List<TempTableProbabilityCell> cellList) {
            this.cellList = cellList;
        }

        @Override
        public List<TempTableHeaderCell> getNestedClauses() {
            return this.nestedIfs;
        }

        public void setNestedIfs(List<TempTableHeaderCell> nestedIfs) {
            this.nestedIfs = nestedIfs;
        }

        public void addCell(Entity possibleValue, IProbabilityValue probability) {
            this.addCell(new TempTableProbabilityCell(possibleValue, probability));
        }

        public void addCell(TempTableProbabilityCell cell) {
            if (cell == null) {
                return;
            }
            float value = Float.NaN;
            try {
                value = cell.getProbabilityValue();
            }
            catch (InvalidProbabilityRangeException invalidProbabilityRangeException) {
                // empty catch block
            }
            if (value > 0.0f && (Float.isNaN(this.leastCellValue) || value < this.leastCellValue)) {
                this.leastCellValue = value;
            }
            this.cellList.add(cell);
        }

        public boolean isSumEquals1() throws InvalidProbabilityRangeException {
            float value = this.getProbCellSum();
            return value >= 1.0f - this.leastCellValue / 2.0f && value <= 1.0f + this.leastCellValue / 2.0f;
        }

        public float getProbCellSum() throws InvalidProbabilityRangeException {
            float sum = Float.NaN;
            if (this.cellList == null) {
                return sum;
            }
            if (this.cellList.size() <= 0) {
                return sum;
            }
            sum = 0.0f;
            for (TempTableProbabilityCell cell : this.cellList) {
                sum += cell.getProbabilityValue();
            }
            return sum;
        }

        public ICompilerBooleanValue getBooleanExpressionTree() {
            return this.booleanExpressionTree;
        }

        public void setBooleanExpressionTree(ICompilerBooleanValue booleanExpressionTree) {
            this.booleanExpressionTree = booleanExpressionTree;
        }

        public boolean evaluateBooleanExpressionTree(Map<String, List<EntityAndArguments>> valuesOnCPTColumn) {
            if (this.isDefault()) {
                return true;
            }
            this.setValidParentSetCount(0);
            List<TempTableHeaderParent> parentsList = this.getParents();
            boolean ret = !this.isAny();
            TempTableHeaderParent pointer = null;
            for (TempTableHeaderParent leaf : parentsList) {
                if (leaf.isKnownValue()) continue;
                leaf.setEvaluationList(valuesOnCPTColumn.get(leaf.getParent().getName()));
            }
            boolean hasMoreCombination = true;
            boolean expressionWasEvaluated = false;
            while (hasMoreCombination) {
                if (this.isSameOVsameEntity()) {
                    if (this.isAny()) {
                        boolean evaluation = this.getBooleanExpressionTree().evaluate();
                        boolean bl = ret = ret || evaluation;
                        if (evaluation) {
                            this.increaseValidParentSetCount();
                        }
                    } else {
                        boolean bl = ret = ret && this.getBooleanExpressionTree().evaluate();
                        if (!ret) {
                            return false;
                        }
                        this.increaseValidParentSetCount();
                    }
                    expressionWasEvaluated = true;
                }
                if ((pointer = parentsList.get(0)).hasNextEvaluation()) {
                    pointer.getNextEvaluation();
                    continue;
                }
                int lastPos = 0;
                while (!pointer.hasNextEvaluation() && lastPos < parentsList.size()) {
                    pointer.resetEvaluationList();
                    if (lastPos == parentsList.size() - 1) {
                        hasMoreCombination = false;
                        break;
                    }
                    pointer = parentsList.get(++lastPos);
                }
                if (!hasMoreCombination || !parentsList.get(lastPos).hasNextEvaluation()) continue;
                parentsList.get(lastPos).getNextEvaluation();
            }
            if (expressionWasEvaluated) {
                return ret;
            }
            return false;
        }

        private boolean isSameOVsameEntity() {
            List<TempTableHeaderParent> leaves = this.getParents();
            for (TempTableHeaderParent leaf : leaves) {
                if (leaf.isKnownValue()) continue;
                List<OVInstance> args = leaf.getCurrentEntityAndArguments().arguments;
                for (OVInstance argParent : args) {
                    for (OVInstance argChild : this.currentSSBNNode.getArguments()) {
                        if (!argChild.getOv().getName().equalsIgnoreCase(argParent.getOv().getName()) || argChild.getEntity().getInstanceName().equalsIgnoreCase(argParent.getEntity().getInstanceName())) continue;
                        return false;
                    }
                }
                int i = leaves.indexOf(leaf) + 1;
                while (i < leaves.size()) {
                    for (OVInstance argleaf : args) {
                        for (OVInstance argothers : leaves.get((int)i).getCurrentEntityAndArguments().arguments) {
                            if (!argleaf.getOv().getName().equalsIgnoreCase(argothers.getOv().getName()) || argleaf.getEntity().getInstanceName().equalsIgnoreCase(argothers.getEntity().getInstanceName())) continue;
                            return false;
                        }
                    }
                    ++i;
                }
            }
            return true;
        }

        private void cleanUpByVarSetName(SSBNNode baseSSBNNode) {
            if (this.isDefault()) {
                return;
            }
            List<SSBNNode> parents = baseSSBNNode.getParentSetByStrongOVWithWeakOVCheck(this.getVarsetname().split("\\" + baseSSBNNode.getStrongOVSeparator()));
            boolean found = false;
            for (TempTableHeaderParent headParent : this.getParents()) {
                found = false;
                for (SSBNNode node : parents) {
                    if (!node.getResident().equals(headParent.getParent())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                headParent.setKnownValue(true);
            }
        }

        @Override
        public void addNestedClause(TempTableHeaderCell nestedClause) {
            this.getNestedClauses().add(nestedClause);
            nestedClause.setUpperClause(this);
        }

        public TempTableHeaderCell getDefaultClause() {
            if (this.isEmptyNestedClauses()) {
                if (this.isDefault()) {
                    return this;
                }
                return null;
            }
            return this.getNestedClauses().get(this.getNestedClauses().size() - 1).getDefaultClause();
        }

        @Override
        public TempTableHeaderCell getFirstTrueClause(Map<String, List<EntityAndArguments>> valuesOnCPTColumn) {
            if (this.isEmptyNestedClauses()) {
                return this;
            }
            for (TempTableHeaderCell nested : this.getNestedClauses()) {
                if (!nested.evaluateBooleanExpressionTree(valuesOnCPTColumn)) continue;
                return nested.getFirstTrueClause(valuesOnCPTColumn);
            }
            return null;
        }

        @Override
        public boolean isEmptyNestedClauses() {
            if (this.getNestedClauses() == null) {
                return true;
            }
            return this.getNestedClauses().size() == 0;
        }

        @Override
        public INestedIfElseClauseContainer getUpperClause() {
            return this.upperContainer;
        }

        @Override
        public void setUpperClause(INestedIfElseClauseContainer upper) {
            this.upperContainer = upper;
        }

        @Override
        public void cleanUpKnownValues(SSBNNode ssbnnode) {
            this.cleanUpByVarSetName(ssbnnode);
            try {
                for (TempTableHeaderCell clause : this.getNestedClauses()) {
                    clause.cleanUpKnownValues(ssbnnode);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TempTableHeaderParent
    implements ICompilerBooleanValue {
        private ResidentNode parent = null;
        private Entity value = null;
        private List<EntityAndArguments> evaluationList = null;
        private int currentEvaluationIndex = -1;
        private boolean isKnownValue = false;

        TempTableHeaderParent(ResidentNode parent, Entity value) {
            this.parent = parent;
            this.value = value;
            this.evaluationList = null;
            this.currentEvaluationIndex = -1;
        }

        TempTableHeaderParent(ResidentNode parent, Entity value, List<EntityAndArguments> evaluationList) {
            this.parent = parent;
            this.value = value;
            this.setEvaluationList(evaluationList);
        }

        public ResidentNode getParent() {
            return this.parent;
        }

        public void setParent(ResidentNode parent) {
            this.parent = parent;
        }

        public Entity getValue() {
            return this.value;
        }

        public void setValue(Entity value) {
            this.value = value;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof TempTableHeaderParent) {
                TempTableHeaderParent arg = (TempTableHeaderParent)arg0;
                if (this.parent.getName().equalsIgnoreCase(arg.getParent().getName())) {
                    return this.value.getName().equalsIgnoreCase(arg.getValue().getName());
                }
                return false;
            }
            return false;
        }

        @Override
        public boolean evaluate() {
            if (this.isKnownValue()) {
                return false;
            }
            return this.getCurrentEvaluation().getName().equalsIgnoreCase(this.getValue().getName());
        }

        public List<EntityAndArguments> getEvaluationList() {
            return this.evaluationList;
        }

        public void setEvaluationList(List<EntityAndArguments> evaluationList) {
            this.evaluationList = evaluationList;
            if (this.evaluationList != null) {
                if (this.evaluationList.size() > 0) {
                    this.currentEvaluationIndex = 0;
                }
            } else {
                this.isKnownValue = true;
            }
        }

        public Entity getCurrentEvaluation() {
            if (this.evaluationList == null) {
                return null;
            }
            return this.evaluationList.get((int)this.currentEvaluationIndex).entity;
        }

        public EntityAndArguments getCurrentEntityAndArguments() {
            if (this.evaluationList == null) {
                return null;
            }
            return this.evaluationList.get(this.currentEvaluationIndex);
        }

        public void setCurrentEvaluation(Entity currentEvaluation) {
            this.currentEvaluationIndex = this.evaluationList.indexOf(currentEvaluation);
        }

        public boolean hasNextEvaluation() {
            if (this.evaluationList == null) {
                return false;
            }
            return this.currentEvaluationIndex + 1 < this.evaluationList.size();
        }

        public Entity getNextEvaluation() {
            ++this.currentEvaluationIndex;
            return this.getCurrentEvaluation();
        }

        public void resetEvaluationList() {
            if (this.evaluationList == null) {
                this.currentEvaluationIndex = -1;
                return;
            }
            if (this.evaluationList.size() <= 0) {
                this.currentEvaluationIndex = -1;
                return;
            }
            this.currentEvaluationIndex = 0;
        }

        public boolean isKnownValue() {
            return this.isKnownValue;
        }

        public void setKnownValue(boolean isKnownValue) {
            this.isKnownValue = isKnownValue;
            if (this.isKnownValue()) {
                this.setEvaluationList(null);
            }
        }
    }

    private class TempTableProbabilityCell {
        private Entity possibleValue = null;
        private IProbabilityValue probability = null;

        TempTableProbabilityCell(Entity possibleValue, IProbabilityValue probability) {
            this.possibleValue = possibleValue;
            this.probability = probability;
        }

        public Entity getPossibleValue() {
            return this.possibleValue;
        }

        public void setPossibleValue(Entity possibleValue) {
            this.possibleValue = possibleValue;
        }

        public float getProbabilityValue() throws InvalidProbabilityRangeException {
            return this.probability.getProbability();
        }

        public IProbabilityValue getProbability() {
            return this.probability;
        }

        public void setProbability(IProbabilityValue probability) {
            this.probability = probability;
        }
    }
}

