/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import unbbayes.draw.DrawFlatPentagon;
import unbbayes.prs.Node;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.ResidentNodePointer;
import unbbayes.prs.mebn.entity.Type;
import unbbayes.util.SerializablePoint2D;

public class OrdinaryVariable
extends Node {
    private static final long serialVersionUID = 1L;
    private MFrag mFrag;
    private Type type;
    private List<Node> isOVariableOfList;
    private List<ResidentNodePointer> isArgumentOfList;
    private static Color color = new Color(176, 252, 131);
    private DrawFlatPentagon drawContextNode;
    private static final Point DEFAULT_MEBN_SIZE = new Point(100, 20);
    protected static SerializablePoint2D size = new SerializablePoint2D(DEFAULT_MEBN_SIZE.getX(), DEFAULT_MEBN_SIZE.getY());

    public OrdinaryVariable(String name, Type type, MFrag mFrag) {
        this.name = name;
        this.mFrag = mFrag;
        this.type = type;
        type.addUserObject(this);
        this.isOVariableOfList = new ArrayList<Node>();
        this.isArgumentOfList = new ArrayList<ResidentNodePointer>();
        this.updateLabel();
        OrdinaryVariable.size.x = 100.0;
        OrdinaryVariable.size.y = 20.0;
        this.drawContextNode = new DrawFlatPentagon(this.position, size);
        this.drawElement.add(this.drawContextNode);
    }

    public MFrag getMFrag() {
        return this.mFrag;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        for (Node node : this.isOVariableOfList) {
            if (!(node instanceof ResidentNode)) continue;
            ((ResidentNode)node).updateLabel();
        }
    }

    public void setValueType(Type _type) {
        this.type.removeUserObject(this);
        this.type = _type;
        this.type.addUserObject(this);
    }

    public Type getValueType() {
        return this.type;
    }

    protected void addIsOVariableOfList(Node node) {
        if (!this.isOVariableOfList.contains(node)) {
            this.isOVariableOfList.add(node);
        }
    }

    public void removeIsOVariableOfList(Node node) {
        this.isOVariableOfList.remove(node);
    }

    protected void addIsArgumentOfList(ResidentNodePointer pointer) {
        if (!this.isArgumentOfList.contains(pointer)) {
            this.isArgumentOfList.add(pointer);
        }
    }

    protected void removeIsArgumentOfList(ResidentNodePointer pointer) {
        this.isArgumentOfList.remove(pointer);
    }

    public void removeFromMFrag() {
        this.mFrag = null;
    }

    public void delete() {
        this.mFrag.removeOrdinaryVariable(this);
        this.type.removeUserObject(this);
        for (Node node : this.isOVariableOfList) {
            if (node instanceof ResidentNode) {
                ((ResidentNode)node).removeArgument(this);
                continue;
            }
            boolean cfr_ignored_0 = node instanceof InputNode;
        }
        for (ResidentNodePointer pointer : this.isArgumentOfList) {
            pointer.removeOrdinaryVariable(this);
        }
    }

    public static Color getColor() {
        return color;
    }

    public static void setColor(int c) {
        color = new Color(c);
    }

    public void setSelected(boolean b) {
        this.drawContextNode.setSelected(b);
        super.setSelected(b);
    }

    public void paint(Graphics2D graphics) {
        this.drawContextNode.setFillColor(OrdinaryVariable.getColor());
        super.paint(graphics);
    }

    public String updateLabel() {
        String label = "isA(" + this.name + "," + this.type + ")";
        this.setLabel(label);
        return label;
    }

    public int getType() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof OrdinaryVariable) {
            OrdinaryVariable node = (OrdinaryVariable)obj;
            return node.name.equals(this.name);
        }
        return false;
    }

    public static Point2D.Double getSize() {
        return size;
    }

    public String toString() {
        return this.name;
    }
}

