/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import unbbayes.prs.Network;
import unbbayes.prs.Node;
import unbbayes.prs.mebn.BuiltInRV;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.MultiEntityNode;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.entity.BooleanStatesEntityContainer;
import unbbayes.prs.mebn.entity.CategoricalStatesEntityContainer;
import unbbayes.prs.mebn.entity.ObjectEntityConteiner;
import unbbayes.prs.mebn.entity.TypeContainer;
import unbbayes.util.IBridgeImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiEntityBayesianNetwork
extends Network {
    private List<MFrag> mFragList = new ArrayList<MFrag>();
    private List<MFrag> domainMFragList = new ArrayList<MFrag>();
    private List<BuiltInRV> builtInRVList = new ArrayList<BuiltInRV>();
    private MFrag currentMFrag;
    TypeContainer typeContainer = new TypeContainer();
    ObjectEntityConteiner objectEntityContainer = new ObjectEntityConteiner(this.typeContainer);
    BooleanStatesEntityContainer booleanStatesEntityContainer = new BooleanStatesEntityContainer();
    CategoricalStatesEntityContainer categoricalStatesEntityContainer = new CategoricalStatesEntityContainer();
    private String description;
    private int domainMFragNum = 1;
    private int generativeInputNodeNum = 1;
    private int domainResidentNodeNum = 1;
    private int contextNodeNum = 1;
    private int entityNum = 1;
    IBridgeImplementor storageImplementor = null;
    private Set<String> namesUsed = new TreeSet<String>();

    public MultiEntityBayesianNetwork(String name) {
        super(name);
    }

    public Set<String> getNamesUsed() {
        return this.namesUsed;
    }

    public void initListNamesUsedWithReservatedNames() {
        if (this.namesUsed == null) {
            this.namesUsed = new TreeSet<String>();
        }
        this.namesUsed.add("true");
        this.namesUsed.add("false");
        this.namesUsed.add("absurd");
        for (String typesNames : this.typeContainer.getTypesNames()) {
            this.namesUsed.add(typesNames);
        }
    }

    public void addDomainMFrag(MFrag domainMFrag) {
        this.mFragList.add(domainMFrag);
        this.domainMFragList.add(domainMFrag);
        this.currentMFrag = domainMFrag;
        ++this.domainMFragNum;
    }

    public void removeDomainMFrag(MFrag domainMFrag) {
        domainMFrag.delete();
        this.mFragList.remove(domainMFrag);
        this.domainMFragList.remove(domainMFrag);
        this.currentMFrag = null;
    }

    public MFrag getMFragByName(String name) {
        for (MFrag test : this.domainMFragList) {
            if (!test.getName().equals(name)) continue;
            return test;
        }
        return null;
    }

    public List<MFrag> getMFragList() {
        return this.mFragList;
    }

    public List<MFrag> getDomainMFragList() {
        return this.domainMFragList;
    }

    public int getMFragCount() {
        return this.mFragList.size();
    }

    public MFrag getCurrentMFrag() {
        return this.currentMFrag;
    }

    public void setCurrentMFrag(MFrag currentMFrag) {
        this.currentMFrag = currentMFrag;
    }

    public List<BuiltInRV> getBuiltInRVList() {
        return this.builtInRVList;
    }

    public void addBuiltInRVList(BuiltInRV builtInRV) {
        this.builtInRVList.add(builtInRV);
    }

    public ArrayList<Node> getNodeList() {
        if (this.currentMFrag != null) {
            return this.currentMFrag.getNodeList();
        }
        return null;
    }

    public int getDomainMFragNum() {
        return this.domainMFragNum;
    }

    public int getContextNodeNum() {
        return this.contextNodeNum;
    }

    public void setContextNodeNum(int contextNodeNum) {
        this.contextNodeNum = contextNodeNum;
    }

    public void plusContextNodeNul() {
        ++this.contextNodeNum;
    }

    public int getDomainResidentNodeNum() {
        return this.domainResidentNodeNum;
    }

    public void setDomainResidentNodeNum(int domainResidentNodeNum) {
        this.domainResidentNodeNum = domainResidentNodeNum;
    }

    public void plusDomainResidentNodeNum() {
        ++this.domainResidentNodeNum;
    }

    public int getGenerativeInputNodeNum() {
        return this.generativeInputNodeNum;
    }

    public void setGenerativeInputNodeNum(int generativeInputNodeNum) {
        this.generativeInputNodeNum = generativeInputNodeNum;
    }

    public void plusGenerativeInputNodeNum() {
        ++this.generativeInputNodeNum;
    }

    public int getEntityNum() {
        return this.entityNum;
    }

    public void setEntityNum(int entityNum) {
        this.entityNum = entityNum;
    }

    public void plusEntityNul() {
        ++this.entityNum;
    }

    public void setDomainMFragNum(int domainMFragNum) {
        this.domainMFragNum = domainMFragNum;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public BooleanStatesEntityContainer getBooleanStatesEntityContainer() {
        return this.booleanStatesEntityContainer;
    }

    public CategoricalStatesEntityContainer getCategoricalStatesEntityContainer() {
        return this.categoricalStatesEntityContainer;
    }

    public ObjectEntityConteiner getObjectEntityContainer() {
        return this.objectEntityContainer;
    }

    public TypeContainer getTypeContainer() {
        return this.typeContainer;
    }

    public MFrag getDomainMFragByNodeName(String nodeName) {
        for (MFrag mfrag : this.domainMFragList) {
            if (mfrag.getDomainResidentNodeByName(nodeName) == null) continue;
            return mfrag;
        }
        return null;
    }

    public MFrag getMFragByNode(MultiEntityNode node) {
        for (MFrag element : this.mFragList) {
            if (!element.containsNode(node)) continue;
            return element;
        }
        return null;
    }

    public ContextNode getContextNode(String name) {
        for (MFrag mfrag : this.domainMFragList) {
            for (ContextNode node : mfrag.getContextNodeList()) {
                if (!node.getName().equals(name)) continue;
                return node;
            }
        }
        return null;
    }

    public ResidentNode getDomainResidentNode(String name) {
        for (MFrag mfrag : this.domainMFragList) {
            for (ResidentNode node : mfrag.getResidentNodeList()) {
                if (!node.getName().equalsIgnoreCase(name)) continue;
                return node;
            }
        }
        return null;
    }

    public List<ResidentNode> getDomainResidentNodes() {
        ArrayList<ResidentNode> nodes = new ArrayList<ResidentNode>();
        for (MFrag mfrag : this.domainMFragList) {
            nodes.addAll(mfrag.getResidentNodeList());
        }
        return nodes;
    }

    public InputNode getInputNode(String name) {
        for (MFrag mfrag : this.domainMFragList) {
            for (InputNode node : mfrag.getInputNodeList()) {
                if (!node.getName().equals(name)) continue;
                return node;
            }
        }
        return null;
    }

    public void clearMFragsIsUsingDefaultCPTFlag() {
        for (MFrag mfrag : this.getDomainMFragList()) {
            mfrag.setAsUsingDefaultCPT(false);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IBridgeImplementor getStorageImplementor() {
        return this.storageImplementor;
    }

    public void setStorageImplementor(IBridgeImplementor storageImplementor) {
        this.storageImplementor = storageImplementor;
    }
}

