/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.hybridbn;

import java.util.ArrayList;
import java.util.List;
import unbbayes.prs.Node;
import unbbayes.prs.hybridbn.ContinuousNode;
import unbbayes.prs.hybridbn.NormalDistribution;
import unbbayes.util.SortUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNNormalDistribution {
    protected ContinuousNode cNode;
    protected NormalDistributionFunction[] ndfList;
    protected List<Node> discreteParentList;
    protected List<Node> continuousParentList;
    protected int[] factors;

    public List<Node> getDiscreteParentList() {
        return this.discreteParentList;
    }

    public List<Node> getContinuousParentList() {
        return this.continuousParentList;
    }

    public CNNormalDistribution(ContinuousNode cNode) {
        this.cNode = cNode;
        this.refreshParents();
    }

    public void refreshParents() {
        this.discreteParentList = new ArrayList<Node>();
        this.continuousParentList = new ArrayList<Node>();
        for (Node node : this.cNode.getParents()) {
            if (node.getType() == 5) {
                this.continuousParentList.add(node);
                continue;
            }
            this.discreteParentList.add(node);
        }
        SortUtil.sortNodeListByName(this.discreteParentList);
        SortUtil.sortNodeListByName(this.continuousParentList);
        this.calculateFactors();
        if (this.discreteParentList.size() > 0) {
            int lastNode = this.factors.length - 1;
            int ndfListSize = this.factors[lastNode] * this.discreteParentList.get(lastNode).getStatesSize();
            this.ndfList = new NormalDistributionFunction[ndfListSize];
            int i = 0;
            while (i < this.ndfList.length) {
                this.ndfList[i] = new NormalDistributionFunction();
                ++i;
            }
        } else {
            this.ndfList = new NormalDistributionFunction[1];
            this.ndfList[0] = new NormalDistributionFunction();
        }
    }

    public void setConstantAt(int constantIndex, double value, int[] multidimensionalCoord) {
        this.ndfList[this.getLinearCoord(multidimensionalCoord)].setConstantAt(constantIndex, value);
    }

    public void setConstantAt(int constantIndex, double value, int index) {
        this.ndfList[index].setConstantAt(constantIndex, value);
    }

    public double getConstantAt(int constantIndex, int[] multidimensionalCoord) {
        return this.ndfList[this.getLinearCoord(multidimensionalCoord)].getConstantAt(constantIndex);
    }

    public double getConstantAt(int constantIndex, int index) {
        return this.ndfList[index].getConstantAt(constantIndex);
    }

    public int getConstantListSize() {
        return this.continuousParentList.size();
    }

    public void setMean(double mean, int[] multidimensionalCoord) {
        this.ndfList[this.getLinearCoord(multidimensionalCoord)].setMean(mean);
    }

    public void setMean(double mean, int index) {
        this.ndfList[index].setMean(mean);
    }

    public double getMean(int[] multidimensionalCoord) {
        return this.ndfList[this.getLinearCoord(multidimensionalCoord)].getMean();
    }

    public double getMean(int index) {
        return this.ndfList[index].getMean();
    }

    public void setVariance(double variance, int[] multidimensionalCoord) {
        this.ndfList[this.getLinearCoord(multidimensionalCoord)].setVariance(variance);
    }

    public void setVariance(double variance, int index) {
        this.ndfList[index].setVariance(variance);
    }

    public double getVariance(int[] multidimensionalCoord) {
        return this.ndfList[this.getLinearCoord(multidimensionalCoord)].getVariance();
    }

    public double getVariance(int index) {
        return this.ndfList[index].getVariance();
    }

    protected void calculateFactors() {
        int size = this.discreteParentList.size();
        if (this.factors == null || this.factors.length != size) {
            this.factors = new int[size];
        }
        if (size == 0) {
            this.factors = new int[1];
        }
        this.factors[0] = 1;
        int i = 1;
        while (i < size) {
            Node node = this.discreteParentList.get(i - 1);
            this.factors[i] = this.factors[i - 1] * node.getStatesSize();
            ++i;
        }
    }

    public final int getLinearCoord(int[] multidimensionalCoord) {
        this.calculateFactors();
        int coordLinear = 0;
        int size = this.discreteParentList.size();
        int v = 0;
        while (v < size) {
            coordLinear += multidimensionalCoord[v] * this.factors[v];
            ++v;
        }
        return coordLinear;
    }

    public final int[] getMultidimensionalCoord(int linearCoord) {
        this.calculateFactors();
        int size = this.discreteParentList.size();
        int[] multidimensionalCoord = new int[size];
        int i = size - 1;
        while (linearCoord != 0) {
            int factorI = this.factors[i];
            multidimensionalCoord[i--] = linearCoord / factorI;
            linearCoord %= factorI;
        }
        return multidimensionalCoord;
    }

    public int functionSize() {
        return this.ndfList.length;
    }

    protected class NormalDistributionFunction {
        protected double[] constantList;
        protected NormalDistribution normalDistribution;

        public NormalDistributionFunction() {
            this.constantList = new double[CNNormalDistribution.this.continuousParentList.size()];
            int i = 0;
            while (i < this.constantList.length) {
                this.constantList[i] = 0.0;
                ++i;
            }
            this.normalDistribution = new NormalDistribution();
        }

        public void setMean(double mean) {
            this.normalDistribution.setMean(mean);
        }

        public double getMean() {
            return this.normalDistribution.getMean();
        }

        public void setVariance(double variance) {
            this.normalDistribution.setVariance(variance);
        }

        public double getVariance() {
            return this.normalDistribution.getVariance();
        }

        public void setConstantAt(int index, double value) {
            this.constantList[index] = value;
        }

        public double getConstantAt(int index) {
            return this.constantList[index];
        }
    }
}

