/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.io.Serializable;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ITabledVariable;
import unbbayes.prs.bn.PotentialTable;

public abstract class TreeVariable
extends Node
implements Serializable {
    protected ITabledVariable cliqueAssociado;
    protected float[] marginalList;
    private float[] marginalCopy;
    private int evidence = -1;

    protected abstract void marginal();

    public void initMarginalList() {
        this.marginalList = new float[this.getStatesSize()];
    }

    void copyMarginal() {
        int size = this.marginalList.length;
        this.marginalCopy = new float[size];
        System.arraycopy(this.marginalList, 0, this.marginalCopy, 0, size);
    }

    void restoreMarginal() {
        int size = this.marginalList.length;
        System.arraycopy(this.marginalCopy, 0, this.marginalList, 0, size);
    }

    public float getMarginalAt(int index) {
        return this.marginalList[index];
    }

    void setMarginalAt(int index, float value) {
        this.marginalList[index] = value;
    }

    void resetEvidence() {
        this.evidence = -1;
    }

    public boolean hasEvidence() {
        return this.evidence != -1;
    }

    public int getEvidence() {
        return this.evidence;
    }

    public void addFinding(int stateNo) {
        float[] likelihood = new float[this.getStatesSize()];
        this.evidence = stateNo;
        likelihood[stateNo] = 1.0f;
        this.addLikeliHood(likelihood);
    }

    public void addLikeliHood(float[] valores) {
        int i = 0;
        while (i < this.getStatesSize()) {
            this.setMarginalAt(i, valores[i]);
            ++i;
        }
    }

    protected ITabledVariable getAssociatedClique() {
        return this.cliqueAssociado;
    }

    protected void setAssociatedClique(ITabledVariable clique) {
        this.cliqueAssociado = clique;
    }

    protected void updateEvidences() {
        if (this.evidence != -1) {
            PotentialTable auxTab = this.cliqueAssociado.getPotentialTable();
            int index = auxTab.indexOfVariable(this);
            auxTab.calcularFatores();
            this.updateRecursive(auxTab, 0, 0, index, 0);
        }
    }

    private void updateRecursive(PotentialTable tab, int c, int linear, int index, int state) {
        if (c >= tab.variaveis.size()) {
            int n = linear;
            tab.dados.data[n] = tab.dados.data[n] * this.marginalList[state];
            return;
        }
        if (index == c) {
            int i = tab.variaveis.get(c).getStatesSize() - 1;
            while (i >= 0) {
                this.updateRecursive(tab, c + 1, linear + i * tab.fatores[c], index, i);
                --i;
            }
        } else {
            int i = tab.variaveis.get(c).getStatesSize() - 1;
            while (i >= 0) {
                this.updateRecursive(tab, c + 1, linear + i * tab.fatores[c], index, state);
                --i;
            }
        }
    }
}

