/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import unbbayes.draw.DrawElement;
import unbbayes.draw.DrawText;
import unbbayes.draw.IOnePositionDrawable;
import unbbayes.prs.bn.ExplanationPhrase;
import unbbayes.prs.bn.ITabledVariable;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.util.ArrayMap;
import unbbayes.util.SerializablePoint2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements Serializable,
IOnePositionDrawable,
Comparable<Node> {
    private String description = "";
    protected String name = "";
    protected String label = "";
    private boolean nameIsLabel = true;
    private static final Point DEFAULT_SIZE = new Point(35, 35);
    protected SerializablePoint2D position;
    protected static SerializablePoint2D size = new SerializablePoint2D(DEFAULT_SIZE.getX(), DEFAULT_SIZE.getY());
    protected SerializablePoint2D sizeVariable = new SerializablePoint2D();
    protected boolean sizeIsVariable = false;
    protected ArrayList<Node> parents;
    private ArrayList<Node> children;
    protected List<String> states;
    private ArrayList<Node> adjacents;
    private boolean bSelected;
    private String explanationDescription = "";
    private ArrayMap<String, ExplanationPhrase> phrasesMap;
    private int informationType;
    public int[] infoestados;
    public static final int PROBABILISTIC_NODE_TYPE = 0;
    public static final int UTILITY_NODE_TYPE = 1;
    public static final int DECISION_NODE_TYPE = 2;
    public static final int DESCRIPTION_TYPE = 3;
    public static final int EXPLANATION_TYPE = 4;
    public static final int CONTINUOUS_NODE_TYPE = 5;
    protected DrawElement drawElement;
    protected double[] mean;
    protected double[] standardDeviation;
    protected List<NodeNameChangedListener> nodeNameChangedListenerList = new ArrayList<NodeNameChangedListener>();

    public Node() {
        this.adjacents = new ArrayList();
        this.parents = new ArrayList();
        this.children = new ArrayList();
        this.states = new ArrayList<String>();
        Node.size.x = DEFAULT_SIZE.getX();
        Node.size.y = DEFAULT_SIZE.getY();
        this.position = new SerializablePoint2D();
        this.bSelected = false;
        this.drawElement = new DrawText(this.name, this.position);
        this.drawElement.setFillColor(Color.black);
        this.phrasesMap = new ArrayMap();
        this.informationType = 3;
    }

    public static Point getDefaultSize() {
        return DEFAULT_SIZE;
    }

    public abstract int getType();

    public int getInformationType() {
        return this.informationType;
    }

    public void setInformationType(int informationType) {
        if (informationType > 2 && informationType < 5) {
            this.informationType = informationType;
        }
    }

    public void addExplanationPhrase(ExplanationPhrase explanationPhrase) {
        this.phrasesMap.put(explanationPhrase.getNode(), explanationPhrase);
    }

    public ExplanationPhrase getExplanationPhrase(String node) throws Exception {
        ExplanationPhrase ep = this.phrasesMap.get(node);
        if (ep == null) {
            throw new Exception("N\ufffd n\ufffdo encontrado.");
        }
        return ep;
    }

    public void setDescription(String texto) {
        this.description = texto;
    }

    public void setName(String name) {
        NodeNameChangedEvent event = new NodeNameChangedEvent(this.name, name);
        this.name = name;
        if (this.nameIsLabel) {
            ((DrawText)this.drawElement).setText(name);
        }
        this.nameChanged(event);
    }

    public void setLabel(String label) {
        this.label = label;
        this.nameIsLabel = false;
        ((DrawText)this.drawElement).setText(label);
    }

    public String getLabel() {
        return this.label;
    }

    public void setChildren(ArrayList<Node> children) {
        this.children = children;
    }

    public void setParents(ArrayList<Node> parents) {
        this.parents = parents;
    }

    public void addChild(Node child) throws InvalidParentException {
        this.children.add(child);
    }

    public void removeChild(Node child) {
        this.children.remove(child);
    }

    public void addParent(Node parent) throws InvalidParentException {
        this.parents.add(parent);
    }

    public void removeParent(Node parent) {
        this.parents.remove(parent);
    }

    public boolean isParentOf(Node child) {
        boolean result = false;
        int j = this.children.size();
        try {
            int i = 0;
            while (i < j) {
                result = result || child.getName() == this.children.get(i).getName();
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean isChildOf(Node parent) {
        boolean result = false;
        int j = this.parents.size();
        int i = 0;
        while (i < j) {
            result = result || parent.getName() == this.parents.get(i).getName();
            ++i;
        }
        return result;
    }

    public void setExplanationDescription(String text) {
        this.explanationDescription = text;
    }

    public ArrayMap<String, ExplanationPhrase> setPhrasesMap(ArrayMap<String, ExplanationPhrase> phrasesMap) {
        ArrayMap<String, ExplanationPhrase> old = this.phrasesMap;
        this.phrasesMap = phrasesMap;
        return old;
    }

    public String getDescription() {
        return this.description;
    }

    public ArrayList<Node> getAdjacents() {
        return this.adjacents;
    }

    public String getName() {
        return this.name;
    }

    public final ArrayList<Node> getChildren() {
        return this.children;
    }

    public final ArrayList<Node> getParents() {
        return this.parents;
    }

    public String getExplanationDescription() {
        return this.explanationDescription;
    }

    public ArrayMap<String, ExplanationPhrase> getPhrasesMap() {
        return this.phrasesMap;
    }

    public void atualizatamanhoinfoestados() {
        int i = this.states.size();
        this.infoestados = new int[i];
    }

    public void appendState(String state) {
        this.updateTables();
        this.states.add(state);
    }

    public void removeLastState() {
        if (this.states.size() > 1) {
            this.updateTables();
            this.states.remove(this.states.size() - 1);
        }
    }

    public void removeStateAt(int index) {
        this.states.remove(index);
        this.atualizatamanhoinfoestados();
    }

    public void setStateAt(String state, int index) {
        this.states.set(index, state);
    }

    public final int getStatesSize() {
        return this.states.size();
    }

    public final String getStateAt(int index) {
        return this.states.get(index);
    }

    public void makeAdjacents() {
        this.adjacents.addAll(this.parents);
        this.adjacents.addAll(this.children);
    }

    public void clearAdjacents() {
        this.adjacents.clear();
    }

    private void updateTables() {
        ITabledVariable aux;
        if (this instanceof ITabledVariable) {
            aux = (ITabledVariable)((Object)this);
            aux.getPotentialTable().variableModified();
        }
        int i = this.children.size() - 1;
        while (i >= 0) {
            if (this.children.get(i) instanceof ITabledVariable) {
                aux = (ITabledVariable)((Object)this.children.get(i));
                aux.getPotentialTable().variableModified();
            }
            --i;
        }
    }

    public void setAdjacents(ArrayList<Node> adjacents) {
        this.adjacents = adjacents;
    }

    public void setStates(List<String> states) {
        this.states = states;
    }

    public String toString() {
        return String.valueOf(this.description) + " (" + this.name + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof Node) {
            Node node = (Node)obj;
            return node.name.equals(this.name);
        }
        return false;
    }

    @Override
    public int compareTo(Node arg0) {
        return this.getName().compareTo(arg0.getName());
    }

    @Override
    public void paint(Graphics2D graphics) {
        this.drawElement.paint(graphics);
    }

    @Override
    public boolean isPointInDrawableArea(int x, int y) {
        double x1 = this.position.x;
        double y1 = this.position.y;
        double width = Node.size.x / 2.0;
        double height = Node.size.y / 2.0;
        return (double)x >= x1 - width && (double)x <= x1 + width && (double)y >= y1 - height && (double)y <= y1 + height;
    }

    @Override
    public boolean isSelected() {
        return this.bSelected;
    }

    @Override
    public void setSelected(boolean b) {
        this.bSelected = b;
    }

    @Override
    public Point2D.Double getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(double x, double y) {
        this.position.setLocation(x, y);
    }

    public static int getWidth() {
        return (int)Node.size.x;
    }

    public static int getHeight() {
        return (int)Node.size.y;
    }

    public static Point2D.Double getSize() {
        return size;
    }

    public static void setSize(double width, double height) {
        size.setLocation(width, height);
    }

    public void setSizeVariable(double width, double height) {
        this.sizeVariable.setLocation(width, height);
    }

    public void setSizeIsVariable(boolean is) {
        this.sizeIsVariable = is;
    }

    public void setMean(double[] mean) {
        this.mean = mean;
    }

    public void setStandardDeviation(double[] standardDeviation) {
        this.standardDeviation = standardDeviation;
    }

    public double[] getMean() {
        return this.mean;
    }

    public double[] getStandardDeviation() {
        return this.standardDeviation;
    }

    public void addNodeNameChangedListener(NodeNameChangedListener listener) {
        this.nodeNameChangedListenerList.add(listener);
    }

    public void removeNodeNameChangedListener(NodeNameChangedListener listener) {
        this.nodeNameChangedListenerList.remove(listener);
    }

    protected void nameChanged(NodeNameChangedEvent event) {
        for (NodeNameChangedListener listener : this.nodeNameChangedListenerList) {
            listener.nodeNameChanged(event);
        }
    }

    public class NodeNameChangedEvent {
        private String oldName;
        private String newName;

        public NodeNameChangedEvent(String oldName, String newName) {
            this.oldName = oldName;
            this.newName = newName;
        }

        public String getOldName() {
            return this.oldName;
        }

        public String getNewName() {
            return this.newName;
        }
    }

    public static interface NodeNameChangedListener {
        public void nodeNameChanged(NodeNameChangedEvent var1);
    }
}

