/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import unbbayes.draw.DrawArrow;
import unbbayes.draw.DrawLine;
import unbbayes.draw.ITwoPositionDrawable;
import unbbayes.prs.Node;
import unbbayes.util.GeometricUtil;

public class Edge
implements Serializable,
ITwoPositionDrawable {
    private static Color color = Color.black;
    private DrawLine drawLine;
    private DrawArrow drawArrow;
    private static final long serialVersionUID = -3912210617648282346L;
    private Node node1;
    private Node node2;
    private boolean bSelected;
    private boolean direction;

    public Edge(Node no1, Node no2) {
        this.node1 = no1;
        this.node2 = no2;
        this.direction = true;
        this.drawLine = new DrawLine(this.node1.getPosition(), this.node2.getPosition(), Node.getSize());
        this.drawArrow = new DrawArrow(this.node1.getPosition(), this.node2.getPosition(), Node.getSize());
        this.drawArrow.setNew(false);
        this.drawLine.add(this.drawArrow);
    }

    public void setSelected(boolean b) {
        this.drawArrow.setSelected(b);
        this.drawLine.setSelected(b);
        this.bSelected = b;
    }

    public void setDirection(boolean direction) {
        this.direction = direction;
    }

    public Node getOriginNode() {
        return this.node1;
    }

    public Node getDestinationNode() {
        return this.node2;
    }

    public boolean hasDirection() {
        return this.direction;
    }

    public void changeDirection() {
        this.node1.getChildren().remove(this.node2);
        this.node2.getParents().remove(this.node1);
        this.node1.getParents().add(this.node2);
        this.node2.getChildren().add(this.node1);
        Node aux = this.node1;
        this.node1 = this.node2;
        this.node2 = aux;
    }

    public String toString() {
        return "Edge: " + this.node1.toString() + " -> " + this.node2.toString();
    }

    public static Color getColor() {
        return color;
    }

    public static void setColor(int rgb) {
        color = new Color(rgb);
    }

    public void paint(Graphics2D graphics) {
        this.drawLine.setFillColor(Edge.getColor());
        this.drawArrow.setFillColor(Edge.getColor());
        this.drawLine.paint(graphics);
    }

    public boolean isPointInDrawableArea(int x, int y) {
        double x1 = this.node1.getPosition().getX();
        double y1 = this.node1.getPosition().getY();
        double x2 = this.node2.getPosition().getX();
        double y2 = this.node2.getPosition().getY();
        double yTeste = (y2 - y1) / (x2 - x1) * (double)x + (y1 - x1 * ((y2 - y1) / (x2 - x1)));
        double xTeste = ((double)y - (y1 - x1 * ((y2 - y1) / (x2 - x1)))) / ((y2 - y1) / (x2 - x1));
        Point2D.Double ponto1 = GeometricUtil.getCircunferenceTangentPoint(this.node1.getPosition(), this.node2.getPosition(), (Node.getWidth() + Node.getHeight()) / 4);
        Point2D.Double ponto2 = GeometricUtil.getCircunferenceTangentPoint(this.node2.getPosition(), this.node1.getPosition(), (Node.getWidth() + Node.getHeight()) / 4);
        return ponto1.getX() < ponto2.getX() ? ((double)y <= yTeste + 5.0 && (double)y >= yTeste - 5.0 || (double)x <= xTeste + 5.0 && (double)x >= xTeste - 5.0) && (ponto1.getY() < ponto2.getY() ? (double)y >= ponto1.getY() - 5.0 && (double)y <= ponto2.getY() + 5.0 && (double)x >= ponto1.getX() - 5.0 && (double)x <= ponto2.getX() + 5.0 : (double)y >= ponto2.getY() - 5.0 && (double)y <= ponto1.getY() + 5.0 && (double)x >= ponto1.getX() - 5.0 && (double)x <= ponto2.getX() + 5.0) : ((double)y <= yTeste + 5.0 && (double)y >= yTeste - 5.0 || (double)x <= xTeste + 5.0 && (double)x >= xTeste - 5.0) && (ponto1.getY() < ponto2.getY() ? (double)y >= ponto1.getY() - 5.0 && (double)y <= ponto2.getY() + 5.0 && (double)x >= ponto2.getX() - 5.0 && (double)x <= ponto1.getX() + 5.0 : (double)y >= ponto2.getY() - 5.0 && (double)y <= ponto1.getY() + 5.0 && (double)x >= ponto2.getX() - 5.0 && (double)x <= ponto1.getX() + 5.0);
    }

    public boolean isSelected() {
        return this.bSelected;
    }

    public Point2D.Double getOriginPosition() {
        return this.node1.getPosition();
    }

    public void setOriginPosition(double x, double y) {
        this.node1.setPosition(x, y);
    }

    public Point2D.Double getDestinationPosition() {
        return this.node2.getPosition();
    }

    public void setDestinationPosition(double x, double y) {
        this.node2.setPosition(x, y);
    }

    public void setNew(boolean bNew) {
        this.drawArrow.setNew(bNew);
        this.drawLine.setNew(bNew);
    }
}

