/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.metaphor.afin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ExplanationPhrase;
import unbbayes.prs.bn.ProbabilisticNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AFINMetaphorResult
extends JPanel {
    private static final long serialVersionUID = 0L;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.metaphor.afin.resources.AFINMetaphorResources");
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private GridLayout gridLayout1 = new GridLayout();
    private JPanel jPanel3 = new JPanel();
    private JPanel jPanel4 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JScrollPane jScrollPane2 = new JScrollPane();
    private JTabbedPane jTabbedPane1 = new JTabbedPane();
    private ArrayList<Node> explanationNodes;
    private JScrollPane jScrollPane3 = new JScrollPane();
    private JTextArea jTextArea3 = new JTextArea();
    private JScrollPane jScrollPane4 = new JScrollPane();
    private JTextArea jTextArea4 = new JTextArea();
    private JList jList1 = new JList();
    private JList jList2 = new JList();
    private DefaultListModel listModel1 = new DefaultListModel();
    private DefaultListModel listModel2 = new DefaultListModel();
    GridLayout gridLayout2 = new GridLayout();
    private boolean flag = true;

    public AFINMetaphorResult() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridLayout2);
        this.jPanel1.setLayout(this.gridLayout1);
        this.jPanel2.setLayout(this.borderLayout2);
        this.gridLayout1.setRows(2);
        this.jPanel3.setLayout(this.borderLayout1);
        this.jPanel4.setLayout(this.borderLayout3);
        this.jLabel1.setText(resource.getString("HighestProb"));
        this.jLabel2.setText(resource.getString("LowestProb"));
        this.jTextArea3.setBackground(new Color(255, 255, 210));
        this.jTextArea3.setEditable(false);
        this.jTextArea4.setBackground(new Color(255, 255, 210));
        this.jTextArea4.setEditable(false);
        this.jList1.setModel(this.listModel1);
        this.jList1.setSelectionMode(0);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AFINMetaphorResult.this.jList_valueChanged(e);
            }
        });
        this.jList2.setModel(this.listModel2);
        this.jList2.setSelectionMode(0);
        this.jList2.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AFINMetaphorResult.this.jList_valueChanged(e);
            }
        });
        this.gridLayout2.setColumns(2);
        this.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.jLabel1, "North");
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jList1, null);
        this.jPanel1.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.jLabel2, "North");
        this.jPanel4.add((Component)this.jScrollPane2, "Center");
        this.jScrollPane2.getViewport().add((Component)this.jList2, null);
        this.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.jTabbedPane1, "Center");
        this.jTabbedPane1.add((Component)this.jScrollPane3, resource.getString("Description"));
        this.jTabbedPane1.add((Component)this.jScrollPane4, resource.getString("Conditionant"));
        this.jScrollPane4.getViewport().add((Component)this.jTextArea4, null);
        this.jScrollPane3.getViewport().add((Component)this.jTextArea3, null);
    }

    public void setExplanationNodes(ArrayList<Node> explanationNodes) {
        this.explanationNodes = explanationNodes;
        this.jTextArea3.setText("");
    }

    public void updateResults() {
        this.jTextArea3.setText("");
        this.jTextArea4.setText("");
        this.flag = false;
        this.listModel1.clear();
        this.listModel2.clear();
        this.flag = true;
        if (this.explanationNodes != null) {
            int size = this.explanationNodes.size();
            int i = 0;
            while (i < size) {
                ProbabilisticNode node = (ProbabilisticNode)this.explanationNodes.get(i);
                int statesSize = node.getStatesSize();
                if (statesSize > 1) {
                    this.listModel1.addElement(new ListObject(node.getDescription(), node.getExplanationDescription()));
                    this.listModel2.addElement(new ListObject(node.getDescription(), node.getExplanationDescription()));
                    int j = 0;
                    while (j < statesSize) {
                        double marginal = node.getMarginalAt(j);
                        String tmp = String.format("        %s        %.2f%%", node.getStateAt(j), marginal * 100.0);
                        if (marginal >= 0.5) {
                            this.listModel1.addElement(new ListObject(tmp, node, true));
                        } else {
                            this.listModel2.addElement(new ListObject(tmp, node, false));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    void jList_valueChanged(ListSelectionEvent e) {
        if (this.flag) {
            JList source = (JList)e.getSource();
            ListObject list = (ListObject)source.getSelectedValue();
            if (list == null) {
                return;
            }
            this.jTabbedPane1.setTitleAt(1, resource.getString("Conditionant"));
            if (list.getDiagnostic() != null) {
                this.jTabbedPane1.setSelectedIndex(1);
                this.jTextArea3.setText(list.description);
                this.jTextArea4.setText(list.getDiagnostic());
            } else {
                this.jTabbedPane1.setSelectedIndex(0);
                this.jTextArea3.setText(list.description);
                this.jTextArea4.setText("");
            }
        }
    }

    private class ListObject {
        private String description;
        private String name;
        private String diagnostic;
        public static final boolean FINDINGS = true;
        public static final boolean WHY_NOT = false;

        public ListObject(String name, String description) {
            this.name = name;
            this.description = description;
            this.diagnostic = null;
        }

        public ListObject(String name, ProbabilisticNode node, boolean flag) {
            this.name = name;
            this.description = node.getExplanationDescription();
            ArrayList<String> keys = node.getPhrasesMap().getKeys();
            int size = keys.size();
            ExplanationPhrase[] phrases = new ExplanationPhrase[size];
            int i = 0;
            while (i < size) {
                phrases[i] = node.getPhrasesMap().get(keys.get(i));
                ++i;
            }
            if (flag) {
                this.calculatePositives(phrases);
            } else {
                this.calculateNegatives(phrases);
            }
        }

        private void calculatePositives(ExplanationPhrase[] phrases) {
            int size = phrases.length;
            ArrayList<ExplanationPhrase> trigger = new ArrayList<ExplanationPhrase>();
            ArrayList<ExplanationPhrase> complementary = new ArrayList<ExplanationPhrase>();
            ArrayList<ExplanationPhrase> necessary = new ArrayList<ExplanationPhrase>();
            int i = 0;
            while (i < size) {
                ExplanationPhrase explanationPhrase = phrases[i];
                switch (explanationPhrase.getEvidenceType()) {
                    case 0: {
                        trigger.add(explanationPhrase);
                        break;
                    }
                    case 1: {
                        necessary.add(explanationPhrase);
                        break;
                    }
                    case 2: {
                        complementary.add(explanationPhrase);
                    }
                }
                ++i;
            }
            StringBuffer sb = new StringBuffer();
            this.addPhrases(sb, trigger);
            this.addPhrases(sb, necessary);
            this.addPhrases(sb, complementary);
            this.diagnostic = sb.toString();
        }

        private void addPhrases(StringBuffer sb, ArrayList evidence) {
            int size = evidence.size();
            if (size > 0) {
                int i = 0;
                while (i < size) {
                    ExplanationPhrase explanationPhrase = (ExplanationPhrase)evidence.get(i);
                    sb.append(String.valueOf(explanationPhrase.getNode()) + "\n");
                    sb.append(String.valueOf(explanationPhrase.getPhrase()) + "\n\n");
                    ++i;
                }
            }
        }

        private void calculateNegatives(ExplanationPhrase[] phrases) {
            int size = phrases.length;
            ArrayList<ExplanationPhrase> exclusive = new ArrayList<ExplanationPhrase>();
            int i = 0;
            while (i < size) {
                ExplanationPhrase explanationPhrase = phrases[i];
                if (explanationPhrase.getEvidenceType() == 3) {
                    exclusive.add(explanationPhrase);
                }
                ++i;
            }
            StringBuffer sb = new StringBuffer();
            this.addPhrases(sb, exclusive);
            this.diagnostic = sb.toString();
        }

        public String toString() {
            return this.name;
        }

        public String getDiagnostic() {
            return this.diagnostic;
        }

        public void setDiagnostic(String diagnostic) {
            this.diagnostic = diagnostic;
        }
    }
}

