/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.metaphor.afin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import unbbayes.controller.FileController;
import unbbayes.controller.IconController;
import unbbayes.gui.FileIcon;
import unbbayes.gui.SimpleFileFilter;
import unbbayes.io.NetIO;
import unbbayes.io.XMLBIFIO;
import unbbayes.metaphor.afin.AFINMetaphorResult;
import unbbayes.metaphor.afin.AFINMetaphorTree;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AFINMetaphorMainPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.metaphor.afin.resources.AFINMetaphorResources");
    private BorderLayout borderLayout1 = new BorderLayout();
    private JToolBar metaphorToolBar = new JToolBar();
    private JTabbedPane jTabbedPane1 = new JTabbedPane();
    private JPanel statusPanel = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JLabel statusBar = new JLabel();
    private JButton diagnosticButton = new JButton();
    private JButton openButton = new JButton();
    private JPanel findingEntryPanel = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private AFINMetaphorTree aFINMetaphorTree = new AFINMetaphorTree();
    private BorderLayout borderLayout7 = new BorderLayout();
    private ImageIcon openMetaphorIcon;
    private ImageIcon saveMetaphorIcon;
    private ImageIcon diagnosticMetaphorIcon;
    private ImageIcon openMetaphorRollOverIcon;
    private ImageIcon saveMetaphorRollOverIcon;
    private ImageIcon diagnosticMetaphorRollOverIcon;
    private ProbabilisticNetwork net = null;
    private JFileChooser fileChooser;
    private TitledBorder titledBorder1;
    private Border border1;
    private Border border2;
    private Border border3;
    private JTextArea descriptionTextArea = new JTextArea();
    private BorderLayout borderLayout9 = new BorderLayout();
    private BorderLayout borderLayout12 = new BorderLayout();
    private BorderLayout borderLayout11 = new BorderLayout();
    private JPanel jPanel9 = new JPanel();
    private JLabel descriptionLabel = new JLabel();
    private JPanel jPanel11 = new JPanel();
    private JPanel jPanel10 = new JPanel();
    private BorderLayout borderLayout14 = new BorderLayout();
    private BorderLayout borderLayout13 = new BorderLayout();
    private BorderLayout borderLayout10 = new BorderLayout();
    private JLabel jLabel4 = new JLabel();
    private JPanel jPanel13 = new JPanel();
    private JPanel jPanel8 = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private AFINMetaphorResult aFINMetaphorResult = new AFINMetaphorResult();

    public AFINMetaphorMainPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        IconController iconController = IconController.getInstance();
        this.openMetaphorIcon = iconController.getOpenIcon();
        this.saveMetaphorIcon = iconController.getLoadFindingsInstance();
        this.diagnosticMetaphorIcon = iconController.getCompileIcon();
        this.titledBorder1 = new TitledBorder("");
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border2 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border3 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setLayout(this.borderLayout1);
        this.statusPanel.setLayout(this.borderLayout2);
        this.statusPanel.setBorder(new TitledBorder(resource.getString("Status")));
        this.statusBar.setToolTipText("");
        this.statusBar.setText(resource.getString("StatusInitialized"));
        this.metaphorToolBar.setFloatable(false);
        this.jTabbedPane1.setOpaque(true);
        this.findingEntryPanel.setLayout(this.gridBagLayout1);
        this.jPanel3.setLayout(this.borderLayout7);
        this.openButton.setBorder(this.border1);
        this.openButton.setIcon(this.openMetaphorIcon);
        this.openButton.setRolloverIcon(this.openMetaphorRollOverIcon);
        this.openButton.setPressedIcon(this.openMetaphorRollOverIcon);
        this.openButton.setToolTipText(resource.getString("OpenButton"));
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AFINMetaphorMainPanel.this.openButton_actionPerformed(e);
            }
        });
        this.diagnosticButton.setBorder(this.border3);
        this.diagnosticButton.setIcon(this.diagnosticMetaphorIcon);
        this.diagnosticButton.setToolTipText(resource.getString("Propagate"));
        this.diagnosticButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AFINMetaphorMainPanel.this.diagnosticButton_actionPerformed(e);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
        this.descriptionTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
        this.descriptionTextArea.setEditable(false);
        this.jPanel9.setLayout(this.borderLayout9);
        this.descriptionLabel.setHorizontalAlignment(0);
        this.descriptionLabel.setText(resource.getString("Description"));
        this.jPanel11.setLayout(this.borderLayout11);
        this.jPanel10.setLayout(this.borderLayout12);
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText(resource.getString("Help"));
        this.jPanel13.setLayout(this.borderLayout13);
        this.jPanel8.setLayout(this.borderLayout10);
        this.add((Component)this.metaphorToolBar, "North");
        this.metaphorToolBar.add((Component)this.openButton, null);
        this.metaphorToolBar.add((Component)this.diagnosticButton, null);
        this.add((Component)this.jTabbedPane1, "Center");
        this.add((Component)this.statusPanel, "South");
        this.statusPanel.add((Component)this.statusBar, "North");
        this.jTabbedPane1.add((Component)this.findingEntryPanel, resource.getString("FindingEntry"));
        this.jTabbedPane1.add((Component)this.aFINMetaphorResult, resource.getString("Report"));
        this.findingEntryPanel.add((Component)this.jPanel3, new GridBagConstraints(0, 0, 3, 4, 5.0, 30.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.findingEntryPanel.add((Component)this.jPanel9, new GridBagConstraints(3, 0, 1, 1, 15.0, 30.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel9.add((Component)this.jPanel10, "Center");
        this.jPanel10.add((Component)this.descriptionTextArea, "Center");
        this.jPanel9.add((Component)this.jPanel11, "North");
        this.jPanel11.add((Component)this.descriptionLabel, "Center");
        this.aFINMetaphorResult.setExplanationNodes(null);
        this.findingEntryPanel.setBackground(Color.WHITE);
        this.jPanel3.setBackground(Color.WHITE);
        this.jPanel9.setBackground(Color.WHITE);
        this.jPanel13.setBackground(Color.WHITE);
    }

    void diagnosticButton_actionPerformed(ActionEvent e) {
        this.jTabbedPane1.setSelectedComponent(this.aFINMetaphorResult);
        this.aFINMetaphorTree.propagate();
        this.aFINMetaphorResult.updateResults();
    }

    void openButton_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        String[] s1 = new String[]{"net", "xml"};
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s1, resource.getString("FileTypes")));
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            this.openFile(selectedFile);
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
        }
        this.setCursor(new Cursor(0));
    }

    private ArrayList<Node> getNodesWithoutMetaphorHierarch(ProbabilisticNetwork net, AFINMetaphorTree metTree) {
        ArrayList<Node> ret = new ArrayList<Node>();
        ArrayList<Node> allNodes = net.getExplanationNodes();
        for (Node node : allNodes) {
            if (metTree.hasNode(node)) continue;
            ret.add(node);
        }
        return ret;
    }

    private void openFile(File selectedFile) {
        try {
            String name = selectedFile.getName().toLowerCase();
            if (name.endsWith("net")) {
                this.net = new NetIO().load(selectedFile);
            } else if (name.endsWith("xml")) {
                this.net = new XMLBIFIO().load(selectedFile);
            }
            this.net.compile();
            this.aFINMetaphorTree = new AFINMetaphorTree();
            this.aFINMetaphorTree.setProbabilisticNetwork(this.net);
            this.aFINMetaphorTree.expandTree();
            JScrollPane jScrollPane3 = new JScrollPane(this.aFINMetaphorTree);
            this.jPanel3.removeAll();
            this.jPanel3.add((Component)jScrollPane3, "Center");
            this.jPanel3.updateUI();
            this.jTabbedPane1.setSelectedComponent(this.findingEntryPanel);
            this.aFINMetaphorResult.setExplanationNodes(this.getNodesWithoutMetaphorHierarch(this.net, this.aFINMetaphorTree));
            this.statusBar.setText(resource.getString("FileOpened"));
            this.aFINMetaphorTree.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                    try {
                        AFINMetaphorMainPanel.this.descriptionTextArea.setText(AFINMetaphorMainPanel.this.aFINMetaphorTree.getLastSelectedPathComponent().getExplanationDescription());
                    }
                    catch (Exception ex) {
                        AFINMetaphorMainPanel.this.descriptionTextArea.setText(ex.getMessage());
                    }
                }
            });
        }
        catch (Exception e) {
            this.net = null;
            System.err.print(e.getMessage());
            this.statusBar.setText(e.getMessage());
        }
    }
}

