/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io.mebn;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.net.URI;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import unbbayes.gui.ProgressBarPanel;
import unbbayes.gui.UnBBayesFrame;
import unbbayes.io.mebn.MebnIO;
import unbbayes.io.mebn.PrOwlIO;
import unbbayes.io.mebn.exceptions.IOMebnException;
import unbbayes.prs.Node;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.entity.ObjectEntity;
import unbbayes.prs.mebn.entity.ObjectEntityInstance;
import unbbayes.prs.mebn.entity.ObjectEntityInstanceOrdereable;
import unbbayes.prs.mebn.entity.exception.ObjectEntityHasInstancesException;
import unbbayes.prs.mebn.entity.exception.TypeException;
import unbbayes.util.Debug;

public class UbfIO
implements MebnIO {
    private static final String prowlExtension = "owl";
    private ResourceBundle resource = ResourceBundle.getBundle("unbbayes.io.mebn.resources.IoUbfResources");
    private PrOwlIO prowlIO = null;
    private String[][] tokens = new String[][]{{"CommentInitiator", "%"}, {"ArgumentSeparator", ","}, {"AttributionSeparator", "="}, {"Quote", "\""}, {"VersionDeclarator", "Version"}, {"PrOwlFileDeclarator", "PrOwl"}, {"MTheoryDeclarator", "MTheory"}, {"NextMFragDeclarator", "NextMFrag"}, {"NextResidentDeclarator", "NextResident"}, {"NextInputDeclarator", "NextInput"}, {"NextContextDeclarator", "NextContext"}, {"NextEntityDeclarator", "NextEntity"}, {"MFragDeclarator", "MFrag"}, {"NextOrdinalVarDeclarator", "NextOrdinaryVar"}, {"NodeDeclarator", "Node"}, {"TypeDeclarator", "Type"}, {"PositionDeclarator", "Position"}, {"SizeDeclarator", "Size"}, {"NextArgumentDeclarator", "NextArgument"}, {"DomainResidentType", "DomainResidentNode"}, {"GenerativeInputType", "GenerativeInputNode"}, {"ContextType", "ContextNode"}, {"OrdinalVarType", "OrdinalVar"}, {"ObjectEntityDeclarator", "ObjEntity"}, {"EntityInstancesDeclarator", "Instances"}};
    public static final double ubfVersion = 0.03;
    public static final String fileExtension = "ubf";
    JDialog dialog;

    private UbfIO() {
        this.prowlIO = new PrOwlIO();
    }

    public static UbfIO getInstance() {
        return new UbfIO();
    }

    private MFrag searchMFrag(String name, MultiEntityBayesianNetwork mebn) {
        for (MFrag element : mebn.getDomainMFragList()) {
            if (!name.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    private Node searchNode(String name, MFrag mfrag) {
        for (Node node : mfrag.getResidentNodeList()) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        for (Node node : mfrag.getInputNodeList()) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        for (Node node : mfrag.getContextNodeList()) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        for (Node node : mfrag.getOrdinaryVariableList()) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    private double readVersion(StreamTokenizer st) throws IOException {
        while (st.nextToken() != -1) {
            if (st.ttype != -3 || !this.getToken("VersionDeclarator").equals(st.sval)) continue;
            if (st.nextToken() != -2) break;
            return st.nval;
        }
        throw new IOException(this.resource.getString("InvalidSyntax"));
    }

    private String readOwlFile(StreamTokenizer st) throws IOException {
        while (st.nextToken() != -1) {
            if (st.ttype != -3 || !this.getToken("PrOwlFileDeclarator").equals(st.sval)) continue;
            if (st.nextToken() == 10) break;
            return st.sval;
        }
        throw new IOException(this.resource.getString("InvalidSyntax"));
    }

    private void updateMTheory(StreamTokenizer st, MultiEntityBayesianNetwork mebn) throws IOException {
        block0: while (st.nextToken() != -1) {
            if (st.ttype != -3) continue;
            if (this.getToken("MFragDeclarator").equals(st.sval)) {
                st.pushBack();
                break;
            }
            if (this.getToken("ObjectEntityDeclarator").equals(st.sval)) {
                st.pushBack();
                break;
            }
            if (st.ttype != -3) continue;
            if (this.getToken("MTheoryDeclarator").equals(st.sval)) {
                while (st.nextToken() != 10) {
                }
            }
            if (st.ttype != -3) continue;
            if (this.getToken("NextMFragDeclarator").equals(st.sval)) {
                while (st.nextToken() != 10) {
                    if (st.ttype != -2) continue;
                    mebn.setDomainMFragNum((int)st.nval);
                    break;
                }
            }
            if (st.ttype != -3) continue;
            if (this.getToken("NextResidentDeclarator").equals(st.sval)) {
                while (st.nextToken() != 10) {
                    if (st.ttype != -2) continue;
                    mebn.setDomainResidentNodeNum((int)st.nval);
                    break;
                }
            }
            if (st.ttype != -3) continue;
            if (this.getToken("NextInputDeclarator").equals(st.sval)) {
                while (st.nextToken() != 10) {
                    if (st.ttype != -2) continue;
                    mebn.setGenerativeInputNodeNum((int)st.nval);
                    break;
                }
            }
            if (st.ttype != -3) continue;
            if (this.getToken("NextContextDeclarator").equals(st.sval)) {
                while (st.nextToken() != 10) {
                    if (st.ttype != -2) continue;
                    mebn.setContextNodeNum((int)st.nval);
                    break;
                }
            }
            if (st.ttype != -3 || !this.getToken("NextEntityDeclarator").equals(st.sval)) continue;
            while (st.nextToken() != 10) {
                if (st.ttype != -2) continue;
                mebn.setEntityNum((int)st.nval);
                continue block0;
            }
        }
    }

    private void updateMFrag(StreamTokenizer st, MultiEntityBayesianNetwork mebn) throws IOException, ClassCastException {
        MFrag mfrag = null;
        while (st.nextToken() != -1) {
            if (st.ttype != -3) continue;
            if (this.getToken("ObjectEntityDeclarator").equals(st.sval)) {
                st.pushBack();
                break;
            }
            if (this.getToken("MFragDeclarator").equals(st.sval)) {
                while (st.nextToken() != 10) {
                    if (st.ttype != -3) continue;
                    mfrag = this.searchMFrag(st.sval, mebn);
                    break;
                }
            }
            if (mfrag == null || st.ttype != -3) continue;
            if (this.getToken("NextOrdinalVarDeclarator").equals(st.sval)) {
                while (st.nextToken() != 10) {
                    if (st.ttype != -2) continue;
                    mfrag.setOrdinaryVariableNum((int)st.nval);
                    break;
                }
            }
            if (st.ttype != -3 || !this.getToken("NodeDeclarator").equals(st.sval)) continue;
            st.pushBack();
            try {
                this.updateNode(st, mfrag);
            }
            catch (ClassCastException e) {
                throw new ClassCastException(this.resource.getString("MFragTypeException"));
            }
        }
    }

    private void updateObjectEntities(StreamTokenizer st, MultiEntityBayesianNetwork mebn) throws IOException, ClassCastException {
        ObjectEntity objectEntity = null;
        ArrayList<String> owlDeclaredInstanceNames = null;
        while (st.nextToken() != -1) {
            if (st.ttype != -3) continue;
            if (this.getToken("ObjectEntityDeclarator").equals(st.sval)) {
                while (st.nextToken() != 10) {
                    if (st.ttype != -3) continue;
                    objectEntity = mebn.getObjectEntityContainer().getObjectEntityByName(st.sval);
                    owlDeclaredInstanceNames = new ArrayList<String>();
                    break;
                }
            }
            if (objectEntity == null) continue;
            for (ObjectEntityInstance entityInstance : objectEntity.getInstanceList()) {
                owlDeclaredInstanceNames.add(entityInstance.getName());
            }
            mebn.getObjectEntityContainer().clearAllInstances(objectEntity);
            try {
                objectEntity.setOrdereable(true);
            }
            catch (ObjectEntityHasInstancesException e) {
                e.printStackTrace();
            }
            if (st.ttype != -3 || !this.getToken("EntityInstancesDeclarator").equals(st.sval)) continue;
            ObjectEntityInstanceOrdereable prev = null;
            while (st.nextToken() != 10) {
                String name;
                if (st.ttype != -3 || !owlDeclaredInstanceNames.contains(name = st.sval)) continue;
                try {
                    ObjectEntityInstanceOrdereable oe = (ObjectEntityInstanceOrdereable)objectEntity.addInstance(name);
                    mebn.getObjectEntityContainer().addEntityInstance(oe);
                    oe.setPrev(prev);
                    if (prev != null) {
                        prev.setProc(oe);
                    }
                    prev = oe;
                }
                catch (TypeException e) {
                    e.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void updateNode(StreamTokenizer st, MFrag mfrag) throws IOException {
        Node node = null;
        block0: while (st.nextToken() != -1) {
            if (st.ttype != -3) continue;
            if (this.getToken("MFragDeclarator").equals(st.sval)) {
                st.pushBack();
                break;
            }
            if (this.getToken("ObjectEntityDeclarator").equals(st.sval)) {
                st.pushBack();
                break;
            }
            if (st.ttype != -3) continue;
            if (this.getToken("NodeDeclarator").equals(st.sval)) {
                while (st.nextToken() != 10) {
                    if (st.ttype != -3) continue;
                    node = this.searchNode(st.sval, mfrag);
                    break;
                }
            }
            if (node == null || st.ttype != -3) continue;
            if (this.getToken("PositionDeclarator").equals(st.sval)) {
                int posx = 15;
                block2: while (st.nextToken() != 10) {
                    if (st.ttype != -2) continue;
                    posx = (int)st.nval;
                    while (st.nextToken() != 10) {
                        if (st.ttype != -2) continue;
                        node.setPosition(posx, (int)st.nval);
                        break block2;
                    }
                    break block2;
                }
            }
            if (st.ttype != -3 || !this.getToken("SizeDeclarator").equals(st.sval)) continue;
            double width = 100.0;
            while (st.nextToken() != 10) {
                if (st.ttype != -2) continue;
                width = st.nval;
                while (st.nextToken() != 10) {
                    if (st.ttype != -2) continue;
                    Node.setSize(width, st.nval);
                    continue block0;
                }
                continue block0;
            }
        }
    }

    protected String getToken(String s) throws IllegalArgumentException {
        int i = 0;
        while (i < this.tokens.length) {
            if (this.tokens[i][0].equals(s)) {
                return this.tokens[i][1];
            }
            ++i;
        }
        throw new IllegalArgumentException(this.resource.getString("InvalidSyntax"));
    }

    protected void setToken(String s, String newValue) throws IllegalArgumentException {
        int i = 0;
        while (i < this.tokens.length) {
            if (this.tokens[i][0].equals(s)) {
                this.tokens[i][1] = newValue;
            }
            ++i;
        }
        throw new IllegalArgumentException(this.resource.getString("InvalidSyntax"));
    }

    public void createAndShowProgressBar(ProgressBarPanel progressPanel) {
        this.dialog = new JDialog();
        this.dialog.setTitle("Progress");
        this.dialog.setContentPane(progressPanel);
        this.dialog.pack();
        this.dialog.repaint();
        this.dialog.setLocationRelativeTo(UnBBayesFrame.getIUnBBayes());
        this.dialog.setModal(false);
        this.dialog.setVisible(true);
        this.dialog.validate();
        this.dialog.pack();
    }

    public void disableProgressBar() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    public MultiEntityBayesianNetwork loadMebn(File file) throws IOException, IOMebnException {
        MultiEntityBayesianNetwork mebn = null;
        String owlFilePath = String.valueOf(file.getPath().substring(0, file.getPath().lastIndexOf(fileExtension))) + prowlExtension;
        File prowlFile = null;
        StreamTokenizer st = new StreamTokenizer(new BufferedReader(new FileReader(file)));
        st.wordChars(65, 122);
        st.wordChars(46, 46);
        st.whitespaceChars(this.getToken("ArgumentSeparator").charAt(0), this.getToken("ArgumentSeparator").charAt(0));
        st.whitespaceChars(this.getToken("AttributionSeparator").charAt(0), this.getToken("AttributionSeparator").charAt(0));
        st.whitespaceChars(32, 32);
        st.whitespaceChars(9, 9);
        st.quoteChar(34);
        st.quoteChar(39);
        st.eolIsSignificant(true);
        st.commentChar(this.getToken("CommentInitiator").charAt(0));
        double version = this.readVersion(st);
        if (0.03 < version) {
            throw new IOMebnException(this.resource.getString("IncompatibleVersion"));
        }
        owlFilePath = this.readOwlFile(st);
        owlFilePath = file.getParentFile().getCanonicalPath().concat("/" + owlFilePath);
        Debug.println("Opening .owl file: " + owlFilePath);
        try {
            prowlFile = new File(owlFilePath);
            if (!prowlFile.exists()) {
                throw new IOException(this.resource.getString("NoProwlFound"));
            }
            mebn = this.prowlIO.loadMebn(prowlFile);
        }
        catch (Exception e) {
            throw new IOException(String.valueOf(e.getLocalizedMessage()) + " : " + this.resource.getString("InvalidProwlScheme"));
        }
        try {
            this.updateMTheory(st, mebn);
        }
        catch (Exception e) {
            System.err.println(String.valueOf(e.getLocalizedMessage()) + " : " + this.resource.getString("MTheoryConfigError"));
        }
        try {
            this.updateMFrag(st, mebn);
        }
        catch (Exception e) {
            System.err.println(String.valueOf(e.getLocalizedMessage()) + " : " + this.resource.getString("MFragConfigError"));
        }
        this.updateObjectEntities(st, mebn);
        this.disableProgressBar();
        return mebn;
    }

    /*
     * WARNING - void declaration
     */
    public void saveMebn(File file, MultiEntityBayesianNetwork mebn) throws IOException, IOMebnException {
        Object varType = null;
        String noExtensionFileName = file.getPath().substring(0, file.getPath().lastIndexOf(fileExtension));
        File prowlFile = new File(String.valueOf(noExtensionFileName) + prowlExtension);
        PrintStream out = new PrintStream(new FileOutputStream(file));
        try {
            this.prowlIO.saveMebn(prowlFile, mebn);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(String.valueOf(e.getLocalizedMessage()) + " : " + this.resource.getString("UnknownPrOWLError"));
        }
        URI relativeURI = file.getCanonicalFile().getParentFile().toURI();
        relativeURI = relativeURI.relativize(prowlFile.toURI());
        out.println(String.valueOf(this.getToken("CommentInitiator")) + this.resource.getString("UBFFileHeader"));
        out.println(String.valueOf(this.getToken("VersionDeclarator")) + this.getToken("AttributionSeparator") + 0.03);
        out.println(String.valueOf(this.getToken("PrOwlFileDeclarator")) + this.getToken("AttributionSeparator") + this.getToken("Quote") + relativeURI.getPath() + this.getToken("Quote"));
        out.println();
        out.println(String.valueOf(this.getToken("CommentInitiator")) + this.resource.getString("UBFMTheory"));
        out.println(String.valueOf(this.getToken("MTheoryDeclarator")) + this.getToken("AttributionSeparator") + mebn.getName());
        out.println(String.valueOf(this.getToken("NextMFragDeclarator")) + this.getToken("AttributionSeparator") + mebn.getDomainMFragNum());
        out.println(String.valueOf(this.getToken("NextResidentDeclarator")) + this.getToken("AttributionSeparator") + mebn.getDomainResidentNodeNum());
        out.println(String.valueOf(this.getToken("NextInputDeclarator")) + this.getToken("AttributionSeparator") + mebn.getGenerativeInputNodeNum());
        out.println(String.valueOf(this.getToken("NextContextDeclarator")) + this.getToken("AttributionSeparator") + mebn.getContextNodeNum());
        out.println(String.valueOf(this.getToken("NextEntityDeclarator")) + this.getToken("AttributionSeparator") + mebn.getEntityNum());
        out.println();
        out.println(String.valueOf(this.getToken("CommentInitiator")) + this.resource.getString("UBFMFragsNodes"));
        for (MFrag mfrag : mebn.getDomainMFragList()) {
            out.println();
            out.println(String.valueOf(this.getToken("CommentInitiator")) + this.resource.getString("UBFMFrags"));
            out.println(String.valueOf(this.getToken("MFragDeclarator")) + this.getToken("AttributionSeparator") + mfrag.getName());
            out.println(String.valueOf(this.getToken("NextOrdinalVarDeclarator")) + this.getToken("AttributionSeparator") + mfrag.getOrdinaryVariableNum());
            if (mfrag.getResidentNodeList() != null && !mfrag.getResidentNodeList().isEmpty()) {
                out.println();
                out.println(String.valueOf(this.getToken("CommentInitiator")) + this.resource.getString("UBFResidentNodes"));
                out.println();
                for (ResidentNode residentNode : mfrag.getResidentNodeList()) {
                    out.println();
                    out.println(String.valueOf(this.getToken("NodeDeclarator")) + this.getToken("AttributionSeparator") + residentNode.getName());
                    out.println(String.valueOf(this.getToken("TypeDeclarator")) + this.getToken("AttributionSeparator") + this.getToken("DomainResidentType"));
                    out.println(String.valueOf(this.getToken("PositionDeclarator")) + this.getToken("AttributionSeparator") + residentNode.getPosition().getX() + this.getToken("ArgumentSeparator") + residentNode.getPosition().getY());
                    out.println(String.valueOf(this.getToken("SizeDeclarator")) + this.getToken("AttributionSeparator") + ResidentNode.getWidth() + this.getToken("ArgumentSeparator") + ResidentNode.getHeight());
                }
            }
            if (mfrag.getInputNodeList() != null && !mfrag.getInputNodeList().isEmpty()) {
                out.println();
                out.println(String.valueOf(this.getToken("CommentInitiator")) + this.resource.getString("UBFInputNodes"));
                out.println();
                for (InputNode inputNode : mfrag.getInputNodeList()) {
                    out.println();
                    out.println(String.valueOf(this.getToken("NodeDeclarator")) + this.getToken("AttributionSeparator") + inputNode.getName());
                    out.println(String.valueOf(this.getToken("TypeDeclarator")) + this.getToken("AttributionSeparator") + this.getToken("GenerativeInputType"));
                    out.println(String.valueOf(this.getToken("PositionDeclarator")) + this.getToken("AttributionSeparator") + inputNode.getPosition().getX() + this.getToken("ArgumentSeparator") + inputNode.getPosition().getY());
                    out.println(String.valueOf(this.getToken("SizeDeclarator")) + this.getToken("AttributionSeparator") + InputNode.getWidth() + this.getToken("ArgumentSeparator") + InputNode.getHeight());
                }
            }
            if (mfrag.getContextNodeList() != null && !mfrag.getContextNodeList().isEmpty()) {
                out.println();
                out.println(String.valueOf(this.getToken("CommentInitiator")) + this.resource.getString("UBFContextNodes"));
                out.println();
                for (ContextNode contextNode : mfrag.getContextNodeList()) {
                    out.println();
                    out.println(String.valueOf(this.getToken("NodeDeclarator")) + this.getToken("AttributionSeparator") + contextNode.getName());
                    out.println(String.valueOf(this.getToken("TypeDeclarator")) + this.getToken("AttributionSeparator") + this.getToken("ContextType"));
                    out.println(String.valueOf(this.getToken("PositionDeclarator")) + this.getToken("AttributionSeparator") + contextNode.getPosition().getX() + this.getToken("ArgumentSeparator") + contextNode.getPosition().getY());
                    out.println(String.valueOf(this.getToken("SizeDeclarator")) + this.getToken("AttributionSeparator") + ContextNode.getWidth() + this.getToken("ArgumentSeparator") + ContextNode.getHeight());
                }
            }
            if (mfrag.getOrdinaryVariableList() == null || mfrag.getOrdinaryVariableList().isEmpty()) continue;
            out.println();
            out.println(String.valueOf(this.getToken("CommentInitiator")) + this.resource.getString("UBFOrdinalVars"));
            out.println();
            for (OrdinaryVariable ordinaryVariable : mfrag.getOrdinaryVariableList()) {
                out.println();
                out.println(String.valueOf(this.getToken("NodeDeclarator")) + this.getToken("AttributionSeparator") + ordinaryVariable.getName());
                out.println(String.valueOf(this.getToken("TypeDeclarator")) + this.getToken("AttributionSeparator") + this.getToken("OrdinalVarType"));
                out.println(String.valueOf(this.getToken("PositionDeclarator")) + this.getToken("AttributionSeparator") + ordinaryVariable.getPosition().getX() + this.getToken("ArgumentSeparator") + ordinaryVariable.getPosition().getY());
                out.println(String.valueOf(this.getToken("SizeDeclarator")) + this.getToken("AttributionSeparator") + OrdinaryVariable.getWidth() + this.getToken("ArgumentSeparator") + OrdinaryVariable.getHeight());
            }
        }
        out.println();
        out.println(String.valueOf(this.getToken("CommentInitiator")) + this.resource.getString("UBFObjectEntityInstances"));
        for (ObjectEntity objectEntity : mebn.getObjectEntityContainer().getListEntity()) {
            void var11_24;
            void var11_21;
            if (!objectEntity.isOrdereable()) continue;
            out.println();
            out.println(String.valueOf(this.getToken("ObjectEntityDeclarator")) + this.getToken("AttributionSeparator") + objectEntity.getName());
            out.print(String.valueOf(this.getToken("EntityInstancesDeclarator")) + this.getToken("AttributionSeparator"));
            ArrayList<ObjectEntityInstanceOrdereable> list = new ArrayList<ObjectEntityInstanceOrdereable>();
            for (ObjectEntityInstance objectEntityInstance : objectEntity.getInstanceList()) {
                list.add((ObjectEntityInstanceOrdereable)objectEntityInstance);
            }
            String string = "";
            for (ObjectEntityInstance objectEntityInstance : ObjectEntityInstanceOrdereable.ordererList(list)) {
                String string2 = String.valueOf(var11_21) + objectEntityInstance.getName() + this.getToken("ArgumentSeparator");
            }
            if (list.size() > 0) {
                String string3 = var11_21.substring(0, var11_21.length() - this.getToken("ArgumentSeparator").length());
            }
            out.println((String)var11_24);
        }
    }

    public ResourceBundle getResource() {
        return this.resource;
    }

    public void setResource(ResourceBundle resource) {
        this.resource = resource;
    }

    public String getFileExtension() {
        return fileExtension;
    }
}

