/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io.mebn;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import unbbayes.io.mebn.LoaderPrOwlIO;
import unbbayes.io.mebn.MEBNStorageImplementorDecorator;
import unbbayes.io.mebn.MebnIO;
import unbbayes.io.mebn.PROWLModelUser;
import unbbayes.io.mebn.SaverPrOwlIO;
import unbbayes.io.mebn.exceptions.IOMebnException;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrOwlIO
extends PROWLModelUser
implements MebnIO {
    public static final String PROWLMODELURI = "http://www.pr-owl.org/pr-owl.owl";
    public static final String FILEEXTENSION = "owl";
    private OWLModel lastOwlModel = null;
    private LoaderPrOwlIO loader = new LoaderPrOwlIO();

    private void clearAllPROWLOntologyIndividuals(JenaOWLModel model) {
        Collection individuals = null;
        Collection<String> untouchableIndividuals = this.getNamesOfAllModifiedLabels();
        for (String classNames : this.getNamesOfAllModifiedPROWLClasses()) {
            try {
                individuals = model.getOWLNamedClass(classNames).getInstances(false);
                for (OWLIndividual individual : individuals) {
                    try {
                        if (untouchableIndividuals.contains(individual.getName())) continue;
                        Debug.println(this.getClass(), "Removing all prowl individuals: " + individual.getName());
                        model.deleteInstance((Instance)individual);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    private void clearAllObjectEntity(JenaOWLModel model) {
        OWLNamedClass objectEntity;
        Collection subclasses = null;
        try {
            objectEntity = model.getOWLNamedClass("ObjectEntity");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Collection individuals = objectEntity.getInstances(true);
        for (OWLIndividual individual : individuals) {
            try {
                Debug.println(this.getClass(), "Clearing object entity individual: " + individual.getName());
                model.deleteInstance((Instance)individual);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            subclasses = objectEntity.getSubclasses(true);
            for (OWLNamedClass namedClass : subclasses) {
                try {
                    Debug.println(this.getClass(), "Clearing object entity: " + namedClass.getName());
                    model.deleteCls((Cls)namedClass);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public MultiEntityBayesianNetwork loadMebn(File file) throws IOException, IOMebnException {
        MultiEntityBayesianNetwork mebn = this.loader.loadMebn(file);
        OWLModel lastOWLModel = this.loader.getLastOWLModel();
        this.clearAllPROWLModel(lastOWLModel);
        mebn.setStorageImplementor(new MEBNStorageImplementorDecorator(lastOWLModel));
        this.setOWLModelToUse(lastOWLModel);
        return mebn;
    }

    @Override
    public void saveMebn(File file, MultiEntityBayesianNetwork mebn) throws IOException, IOMebnException {
        SaverPrOwlIO saver = new SaverPrOwlIO();
        JenaOWLModel jenaOWLModel = null;
        try {
            MEBNStorageImplementorDecorator decorator = (MEBNStorageImplementorDecorator)mebn.getStorageImplementor();
            jenaOWLModel = (JenaOWLModel)decorator.getAdaptee();
        }
        catch (Exception e) {
            e.printStackTrace();
            jenaOWLModel = null;
        }
        saver.saveMebn(file, mebn, (OWLModel)jenaOWLModel);
        try {
            OWLModel model = saver.getLastOWLModel();
            this.clearAllPROWLModel(model);
            this.setOWLModelToUse(model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getFileExtension() {
        return this.getFileExtension();
    }

    @Override
    public OWLModel getLastOWLModel() {
        return this.lastOwlModel;
    }

    @Override
    public void setOWLModelToUse(OWLModel model) throws IOMebnException {
        this.lastOwlModel = model;
    }

    @Override
    public Collection<String> getNamesOfAllModifiedPROWLClasses() {
        Collection<String> ret = super.getNamesOfAllModifiedPROWLClasses();
        ret.remove("BuiltInRV");
        ret.remove("BooleanRVState");
        return ret;
    }

    public void clearAllPROWLModel(OWLModel model) {
        try {
            this.clearAllPROWLOntologyIndividuals((JenaOWLModel)model);
            this.clearAllObjectEntity((JenaOWLModel)model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LoaderPrOwlIO getLoader() {
        return this.loader;
    }
}

