/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.table;

import java.awt.Color;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import unbbayes.gui.table.ColumnGroup;
import unbbayes.gui.table.GroupableTableCellRenderer;
import unbbayes.gui.table.GroupableTableColumnModel;
import unbbayes.gui.table.GroupableTableHeader;
import unbbayes.prs.Node;
import unbbayes.prs.bn.PotentialTable;

public class GUIPotentialTable {
    private PotentialTable potentialTable;

    public GUIPotentialTable(PotentialTable potentialTable) {
        this.potentialTable = potentialTable;
    }

    public JTable makeTable() {
        int i;
        int nStates = 1;
        int nVariables = this.potentialTable.variableCount();
        Node node = this.potentialTable.getVariableAt(0);
        NumberFormat df = NumberFormat.getInstance(Locale.getDefault());
        df.setMaximumFractionDigits(4);
        nStates = this.potentialTable.tableSize() / node.getStatesSize();
        int rows = node.getStatesSize();
        int columns = nStates + 1;
        Object[][] data = new String[rows][columns];
        Object[] column = new String[data[0].length];
        if (nVariables == 1) {
            column[0] = "State";
            column[1] = "Probability";
        } else {
            Node firtHeaderNode = this.potentialTable.getVariableAt(1);
            column[0] = firtHeaderNode.getName();
            i = 0;
            while (i < data[0].length - 1) {
                if (nVariables > 1) {
                    column[i + 1] = firtHeaderNode.getStateAt(i % firtHeaderNode.getStatesSize());
                }
                ++i;
            }
        }
        int c = 1;
        int n = 0;
        while (c < columns) {
            int r = 0;
            while (r < rows) {
                data[r][c] = df.format(this.potentialTable.getValue(n + r));
                ++r;
            }
            ++c;
            n += rows;
        }
        i = 0;
        while (i < rows) {
            data[i][0] = node.getStateAt(i);
            ++i;
        }
        DefaultTableModel model = new DefaultTableModel();
        model.setDataVector(data, column);
        JTable table = new JTable();
        table.setColumnModel(new GroupableTableColumnModel());
        table.setTableHeader(new GroupableTableHeader((GroupableTableColumnModel)table.getColumnModel()));
        table.setModel(model);
        GroupableTableColumnModel cModel = (GroupableTableColumnModel)table.getColumnModel();
        ColumnGroup cNodeGroup = null;
        ColumnGroup cNodeTempGroup = null;
        ColumnGroup cGroup = null;
        ArrayList<ColumnGroup> cGroupList = new ArrayList<ColumnGroup>();
        ArrayList previousCGroupList = new ArrayList();
        boolean firstNode = true;
        int sizeColumn = 1;
        cModel.getColumn(0).setHeaderRenderer(new GroupableTableCellRenderer());
        cModel.getColumn(0).setCellRenderer(new GroupableTableCellRenderer(Color.BLACK, Color.YELLOW));
        int k = 2;
        while (k < nVariables) {
            Node parent = this.potentialTable.getVariableAt(k);
            int nPreviousParentStates = this.potentialTable.getVariableAt(k - 1).getStatesSize();
            sizeColumn *= nPreviousParentStates;
            if (!firstNode) {
                cNodeTempGroup = cNodeGroup;
                cNodeGroup = new ColumnGroup(new GroupableTableCellRenderer(), parent.getName());
                cNodeGroup.add(cNodeTempGroup);
            } else {
                cNodeGroup = new ColumnGroup(new GroupableTableCellRenderer(), parent.getName());
                cNodeGroup.add(cModel.getColumn(0));
            }
            int columnIndex = 1;
            cGroup = null;
            while (columnIndex <= nStates) {
                int i2 = 0;
                while (i2 < parent.getStatesSize()) {
                    int j;
                    cGroup = new ColumnGroup(parent.getStateAt(i2));
                    if (!firstNode) {
                        j = 0;
                        while (j < nPreviousParentStates) {
                            ColumnGroup group = (ColumnGroup)previousCGroupList.get(columnIndex - 1);
                            cGroup.add(group);
                            ++columnIndex;
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < sizeColumn) {
                            cGroup.add(cModel.getColumn(columnIndex++));
                            ++j;
                        }
                    }
                    cGroupList.add(cGroup);
                    ++i2;
                }
            }
            previousCGroupList = cGroupList;
            cGroupList = new ArrayList();
            firstNode = false;
            nStates /= nPreviousParentStates;
            ++k;
        }
        if (cNodeGroup != null) {
            cModel.addColumnGroup(cNodeGroup);
        }
        if (previousCGroupList != null) {
            for (ColumnGroup group : previousCGroupList) {
                cModel.addColumnGroup(group);
            }
        }
        table.setAutoResizeMode(0);
        return table;
    }

    public void showTable(String title) {
        JDialog diag = new JDialog();
        diag.getContentPane().add(new JScrollPane(this.makeTable()));
        diag.pack();
        diag.setVisible(true);
        diag.setDefaultCloseOperation(2);
        diag.setTitle(title);
    }
}

