/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.oobn;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import unbbayes.controller.NetworkController;
import unbbayes.controller.oobn.OOBNClassController;
import unbbayes.gui.EditNet;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.PNEditionPane;
import unbbayes.gui.oobn.EditOOBN;
import unbbayes.gui.oobn.OOBNEditionPane;
import unbbayes.gui.oobn.OOBNGraphPane;
import unbbayes.prs.Network;
import unbbayes.prs.Node;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.oobn.IOOBNClass;

public class OOBNClassWindow
extends NetworkWindow {
    public static final long serialVersionUID = 191L;
    private JViewport graphViewport = null;
    private OOBNGraphPane graphPane = null;
    private OOBNClassController controller = null;
    private Network net = null;
    private String fileName = null;
    private JScrollPane jspGraph = null;
    private JLabel status = null;
    private boolean bCompiled = false;
    private CardLayout card = null;
    private PNEditionPane pnEditionPane = null;
    private EditNet editNet = null;
    private final String PN_PANE_PN_EDITION_PANE = "pnEditionPane";
    private final String PN_PANE_PN_EDIT_NET = "editNet";
    private final String PN_PANE_HIERARCHY_PANE = "hierarchy";
    private final String PN_PANE_EVALUATION_PANE = "pnEvaluation";
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    protected OOBNClassWindow() {
    }

    protected OOBNClassWindow(IOOBNClass net) {
        this.net = net.getNetwork();
        this.fileName = null;
        this.controller = OOBNClassController.newInstance(net, this);
        this.card = new CardLayout();
        this.graphViewport = new JViewport();
        this.graphPane = OOBNGraphPane.newInstance(this.controller, this.graphViewport);
        this.jspGraph = new JScrollPane(this.graphViewport);
        this.status = new JLabel(resource.getString("statusReadyLabel"));
        this.bCompiled = false;
        this.graphPane.addKeyListener(this.controller);
    }

    public static OOBNClassWindow newInstance(IOOBNClass net) {
        OOBNClassWindow ret = new OOBNClassWindow(net);
        ret.initComponents();
        return ret;
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
        try {
            this.graphPane.update();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initComponents() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(this.card);
        this.setDefaultCloseOperation(2);
        long width = Node.getWidth();
        long height = Node.getHeight();
        this.graphPane.getGraphViewport().reshape(0, 0, (int)(this.graphPane.getBiggestPoint().getX() + (double)width), (int)(this.graphPane.getBiggestPoint().getY() + (double)height));
        this.graphPane.getGraphViewport().setViewSize(new Dimension((int)(this.graphPane.getBiggestPoint().getX() + (double)width), (int)(this.graphPane.getBiggestPoint().getY() + (double)height)));
        this.graphViewport.setView(this.graphPane);
        this.graphViewport.setSize(800, 600);
        this.initListeners();
        this.jspGraph.setHorizontalScrollBar(this.jspGraph.createHorizontalScrollBar());
        this.jspGraph.setVerticalScrollBar(this.jspGraph.createVerticalScrollBar());
        this.jspGraph.setHorizontalScrollBarPolicy(32);
        this.jspGraph.setVerticalScrollBarPolicy(22);
        this.pnEditionPane = OOBNEditionPane.newInstance(this, this.controller);
        this.editNet = EditOOBN.newInstance(this, this.controller);
        contentPane.add((Component)this.pnEditionPane, "pnEditionPane");
        contentPane.add((Component)this.editNet, "editNet");
        this.pnEditionPane.getCenterPanel().setBottomComponent(this.jspGraph);
        this.card.show(this.getContentPane(), "pnEditionPane");
    }

    private void initListeners() {
        this.jspGraph.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                OOBNClassWindow.this.graphPane.update();
            }
        });
        this.jspGraph.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                OOBNClassWindow.this.graphPane.update();
            }
        });
    }

    public void updateTitle() {
        super.setTitle(String.valueOf(this.net.getName()) + " " + "[" + this.fileName + "]");
    }

    public OOBNGraphPane getGraphPane() {
        return this.graphPane;
    }

    public JViewport getGraphViewport() {
        return this.graphViewport;
    }

    public JTable getTable() {
        return this.pnEditionPane.getTable();
    }

    public JTextField getTxtDescription() {
        return this.pnEditionPane.getTxtDescription();
    }

    public JTextField getTxtSigla() {
        return this.pnEditionPane.getTxtSigla();
    }

    public void setDistributionPane(JPanel distributionPane) {
        this.pnEditionPane.setDistributionPane(distributionPane);
    }

    public void setTable(JTable table) {
        this.pnEditionPane.setTable(table);
    }

    public JScrollPane getJspGraph() {
        if (this.jspGraph != null) {
            return this.jspGraph;
        }
        return super.getJspGraph();
    }

    public Node getTableOwner() {
        return this.pnEditionPane.getTableOwner();
    }

    public void setTableOwner(Node node) {
        this.pnEditionPane.setTableOwner(node);
    }

    public SingleEntityNetwork getSingleEntityNetwork() {
        try {
            return (SingleEntityNetwork)this.controller.getNetwork();
        }
        catch (Exception e) {
            return null;
        }
    }

    public MultiEntityBayesianNetwork getMultiEntityBayesianNetwork() {
        return (MultiEntityBayesianNetwork)this.controller.getNetwork();
    }

    public void setStatus(String status) {
        this.pnEditionPane.setStatus(status);
        this.status.setText(status);
    }

    public boolean isCompiled() {
        return this.bCompiled;
    }

    public PNEditionPane getNetWindowEdition() {
        return this.pnEditionPane;
    }

    public NetworkController getNetworkController() {
        return this.controller;
    }

    public EditNet getEditNet() {
        return this.editNet;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.updateTitle();
    }

    public void setAddRemoveStateButtonVisible(boolean visible) {
        this.pnEditionPane.getBtnAddState().setVisible(visible);
        this.pnEditionPane.getBtnRemoveState().setVisible(visible);
    }

    public OOBNClassController getController() {
        return this.controller;
    }

    public void setController(OOBNClassController controller) {
        this.controller = controller;
    }

    public JLabel getStatus() {
        return this.status;
    }

    public void setStatus(JLabel status) {
        this.status = status;
    }

    public CardLayout getCard() {
        return this.card;
    }

    public void setCard(CardLayout card) {
        this.card = card;
    }

    public PNEditionPane getPnEditionPane() {
        return this.pnEditionPane;
    }

    public void setPnEditionPane(PNEditionPane pnEditionPane) {
        this.pnEditionPane = pnEditionPane;
    }

    public void setGraphViewport(JViewport graphViewport) {
        this.graphViewport = graphViewport;
    }

    public void setGraphPane(OOBNGraphPane graphPane) {
        this.graphPane = graphPane;
    }

    public void setJspGraph(JScrollPane jspGraph) {
        this.jspGraph = jspGraph;
    }

    public void setEditNet(EditNet editNet) {
        this.editNet = editNet;
    }
}

