/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn.formula;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import unbbayes.controller.FormulaTreeController;
import unbbayes.gui.mebn.formula.BuilderMenuNode;
import unbbayes.gui.mebn.formula.FormulaTreeCellRenderer;
import unbbayes.gui.mebn.formula.exception.FormulaTreeConstructionException;
import unbbayes.prs.mebn.BuiltInRV;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.builtInRV.BuiltInRVAnd;
import unbbayes.prs.mebn.builtInRV.BuiltInRVEqualTo;
import unbbayes.prs.mebn.builtInRV.BuiltInRVExists;
import unbbayes.prs.mebn.builtInRV.BuiltInRVForAll;
import unbbayes.prs.mebn.builtInRV.BuiltInRVIff;
import unbbayes.prs.mebn.builtInRV.BuiltInRVImplies;
import unbbayes.prs.mebn.builtInRV.BuiltInRVNot;
import unbbayes.prs.mebn.builtInRV.BuiltInRVOr;
import unbbayes.prs.mebn.context.EnumSubType;
import unbbayes.prs.mebn.context.EnumType;
import unbbayes.prs.mebn.context.NodeFormulaTree;

public class FormulaViewTree
extends JTree {
    private FormulaTreeController formulaTreeController;
    private BuilderMenuNode builderMenuNode;
    private ContextNode contextNode;
    private DefaultMutableTreeNode rootTreeView;
    private DefaultTreeModel model;
    private NodeFormulaTree rootTreeFormula;
    private NodeFormulaTree nodeFormulaActive;
    private DefaultMutableTreeNode nodeActive;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    public FormulaViewTree(FormulaTreeController _controller, ContextNode _contextNode) {
        this.formulaTreeController = _controller;
        this.contextNode = _contextNode;
        this.builderMenuNode = new BuilderMenuNode(_controller);
        if (this.contextNode.getFormulaTree() == null) {
            NodeFormulaTree rootFormula = new NodeFormulaTree("formula", EnumType.FORMULA, EnumSubType.NOTHING, null);
            this.rootTreeView = new DefaultMutableTreeNode(rootFormula);
            this.createTree();
            this.contextNode.setFormulaTree(rootFormula);
        } else {
            this.buildTree();
        }
        this.model = new DefaultTreeModel(this.rootTreeView);
        this.setModel(this.model);
        this.setCellRenderer(new FormulaTreeCellRenderer());
        this.updateTree();
        this.addMouseListener(new MouseListenerTree());
        this.treeDidChange();
    }

    public void recriateTree() {
        NodeFormulaTree rootFormula = new NodeFormulaTree("formula", EnumType.FORMULA, EnumSubType.NOTHING, null);
        DefaultMutableTreeNode nodeTree = new DefaultMutableTreeNode(rootFormula);
        this.rootTreeView = new DefaultMutableTreeNode(rootFormula);
        this.contextNode.setFormulaTree(rootFormula);
        this.model = new DefaultTreeModel(this.rootTreeView);
        this.setModel(this.model);
        this.updateTree();
    }

    private void createTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        this.expandRow(0);
    }

    public void buildTree() {
        this.rootTreeFormula = this.contextNode.getFormulaTree();
        this.rootTreeView = new DefaultMutableTreeNode(this.rootTreeFormula);
        this.buildChildren(this.rootTreeFormula, this.rootTreeView);
    }

    public void buildChildren(NodeFormulaTree nodeFormulaFather, DefaultMutableTreeNode nodeTreeFather) {
        for (NodeFormulaTree child : nodeFormulaFather.getChildren()) {
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(child);
            nodeTreeFather.add(treeNode);
            this.buildChildren(child, treeNode);
        }
    }

    public void updateTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        ((DefaultTreeModel)this.getModel()).reload(root);
        int i = 0;
        while (i < this.getRowCount()) {
            this.expandRow(i);
            ++i;
        }
    }

    private DefaultMutableTreeNode findUserObject(String treeNode, DefaultMutableTreeNode root) {
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.getUserObject().toString().equals(treeNode)) continue;
            return node;
        }
        return null;
    }

    public void addOperatorAnd() throws Exception {
        BuiltInRVAnd builtInRV = new BuiltInRVAnd();
        this.addSimpleOperatorInTree(builtInRV, EnumSubType.AND);
    }

    public void addOperatorOr() throws Exception {
        BuiltInRVOr builtInRV = new BuiltInRVOr();
        this.addSimpleOperatorInTree(builtInRV, EnumSubType.OR);
    }

    public void addOperatorNot() throws Exception {
        BuiltInRVNot builtInRV = new BuiltInRVNot();
        this.addSimpleOperatorInTree(builtInRV, EnumSubType.NOT);
    }

    public void addOperatorEqualTo() throws Exception {
        BuiltInRVEqualTo builtInRV = new BuiltInRVEqualTo();
        this.addSimpleOperatorInTree(builtInRV, EnumSubType.EQUALTO);
    }

    public void addOperatorIf() throws Exception {
        BuiltInRVIff builtInRV = new BuiltInRVIff();
        this.addSimpleOperatorInTree(builtInRV, EnumSubType.IFF);
    }

    public void addOperatorImplies() throws Exception {
        BuiltInRVImplies builtInRV = new BuiltInRVImplies();
        this.addSimpleOperatorInTree(builtInRV, EnumSubType.IMPLIES);
    }

    public void addOperatorForAll() throws Exception {
        BuiltInRVForAll builtInRV = new BuiltInRVForAll();
        this.addQuantifierOperatorInTree(builtInRV, EnumSubType.FORALL);
    }

    public void addOperatorExists() throws Exception {
        BuiltInRVExists builtInRV = new BuiltInRVExists();
        this.addQuantifierOperatorInTree(builtInRV, EnumSubType.EXISTS);
    }

    public void addSimpleOperatorInTree(BuiltInRV builtInRV, EnumSubType subType) throws FormulaTreeConstructionException {
        NodeFormulaTree nodeFormula = (NodeFormulaTree)this.nodeActive.getUserObject();
        if (nodeFormula.getTypeNode() == EnumType.VARIABLE_SEQUENCE) {
            throw new FormulaTreeConstructionException(resource.getString("notOperator"));
        }
        this.nodeActive.removeAllChildren();
        nodeFormula.removeAllChildren();
        nodeFormula.setName(builtInRV.getName());
        nodeFormula.setMnemonic(builtInRV.getMnemonic());
        nodeFormula.setNodeVariable(builtInRV);
        nodeFormula.setTypeNode(EnumType.SIMPLE_OPERATOR);
        nodeFormula.setSubTypeNode(subType);
        int i = 1;
        while (i <= builtInRV.getNumOperandos()) {
            NodeFormulaTree operandoChild = new NodeFormulaTree("op_" + i, EnumType.OPERAND, EnumSubType.NOTHING, null);
            DefaultMutableTreeNode nodeChild = new DefaultMutableTreeNode(operandoChild);
            this.nodeActive.add(nodeChild);
            nodeFormula.addChild(operandoChild);
            ++i;
        }
        this.updateTree();
    }

    public void addQuantifierOperatorInTree(BuiltInRV builtInRV, EnumSubType subType) throws FormulaTreeConstructionException {
        NodeFormulaTree nodeFormula = (NodeFormulaTree)this.nodeActive.getUserObject();
        if (nodeFormula.getTypeNode() == EnumType.VARIABLE_SEQUENCE) {
            throw new FormulaTreeConstructionException(resource.getString("notOperator"));
        }
        this.nodeActive.removeAllChildren();
        nodeFormula.removeAllChildren();
        nodeFormula.setName(builtInRV.getName());
        nodeFormula.setMnemonic(builtInRV.getMnemonic());
        nodeFormula.setNodeVariable(builtInRV);
        nodeFormula.setTypeNode(EnumType.QUANTIFIER_OPERATOR);
        nodeFormula.setSubTypeNode(subType);
        NodeFormulaTree nodeFormulaTree = new NodeFormulaTree("Var", EnumType.VARIABLE_SEQUENCE, EnumSubType.NOTHING, null);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeFormulaTree);
        this.nodeActive.add(node);
        nodeFormula.addChild(nodeFormulaTree);
        nodeFormulaTree = new NodeFormulaTree("Formula", EnumType.FORMULA, EnumSubType.NOTHING, null);
        node = new DefaultMutableTreeNode(nodeFormulaTree);
        this.nodeActive.add(node);
        nodeFormula.addChild(nodeFormulaTree);
        this.updateTree();
    }

    public JPanel replaceByVariable() {
        int i;
        NodeFormulaTree nodeFormula;
        JPanel painel = new JPanel(new BorderLayout());
        if (this.nodeActive == null) {
            return painel;
        }
        DefaultMutableTreeNode nodeTree = this.nodeActive;
        TreeNode nodeAux = nodeTree.getParent();
        boolean testeEnd = false;
        final ArrayList<TreeNode> listVariables = new ArrayList<TreeNode>();
        while (!testeEnd) {
            nodeFormula = (NodeFormulaTree)((DefaultMutableTreeNode)nodeAux).getUserObject();
            if (nodeFormula.getTypeNode() == EnumType.QUANTIFIER_OPERATOR) {
                TreeNode variableListNode = nodeAux.getChildAt(0);
                int numChild = variableListNode.getChildCount();
                i = 0;
                while (i < numChild) {
                    listVariables.add(variableListNode.getChildAt(i));
                    ++i;
                }
            }
            if (nodeAux.getParent() == null) {
                testeEnd = true;
                continue;
            }
            nodeAux = nodeAux.getParent();
        }
        String[] variablesNames = new String[listVariables.size()];
        i = 0;
        for (TreeNode node : listVariables) {
            nodeFormula = (NodeFormulaTree)((DefaultMutableTreeNode)node).getUserObject();
            variablesNames[i] = nodeFormula.getName();
            ++i;
        }
        final JList<String> list = new JList<String>(variablesNames);
        list.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getModifiers() == 16 && e.getClickCount() == 2) {
                    int selectedIndex = list.getSelectedIndex();
                    TreeNode treeNodeSelected = (TreeNode)listVariables.get(selectedIndex);
                    NodeFormulaTree nodePlace = (NodeFormulaTree)((DefaultMutableTreeNode)treeNodeSelected).getUserObject();
                    NodeFormulaTree nodeFormulaActive = (NodeFormulaTree)FormulaViewTree.this.nodeActive.getUserObject();
                    nodeFormulaActive.setName(nodePlace.getName());
                    nodeFormulaActive.setNodeVariable(nodePlace);
                    nodeFormulaActive.setTypeNode(EnumType.OPERAND);
                    nodeFormulaActive.setSubTypeNode(EnumSubType.VARIABLE);
                    FormulaViewTree.this.updateTree();
                }
            }
        });
        list.setSelectionMode(1);
        list.setLayoutOrientation(0);
        list.setVisibleRowCount(-1);
        JScrollPane listScroller = new JScrollPane(list);
        listScroller.setPreferredSize(new Dimension(100, 200));
        painel.add(listScroller);
        return painel;
    }

    public JPanel replaceByExemplar() {
        JPanel exemplarPainel = new JPanel(new BorderLayout());
        if (this.nodeActive == null) {
            return exemplarPainel;
        }
        DefaultMutableTreeNode nodeActual = this.nodeActive;
        JTree variableTree = new JTree();
        NodeFormulaTree nodeFormulaActual = (NodeFormulaTree)this.nodeActive.getUserObject();
        while (((NodeFormulaTree)nodeActual.getUserObject()).getTypeNode() != EnumType.QUANTIFIER_OPERATOR) {
            nodeActual = (DefaultMutableTreeNode)nodeActual.getParent();
        }
        NodeFormulaTree nodeQuantifier = (NodeFormulaTree)nodeActual.getUserObject();
        nodeActual.getChildCount();
        return exemplarPainel;
    }

    public NodeFormulaTree getNodeFormulaActive() {
        return this.nodeFormulaActive;
    }

    public void setNodeFormulaActive(NodeFormulaTree nodeFormulaActive) {
        this.nodeFormulaActive = nodeFormulaActive;
    }

    public DefaultMutableTreeNode getNodeActive() {
        return this.nodeActive;
    }

    public void setNodeActive(DefaultMutableTreeNode nodeActive) {
        this.nodeActive = nodeActive;
    }

    public void addNewNodeInTree(NodeFormulaTree node) {
        this.nodeActive.add(new DefaultMutableTreeNode(node));
    }

    private class MouseListenerTree
    extends MouseAdapter {
        private MouseListenerTree() {
        }

        public void mousePressed(MouseEvent e) {
            int selRow = FormulaViewTree.this.getRowForLocation(e.getX(), e.getY());
            if (selRow == -1) {
                return;
            }
            TreePath selPath = FormulaViewTree.this.getPathForLocation(e.getX(), e.getY());
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            FormulaViewTree.this.nodeActive = node;
            FormulaViewTree.this.nodeFormulaActive = (NodeFormulaTree)node.getUserObject();
            if (e.getModifiers() == 4) {
                switch (FormulaViewTree.this.nodeFormulaActive.getTypeNode()) {
                    case EMPTY: 
                    case FORMULA: {
                        FormulaViewTree.this.builderMenuNode.buildPopupFormula().show(e.getComponent(), e.getX(), e.getY());
                        break;
                    }
                    case OPERAND: {
                        FormulaViewTree.this.builderMenuNode.buildPopupOperando().show(e.getComponent(), e.getX(), e.getY());
                        break;
                    }
                    case SIMPLE_OPERATOR: {
                        FormulaViewTree.this.builderMenuNode.buildPopupOperator().show(e.getComponent(), e.getX(), e.getY());
                        break;
                    }
                    case QUANTIFIER_OPERATOR: {
                        FormulaViewTree.this.builderMenuNode.buildPopupOperator().show(e.getComponent(), e.getX(), e.getY());
                        break;
                    }
                    case VARIABLE_SEQUENCE: {
                        FormulaViewTree.this.builderMenuNode.buildPopupExemplarList().show(e.getComponent(), e.getX(), e.getY());
                        break;
                    }
                    case VARIABLE: {
                        FormulaViewTree.this.builderMenuNode.buildPopupExemplar().show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            } else if (e.getClickCount() == 2 && e.getModifiers() == 16) {
                switch (FormulaViewTree.this.nodeFormulaActive.getTypeNode()) {
                    case OPERAND: {
                        switch (FormulaViewTree.this.nodeFormulaActive.getSubTypeNode()) {
                            case NODE: {
                                FormulaViewTree.this.formulaTreeController.showArgumentPanel(FormulaViewTree.this.nodeFormulaActive);
                            }
                        }
                        break;
                    }
                }
            } else {
                e.getClickCount();
            }
        }
    }
}

