/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn.finding;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import unbbayes.controller.MEBNController;
import unbbayes.gui.ParcialStateException;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.entity.BooleanStatesEntityContainer;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.entity.ObjectEntity;
import unbbayes.prs.mebn.entity.ObjectEntityInstance;
import unbbayes.prs.mebn.entity.StateLink;
import unbbayes.util.ResourceController;

public class FindingArgumentPane
extends JPanel {
    private MEBNController mebnController;
    private ResidentNode node;
    private JComboBox states;
    private JComboBox[] argument;
    private static final int MINIMUM_LINE_SIXE_PANEL = 5;
    ResourceBundle resource = ResourceController.RS_GUI;

    public FindingArgumentPane(ResidentNode node, MEBNController mebnController) {
        this.node = node;
        this.mebnController = mebnController;
        if (node.getOrdinaryVariableList().size() > 5) {
            this.setLayout(new GridLayout(node.getOrdinaryVariableList().size(), 1));
        } else {
            this.setLayout(new GridLayout(6, 1));
        }
        this.argument = new JComboBox[node.getOrdinaryVariableList().size()];
        List<ObjectEntityInstance> entityList = mebnController.getMultiEntityBayesianNetwork().getObjectEntityContainer().getListEntityInstances();
        int i = 0;
        for (OrdinaryVariable ov : node.getOrdinaryVariableList()) {
            JToolBar tbArgX = new JToolBar();
            Vector<ObjectEntityInstance> list = new Vector<ObjectEntityInstance>();
            list.add(null);
            for (ObjectEntityInstance entity : entityList) {
                if (!entity.getType().equals(ov.getValueType())) continue;
                list.add(entity);
            }
            this.argument[i] = new JComboBox(list);
            this.argument[i].addItemListener(new ComboListener(i));
            this.argument[i].setSelectedIndex(0);
            JButton btnArgXNumber = new JButton("" + i);
            btnArgXNumber.setBackground(new Color(193, 207, 180));
            JButton btnArgXType = new JButton(ov.getValueType().getName());
            btnArgXType.setBackground(new Color(193, 210, 205));
            tbArgX.add(btnArgXNumber);
            tbArgX.add(btnArgXType);
            tbArgX.add(this.argument[i]);
            tbArgX.setFloatable(false);
            this.add(tbArgX);
            ++i;
        }
        JLabel labelState = new JLabel(this.resource.getString("stateLabel"));
        JButton btnLabelType = null;
        switch (node.getTypeOfStates()) {
            case 2: {
                btnLabelType = new JButton(this.resource.getString("booleanLabel"));
                ArrayList<StateLink> values = new ArrayList<StateLink>(node.getPossibleValueLinkList());
                BooleanStatesEntityContainer container = new BooleanStatesEntityContainer();
                for (StateLink state : values) {
                    if (state.getState().getName().compareTo(container.getAbsurdStateEntity().getName()) != 0) continue;
                    values.remove(state);
                    break;
                }
                this.states = new JComboBox<Object>(values.toArray());
                break;
            }
            case 1: {
                btnLabelType = new JButton(this.resource.getString("categoricalLabel"));
                this.states = new JComboBox<Object>(node.getPossibleValueLinkList().toArray());
                break;
            }
            case 0: {
                StateLink link = node.getPossibleValueLinkList().get(0);
                ObjectEntity objectEntity = (ObjectEntity)link.getState();
                btnLabelType = new JButton(objectEntity.getName());
                this.states = new JComboBox<Object>(objectEntity.getInstanceList().toArray());
                break;
            }
        }
        JToolBar tbStates = new JToolBar();
        tbStates.add(labelState);
        tbStates.add(btnLabelType);
        tbStates.add(this.states);
        tbStates.setFloatable(false);
        this.add(tbStates);
    }

    public ObjectEntityInstance[] getArguments() throws ParcialStateException {
        ObjectEntityInstance[] argumentVector = new ObjectEntityInstance[this.argument.length];
        int i = 0;
        while (i < this.argument.length) {
            if (this.argument[i].getSelectedItem() == null) {
                throw new ParcialStateException();
            }
            argumentVector[i] = (ObjectEntityInstance)this.argument[i].getSelectedItem();
            ++i;
        }
        return argumentVector;
    }

    public Entity getState() {
        switch (this.node.getTypeOfStates()) {
            case 1: 
            case 2: {
                return ((StateLink)this.states.getSelectedItem()).getState();
            }
            case 0: {
                return (ObjectEntityInstance)this.states.getSelectedItem();
            }
        }
        return null;
    }

    public void clear() {
    }

    private class ComboListener
    implements ItemListener {
        int indice;

        public ComboListener(int i) {
            this.indice = i;
        }

        public void itemStateChanged(ItemEvent e) {
            JComboBox combo = (JComboBox)e.getSource();
            combo.getSelectedItem();
        }
    }
}

