/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import unbbayes.controller.MEBNController;
import unbbayes.gui.ParcialStateException;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.entity.ObjectEntity;
import unbbayes.prs.mebn.entity.ObjectEntityInstance;

public class QueryArgumentsPane
extends JPanel {
    private MEBNController mebnController;
    private ResidentNode node;
    private JComboBox[] argument;

    public QueryArgumentsPane(ResidentNode node, MEBNController mebnController) {
        this.node = node;
        this.mebnController = mebnController;
        this.setLayout(new GridLayout(node.getOrdinaryVariableList().size(), 1));
        this.argument = new JComboBox[node.getOrdinaryVariableList().size()];
        List<ObjectEntityInstance> entityList = mebnController.getMultiEntityBayesianNetwork().getObjectEntityContainer().getListEntityInstances();
        int i = 0;
        for (OrdinaryVariable ov : node.getOrdinaryVariableList()) {
            JToolBar tbArgX = new JToolBar();
            Vector<ObjectEntityInstance> list = new Vector<ObjectEntityInstance>();
            list.add(null);
            for (ObjectEntityInstance entity : entityList) {
                if (!entity.getType().equals(ov.getValueType())) continue;
                list.add(entity);
            }
            this.argument[i] = new JComboBox(list);
            this.argument[i].addItemListener(new ComboListener(i));
            this.argument[i].setSelectedIndex(0);
            ObjectEntity oe = mebnController.getMultiEntityBayesianNetwork().getObjectEntityContainer().getObjectEntityByType(ov.getValueType());
            if (oe.isOrdereable()) {
                this.argument[i].setEditable(false);
            } else {
                this.argument[i].setEditable(true);
            }
            JButton btnArgXNumber = new JButton("" + i);
            btnArgXNumber.setBackground(new Color(193, 207, 180));
            JButton btnArgXType = new JButton(ov.getValueType().getName());
            btnArgXType.setBackground(new Color(193, 210, 205));
            tbArgX.add(btnArgXNumber);
            tbArgX.add(btnArgXType);
            tbArgX.add(this.argument[i]);
            tbArgX.setFloatable(false);
            this.add(tbArgX);
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectEntityInstance[] getArguments() throws ParcialStateException {
        ObjectEntityInstance[] argumentVector = new ObjectEntityInstance[this.argument.length];
        int i = 0;
        while (i < this.argument.length) {
            if (this.argument[i].getSelectedItem() == null) throw new ParcialStateException();
            if (this.argument[i].getSelectedItem() instanceof ObjectEntityInstance) {
                argumentVector[i] = (ObjectEntityInstance)this.argument[i].getSelectedItem();
            } else if (this.argument[i].getSelectedItem() instanceof String) {
                if (!this.isNameValid((String)this.argument[i].getSelectedItem())) throw new ParcialStateException();
                String nameInstance = (String)this.argument[i].getSelectedItem();
                ObjectEntity objectEntity = this.mebnController.getMultiEntityBayesianNetwork().getObjectEntityContainer().getObjectEntityByType(this.node.getOrdinaryVariableList().get(i).getValueType());
                argumentVector[i] = new ObjectEntityInstance(nameInstance, objectEntity);
            }
            ++i;
        }
        return argumentVector;
    }

    private boolean isNameValid(String name) {
        return true;
    }

    public void clear() {
    }

    private class ComboListener
    implements ItemListener {
        int indice;

        public ComboListener(int i) {
            this.indice = i;
        }

        public void itemStateChanged(ItemEvent e) {
            JComboBox combo = (JComboBox)e.getSource();
            combo.getSelectedItem();
        }
    }
}

