/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.exception.CycleFoundException;
import unbbayes.util.ArrayMap;

public class InputInstanceOfTree
extends JTree {
    private MultiEntityBayesianNetwork net;
    private boolean[] expandedNodes;
    private ArrayMap<Object, ResidentNode> residentNodeMap = new ArrayMap();
    private ArrayMap<Object, MFrag> mFragMap = new ArrayMap();
    private ArrayMap<Object, Object> nodeMap = new ArrayMap();
    protected IconController iconController = IconController.getInstance();
    private final MEBNController controller;

    public InputInstanceOfTree(final MEBNController controller) {
        this.controller = controller;
        this.net = controller.getMultiEntityBayesianNetwork();
        this.setCellRenderer(new InputInstanceTreeCellRenderer());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.net.getName());
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.setModel(model);
        this.createTree();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = InputInstanceOfTree.this.getRowForLocation(e.getX(), e.getY());
                if (selRow == -1) {
                    return;
                }
                TreePath selPath = InputInstanceOfTree.this.getPathForLocation(e.getX(), e.getY());
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                if (node.isLeaf()) {
                    ResidentNode residentNode = (ResidentNode)InputInstanceOfTree.this.residentNodeMap.get(node);
                    if (e.getModifiers() != 4) {
                        if (e.getClickCount() == 2 && e.getModifiers() == 16) {
                            InputNode inputNode = controller.getInputNodeActive();
                            try {
                                controller.setInputInstanceOf(inputNode, residentNode);
                            }
                            catch (CycleFoundException ce) {
                                JOptionPane.showMessageDialog(null, ce.getMessage(), "MEBN Construction Error", 0);
                            }
                        } else {
                            e.getClickCount();
                        }
                    }
                } else {
                    e.getModifiers();
                    if (e.getClickCount() != 1 && e.getClickCount() == 2) {
                        DefaultMutableTreeNode root = (DefaultMutableTreeNode)InputInstanceOfTree.this.getModel().getRoot();
                        int n = root.getIndex(node);
                    }
                }
            }
        });
        this.expandTree();
    }

    private void createTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        List<MFrag> domainMFragList = this.net.getDomainMFragList();
        for (MFrag domainMFrag : domainMFragList) {
            DefaultMutableTreeNode mFragTreeNode = new DefaultMutableTreeNode(domainMFrag.getName());
            this.mFragMap.put(mFragTreeNode, domainMFrag);
            this.nodeMap.put(mFragTreeNode, domainMFrag);
            root.add(mFragTreeNode);
            List<ResidentNode> residentNodeList = domainMFrag.getResidentNodeList();
            for (ResidentNode domainResidentNode : residentNodeList) {
                DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(domainResidentNode.getName());
                mFragTreeNode.add(treeNode);
                this.residentNodeMap.put(treeNode, domainResidentNode);
                this.nodeMap.put(treeNode, domainResidentNode);
            }
        }
        this.expandedNodes = new boolean[this.net.getMFragCount()];
    }

    public void collapseTree() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.collapseRow(i);
            ++i;
        }
        i = 0;
        while (i < this.expandedNodes.length) {
            this.expandedNodes[i] = false;
            ++i;
        }
    }

    public void expandTree() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.expandRow(i);
            ++i;
        }
        i = 0;
        while (i < this.expandedNodes.length) {
            this.expandedNodes[i] = true;
            ++i;
        }
    }

    private void restoreTree() {
        int i = this.expandedNodes.length - 1;
        while (i >= 0) {
            if (this.expandedNodes[i]) {
                this.expandRow(i);
            } else {
                this.collapseRow(i);
            }
            --i;
        }
    }

    public void updateTree() {
        if (this.expandedNodes == null) {
            this.expandedNodes = new boolean[this.net.getMFragCount()];
            int i = 0;
            while (i < this.expandedNodes.length) {
                this.expandedNodes[i] = false;
                ++i;
            }
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        root.removeAllChildren();
        this.mFragMap.clear();
        this.residentNodeMap.clear();
        this.nodeMap.clear();
        List<MFrag> domainMFragList = this.net.getDomainMFragList();
        for (MFrag domainMFrag : domainMFragList) {
            DefaultMutableTreeNode mFragTreeNode = new DefaultMutableTreeNode(domainMFrag.getName());
            this.mFragMap.put(mFragTreeNode, domainMFrag);
            this.nodeMap.put(mFragTreeNode, domainMFrag);
            root.add(mFragTreeNode);
            List<ResidentNode> residentNodeList = domainMFrag.getResidentNodeList();
            for (ResidentNode domainResidentNode : residentNodeList) {
                DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(domainResidentNode.getName());
                mFragTreeNode.add(treeNode);
                this.residentNodeMap.put(treeNode, domainResidentNode);
                this.nodeMap.put(treeNode, domainResidentNode);
            }
        }
        this.restoreTree();
        ((DefaultTreeModel)this.getModel()).reload(root);
        this.restoreTree();
    }

    private DefaultMutableTreeNode findUserObject(String treeNode, DefaultMutableTreeNode root) {
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.getUserObject().toString().equals(treeNode)) continue;
            return node;
        }
        return null;
    }

    private void treeDoubleClick(DefaultMutableTreeNode treeNode) {
    }

    private class InputInstanceTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 0L;
        private ImageIcon yellowNodeIcon;
        private ImageIcon greenNodeIcon;
        private ImageIcon blueNodeIcon;
        private ImageIcon orangeNodeIcon;
        private ImageIcon mTheoryNodeIcon;

        private InputInstanceTreeCellRenderer() {
            this.yellowNodeIcon = InputInstanceOfTree.this.iconController.getYellowNodeIcon();
            this.greenNodeIcon = InputInstanceOfTree.this.iconController.getGreenNodeIcon();
            this.blueNodeIcon = InputInstanceOfTree.this.iconController.getBlueNodeIcon();
            this.orangeNodeIcon = InputInstanceOfTree.this.iconController.getOrangeNodeIcon();
            this.mTheoryNodeIcon = InputInstanceOfTree.this.iconController.getMTheoryNodeIcon();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object obj = InputInstanceOfTree.this.nodeMap.get((DefaultMutableTreeNode)value);
            if (leaf) {
                if (obj != null) {
                    if (obj instanceof ResidentNode) {
                        this.setIcon(this.yellowNodeIcon);
                    } else if (obj instanceof ContextNode) {
                        this.setIcon(this.greenNodeIcon);
                    } else if (obj instanceof MFrag) {
                        this.setIcon(this.orangeNodeIcon);
                    } else {
                        this.setIcon(this.mTheoryNodeIcon);
                    }
                }
            } else if (obj instanceof MFrag) {
                this.setOpenIcon(this.orangeNodeIcon);
                this.setClosedIcon(this.orangeNodeIcon);
                this.setIcon(this.orangeNodeIcon);
            } else {
                this.setOpenIcon(this.mTheoryNodeIcon);
                this.setClosedIcon(this.mTheoryNodeIcon);
                this.setIcon(this.mTheoryNodeIcon);
            }
            return this;
        }
    }
}

