/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.gui.mebn.auxiliary.FocusListenerTextField;
import unbbayes.gui.mebn.auxiliary.ListCellRenderer;
import unbbayes.gui.mebn.auxiliary.MebnToolkit;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.entity.ObjectEntity;
import unbbayes.prs.mebn.entity.exception.ObjectEntityHasInstancesException;
import unbbayes.prs.mebn.entity.exception.TypeException;
import unbbayes.prs.mebn.exception.DuplicatedNameException;
import unbbayes.prs.mebn.exception.ReservedWordException;

public class EntityEditionPane
extends JPanel {
    private MEBNController mebnController;
    private List<ObjectEntity> listEntity;
    private JPanel jpInformation;
    private JTextField txtName;
    private JTextField txtType;
    private JCheckBox checkIsOrdereable;
    private JButton jbNew;
    private JButton jbDelete;
    private JList jlEntities;
    private DefaultListModel listModel;
    private ObjectEntity selected;
    private final Pattern wordPattern = Pattern.compile("[a-zA-Z_0-9]*");
    private Matcher matcher;
    private final IconController iconController = IconController.getInstance();
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    public EntityEditionPane(MEBNController mebnController) {
        this.mebnController = mebnController;
        this.setBorder(MebnToolkit.getBorderForTabPanel(resource.getString("EntityTitle")));
        this.setLayout(new BorderLayout());
        this.buildJlEntities();
        JScrollPane listScrollPane = new JScrollPane(this.jlEntities);
        this.buildJpInformation();
        this.add("South", this.jpInformation);
        this.add("Center", listScrollPane);
        this.selected = null;
        this.update();
        this.addListListener();
        this.addButtonsListeners();
    }

    private void buildJlEntities() {
        this.listModel = new DefaultListModel();
        this.jlEntities = new JList(this.listModel);
        this.jlEntities.setSelectionMode(0);
        this.jlEntities.setLayoutOrientation(0);
        this.jlEntities.setVisibleRowCount(-1);
        this.jlEntities.setCellRenderer(new ListCellRenderer(this.iconController.getObjectEntityIcon()));
    }

    private void buildJpInformation() {
        this.jpInformation = new JPanel(new GridLayout(4, 0));
        JToolBar toolBar = new JToolBar();
        toolBar.setLayout(new GridLayout(0, 2));
        this.jbNew = new JButton(this.iconController.getMoreIcon());
        this.jbNew.setToolTipText(resource.getString("newEntityToolTip"));
        toolBar.add(this.jbNew);
        this.jbDelete = new JButton(this.iconController.getLessIcon());
        this.jbDelete.setToolTipText(resource.getString("delEntityToolTip"));
        toolBar.add(this.jbDelete);
        toolBar.setFloatable(false);
        this.jpInformation.add(toolBar);
        toolBar = new JToolBar();
        toolBar.setLayout(new BorderLayout());
        JLabel label = new JLabel(resource.getString("nameLabel"));
        label.setPreferredSize(new Dimension(50, 5));
        toolBar.add((Component)label, "Before");
        this.txtName = new JTextField(10);
        this.txtName.setEditable(false);
        toolBar.add((Component)this.txtName, "Center");
        toolBar.setFloatable(false);
        this.jpInformation.add(toolBar);
        toolBar = new JToolBar();
        toolBar.setLayout(new BorderLayout());
        label = new JLabel(resource.getString("typeLabel"));
        label.setPreferredSize(new Dimension(50, 5));
        toolBar.add((Component)label, "Before");
        this.txtType = new JTextField(10);
        this.txtType.setEditable(false);
        toolBar.add((Component)this.txtType, "Center");
        toolBar.setFloatable(false);
        this.jpInformation.add(toolBar);
        toolBar = new JToolBar();
        toolBar.setLayout(new BorderLayout());
        this.checkIsOrdereable = new JCheckBox();
        this.checkIsOrdereable.setEnabled(false);
        toolBar.add((Component)this.checkIsOrdereable, "Before");
        label = new JLabel(resource.getString("ordereableLabel"));
        toolBar.add((Component)label, "Center");
        toolBar.setFloatable(false);
        this.jpInformation.add(toolBar);
    }

    private void update() {
        ObjectEntity antSelected = this.selected;
        this.listModel.clear();
        this.listEntity = this.mebnController.getMultiEntityBayesianNetwork().getObjectEntityContainer().getListEntity();
        this.listModel = new DefaultListModel();
        for (Entity entity : this.listEntity) {
            this.listModel.addElement(entity);
        }
        this.jlEntities.setModel(this.listModel);
        this.selected = antSelected;
    }

    private void addListListener() {
        this.jlEntities.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                EntityEditionPane.this.selected = (ObjectEntity)EntityEditionPane.this.jlEntities.getSelectedValue();
                if (EntityEditionPane.this.selected != null) {
                    EntityEditionPane.this.txtName.setText(EntityEditionPane.this.selected.getName());
                    EntityEditionPane.this.txtName.setEditable(true);
                    EntityEditionPane.this.checkIsOrdereable.setEnabled(true);
                    EntityEditionPane.this.checkIsOrdereable.setSelected(EntityEditionPane.this.selected.isOrdereable());
                    EntityEditionPane.this.txtType.setText(EntityEditionPane.this.selected.getType().getName());
                }
            }
        });
    }

    private void addButtonsListeners() {
        this.txtName.addFocusListener(new FocusListenerTextField());
        this.txtName.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                block9: {
                    if (e.getKeyCode() == 10 && EntityEditionPane.this.txtName.getText().length() > 0) {
                        try {
                            String nameValue = EntityEditionPane.this.txtName.getText(0, EntityEditionPane.this.txtName.getText().length());
                            EntityEditionPane.this.matcher = EntityEditionPane.this.wordPattern.matcher(nameValue);
                            if (EntityEditionPane.this.matcher.matches()) {
                                try {
                                    try {
                                        EntityEditionPane.this.mebnController.renameObjectEntity(EntityEditionPane.this.selected, nameValue);
                                        EntityEditionPane.this.jlEntities.setSelectedValue(EntityEditionPane.this.selected, true);
                                        EntityEditionPane.this.txtName.setText(EntityEditionPane.this.selected.getName());
                                        EntityEditionPane.this.txtName.setEditable(false);
                                        EntityEditionPane.this.checkIsOrdereable.setEnabled(false);
                                        EntityEditionPane.this.txtType.setText(EntityEditionPane.this.selected.getType().getName());
                                        EntityEditionPane.this.update();
                                        break block9;
                                    }
                                    catch (DuplicatedNameException e1) {
                                        JOptionPane.showMessageDialog(EntityEditionPane.this.mebnController.getScreen(), resource.getString("nameDuplicated"), resource.getString("nameError"), 0);
                                        break block9;
                                    }
                                    catch (ReservedWordException e2) {
                                        JOptionPane.showMessageDialog(EntityEditionPane.this.mebnController.getScreen(), resource.getString("nameReserved"), resource.getString("nameError"), 0);
                                    }
                                }
                                catch (TypeException typeException) {
                                    JOptionPane.showMessageDialog(null, resource.getString("nameDuplicated"), resource.getString("nameError"), 0);
                                    EntityEditionPane.this.txtName.selectAll();
                                }
                                break block9;
                            }
                            EntityEditionPane.this.txtName.setBackground(MebnToolkit.getColorTextFieldError());
                            EntityEditionPane.this.txtName.setForeground(Color.WHITE);
                            JOptionPane.showMessageDialog(null, resource.getString("nameException"), resource.getString("nameError"), 0);
                            EntityEditionPane.this.txtName.selectAll();
                        }
                        catch (BadLocationException ble) {
                            System.out.println(ble.getMessage());
                        }
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
                try {
                    String name = EntityEditionPane.this.txtName.getText(0, EntityEditionPane.this.txtName.getText().length());
                    EntityEditionPane.this.matcher = EntityEditionPane.this.wordPattern.matcher(name);
                    if (!EntityEditionPane.this.matcher.matches()) {
                        EntityEditionPane.this.txtName.setBackground(MebnToolkit.getColorTextFieldError());
                        EntityEditionPane.this.txtName.setForeground(Color.WHITE);
                    } else {
                        EntityEditionPane.this.txtName.setBackground(MebnToolkit.getColorTextFieldSelected());
                        EntityEditionPane.this.txtName.setForeground(Color.BLACK);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.checkIsOrdereable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                try {
                    EntityEditionPane.this.mebnController.setIsOrdereableObjectEntityProperty(EntityEditionPane.this.selected, checkBox.isSelected());
                }
                catch (ObjectEntityHasInstancesException e1) {
                    JOptionPane.showMessageDialog(null, resource.getString("objectEntityHasInstance"), resource.getString("operationFail"), 0);
                }
            }
        });
        this.jbNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    EntityEditionPane.this.selected = EntityEditionPane.this.mebnController.createObjectEntity();
                    EntityEditionPane.this.update();
                    EntityEditionPane.this.jlEntities.setSelectedValue(EntityEditionPane.this.selected, true);
                    EntityEditionPane.this.txtType.setText(EntityEditionPane.this.selected.getType().getName());
                    EntityEditionPane.this.txtName.setEditable(true);
                    EntityEditionPane.this.checkIsOrdereable.setEnabled(true);
                    EntityEditionPane.this.txtName.setText(EntityEditionPane.this.selected.getName());
                    EntityEditionPane.this.txtName.selectAll();
                    EntityEditionPane.this.txtName.requestFocus();
                }
                catch (TypeException e) {
                    JOptionPane.showMessageDialog(null, resource.getString("nameDuplicated"), resource.getString("nameError"), 0);
                }
            }
        });
        this.jbDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (EntityEditionPane.this.selected != null) {
                    try {
                        EntityEditionPane.this.mebnController.removeObjectEntity(EntityEditionPane.this.selected);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    EntityEditionPane.this.update();
                    EntityEditionPane.this.txtName.setText(" ");
                    EntityEditionPane.this.txtType.setText(" ");
                    EntityEditionPane.this.txtName.setEditable(false);
                    EntityEditionPane.this.checkIsOrdereable.setEnabled(false);
                }
            }
        });
    }
}

