/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.bind.JAXBException;
import unbbayes.aprendizagem.ConstructionController;
import unbbayes.aprendizagem.incrementalLearning.ILBridge;
import unbbayes.controller.ConfigurationsController;
import unbbayes.controller.FileController;
import unbbayes.controller.IconController;
import unbbayes.controller.JavaHelperController;
import unbbayes.controller.MainController;
import unbbayes.gui.AboutPane;
import unbbayes.gui.FileIcon;
import unbbayes.gui.IFileExtensionAwareWindow;
import unbbayes.gui.MDIDesktopPane;
import unbbayes.gui.SimpleFileFilter;
import unbbayes.io.exception.LoadException;
import unbbayes.io.mebn.exceptions.IOMebnException;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.simulation.montecarlo.controller.MCMainController;
import unbbayes.util.Debug;

public class UnBBayesFrame
extends JFrame {
    private static final long serialVersionUID = 0L;
    private MDIDesktopPane desktop;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private JToolBar jtbFile;
    private JToolBar jtbView;
    private JToolBar jtbTools;
    private JToolBar jtbWindow;
    private JToolBar jtbHelp;
    private MainController controller;
    private JButton newNet;
    private JButton newMsbn;
    private JButton newMebn;
    private JButton newOobn;
    private JButton openNet;
    private JButton saveNet;
    private JButton learn;
    private JButton metal;
    private JButton motif;
    private JButton windows;
    private JButton tile;
    private JButton cascade;
    private JButton help;
    private JButton about;
    private URL helpSetURL;
    private HelpSet set;
    private JHelp jHelp;
    private ActionListener alNewBN;
    private ActionListener alTAN;
    private ActionListener alBAN;
    private ActionListener alNewMSBN;
    private ActionListener alNewMEBN;
    private ActionListener alNewOOBN;
    private ActionListener alOpen;
    private ActionListener alSave;
    private ActionListener alExit;
    private ActionListener alTbFile;
    private ActionListener alTbView;
    private ActionListener alTbTools;
    private ActionListener alTbWindow;
    private ActionListener alTbHelp;
    private ActionListener alMetal;
    private ActionListener alMotif;
    private ActionListener alWindows;
    private ActionListener alLearn;
    private ActionListener alCascade;
    private ActionListener alTile;
    private ActionListener alHelp;
    private ActionListener alAbout;
    private ActionListener alMonteCarlo;
    private ActionListener alGibbs;
    private ActionListener alIL;
    private JFileChooser chooser;
    private FileController fileController;
    protected IconController iconController = IconController.getInstance();
    private static UnBBayesFrame singleton = null;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    public UnBBayesFrame(MainController _controller) {
        super(resource.getString("unbbayesTitle"));
        this.controller = _controller;
        this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new ListenerCloserFrame());
        this.fileController = FileController.getInstance();
        Container contentPane = this.getContentPane();
        this.desktop = new MDIDesktopPane();
        this.topPanel = new JPanel(new FlowLayout(0));
        this.bottomPanel = new JPanel(new FlowLayout(0, 5, 1));
        this.createActionListeners();
        this.createMenu();
        this.createToolBars();
        this.assignActionListeners();
        contentPane.add((Component)this.topPanel, "North");
        contentPane.add((Component)new JScrollPane(this.desktop), "Center");
        contentPane.add((Component)this.bottomPanel, "South");
        this.setIconImage(this.iconController.getUnBBayesIcon().getImage());
        this.setLocationByPlatform(true);
        this.setExtendedState(6);
        this.setVisible(true);
        singleton = this;
    }

    private void setLnF(String lnfName) {
        try {
            UIManager.setLookAndFeel(lnfName);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (UnsupportedLookAndFeelException ex1) {
            System.err.println(String.valueOf(resource.getString("LookAndFeelUnsupportedException")) + lnfName);
        }
        catch (ClassNotFoundException ex2) {
            System.err.println(String.valueOf(resource.getString("LookAndFeelClassNotFoundException")) + lnfName);
        }
        catch (InstantiationException ex3) {
            System.err.println(String.valueOf(resource.getString("LookAndFeelInstantiationException")) + lnfName);
        }
        catch (IllegalAccessException ex4) {
            System.err.println(String.valueOf(resource.getString("LookAndFeelIllegalAccessException")) + lnfName);
        }
    }

    public JInternalFrame getSelectedWindow() {
        return this.desktop.getSelectedFrame();
    }

    public void addWindow(JInternalFrame newWindow) {
        this.desktop.add(newWindow);
    }

    public void createActionListeners() {
        this.alNewBN = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                UnBBayesFrame.this.controller.newPN();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alNewMSBN = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                UnBBayesFrame.this.controller.newMSBN();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alNewMEBN = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                UnBBayesFrame.this.controller.newMEBN();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alNewOOBN = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                UnBBayesFrame.this.controller.newOOBN();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alTAN = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String[] nets = new String[]{"txt"};
                int classe = 0;
                UnBBayesFrame.this.chooser = new JFileChooser(UnBBayesFrame.this.fileController.getCurrentDirectory());
                UnBBayesFrame.this.chooser.setMultiSelectionEnabled(false);
                UnBBayesFrame.this.chooser.addChoosableFileFilter(new SimpleFileFilter(nets, resource.getString("textFileFilter")));
                int option = UnBBayesFrame.this.chooser.showOpenDialog(UnBBayesFrame.this);
                if (option == 0) {
                    File file = UnBBayesFrame.this.chooser.getSelectedFile();
                    UnBBayesFrame.this.fileController.setCurrentDirectory(UnBBayesFrame.this.chooser.getCurrentDirectory());
                    try {
                        new ConstructionController(file, UnBBayesFrame.this.controller, classe);
                    }
                    catch (InvalidParentException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.alBAN = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String[] nets = new String[]{"txt"};
                int classe = 0;
                UnBBayesFrame.this.chooser = new JFileChooser(UnBBayesFrame.this.fileController.getCurrentDirectory());
                UnBBayesFrame.this.chooser.setMultiSelectionEnabled(false);
                UnBBayesFrame.this.chooser.addChoosableFileFilter(new SimpleFileFilter(nets, resource.getString("textFileFilter")));
                int option = UnBBayesFrame.this.chooser.showOpenDialog(UnBBayesFrame.this);
                if (option == 0) {
                    File file = UnBBayesFrame.this.chooser.getSelectedFile();
                    UnBBayesFrame.this.fileController.setCurrentDirectory(UnBBayesFrame.this.chooser.getCurrentDirectory());
                    try {
                        new ConstructionController(file, UnBBayesFrame.this.controller, classe, true);
                    }
                    catch (InvalidParentException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.alOpen = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                String[] nets = new String[]{"net", "xml", "owl", "ubf", "oobn"};
                UnBBayesFrame.this.chooser = new JFileChooser(UnBBayesFrame.this.fileController.getCurrentDirectory());
                UnBBayesFrame.this.chooser.setDialogTitle(resource.getString("openTitle"));
                UnBBayesFrame.this.chooser.setMultiSelectionEnabled(false);
                UnBBayesFrame.this.chooser.setFileSelectionMode(2);
                UnBBayesFrame.this.chooser.setFileView(new FileIcon(UnBBayesFrame.this));
                UnBBayesFrame.this.chooser.addChoosableFileFilter(new SimpleFileFilter(nets, resource.getString("netFileFilter")));
                int option = UnBBayesFrame.this.chooser.showOpenDialog(UnBBayesFrame.this);
                if (option == 0 && UnBBayesFrame.this.chooser.getSelectedFile() != null) {
                    UnBBayesFrame.this.chooser.setVisible(false);
                    UnBBayesFrame.this.repaint();
                    File file = UnBBayesFrame.this.chooser.getSelectedFile();
                    UnBBayesFrame.this.fileController.setCurrentDirectory(UnBBayesFrame.this.chooser.getCurrentDirectory());
                    UnBBayesFrame.this.chooser.setVisible(false);
                    UnBBayesFrame.this.chooser.setEnabled(false);
                    try {
                        UnBBayesFrame.this.controller.loadNet(file);
                    }
                    catch (LoadException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(UnBBayesFrame.this, e.getMessage(), resource.getString("loadNetException"), 0);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(UnBBayesFrame.this, e.getMessage(), resource.getString("loadNetException"), 0);
                    }
                    catch (IOMebnException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(UnBBayesFrame.this, e.getMessage(), resource.getString("loadNetException"), 0);
                    }
                    catch (JAXBException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(UnBBayesFrame.this, resource.getString("JAXBExceptionFound"), resource.getString("loadNetException"), 0);
                    }
                }
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alSave = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                File file;
                UnBBayesFrame.this.setCursor(new Cursor(3));
                String[] nets = null;
                String filterMessage = null;
                String dialogueTitle = null;
                JInternalFrame focusedInnerFrame = UnBBayesFrame.this.desktop.getSelectedFrame();
                if (focusedInnerFrame != null) {
                    if (focusedInnerFrame instanceof IFileExtensionAwareWindow) {
                        IFileExtensionAwareWindow currentWindow = (IFileExtensionAwareWindow)((Object)focusedInnerFrame);
                        nets = currentWindow.getSupportedFileExtensions();
                        filterMessage = currentWindow.getSupportedFilesDescription();
                        dialogueTitle = currentWindow.getSavingMessage();
                    } else {
                        nets = new String[]{"net", "xml"};
                        filterMessage = resource.getString("netFileFilterSave");
                        dialogueTitle = resource.getString("saveTitle");
                        Debug.println(this.getClass(), "Unknown desktop internal window was found");
                    }
                } else {
                    Debug.println(this.getClass(), "No focused window to save.");
                    UnBBayesFrame.this.setCursor(new Cursor(0));
                    return;
                }
                UnBBayesFrame.this.chooser = new JFileChooser(UnBBayesFrame.this.fileController.getCurrentDirectory());
                UnBBayesFrame.this.chooser.setMultiSelectionEnabled(false);
                UnBBayesFrame.this.chooser.setFileSelectionMode(2);
                UnBBayesFrame.this.chooser.setDialogTitle(dialogueTitle);
                UnBBayesFrame.this.chooser.setFileView(new FileIcon(UnBBayesFrame.this));
                UnBBayesFrame.this.chooser.addChoosableFileFilter(new SimpleFileFilter(nets, filterMessage));
                int option = UnBBayesFrame.this.chooser.showSaveDialog(null);
                if (option == 0 && (file = UnBBayesFrame.this.chooser.getSelectedFile()) != null) {
                    file.isFile();
                    try {
                        if (UnBBayesFrame.this.controller.saveNet(file)) {
                            JOptionPane.showMessageDialog(UnBBayesFrame.this, resource.getString("saveSucess"), resource.getString("sucess"), 2);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(UnBBayesFrame.this, e.getMessage(), resource.getString("error"), 0);
                        e.printStackTrace();
                    }
                }
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alExit = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UnBBayesFrame.this.setVisible(false);
                UnBBayesFrame.this.dispose();
                System.exit(0);
            }
        };
        this.alLearn = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String[] nets = new String[]{"txt"};
                UnBBayesFrame.this.chooser = new JFileChooser(UnBBayesFrame.this.fileController.getCurrentDirectory());
                UnBBayesFrame.this.chooser.setMultiSelectionEnabled(false);
                UnBBayesFrame.this.chooser.addChoosableFileFilter(new SimpleFileFilter(nets, resource.getString("textFileFilter")));
                int option = UnBBayesFrame.this.chooser.showOpenDialog(UnBBayesFrame.this);
                if (option == 0) {
                    File file = UnBBayesFrame.this.chooser.getSelectedFile();
                    UnBBayesFrame.this.fileController.setCurrentDirectory(UnBBayesFrame.this.chooser.getCurrentDirectory());
                    new ConstructionController(file, UnBBayesFrame.this.controller);
                }
            }
        };
        this.alIL = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                new ILBridge(UnBBayesFrame.this.controller);
            }
        };
        this.alMonteCarlo = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                new MCMainController();
            }
        };
        this.alGibbs = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
            }
        };
        this.alTbFile = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    UnBBayesFrame.this.topPanel.add(UnBBayesFrame.this.jtbFile);
                } else {
                    UnBBayesFrame.this.topPanel.remove(UnBBayesFrame.this.jtbFile);
                }
                UnBBayesFrame.this.validate();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alTbView = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    UnBBayesFrame.this.topPanel.add(UnBBayesFrame.this.jtbView);
                } else {
                    UnBBayesFrame.this.topPanel.remove(UnBBayesFrame.this.jtbView);
                }
                UnBBayesFrame.this.validate();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alTbTools = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    UnBBayesFrame.this.topPanel.add(UnBBayesFrame.this.jtbTools);
                } else {
                    UnBBayesFrame.this.topPanel.remove(UnBBayesFrame.this.jtbTools);
                }
                UnBBayesFrame.this.validate();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alTbWindow = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    UnBBayesFrame.this.topPanel.add(UnBBayesFrame.this.jtbWindow);
                } else {
                    UnBBayesFrame.this.topPanel.remove(UnBBayesFrame.this.jtbWindow);
                }
                UnBBayesFrame.this.validate();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alTbHelp = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    UnBBayesFrame.this.topPanel.add(UnBBayesFrame.this.jtbHelp);
                } else {
                    UnBBayesFrame.this.topPanel.remove(UnBBayesFrame.this.jtbHelp);
                }
                UnBBayesFrame.this.validate();
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alMetal = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                UnBBayesFrame.this.setLnF("javax.swing.plaf.metal.MetalLookAndFeel");
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alMotif = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                UnBBayesFrame.this.setLnF("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alWindows = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.setCursor(new Cursor(3));
                UnBBayesFrame.this.setLnF("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                UnBBayesFrame.this.setCursor(new Cursor(0));
            }
        };
        this.alCascade = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.desktop.cascadeFrames();
            }
        };
        this.alTile = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnBBayesFrame.this.desktop.tileFrames();
            }
        };
        this.alHelp = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    JavaHelperController.getInstance().openHelp(singleton);
                }
                catch (Exception evt) {
                    System.out.println("Error= " + evt.getMessage() + " " + this.getClass().getName());
                    evt.printStackTrace();
                }
            }
        };
        this.alAbout = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        UnBBayesFrame.this.showAboutPane();
                    }
                });
            }
        };
    }

    private void showAboutPane() {
        AboutPane abourPane = new AboutPane();
        abourPane.pack();
        abourPane.setVisible(true);
    }

    public void createMenu() {
        JMenuBar menu = new JMenuBar();
        JMenu fileMenu = new JMenu(resource.getString("fileMenu"));
        JMenu recentFilesMenu = new JMenu(resource.getString("recentFilesMenu"));
        JMenu lafMenu = new JMenu(resource.getString("lafMenu"));
        JMenu viewMenu = new JMenu(resource.getString("viewMenu"));
        JMenu tbMenu = new JMenu(resource.getString("tbMenu"));
        JMenu newMenu = new JMenu(resource.getString("newMenu"));
        JMenu toolsMenu = new JMenu(resource.getString("toolsMenu"));
        JMenu windowMenu = new JMenu(resource.getString("windowMenu"));
        JMenu helpMenu = new JMenu(resource.getString("helpMenu"));
        fileMenu.setMnemonic(resource.getString("fileMenuMn").charAt(0));
        recentFilesMenu.setMnemonic(resource.getString("recentFilesMn").charAt(0));
        newMenu.setMnemonic(resource.getString("newMenuMn").charAt(0));
        lafMenu.setMnemonic(resource.getString("lafMenuMn").charAt(0));
        viewMenu.setMnemonic(resource.getString("viewMenuMn").charAt(0));
        tbMenu.setMnemonic(resource.getString("tbMenuMn").charAt(0));
        toolsMenu.setMnemonic(resource.getString("toolsMenuMn").charAt(0));
        windowMenu.setMnemonic(resource.getString("windowMenuMn").charAt(0));
        helpMenu.setMnemonic(resource.getString("helpMenuMn").charAt(0));
        JMenuItem newBN = new JMenuItem(resource.getString("newBN"), this.iconController.getNewIcon());
        JMenuItem newMSBN = new JMenuItem(resource.getString("newMSBN"), this.iconController.getNewIcon());
        JMenuItem newMEBN = new JMenuItem(resource.getString("newMEBN"), this.iconController.getNewIcon());
        JMenuItem newOOBN = new JMenuItem(resource.getString("newOOBN"), this.iconController.getNewIcon());
        newBN.setMnemonic(resource.getString("newBNMn").charAt(0));
        newMSBN.setMnemonic(resource.getString("newMSBNMn").charAt(0));
        newMEBN.setMnemonic(resource.getString("newMEBNMn").charAt(0));
        newOOBN.setMnemonic(resource.getString("newOOBNMn").charAt(0));
        JMenuItem openItem = new JMenuItem(resource.getString("openItem"), this.iconController.getOpenIcon());
        JMenuItem saveItem = new JMenuItem(resource.getString("saveItem"), this.iconController.getSaveIcon());
        JMenuItem exitItem = new JMenuItem(resource.getString("exitItem"), 88);
        JCheckBoxMenuItem tbFile = new JCheckBoxMenuItem(resource.getString("tbFile"), true);
        JCheckBoxMenuItem tbView = new JCheckBoxMenuItem(resource.getString("tbView"), true);
        JCheckBoxMenuItem tbTools = new JCheckBoxMenuItem(resource.getString("tbTools"), true);
        JCheckBoxMenuItem tbWindow = new JCheckBoxMenuItem(resource.getString("tbWindow"), true);
        JCheckBoxMenuItem tbHelp = new JCheckBoxMenuItem(resource.getString("tbHelp"), true);
        JMenuItem metalItem = new JMenuItem(resource.getString("metalItem"), this.iconController.getMetalIcon());
        JMenuItem motifItem = new JMenuItem(resource.getString("motifItem"), this.iconController.getMotifIcon());
        JMenuItem windowsItem = new JMenuItem(resource.getString("windowsItem"), this.iconController.getWindowsIcon());
        JMenuItem cascadeItem = new JMenuItem(resource.getString("cascadeItem"), this.iconController.getCascadeIcon());
        JMenuItem tileItem = new JMenuItem(resource.getString("tileItem"), this.iconController.getTileIcon());
        JMenuItem helpItem = new JMenuItem(resource.getString("helpItem"), this.iconController.getHelpIcon());
        JMenuItem aboutItem = new JMenuItem(resource.getString("aboutItem"));
        openItem.setMnemonic(resource.getString("openItemMn").charAt(0));
        saveItem.setMnemonic(resource.getString("saveItemMn").charAt(0));
        exitItem.setMnemonic(resource.getString("exitItemMn").charAt(0));
        metalItem.setMnemonic(resource.getString("metalItemMn").charAt(0));
        motifItem.setMnemonic(resource.getString("motifItemMn").charAt(0));
        windowsItem.setMnemonic(resource.getString("windowsItemMn").charAt(0));
        cascadeItem.setMnemonic(resource.getString("cascadeItemMn").charAt(0));
        tileItem.setMnemonic(resource.getString("tileItemMn").charAt(0));
        helpItem.setMnemonic(resource.getString("helpItemMn").charAt(0));
        aboutItem.setMnemonic(resource.getString("aboutItemMn").charAt(0));
        newBN.setAccelerator(KeyStroke.getKeyStroke(resource.getString("newItemMn").charAt(0), 2, false));
        openItem.setAccelerator(KeyStroke.getKeyStroke(resource.getString("openItemMn").charAt(0), 2, false));
        saveItem.setAccelerator(KeyStroke.getKeyStroke(resource.getString("saveItemMn").charAt(0), 2, false));
        helpItem.setAccelerator(KeyStroke.getKeyStroke(resource.getString("helpItemMn").charAt(0), 2, false));
        JMenuItem learningItem = new JMenuItem(resource.getString("learningItem"), this.iconController.getLearningIcon());
        JMenuItem tanItem = new JMenuItem(resource.getString("tanItem"));
        JMenuItem banItem = new JMenuItem(resource.getString("banItem"));
        JMenuItem monteCarloItem = new JMenuItem(resource.getString("monteCarloItem"));
        JMenuItem gibbsItem = new JMenuItem(resource.getString("GibbsItem"));
        JMenuItem iLearningItem = new JMenuItem(resource.getString("ILearningItem"));
        learningItem.setMnemonic(resource.getString("learningItemMn").charAt(0));
        tanItem.setMnemonic(resource.getString("tanItemMn").charAt(0));
        banItem.setMnemonic(resource.getString("banItemMn").charAt(0));
        monteCarloItem.setMnemonic(resource.getString("monteCarloItemMn").charAt(0));
        gibbsItem.setMnemonic(resource.getString("GibbsItemMn").charAt(0));
        iLearningItem.setMnemonic(resource.getString("ILearningItemMn").charAt(0));
        learningItem.setAccelerator(KeyStroke.getKeyStroke(resource.getString("learningItemMn").charAt(0), 2, false));
        newBN.addActionListener(this.alNewBN);
        newMSBN.addActionListener(this.alNewMSBN);
        newMEBN.addActionListener(this.alNewMEBN);
        newOOBN.addActionListener(this.alNewOOBN);
        openItem.addActionListener(this.alOpen);
        saveItem.addActionListener(this.alSave);
        exitItem.addActionListener(this.alExit);
        tbFile.addActionListener(this.alTbFile);
        tbView.addActionListener(this.alTbView);
        tbTools.addActionListener(this.alTbTools);
        tbWindow.addActionListener(this.alTbWindow);
        tbHelp.addActionListener(this.alTbHelp);
        metalItem.addActionListener(this.alMetal);
        motifItem.addActionListener(this.alMotif);
        windowsItem.addActionListener(this.alWindows);
        learningItem.addActionListener(this.alLearn);
        cascadeItem.addActionListener(this.alCascade);
        tileItem.addActionListener(this.alTile);
        helpItem.addActionListener(this.alHelp);
        monteCarloItem.addActionListener(this.alMonteCarlo);
        iLearningItem.addActionListener(this.alIL);
        gibbsItem.addActionListener(this.alGibbs);
        aboutItem.addActionListener(this.alAbout);
        tanItem.addActionListener(this.alTAN);
        banItem.addActionListener(this.alBAN);
        newMenu.add(newBN);
        newMenu.add(newMSBN);
        newMenu.add(newMEBN);
        newMenu.add(newOOBN);
        fileMenu.add(newMenu);
        fileMenu.add(openItem);
        fileMenu.add(saveItem);
        fileMenu.addSeparator();
        fileMenu.add(recentFilesMenu);
        ConfigurationsController configController = ConfigurationsController.getInstance();
        for (String nameOfFile : configController.getConfigurations().getPreviewOpenFiles()) {
            File file = new File(nameOfFile);
            JMenuItem fileMenuItem = new JMenuItem(nameOfFile);
            fileMenuItem.addActionListener(new OpenFileListener(file));
            recentFilesMenu.add(fileMenuItem);
        }
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        lafMenu.add(metalItem);
        lafMenu.add(motifItem);
        lafMenu.add(windowsItem);
        tbMenu.add(tbFile);
        tbMenu.add(tbView);
        tbMenu.add(tbTools);
        tbMenu.add(tbWindow);
        tbMenu.add(tbHelp);
        viewMenu.add(tbMenu);
        viewMenu.addSeparator();
        viewMenu.add(lafMenu);
        toolsMenu.add(learningItem);
        toolsMenu.add(tanItem);
        toolsMenu.add(banItem);
        toolsMenu.add(monteCarloItem);
        toolsMenu.add(gibbsItem);
        toolsMenu.add(iLearningItem);
        windowMenu.add(cascadeItem);
        windowMenu.add(tileItem);
        helpMenu.add(helpItem);
        helpMenu.add(aboutItem);
        menu.add(fileMenu);
        menu.add(viewMenu);
        menu.add(toolsMenu);
        menu.add(windowMenu);
        menu.add(helpMenu);
        this.setJMenuBar(menu);
    }

    public void createToolBars() {
        this.createButtons();
        this.jtbFile = new JToolBar();
        this.jtbView = new JToolBar();
        this.jtbTools = new JToolBar();
        this.jtbWindow = new JToolBar();
        this.jtbHelp = new JToolBar();
        this.jtbFile.add(this.newNet);
        this.jtbFile.add(this.newMsbn);
        this.jtbFile.add(this.newMebn);
        this.jtbFile.add(this.newOobn);
        this.jtbFile.add(this.openNet);
        this.jtbFile.add(this.saveNet);
        this.jtbTools.add(this.learn);
        this.jtbView.add(this.metal);
        this.jtbView.add(this.motif);
        this.jtbView.add(this.windows);
        this.jtbWindow.add(this.cascade);
        this.jtbWindow.add(this.tile);
        this.jtbHelp.add(this.help);
        this.topPanel.add(this.jtbFile);
        this.topPanel.add(this.jtbView);
        this.topPanel.add(this.jtbTools);
        this.topPanel.add(this.jtbWindow);
        this.topPanel.add(this.jtbHelp);
    }

    public void createButtons() {
        this.newNet = new JButton(this.iconController.getNewBNIcon());
        this.newMsbn = new JButton(this.iconController.getNewMSBNIcon());
        this.newMebn = new JButton(this.iconController.getNewMEBNIcon());
        this.newOobn = new JButton(this.iconController.getNewOOBNIcon());
        this.openNet = new JButton(this.iconController.getOpenIcon());
        this.saveNet = new JButton(this.iconController.getSaveIcon());
        this.learn = new JButton(this.iconController.getLearningIcon());
        this.metal = new JButton(this.iconController.getMetalIcon());
        this.motif = new JButton(this.iconController.getMotifIcon());
        this.windows = new JButton(this.iconController.getWindowsIcon());
        this.tile = new JButton(this.iconController.getTileIcon());
        this.cascade = new JButton(this.iconController.getCascadeIcon());
        this.help = new JButton(this.iconController.getHelpIcon());
        this.help.setToolTipText(resource.getString("helpToolTip"));
        this.newNet.setToolTipText(resource.getString("newToolTip"));
        this.newMsbn.setToolTipText(resource.getString("newMsbnToolTip"));
        this.newMebn.setToolTipText(resource.getString("newMebnToolTip"));
        this.newOobn.setToolTipText(resource.getString("newOobnToolTip"));
        this.openNet.setToolTipText(resource.getString("openToolTip"));
        this.saveNet.setToolTipText(resource.getString("saveToolTip"));
        this.learn.setToolTipText(resource.getString("learningToolTip"));
        this.metal.setToolTipText(resource.getString("metalToolTip"));
        this.motif.setToolTipText(resource.getString("motifToolTip"));
        this.windows.setToolTipText(resource.getString("windowsToolTip"));
        this.tile.setToolTipText(resource.getString("tileToolTip"));
        this.cascade.setToolTipText(resource.getString("cascadeToolTip"));
    }

    public void assignActionListeners() {
        this.newNet.addActionListener(this.alNewBN);
        this.newMsbn.addActionListener(this.alNewMSBN);
        this.newMebn.addActionListener(this.alNewMEBN);
        this.newOobn.addActionListener(this.alNewOOBN);
        this.openNet.addActionListener(this.alOpen);
        this.saveNet.addActionListener(this.alSave);
        this.metal.addActionListener(this.alMetal);
        this.motif.addActionListener(this.alMotif);
        this.windows.addActionListener(this.alWindows);
        this.learn.addActionListener(this.alLearn);
        this.tile.addActionListener(this.alTile);
        this.cascade.addActionListener(this.alCascade);
        this.help.addActionListener(this.alHelp);
    }

    public static UnBBayesFrame getIUnBBayes() {
        return singleton;
    }

    public class ListenerCloserFrame
    implements WindowListener {
        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            try {
                UnBBayesFrame.this.controller.saveConfigurations();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }
    }

    private class OpenFileListener
    implements ActionListener {
        private final File file;

        OpenFileListener(File file) {
            this.file = file;
        }

        public void actionPerformed(ActionEvent ae) {
            UnBBayesFrame.this.setCursor(new Cursor(3));
            try {
                UnBBayesFrame.this.controller.loadNet(this.file);
            }
            catch (LoadException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(UnBBayesFrame.this, e.getMessage(), resource.getString("loadNetException"), 0);
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(UnBBayesFrame.this, e.getMessage(), resource.getString("loadNetException"), 0);
            }
            catch (IOMebnException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(UnBBayesFrame.this, e.getMessage(), resource.getString("loadNetException"), 0);
            }
            catch (JAXBException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(UnBBayesFrame.this, resource.getString("JAXBExceptionFound"), resource.getString("loadNetException"), 0);
            }
            UnBBayesFrame.this.setCursor(new Cursor(0));
        }
    }
}

