/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.xml.bind.JAXBException;
import unbbayes.controller.FileController;
import unbbayes.controller.IconController;
import unbbayes.controller.NetworkController;
import unbbayes.gui.EvidenceTree;
import unbbayes.gui.NetworkWindow;
import unbbayes.io.BaseIO;
import unbbayes.io.NetIO;
import unbbayes.io.XMLBIFIO;
import unbbayes.prs.bn.SingleEntityNetwork;

public class SSBNCompilationPane
extends JPanel {
    private static final long serialVersionUID = 0L;
    private final NetworkWindow netWindow;
    private EvidenceTree evidenceTree;
    private final NetworkController controller;
    private final JScrollPane jspTree;
    private final JSplitPane centerPanel;
    private final JLabel status;
    private final JPanel bottomPanel;
    private final JPanel topPanel;
    private final JToolBar jtbCompilation;
    private final JButton propagate;
    private final JButton expand;
    private final JButton collapse;
    private final JButton editMode;
    private final JButton log;
    private final JButton reset;
    private final JButton printNet;
    private final JButton previewNet;
    private final JButton saveNetImage;
    private final JButton saveNet;
    private final JButton showWarningDialog;
    private final SingleEntityNetwork network;
    private final IconController iconController = IconController.getInstance();
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    public SSBNCompilationPane() {
        this.editMode = null;
        this.log = null;
        this.netWindow = null;
        this.controller = null;
        this.jspTree = null;
        this.centerPanel = null;
        this.bottomPanel = null;
        this.topPanel = null;
        this.jtbCompilation = null;
        this.status = null;
        this.propagate = null;
        this.expand = null;
        this.collapse = null;
        this.reset = null;
        this.printNet = null;
        this.previewNet = null;
        this.saveNetImage = null;
        this.saveNet = null;
        this.network = null;
        this.showWarningDialog = null;
    }

    public SSBNCompilationPane(SingleEntityNetwork sen, NetworkWindow _netWindow, NetworkController _controller) {
        this.netWindow = _netWindow;
        this.controller = _controller;
        this.setLayout(new BorderLayout());
        this.network = sen;
        this.topPanel = new JPanel(new GridLayout(0, 1));
        this.jtbCompilation = new JToolBar();
        this.centerPanel = new JSplitPane(1);
        this.evidenceTree = new EvidenceTree(sen, this.netWindow);
        this.jspTree = new JScrollPane(this.evidenceTree);
        this.bottomPanel = new JPanel(new FlowLayout(0, 5, 1));
        this.status = new JLabel(resource.getString("statusReadyLabel"));
        this.propagate = new JButton(this.iconController.getPropagateIcon());
        this.expand = new JButton(this.iconController.getExpandIcon());
        this.collapse = new JButton(this.iconController.getColapseIcon());
        this.editMode = new JButton(this.iconController.getEditIcon());
        this.log = new JButton(this.iconController.getInformationIcon());
        this.reset = new JButton(this.iconController.getInitializeIcon());
        this.printNet = new JButton(this.iconController.getPrintNetIcon());
        this.previewNet = new JButton(this.iconController.getPrintPreviewNetIcon());
        this.saveNetImage = new JButton(this.iconController.getSaveNetIcon());
        this.saveNet = new JButton(this.iconController.getSaveIcon());
        this.showWarningDialog = new JButton(this.iconController.getWarningIcon());
        this.propagate.setToolTipText(resource.getString("propagateToolTip"));
        this.expand.setToolTipText(resource.getString("expandToolTip"));
        this.collapse.setToolTipText(resource.getString("collapseToolTip"));
        this.editMode.setToolTipText(resource.getString("editToolTip"));
        this.log.setToolTipText(resource.getString("logToolTip"));
        this.reset.setToolTipText(resource.getString("resetCrencesToolTip"));
        this.saveNet.setToolTipText(resource.getString("saveSSBNToolTip"));
        this.showWarningDialog.setToolTipText(resource.getString("openWarningDialogToolTip"));
        this.log.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SSBNCompilationPane.this.controller.showLog();
                SSBNCompilationPane.this.netWindow.getGraphPane().update();
            }
        });
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SSBNCompilationPane.this.controller.initialize();
            }
        });
        this.editMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SSBNCompilationPane.this.netWindow.changeToMEBNEditionPane();
            }
        });
        this.propagate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SSBNCompilationPane.this.controller.propagate();
            }
        });
        this.collapse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SSBNCompilationPane.this.setCursor(new Cursor(3));
                SSBNCompilationPane.this.evidenceTree.collapseTree();
                SSBNCompilationPane.this.setCursor(new Cursor(0));
            }
        });
        this.expand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SSBNCompilationPane.this.setCursor(new Cursor(3));
                SSBNCompilationPane.this.evidenceTree.expandTree();
                SSBNCompilationPane.this.setCursor(new Cursor(0));
            }
        });
        this.printNet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SSBNCompilationPane.this.controller.printNet(SSBNCompilationPane.this.netWindow.getGraphPane(), SSBNCompilationPane.this.controller.calculateNetRectangle());
            }
        });
        this.previewNet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SSBNCompilationPane.this.controller.previewPrintNet(SSBNCompilationPane.this.netWindow.getGraphPane(), SSBNCompilationPane.this.controller.calculateNetRectangle());
            }
        });
        this.saveNetImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SSBNCompilationPane.this.controller.saveNetImage();
            }
        });
        this.saveNet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File file;
                SSBNCompilationPane.this.setCursor(new Cursor(3));
                JFileChooser chooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileSelectionMode(0);
                int option = chooser.showSaveDialog(null);
                if (option == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
                    BaseIO io = null;
                    String name = file.getName().toLowerCase();
                    if (name.endsWith("net")) {
                        io = new NetIO();
                        try {
                            io.save(file, SSBNCompilationPane.this.network);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        catch (JAXBException e1) {
                            e1.printStackTrace();
                        }
                    } else if (name.endsWith("xml")) {
                        io = new XMLBIFIO();
                        try {
                            io.save(file, SSBNCompilationPane.this.network);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        catch (JAXBException e1) {
                            e1.printStackTrace();
                        }
                    }
                    try {
                        if (io != null) {
                            io.save(file, SSBNCompilationPane.this.network);
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    catch (JAXBException e1) {
                        e1.printStackTrace();
                    }
                    JOptionPane.showMessageDialog(SSBNCompilationPane.this.controller.getScreen(), "Arquivo salvo com sucesso");
                }
                SSBNCompilationPane.this.setCursor(new Cursor(0));
            }
        });
        this.showWarningDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SSBNCompilationPane.this.controller.openWarningDialog();
            }
        });
        this.jtbCompilation.addSeparator();
        this.jtbCompilation.add(this.collapse);
        this.jtbCompilation.add(this.expand);
        this.jtbCompilation.add(this.propagate);
        this.jtbCompilation.addSeparator();
        this.jtbCompilation.add(this.reset);
        this.jtbCompilation.addSeparator();
        this.jtbCompilation.add(this.editMode);
        this.jtbCompilation.add(this.log);
        this.jtbCompilation.add(this.showWarningDialog);
        this.jtbCompilation.addSeparator();
        this.jtbCompilation.add(this.saveNet);
        this.topPanel.add(this.jtbCompilation);
        this.centerPanel.setLeftComponent(this.jspTree);
        this.centerPanel.setDividerSize(3);
        this.centerPanel.resetToPreferredSizes();
        this.bottomPanel.add(this.status);
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.bottomPanel, "South");
        this.setVisible(true);
    }

    public JScrollPane getJspTree() {
        return this.jspTree;
    }

    public void setStatus(String status) {
        this.status.setText(status);
    }

    public EvidenceTree getEvidenceTree() {
        return this.evidenceTree;
    }

    public JSplitPane getCenterPanel() {
        return this.centerPanel;
    }

    public JButton getCollapse() {
        return this.collapse;
    }

    public JButton getExpand() {
        return this.expand;
    }

    public JButton getPropagate() {
        return this.propagate;
    }

    public JButton getReset() {
        return this.reset;
    }
}

