/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.AttributedString;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import unbbayes.gui.GlobalOptionsDialog;

public class PreviewPane
extends JPanel {
    private static final long serialVersionUID = 0L;
    private GlobalOptionsDialog og;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    public PreviewPane(GlobalOptionsDialog og) {
        this.og = og;
    }

    public Point2D.Double getPoint(double x1, double y1, double x2, double y2, double radius) {
        double x = 0.0;
        double y = 0.0;
        if (x2 < x1) {
            x = Math.abs(radius * Math.cos(Math.atan((y2 - y1) / (x2 - x1))) - x1);
            y = Math.abs(radius * Math.sin(Math.atan((y2 - y1) / (x2 - x1))) - y1);
        } else {
            x = Math.abs(radius * Math.cos(Math.atan((y2 - y1) / (x2 - x1))) + x1);
            y = Math.abs(radius * Math.sin(Math.atan((y2 - y1) / (x2 - x1))) + y1);
        }
        return new Point2D.Double(x, y);
    }

    public GeneralPath drawArrow(double x, double y, double x1, double y1) {
        double y4;
        double x4;
        double y3;
        double x3;
        Point2D.Double point1 = new Point2D.Double();
        Point2D.Double point2 = new Point2D.Double();
        GeneralPath arrow = new GeneralPath();
        double radius = this.og.getRadius();
        point1 = this.getPoint(x1 + radius, y1 + radius, x + radius, y + radius, radius + 10.0);
        point2 = this.getPoint(x1 + radius, y1 + radius, x + radius, y + radius, radius);
        double x2 = point2.getX();
        double y2 = point2.getY();
        if (x > x1 && y > y1 || x < x1 && y < y1) {
            x3 = point1.getX() + 5.0 * Math.abs(Math.cos(Math.atan((x1 - x) / (y - y1))));
            y3 = point1.getY() - 5.0 * Math.abs(Math.sin(Math.atan((x1 - x) / (y - y1))));
            x4 = point1.getX() - 5.0 * Math.abs(Math.cos(Math.atan((x1 - x) / (y - y1))));
            y4 = point1.getY() + 5.0 * Math.abs(Math.sin(Math.atan((x1 - x) / (y - y1))));
        } else {
            x3 = point1.getX() + 5.0 * Math.cos(Math.atan((x + radius - x2) / (y + radius - y2)));
            y3 = point1.getY() - 5.0 * Math.sin(Math.atan((x + radius - x2) / (y + radius - y2)));
            x4 = point1.getX() - 5.0 * Math.cos(Math.atan((x + radius - x2) / (y + radius - y2)));
            y4 = point1.getY() + 5.0 * Math.sin(Math.atan((x + radius - x2) / (y + radius - y2)));
        }
        arrow.moveTo((float)x3, (float)y3);
        arrow.lineTo((float)x2, (float)y2);
        arrow.lineTo((float)x4, (float)y4);
        arrow.lineTo((float)x3, (float)y3);
        return arrow;
    }

    private GeneralPath drawUtility(double x, double y) {
        GeneralPath utility = new GeneralPath();
        double radius = this.og.getRadius();
        utility.moveTo((float)(x - radius), (float)y);
        utility.lineTo((float)x, (float)(y + radius));
        utility.lineTo((float)(x + radius), (float)y);
        utility.lineTo((float)x, (float)(y - radius));
        utility.lineTo((float)(x - radius), (float)y);
        return utility;
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setBackground(this.og.getBackgroundColor());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.clearRect(3, 17, this.getWidth() - 6, this.getHeight() - 20);
        Point2D.Double point1 = null;
        Point2D.Double point2 = null;
        double radius = this.og.getRadius();
        g2.setColor(this.og.getPropabilisticDescriptionNodeColor());
        g2.fill(new Ellipse2D.Double((double)(this.getWidth() / 2) - radius, (double)(this.getHeight() / 5) - radius + 10.0, radius * 2.0, radius * 2.0));
        g2.fill(new Ellipse2D.Double((double)(this.getWidth() / 4) - radius, (double)(this.getHeight() * 2 / 5) - radius + 10.0, radius * 2.0, radius * 2.0));
        g2.setColor(this.og.getUtilityNodeColor());
        g2.fill(this.drawUtility(this.getWidth() * 3 / 4, this.getHeight() * 2 / 5 + 10));
        g2.setColor(this.og.getArcColor());
        g2.draw(new Ellipse2D.Double((double)(this.getWidth() / 2) - radius, (double)(this.getHeight() / 5) - radius + 10.0, radius * 2.0, radius * 2.0));
        g2.draw(new Ellipse2D.Double((double)(this.getWidth() / 4) - radius, (double)(this.getHeight() * 2 / 5) - radius + 10.0, radius * 2.0, radius * 2.0));
        g2.setColor(this.og.getSelectionColor());
        g2.draw(this.drawUtility(this.getWidth() * 3 / 4, this.getHeight() * 2 / 5 + 10));
        g2.setColor(this.og.getArcColor());
        point1 = this.getPoint(this.getWidth() / 2, this.getHeight() / 5 + 10, this.getWidth() / 4, this.getHeight() * 2 / 5 + 10, radius);
        point2 = this.getPoint(this.getWidth() / 4, this.getHeight() * 2 / 5 + 10, this.getWidth() / 2, this.getHeight() / 5 + 10, radius);
        g2.draw(new Line2D.Double(point1.getX(), point1.getY(), point2.getX(), point2.getY()));
        g2.fill(this.drawArrow((double)(this.getWidth() / 2) - radius, (double)(this.getHeight() / 5) - radius + 10.0, (double)(this.getWidth() / 4) - radius, (double)(this.getHeight() * 2 / 5) - radius + 10.0));
        point1 = this.getPoint(this.getWidth() / 2, this.getHeight() / 5 + 10, this.getWidth() * 3 / 4, this.getHeight() * 2 / 5 + 10, radius);
        point2 = this.getPoint(this.getWidth() * 3 / 4, this.getHeight() * 2 / 5 + 10, this.getWidth() / 2, this.getHeight() / 5 + 10, radius);
        g2.draw(new Line2D.Double(point1.getX(), point1.getY(), point2.getX(), point2.getY()));
        g2.fill(this.drawArrow((double)(this.getWidth() / 2) - radius, (double)(this.getHeight() / 5) - radius + 10.0, (double)(this.getWidth() * 3 / 4) - radius, (double)(this.getHeight() * 2 / 5) - radius + 10.0));
        g2.setColor(this.og.getPropabilisticExplanationNodeColor());
        g2.fill(new Ellipse2D.Double((double)(this.getWidth() / 2) - radius, (double)(this.getHeight() * 3 / 5) - radius, radius * 2.0, radius * 2.0));
        g2.setColor(this.og.getDecisionNodeColor());
        g2.fillRect((int)((double)(this.getWidth() / 4) - radius), (int)((double)(this.getHeight() * 4 / 5) - radius), (int)(radius * 2.0), (int)(radius * 2.0));
        g2.setColor(this.og.getPropabilisticDescriptionNodeColor());
        g2.fill(new Ellipse2D.Double((double)(this.getWidth() * 3 / 4) - radius, (double)(this.getHeight() * 4 / 5) - radius, radius * 2.0, radius * 2.0));
        g2.setColor(this.og.getArcColor());
        g2.draw(new Ellipse2D.Double((double)(this.getWidth() / 2) - radius, (double)(this.getHeight() * 3 / 5) - radius, radius * 2.0, radius * 2.0));
        g2.drawRect((int)((double)(this.getWidth() / 4) - radius), (int)((double)(this.getHeight() * 4 / 5) - radius), (int)(radius * 2.0), (int)(radius * 2.0));
        g2.draw(new Ellipse2D.Double((double)(this.getWidth() * 3 / 4) - radius, (double)(this.getHeight() * 4 / 5) - radius, radius * 2.0, radius * 2.0));
        point1 = this.getPoint(this.getWidth() / 2, this.getHeight() * 3 / 5, this.getWidth() / 4, this.getHeight() * 4 / 5, radius);
        point2 = this.getPoint(this.getWidth() / 4, this.getHeight() * 4 / 5, this.getWidth() / 2, this.getHeight() * 3 / 5, radius);
        g2.draw(new Line2D.Double(point1.getX(), point1.getY(), point2.getX(), point2.getY()));
        g2.fill(this.drawArrow((double)(this.getWidth() / 2) - radius, (double)(this.getHeight() * 3 / 5) - radius, (double)(this.getWidth() / 4) - radius, (double)(this.getHeight() * 4 / 5) - radius));
        g2.setColor(this.og.getSelectionColor());
        point1 = this.getPoint(this.getWidth() / 2, this.getHeight() * 3 / 5, this.getWidth() * 3 / 4, this.getHeight() * 4 / 5, radius);
        point2 = this.getPoint(this.getWidth() * 3 / 4, this.getHeight() * 4 / 5, this.getWidth() / 2, this.getHeight() * 3 / 5, radius);
        g2.draw(new Line2D.Double(point1.getX(), point1.getY(), point2.getX(), point2.getY()));
        g2.fill(this.drawArrow((double)(this.getWidth() / 2) - radius, (double)(this.getHeight() * 3 / 5) - radius, (double)(this.getWidth() * 3 / 4) - radius, (double)(this.getHeight() * 4 / 5) - radius));
        AttributedString as = new AttributedString(resource.getString("previewTitle"));
        Font serifFont = new Font("Serif", 0, 14);
        as.addAttribute(TextAttribute.FONT, serifFont);
        as.addAttribute(TextAttribute.FOREGROUND, Color.blue);
        g2.drawString(as.getIterator(), 15, 18);
        g2.setColor(Color.blue);
        g2.draw(new Line2D.Double(3.0, 17.0, 8.0, 17.0));
        g2.draw(new Line2D.Double(3.0, 17.0, 3.0, this.getHeight() - 3));
        g2.draw(new Line2D.Double(3.0, this.getHeight() - 3, this.getWidth() - 3, this.getHeight() - 3));
        g2.draw(new Line2D.Double(this.getWidth() - 3, this.getHeight() - 3, this.getWidth() - 3, 17.0));
        if (resource.getString("previewTitle").equals("Preview")) {
            g2.draw(new Line2D.Double(this.getWidth() - 3, 17.0, 65.0, 17.0));
        } else {
            g2.draw(new Line2D.Double(this.getWidth() - 3, 17.0, 123.0, 17.0));
        }
    }
}

