/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import unbbayes.controller.FileController;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.gui.GraphAction;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.SimpleFileFilter;
import unbbayes.gui.mebn.ArgumentEditionPane;
import unbbayes.gui.mebn.DescriptionPane;
import unbbayes.gui.mebn.EntityEditionPane;
import unbbayes.gui.mebn.FormulaEditionPane;
import unbbayes.gui.mebn.InputNodePane;
import unbbayes.gui.mebn.MTheoryTree;
import unbbayes.gui.mebn.OVariableEditionPane;
import unbbayes.gui.mebn.QueryPanel;
import unbbayes.gui.mebn.ResidentNodePane;
import unbbayes.gui.mebn.ToolBarOrdVariable;
import unbbayes.gui.mebn.auxiliary.ButtonLabel;
import unbbayes.gui.mebn.auxiliary.FocusListenerTextField;
import unbbayes.gui.mebn.auxiliary.MebnToolkit;
import unbbayes.gui.mebn.finding.EntityFindingEditionPane;
import unbbayes.gui.mebn.finding.RandomVariableFindingEdtitionPane;
import unbbayes.io.exception.UBIOException;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.exception.DuplicatedNameException;
import unbbayes.prs.mebn.exception.MEBNException;
import unbbayes.prs.mebn.exception.ReservedWordException;
import unbbayes.util.ResourceController;

public class MEBNEditionPane
extends JPanel {
    private static final long serialVersionUID = 6194855055129252835L;
    private final NetworkWindow netWindow;
    private JPanel tabsPanel;
    private JSplitPane centerPanel;
    private JSplitPane jspGraphHelper;
    private JPanel helpPanel;
    private JToolBar jtbTabSelection;
    private JPanel jpTabSelected;
    private MTheoryTree mTheoryTree;
    private JScrollPane mTheoryTreeScroll;
    private FormulaEditionPane formulaEdtion;
    private EntityEditionPane entityEditionPane;
    private InputNodePane inputNodePane;
    private OVariableEditionPane editOVariableTab;
    private RandomVariableFindingEdtitionPane nodeFindingEditionPane;
    private EntityFindingEditionPane entityFindingEditionPane;
    private ResidentNodePane residentNodePane;
    private ArgumentEditionPane editArgumentsTab;
    private final DescriptionPane descriptionPane;
    private JTextField txtNameMTheory;
    private JTextField txtDescription;
    private JTextField txtFormula;
    private JTextField txtNameMFrag;
    private JTextField txtNameContext;
    private JTextField txtArguments;
    private final MEBNController mebnController;
    private final JSplitPane graphPanel;
    private final JLabel status;
    private final JPanel bottomPanel;
    private final JPanel topPanel;
    private final ToolBarEdition jtbEdition;
    private final JPanel nodeSelectedToolBar;
    private final CardLayout cardLayout = new CardLayout();
    private final JToolBar jtbEmpty;
    private final ToolBarMFrag toolBarMFrag;
    private final ToolBarResidentNode toolBarResidentNode;
    private final ToolBarInputNode toolBarInputNode;
    private final ToolBarContextNode toolBarContextNode;
    private final ToolBarMTheory toolBarMTheory;
    private final ToolBarOrdVariable toolBarOVariable;
    private final String MTHEORY_BAR = "MTheoryCard";
    private final String RESIDENT_BAR = "ResidentCard";
    private final String CONTEXT_BAR = "ContextCard";
    private final String INPUT_BAR = "InputCard";
    private final String MFRAG_BAR = "MFragCard";
    private final String EMPTY_BAR = "EmptyCard";
    private final String ORDVARIABLE_BAR = "OrdVariableCard";
    private ButtonGroup groupButtonsTabs = new ButtonGroup();
    private final JToggleButton btnTabOptionTree;
    private final JToggleButton btnTabOptionOVariable;
    private final JToggleButton btnTabOptionEntity;
    private final JToggleButton btnTabOptionEntityFinding;
    private final JToggleButton btnTabOptionNodeFinding;
    private final String MTHEORY_TREE_TAB = "MTheoryTree";
    private final String ENTITY_EDITION_TAB = "EntityEdtionTab";
    private final String OVARIABLE_EDITION_TAB = "EditOVariableTab";
    private final String INPUT_NODE_TAB = "InputNodeTab";
    private final String ARGUMENTS_EDITION_TAB = "EditArgumentsTab";
    private final String RESIDENT_NODE_TAB = "ResidentNodeTab";
    private final String FORMULA_TAB = "FormulaEdtion";
    private final String ENTITY_FINDING_TAB = "EntityFindingTab";
    private final String NODE_FINDING_TAB = "NodeFindingTab";
    private boolean isTableEditionPaneShow = false;
    private final Pattern wordPattern = Pattern.compile("[a-zA-Z_0-9]*");
    private Matcher matcher;
    private final IconController iconController = IconController.getInstance();
    private static ResourceBundle resource = ResourceController.RS_GUI;

    public MEBNEditionPane(NetworkWindow _netWindow, MEBNController _controller) {
        this.netWindow = _netWindow;
        this.mebnController = _controller;
        this.setLayout(new BorderLayout());
        this.topPanel = new JPanel(new GridLayout(1, 1));
        this.tabsPanel = new JPanel(new BorderLayout());
        this.jpTabSelected = new JPanel(this.cardLayout);
        this.descriptionPane = new DescriptionPane(this.mebnController);
        this.jtbTabSelection = new JToolBar();
        this.nodeSelectedToolBar = new JPanel(this.cardLayout);
        this.jtbEmpty = new JToolBar();
        this.graphPanel = new JSplitPane(0);
        this.graphPanel.setDividerSize(1);
        this.bottomPanel = new JPanel(new GridLayout(1, 1));
        this.status = new JLabel(resource.getString("statusReadyLabel"));
        this.txtDescription = new JTextField(15);
        this.txtNameMTheory = new JTextField(5);
        this.txtNameMFrag = new JTextField(5);
        this.txtNameContext = new JTextField(5);
        this.txtArguments = new JTextField(10);
        this.txtFormula = new JTextField(15);
        this.btnTabOptionTree = new ButtonTab(this.iconController.getMTheoryNodeIcon());
        this.btnTabOptionOVariable = new ButtonTab(this.iconController.getOVariableNodeIcon());
        this.btnTabOptionEntity = new ButtonTab(this.iconController.getObjectEntityIcon());
        this.btnTabOptionEntityFinding = new ButtonTab(this.iconController.getEntityInstance());
        this.btnTabOptionNodeFinding = new ButtonTab(this.iconController.getNodeInstance());
        this.btnTabOptionTree.setToolTipText(resource.getString("showMTheoryToolTip"));
        this.btnTabOptionOVariable.setToolTipText(resource.getString("showOVariablesToolTip"));
        this.btnTabOptionEntity.setToolTipText(resource.getString("showEntitiesToolTip"));
        this.btnTabOptionEntityFinding.setToolTipText(resource.getString("showEntityInstancesToolTip"));
        this.btnTabOptionNodeFinding.setToolTipText(resource.getString("showFingingsToolTip"));
        this.groupButtonsTabs.add(this.btnTabOptionTree);
        this.groupButtonsTabs.add(this.btnTabOptionOVariable);
        this.groupButtonsTabs.add(this.btnTabOptionEntity);
        this.groupButtonsTabs.add(this.btnTabOptionEntityFinding);
        this.groupButtonsTabs.add(this.btnTabOptionNodeFinding);
        this.addActionListenersToButtons();
        this.jtbEdition = new ToolBarEdition();
        this.jtbEdition.setFloatable(true);
        this.jtbEdition.setOrientation(1);
        this.topPanel.add(new ToolBarGlobalOptions());
        this.toolBarMFrag = new ToolBarMFrag();
        this.toolBarResidentNode = new ToolBarResidentNode();
        this.toolBarInputNode = new ToolBarInputNode();
        this.toolBarContextNode = new ToolBarContextNode();
        this.toolBarOVariable = new ToolBarOrdVariable(this.mebnController);
        this.toolBarMTheory = new ToolBarMTheory();
        JTextField txtIsEmpty = new JTextField(resource.getString("whithotMFragActive"));
        txtIsEmpty.setEditable(false);
        this.jtbEmpty.addSeparator();
        this.jtbEmpty.add(txtIsEmpty);
        this.jtbEmpty.setFloatable(false);
        this.nodeSelectedToolBar.add("MTheoryCard", this.toolBarMTheory);
        this.nodeSelectedToolBar.add("ResidentCard", this.toolBarResidentNode);
        this.nodeSelectedToolBar.add("ContextCard", this.toolBarContextNode);
        this.nodeSelectedToolBar.add("InputCard", this.toolBarInputNode);
        this.nodeSelectedToolBar.add("MFragCard", this.toolBarMFrag);
        this.nodeSelectedToolBar.add("EmptyCard", this.jtbEmpty);
        this.nodeSelectedToolBar.add("OrdVariableCard", this.toolBarOVariable);
        this.cardLayout.show(this.nodeSelectedToolBar, "EmptyCard");
        this.bottomPanel.add(this.status);
        this.jtbTabSelection.setLayout(new GridLayout(1, 5));
        this.jtbTabSelection.add(this.btnTabOptionTree);
        this.jtbTabSelection.add(this.btnTabOptionOVariable);
        this.jtbTabSelection.add(this.btnTabOptionEntity);
        this.jtbTabSelection.add(this.btnTabOptionEntityFinding);
        this.jtbTabSelection.add(this.btnTabOptionNodeFinding);
        this.jtbTabSelection.setFloatable(false);
        this.mTheoryTree = new MTheoryTree(this.mebnController, this.netWindow.getGraphPane());
        this.mTheoryTreeScroll = new JScrollPane(this.mTheoryTree);
        this.mTheoryTreeScroll.setHorizontalScrollBarPolicy(32);
        this.mTheoryTreeScroll.setBorder(MebnToolkit.getBorderForTabPanel(resource.getString("MTheoryTreeTitle")));
        this.jpTabSelected.add("MTheoryTree", this.mTheoryTreeScroll);
        this.entityEditionPane = new EntityEditionPane(this.mebnController);
        this.jpTabSelected.add("EntityEdtionTab", this.entityEditionPane);
        this.editOVariableTab = new OVariableEditionPane();
        this.jpTabSelected.add("EditOVariableTab", this.editOVariableTab);
        this.inputNodePane = new InputNodePane();
        this.jpTabSelected.add("InputNodeTab", this.inputNodePane);
        this.editArgumentsTab = new ArgumentEditionPane();
        this.jpTabSelected.add("EditArgumentsTab", this.editArgumentsTab);
        this.residentNodePane = new ResidentNodePane();
        this.jpTabSelected.add("ResidentNodeTab", this.residentNodePane);
        this.formulaEdtion = new FormulaEditionPane();
        this.jpTabSelected.add("FormulaEdtion", this.formulaEdtion);
        this.entityFindingEditionPane = new EntityFindingEditionPane();
        this.jpTabSelected.add("EntityFindingTab", this.entityFindingEditionPane);
        this.nodeFindingEditionPane = new RandomVariableFindingEdtitionPane();
        this.jpTabSelected.add("NodeFindingTab", this.nodeFindingEditionPane);
        this.cardLayout.show(this.jpTabSelected, "MTheoryTree");
        this.tabsPanel.add("North", this.jtbTabSelection);
        this.tabsPanel.add("Center", this.jpTabSelected);
        this.tabsPanel.add("South", this.descriptionPane);
        this.tabsPanel.add("East", this.jtbEdition);
        this.centerPanel = new JSplitPane(1, this.tabsPanel, this.graphPanel);
        this.centerPanel.setDividerSize(1);
        this.centerPanel.setDividerLocation(200);
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.bottomPanel, "South");
        this.add((Component)this.centerPanel, "Center");
        this.setVisible(true);
    }

    private void addActionListenersToButtons() {
        this.btnTabOptionTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MEBNEditionPane.this.setMTheoryTreeActive();
            }
        });
        this.btnTabOptionOVariable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MEBNEditionPane.this.setEditOVariableTabActive();
            }
        });
        this.btnTabOptionEntity.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MEBNEditionPane.this.setEntityEditionTabActive();
            }
        });
        this.btnTabOptionEntityFinding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MEBNEditionPane.this.setEntityFindingEditionPaneActive();
            }
        });
        this.btnTabOptionNodeFinding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MEBNEditionPane.this.setRandonVariableFindingEditionPaneActive();
            }
        });
    }

    public void showTableEditionPane(ResidentNode resident) {
        this.mebnController.openCPTDialog(resident);
    }

    public void hideTopComponent() {
        this.getGraphPanel().setTopComponent(null);
        this.isTableEditionPaneShow = false;
    }

    public boolean isTableEditionPaneShow() {
        return this.isTableEditionPaneShow;
    }

    public void showTitleGraph(String mFragName) {
        JPanel titleMFragPane = new JPanel(new BorderLayout());
        JToolBar tb1 = new JToolBar();
        JButton btnTest = new JButton(this.iconController.getResidentNodeIcon());
        tb1.add(btnTest);
        tb1.setFloatable(false);
        JToolBar tb2 = new JToolBar();
        tb2.setLayout(new BorderLayout());
        JLabel label = new JLabel(mFragName);
        label.setForeground(Color.BLACK);
        label.setHorizontalAlignment(0);
        label.setHorizontalTextPosition(0);
        tb2.add((Component)label, "Center");
        JButton jbtn = new JButton();
        jbtn.setBackground(Color.white);
        JButton jbtn2 = new JButton();
        jbtn2.setBackground(Color.white);
        jbtn = new JButton(this.iconController.getMFragIcon());
        jbtn2 = new JButton(this.iconController.getMFragIcon());
        tb2.setBackground(new Color(255, 255, 255));
        tb2.setFloatable(false);
        titleMFragPane.add((Component)this.nodeSelectedToolBar, "First");
        titleMFragPane.add((Component)tb2, "Last");
        if (!this.isTableEditionPaneShow) {
            this.getGraphPanel().setTopComponent(titleMFragPane);
            this.getGraphPanel().setBackground(Color.white);
        }
    }

    public JTextField getTxtDescription() {
        return this.txtDescription;
    }

    public JTextField getTxtNameResident() {
        return this.toolBarResidentNode.getJTextFieldName();
    }

    public void setStatus(String status) {
        this.status.setText(status);
        this.status.validate();
        this.status.paintImmediately(this.status.getBounds());
    }

    public void setNameMTheory(String name) {
        this.txtNameMTheory.setText(name);
    }

    public String getNameMTheory(String name) {
        return this.txtNameMTheory.getText();
    }

    public JSplitPane getGraphPanel() {
        return this.graphPanel;
    }

    public MTheoryTree getMTheoryTree() {
        return this.mTheoryTree;
    }

    public ArgumentEditionPane getEditArgumentsTab() {
        return this.editArgumentsTab;
    }

    public OVariableEditionPane getEditOVariableTab() {
        return this.editOVariableTab;
    }

    public void setMTheoryTreeActive() {
        this.cardLayout.show(this.jpTabSelected, "MTheoryTree");
    }

    public void setFormulaEdtionActive() {
        this.cardLayout.show(this.jpTabSelected, "FormulaEdtion");
    }

    public void setFormulaEdtionActive(ContextNode context) {
        this.jpTabSelected.remove(this.formulaEdtion);
        this.formulaEdtion = new FormulaEditionPane(this.mebnController, context);
        this.jpTabSelected.add("FormulaEdtion", this.formulaEdtion);
        this.cardLayout.show(this.jpTabSelected, "FormulaEdtion");
    }

    public void setEntityTreeActive() {
        this.cardLayout.show(this.jpTabSelected, "EntityTree");
    }

    public void setInputNodeActive(InputNode input) {
        this.jpTabSelected.remove(this.inputNodePane);
        this.inputNodePane = new InputNodePane(this.mebnController, input);
        this.jpTabSelected.add("InputNodeTab", this.inputNodePane);
        this.cardLayout.show(this.jpTabSelected, "InputNodeTab");
    }

    public InputNodePane getInputNodePane() {
        return this.inputNodePane;
    }

    public void setInputNodeActive() {
        this.cardLayout.show(this.jpTabSelected, "InputNodeTab");
    }

    public void setArgumentTabActive() {
        this.cardLayout.show(this.jpTabSelected, "ArgumentTab");
    }

    public void setEditArgumentsTabActive(ResidentNode resident) {
        this.jpTabSelected.remove(this.editArgumentsTab);
        this.editArgumentsTab = new ArgumentEditionPane(this.mebnController, resident);
        this.jpTabSelected.add("EditArgumentsTab", this.editArgumentsTab);
        this.cardLayout.show(this.jpTabSelected, "EditArgumentsTab");
    }

    public void setEditArgumentsTabActive() {
        this.editArgumentsTab.update();
        this.cardLayout.show(this.jpTabSelected, "EditArgumentsTab");
    }

    public void setEditOVariableTabActive() {
        if (this.mebnController.getCurrentMFrag() != null) {
            this.cardLayout.removeLayoutComponent(this.editOVariableTab);
            this.editOVariableTab = new OVariableEditionPane(this.mebnController);
            this.jpTabSelected.add("EditOVariableTab", this.editOVariableTab);
            this.cardLayout.show(this.jpTabSelected, "EditOVariableTab");
        }
    }

    public void setEntityEditionTabActive() {
        this.cardLayout.show(this.jpTabSelected, "EntityEdtionTab");
    }

    public void setResidentNodeTabActive(ResidentNode resident) {
        if (this.mebnController.getCurrentMFrag() != null) {
            this.jpTabSelected.remove(this.residentNodePane);
            this.residentNodePane = new ResidentNodePane(this.mebnController, resident);
            this.jpTabSelected.add("ResidentNodeTab", this.residentNodePane);
            this.cardLayout.show(this.jpTabSelected, "ResidentNodeTab");
        }
    }

    public void setResidentNodeTabActive() {
        this.cardLayout.show(this.jpTabSelected, "ResidentNodeTab");
    }

    public void setEntityFindingEditionPaneActive() {
        this.cardLayout.removeLayoutComponent(this.entityFindingEditionPane);
        this.entityFindingEditionPane = new EntityFindingEditionPane(this.mebnController);
        this.jpTabSelected.add("EntityFindingTab", this.entityFindingEditionPane);
        this.cardLayout.show(this.jpTabSelected, "EntityFindingTab");
    }

    public void setRandonVariableFindingEditionPaneActive() {
        this.cardLayout.removeLayoutComponent(this.nodeFindingEditionPane);
        this.nodeFindingEditionPane = new RandomVariableFindingEdtitionPane(this.mebnController);
        this.jpTabSelected.add("NodeFindingTab", this.nodeFindingEditionPane);
        this.cardLayout.show(this.jpTabSelected, "NodeFindingTab");
    }

    public void setMTheoryBarActive() {
        this.cardLayout.show(this.nodeSelectedToolBar, "MTheoryCard");
    }

    public void setResidentBarActive() {
        this.cardLayout.show(this.nodeSelectedToolBar, "ResidentCard");
    }

    public void setContextBarActive() {
        this.cardLayout.show(this.nodeSelectedToolBar, "ContextCard");
    }

    public void setInputBarActive() {
        this.cardLayout.show(this.nodeSelectedToolBar, "InputCard");
    }

    public void setMFragBarActive() {
        this.cardLayout.show(this.nodeSelectedToolBar, "MFragCard");
    }

    public void setEmptyBarActive() {
        this.cardLayout.show(this.nodeSelectedToolBar, "EmptyCard");
    }

    public void setOrdVariableBarActive(OrdinaryVariable ov) {
        this.toolBarOVariable.updateListOfTypes();
        this.toolBarOVariable.setOrdVariable(ov);
        this.cardLayout.show(this.nodeSelectedToolBar, "OrdVariableCard");
    }

    public void setTxtNameResident(String name) {
        this.toolBarResidentNode.setNameResident(name);
    }

    public void setTxtNameMFrag(String name) {
        this.txtNameMFrag.setText(name);
    }

    public void setTxtNameInput(String name) {
        this.toolBarInputNode.setTxtNameInput(name);
    }

    public void setTxtNameContext(String name) {
        this.txtNameContext.setText(name);
    }

    public void setTxtInputOf(String name) {
        this.toolBarInputNode.setTxtInputOf(name);
    }

    public void setTxtArguments(String args) {
        this.txtArguments.setText(args);
    }

    public void setFormula(String formula) {
        this.txtFormula.setText(formula);
    }

    public NetworkWindow getNetworkWindow() {
        return this.netWindow;
    }

    public void setDescriptionText(String text, int type) {
        this.descriptionPane.setDescriptionText(text, type);
    }

    public String getDescriptionText() {
        return this.descriptionPane.getDescriptionText();
    }

    public ToolBarOrdVariable getToolBarOVariable() {
        return this.toolBarOVariable;
    }

    public ToolBarEdition getJtbEdition() {
        return this.jtbEdition;
    }

    public ButtonGroup getGroupButtonsTabs() {
        return this.groupButtonsTabs;
    }

    public void unselectButtonsGroupButtonsTabs() {
        Enumeration<AbstractButton> abEnumeration = this.groupButtonsTabs.getElements();
        while (abEnumeration.hasMoreElements()) {
            abEnumeration.nextElement().setSelected(false);
        }
    }

    private class ButtonTab
    extends JToggleButton {
        public ButtonTab(ImageIcon image) {
            super(image);
            this.setBackground(MebnToolkit.getColorTabPanelButton());
        }
    }

    private class EmptyPanel
    extends JButton {
        public EmptyPanel() {
            this.setEnabled(false);
        }
    }

    private class ResidentPaneOptions
    extends JToolBar {
        ResidentPaneOptions() {
            this.setLayout(new GridLayout(1, 5));
            JButton btnStateEdition = new JButton(MEBNEditionPane.this.iconController.getStateIcon());
            JButton btnEditTable = new JButton(MEBNEditionPane.this.iconController.getGridIcon());
            JButton btnEditArguments = new JButton(MEBNEditionPane.this.iconController.getArgumentsIcon());
            btnStateEdition.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.setResidentNodeTabActive();
                }
            });
            btnEditTable.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MEBNEditionPane.this.mebnController.setEnableTableEditionView();
                }
            });
            btnEditArguments.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.setEditArgumentsTabActive();
                }
            });
            this.add(btnStateEdition);
            this.add(btnEditArguments);
            this.add(btnEditTable);
            this.add(new JPanel());
            this.add(new JPanel());
        }
    }

    private class ToolBarContextNode
    extends JToolBar {
        public ToolBarContextNode() {
            this.setLayout(new GridLayout(1, 5));
            ButtonLabel btnContextActive = new ButtonLabel(resource.getString("ContextButton"), MEBNEditionPane.this.iconController.getContextNodeIcon());
            btnContextActive.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.setFormulaEdtionActive();
                }
            });
            JLabel labelFormula = new JLabel(resource.getString("formula"));
            MEBNEditionPane.this.txtFormula.setEditable(false);
            JLabel labelContextName = new JLabel(String.valueOf(resource.getString("nameLabel")) + " ");
            MEBNEditionPane.this.txtNameContext.setEditable(false);
            JToolBar barName = new JToolBar();
            barName.add(MEBNEditionPane.this.txtNameContext);
            barName.setFloatable(false);
            this.add(btnContextActive);
            this.add(barName);
            this.add(new EmptyPanel());
            this.add(new EmptyPanel());
            this.add(new EmptyPanel());
            this.setFloatable(false);
        }
    }

    public class ToolBarEdition
    extends JToolBar {
        private final JToggleButton btnResetCursor;
        private final JToggleButton btnAddMFrag;
        private final JToggleButton btnAddContextNode;
        private final JToggleButton btnAddInputNode;
        private final JToggleButton btnAddResidentNode;
        private final JToggleButton btnAddEdge;
        private final JToggleButton btnAddOrdinaryVariable;
        private final JToggleButton btnEditMTheory;
        private final JToggleButton btnSelectObject;
        private final JToggleButton btnDeleteSelectedItem;
        private final ButtonGroup groupEditionButtons;

        public ToolBarEdition() {
            this.btnEditMTheory = new JToggleButton(MEBNEditionPane.this.iconController.getMTheoryNodeIcon());
            this.btnAddEdge = new JToggleButton(MEBNEditionPane.this.iconController.getEdgeIcon());
            this.btnAddContextNode = new JToggleButton(MEBNEditionPane.this.iconController.getContextNodeIcon());
            this.btnAddInputNode = new JToggleButton(MEBNEditionPane.this.iconController.getInputNodeIcon());
            this.btnAddResidentNode = new JToggleButton(MEBNEditionPane.this.iconController.getResidentNodeIcon());
            this.btnAddOrdinaryVariable = new JToggleButton(MEBNEditionPane.this.iconController.getOVariableNodeIcon());
            this.btnAddMFrag = new JToggleButton(MEBNEditionPane.this.iconController.getMFragIcon());
            this.btnSelectObject = new JToggleButton(MEBNEditionPane.this.iconController.getSelectionIcon());
            this.btnResetCursor = new JToggleButton(MEBNEditionPane.this.iconController.getArrowIcon());
            this.btnDeleteSelectedItem = new JToggleButton(MEBNEditionPane.this.iconController.getEditDelete());
            this.btnEditMTheory.setToolTipText(resource.getString("mTheoryEditionTip"));
            this.btnAddEdge.setToolTipText(resource.getString("arcToolTip"));
            this.btnAddMFrag.setToolTipText(resource.getString("mFragInsertToolTip"));
            this.btnAddContextNode.setToolTipText(resource.getString("contextNodeInsertToolTip"));
            this.btnAddInputNode.setToolTipText(resource.getString("inputNodeInsertToolTip"));
            this.btnAddResidentNode.setToolTipText(resource.getString("residentNodeInsertToolTip"));
            this.btnSelectObject.setToolTipText(resource.getString("selectObjectToolTip"));
            this.btnAddOrdinaryVariable.setToolTipText(resource.getString("ordinaryVariableInsertToolTip"));
            this.btnResetCursor.setToolTipText(resource.getString("resetToolTip"));
            this.btnDeleteSelectedItem.setToolTipText(resource.getString("deleteSelectedItemToolTip"));
            this.groupEditionButtons = new ButtonGroup();
            this.groupEditionButtons.add(this.btnEditMTheory);
            this.groupEditionButtons.add(this.btnAddEdge);
            this.groupEditionButtons.add(this.btnAddContextNode);
            this.groupEditionButtons.add(this.btnAddInputNode);
            this.groupEditionButtons.add(this.btnAddResidentNode);
            this.groupEditionButtons.add(this.btnAddOrdinaryVariable);
            this.groupEditionButtons.add(this.btnAddMFrag);
            this.groupEditionButtons.add(this.btnSelectObject);
            this.groupEditionButtons.add(this.btnResetCursor);
            this.groupEditionButtons.add(this.btnEditMTheory);
            this.groupEditionButtons.add(this.btnDeleteSelectedItem);
            this.add(this.btnResetCursor);
            this.addSeparator();
            this.add(this.btnEditMTheory);
            this.addSeparator();
            this.add(this.btnAddMFrag);
            this.addSeparator();
            this.add(this.btnAddResidentNode);
            this.add(this.btnAddInputNode);
            this.add(this.btnAddContextNode);
            this.add(this.btnAddOrdinaryVariable);
            this.add(this.btnAddEdge);
            this.addSeparator();
            this.add(this.btnDeleteSelectedItem);
            this.addSeparator();
            this.add(this.btnSelectObject);
            this.addSeparator();
            this.btnResetCursor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.mebnController.setActionGraphNone();
                }
            });
            this.btnEditMTheory.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.mebnController.enableMTheoryEdition();
                }
            });
            this.btnAddEdge.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.mebnController.setActionGraphCreateEdge();
                }
            });
            this.btnAddMFrag.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.mebnController.insertDomainMFrag();
                }
            });
            this.btnAddContextNode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.mebnController.setActionGraphCreateContextNode();
                }
            });
            this.btnAddInputNode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.mebnController.setActionGraphCreateInputNode();
                }
            });
            this.btnAddResidentNode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.mebnController.setActionGraphCreateResidentNode();
                }
            });
            this.btnAddOrdinaryVariable.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.mebnController.setActionGraphCreateOrdinaryVariableNode();
                }
            });
            this.btnDeleteSelectedItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.mebnController.deleteSelectedItem();
                }
            });
            this.btnSelectObject.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.netWindow.getGraphPane().setAction(GraphAction.SELECT_MANY_OBJECTS);
                }
            });
        }

        public void selectBtnResetCursor() {
            this.btnResetCursor.setSelected(true);
        }

        public void selectBtnAddMFrag() {
            this.btnAddMFrag.setSelected(true);
        }

        public void selectBtnAddContextNode() {
            this.btnAddContextNode.setSelected(true);
        }

        public void selectBtnAddInputNode() {
            this.btnAddInputNode.setSelected(true);
        }

        public void selectBtnAddResidentNode() {
            this.btnAddResidentNode.setSelected(true);
        }

        public void selectBtnAddEdge() {
            this.btnAddEdge.setSelected(true);
        }

        public void selectBtnAddOrdinaryVariable() {
            this.btnAddOrdinaryVariable.setSelected(true);
        }

        public void selectBtnEditMTheory() {
            this.btnEditMTheory.setSelected(true);
        }

        public void selectBtnSelectObject() {
            this.btnSelectObject.setSelected(true);
        }

        public void selectBtnDeleteSelectedItem() {
            this.btnDeleteSelectedItem.setSelected(true);
        }
    }

    private class ToolBarGlobalOptions
    extends JToolBar {
        private static final long serialVersionUID = 1L;
        private JButton btnDoQuery;
        private JButton btnTurnToSSBNMode;
        private JButton btnSaveKB;
        private JButton btnLoadKB;
        private JButton btnClearKB;

        public ToolBarGlobalOptions() {
            this.btnDoQuery = new JButton(MEBNEditionPane.this.iconController.getCompileIcon());
            this.btnTurnToSSBNMode = new JButton(MEBNEditionPane.this.iconController.getSsbnIcon());
            this.btnClearKB = new JButton(MEBNEditionPane.this.iconController.getEditDelete());
            this.btnLoadKB = new JButton(MEBNEditionPane.this.iconController.getLoadFindingsInstance());
            this.btnSaveKB = new JButton(MEBNEditionPane.this.iconController.getSaveFindingsInstance());
            this.btnDoQuery.setToolTipText(resource.getString("executeQueryToolTip"));
            this.btnTurnToSSBNMode.setToolTipText(resource.getString("turnToSSBNModeToolTip"));
            this.btnClearKB.setToolTipText(resource.getString("clearKBToolTip"));
            this.btnLoadKB.setToolTipText(resource.getString("loadKBToolTip"));
            this.btnSaveKB.setToolTipText(resource.getString("saveKBToolTip"));
            this.btnDoQuery.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    QueryPanel queryPanel = new QueryPanel(MEBNEditionPane.this.mebnController);
                    queryPanel.setLocationRelativeTo(MEBNEditionPane.this.netWindow.getDesktopPane());
                    queryPanel.pack();
                    queryPanel.setVisible(true);
                }
            });
            this.btnTurnToSSBNMode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!MEBNEditionPane.this.mebnController.turnToSSBNMode()) {
                        JOptionPane.showMessageDialog(MEBNEditionPane.this.mebnController.getMebnEditionPane(), resource.getString("NoSSBN"));
                    }
                }
            });
            this.btnClearKB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MEBNEditionPane.this.mebnController.clearFindingsIntoGUI();
                    JOptionPane.showMessageDialog(MEBNEditionPane.this.mebnController.getMebnEditionPane(), resource.getString("KBClean"));
                }
            });
            JButton btnSaveGenerative = new JButton("SVG");
            btnSaveGenerative.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    File file;
                    ToolBarGlobalOptions.this.setCursor(new Cursor(3));
                    JFileChooser chooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setFileSelectionMode(0);
                    int option = chooser.showSaveDialog(null);
                    if (option == 0 && (file = chooser.getSelectedFile()) != null) {
                        MEBNEditionPane.this.mebnController.saveGenerativeMTheory(file);
                        JOptionPane.showMessageDialog(MEBNEditionPane.this.mebnController.getMebnEditionPane(), resource.getString("FileSaveOK"));
                    }
                    ToolBarGlobalOptions.this.setCursor(new Cursor(0));
                }
            });
            this.btnSaveKB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ToolBarGlobalOptions.this.doSaveKnowledgeBase();
                }
            });
            this.btnLoadKB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ToolBarGlobalOptions.this.doLoadKnowledgeBase();
                }
            });
            this.add(this.btnDoQuery);
            this.addSeparator();
            this.add(this.btnLoadKB);
            this.add(this.btnSaveKB);
            this.add(this.btnClearKB);
            this.addSeparator(new Dimension(10, 10));
            this.add(this.btnTurnToSSBNMode);
            this.setFloatable(false);
        }

        private void doSaveKnowledgeBase() {
            this.setCursor(new Cursor(3));
            String[] validSufixes = new String[]{"plm"};
            JFileChooser chooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(0);
            chooser.addChoosableFileFilter(new SimpleFileFilter(validSufixes, resource.getString("powerloomFileFilter")));
            int option = chooser.showSaveDialog(null);
            if (option == 0) {
                File file = chooser.getSelectedFile();
                String nameFile = file.getAbsolutePath();
                if (!nameFile.substring(nameFile.length() - 4).equals(".plm")) {
                    file = new File(String.valueOf(nameFile) + "." + "plm");
                }
                if (file != null) {
                    MEBNEditionPane.this.mebnController.saveFindingsFile(file);
                    JOptionPane.showMessageDialog(MEBNEditionPane.this.mebnController.getMebnEditionPane(), resource.getString("FileSaveOK"));
                }
            }
            this.setCursor(new Cursor(0));
        }

        private void doLoadKnowledgeBase() {
            this.setCursor(new Cursor(3));
            String[] validSufixes = new String[]{"plm"};
            JFileChooser chooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(0);
            chooser.addChoosableFileFilter(new SimpleFileFilter(validSufixes, resource.getString("powerloomFileFilter")));
            int option = chooser.showOpenDialog(null);
            if (option == 0 && chooser.getSelectedFile() != null) {
                File file = chooser.getSelectedFile();
                try {
                    MEBNEditionPane.this.mebnController.loadFindingsFile(file);
                    JOptionPane.showMessageDialog(MEBNEditionPane.this.mebnController.getMebnEditionPane(), resource.getString("FileLoadOK"));
                }
                catch (UBIOException e) {
                    JOptionPane.showMessageDialog(MEBNEditionPane.this.mebnController.getMebnEditionPane(), e.getMessage());
                }
                catch (MEBNException e2) {
                    JOptionPane.showMessageDialog(MEBNEditionPane.this.mebnController.getMebnEditionPane(), e2.getMessage());
                }
            }
            this.setCursor(new Cursor(0));
        }
    }

    private class ToolBarInputNode
    extends JToolBar {
        private ButtonLabel btnInputActive;
        private JLabel labelInputName;
        private JLabel labelInputOf;
        private JTextField txtNameInput;
        private JTextField txtInputOf;

        public ToolBarInputNode() {
            this.btnInputActive = new ButtonLabel(resource.getString("InputButton"), MEBNEditionPane.this.iconController.getInputNodeIcon());
            this.btnInputActive.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.setInputNodeActive();
                }
            });
            this.labelInputName = new JLabel(String.valueOf(resource.getString("nameLabel")) + " ");
            this.labelInputOf = new JLabel(resource.getString("inputOf"));
            GridLayout grid = new GridLayout(1, 5);
            this.setLayout(grid);
            this.add(this.btnInputActive);
            JToolBar barName = new JToolBar();
            barName.setFloatable(false);
            this.txtNameInput = new JTextField(10);
            this.txtNameInput.setEditable(false);
            barName.add(this.txtNameInput);
            barName.setFloatable(false);
            this.add(barName);
            this.txtInputOf = new JTextField(10);
            this.txtInputOf.setEditable(false);
            this.add(new EmptyPanel());
            this.add(new EmptyPanel());
            this.add(new EmptyPanel());
            this.setFloatable(false);
        }

        public void setTxtInputOf(String txtInputOf) {
            this.txtInputOf.setText(txtInputOf);
        }

        public void setTxtNameInput(String txtNameInput) {
            this.txtNameInput.setText(txtNameInput);
        }
    }

    private class ToolBarMFrag
    extends JToolBar {
        public ToolBarMFrag() {
            this.setLayout(new GridLayout(1, 5));
            ButtonLabel btnMFragActive = new ButtonLabel(resource.getString("MFragButton"), MEBNEditionPane.this.iconController.getMFragIcon());
            btnMFragActive.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.setMTheoryTreeActive();
                }
            });
            JLabel labelMFragName = new JLabel(String.valueOf(resource.getString("nameLabel")) + " ");
            MEBNEditionPane.this.txtNameMFrag.addFocusListener(new FocusListenerTextField());
            MEBNEditionPane.this.txtNameMFrag.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 && MEBNEditionPane.this.txtNameMFrag.getText().length() > 0) {
                        try {
                            String name = MEBNEditionPane.this.txtNameMFrag.getText(0, MEBNEditionPane.this.txtNameMFrag.getText().length());
                            MEBNEditionPane.this.matcher = MEBNEditionPane.this.wordPattern.matcher(name);
                            if (MEBNEditionPane.this.matcher.matches()) {
                                try {
                                    MEBNEditionPane.this.mebnController.renameMFrag(MEBNEditionPane.this.mebnController.getCurrentMFrag(), name);
                                }
                                catch (DuplicatedNameException dne) {
                                    JOptionPane.showMessageDialog(MEBNEditionPane.this.netWindow, resource.getString("nameAlreadyExists"), resource.getString("nameException"), 0);
                                }
                                catch (ReservedWordException e2) {
                                    JOptionPane.showMessageDialog(MEBNEditionPane.this.netWindow, resource.getString("nameError"), resource.getString("nameReserved"), 0);
                                }
                            } else {
                                MEBNEditionPane.this.txtNameMFrag.setBackground(MebnToolkit.getColorTextFieldError());
                                MEBNEditionPane.this.txtNameMFrag.setForeground(Color.WHITE);
                                MEBNEditionPane.this.txtNameMFrag.selectAll();
                                JOptionPane.showMessageDialog(MEBNEditionPane.this.netWindow, resource.getString("nameError"), resource.getString("nameException"), 0);
                            }
                        }
                        catch (BadLocationException ble) {
                            System.out.println(ble.getMessage());
                        }
                    }
                }

                public void keyReleased(KeyEvent e) {
                    try {
                        String name = MEBNEditionPane.this.txtNameMFrag.getText(0, MEBNEditionPane.this.txtNameMFrag.getText().length());
                        MEBNEditionPane.this.matcher = MEBNEditionPane.this.wordPattern.matcher(name);
                        if (!MEBNEditionPane.this.matcher.matches()) {
                            MEBNEditionPane.this.txtNameMFrag.setBackground(MebnToolkit.getColorTextFieldError());
                            MEBNEditionPane.this.txtNameMFrag.setForeground(Color.WHITE);
                        } else {
                            MEBNEditionPane.this.txtNameMFrag.setBackground(MebnToolkit.getColorTextFieldSelected());
                            MEBNEditionPane.this.txtNameMFrag.setForeground(Color.BLACK);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.add(btnMFragActive);
            JToolBar barName = new JToolBar();
            barName.add(MEBNEditionPane.this.txtNameMFrag);
            barName.setFloatable(false);
            this.add(barName);
            this.add(new EmptyPanel());
            this.add(new EmptyPanel());
            this.add(new EmptyPanel());
            this.setFloatable(false);
        }
    }

    private class ToolBarMTheory
    extends JToolBar {
        public ToolBarMTheory() {
            this.setLayout(new GridLayout(1, 5));
            ButtonLabel btnMTheoryActive = new ButtonLabel(resource.getString("MTheoryButton"), MEBNEditionPane.this.iconController.getMTheoryNodeIcon());
            btnMTheoryActive.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.setMTheoryTreeActive();
                }
            });
            JLabel labelMTheoryName = new JLabel(String.valueOf(resource.getString("nameLabel")) + " ");
            MEBNEditionPane.this.txtNameMTheory.addFocusListener(new FocusListenerTextField());
            MEBNEditionPane.this.txtNameMTheory.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 && MEBNEditionPane.this.txtNameMTheory.getText().length() > 0) {
                        try {
                            String name = MEBNEditionPane.this.txtNameMTheory.getText(0, MEBNEditionPane.this.txtNameMTheory.getText().length());
                            MEBNEditionPane.this.matcher = MEBNEditionPane.this.wordPattern.matcher(name);
                            if (MEBNEditionPane.this.matcher.matches()) {
                                try {
                                    MEBNEditionPane.this.mebnController.renameMTheory(name);
                                }
                                catch (DuplicatedNameException e1) {
                                    JOptionPane.showMessageDialog(MEBNEditionPane.this.netWindow, resource.getString("nameError"), resource.getString("nameDuplicated"), 0);
                                }
                                catch (ReservedWordException e2) {
                                    JOptionPane.showMessageDialog(MEBNEditionPane.this.netWindow, resource.getString("nameError"), resource.getString("nameReserved"), 0);
                                }
                            } else {
                                MEBNEditionPane.this.txtNameMTheory.setBackground(MebnToolkit.getColorTextFieldError());
                                MEBNEditionPane.this.txtNameMTheory.setForeground(Color.WHITE);
                                MEBNEditionPane.this.txtNameMTheory.selectAll();
                                JOptionPane.showMessageDialog(MEBNEditionPane.this.netWindow, resource.getString("nameError"), resource.getString("nameException"), 0);
                            }
                        }
                        catch (BadLocationException ble) {
                            System.out.println(ble.getMessage());
                        }
                    }
                }

                public void keyReleased(KeyEvent e) {
                    try {
                        String name = MEBNEditionPane.this.txtNameMTheory.getText(0, MEBNEditionPane.this.txtNameMTheory.getText().length());
                        MEBNEditionPane.this.matcher = MEBNEditionPane.this.wordPattern.matcher(name);
                        if (!MEBNEditionPane.this.matcher.matches()) {
                            MEBNEditionPane.this.txtNameMTheory.setBackground(MebnToolkit.getColorTextFieldError());
                            MEBNEditionPane.this.txtNameMTheory.setForeground(Color.WHITE);
                        } else {
                            MEBNEditionPane.this.txtNameMTheory.setBackground(MebnToolkit.getColorTextFieldSelected());
                            MEBNEditionPane.this.txtNameMTheory.setForeground(Color.BLACK);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.add(btnMTheoryActive);
            JToolBar barName = new JToolBar();
            barName.add(MEBNEditionPane.this.txtNameMTheory);
            barName.setFloatable(false);
            this.add(barName);
            this.add(new EmptyPanel());
            this.add(new EmptyPanel());
            this.add(new EmptyPanel());
            this.setFloatable(false);
        }
    }

    private class ToolBarResidentNode
    extends JToolBar {
        private JLabel labelResidentName = new JLabel(String.valueOf(MEBNEditionPane.access$1().getString("nameLabel")) + " ");
        private ButtonLabel btnResidentActive;
        private JTextField txtNameResident;

        public ToolBarResidentNode() {
            this.btnResidentActive = new ButtonLabel(resource.getString("ResidentButton"), MEBNEditionPane.this.iconController.getResidentNodeIcon());
            this.btnResidentActive.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.setResidentNodeTabActive();
                }
            });
            this.txtNameResident = new JTextField(5);
            this.txtNameResident.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    ResidentNode nodeAux = MEBNEditionPane.this.mebnController.getResidentNodeActive();
                    if (e.getKeyCode() == 10 && ToolBarResidentNode.this.txtNameResident.getText().length() > 0) {
                        try {
                            String name = ToolBarResidentNode.this.txtNameResident.getText(0, ToolBarResidentNode.this.txtNameResident.getText().length());
                            MEBNEditionPane.this.matcher = MEBNEditionPane.this.wordPattern.matcher(name);
                            if (MEBNEditionPane.this.matcher.matches()) {
                                MEBNEditionPane.this.mebnController.renameDomainResidentNode(nodeAux, name);
                            } else {
                                ToolBarResidentNode.this.txtNameResident.setBackground(MebnToolkit.getColorTextFieldError());
                                ToolBarResidentNode.this.txtNameResident.setForeground(Color.WHITE);
                                ToolBarResidentNode.this.txtNameResident.selectAll();
                                JOptionPane.showMessageDialog(MEBNEditionPane.this.netWindow, resource.getString("nameError"), resource.getString("nameException"), 0);
                            }
                        }
                        catch (BadLocationException ble) {
                            System.out.println(ble.getMessage());
                        }
                        catch (DuplicatedNameException dne) {
                            JOptionPane.showMessageDialog(MEBNEditionPane.this.netWindow, resource.getString("nameAlreadyExists"), resource.getString("nameException"), 0);
                        }
                        catch (ReservedWordException e2) {
                            JOptionPane.showMessageDialog(MEBNEditionPane.this.netWindow, resource.getString("nameError"), resource.getString("nameReserved"), 0);
                        }
                    }
                }

                public void keyReleased(KeyEvent e) {
                    try {
                        String name = ToolBarResidentNode.this.txtNameResident.getText(0, ToolBarResidentNode.this.txtNameResident.getText().length());
                        MEBNEditionPane.this.matcher = MEBNEditionPane.this.wordPattern.matcher(name);
                        if (!MEBNEditionPane.this.matcher.matches()) {
                            ToolBarResidentNode.this.txtNameResident.setBackground(MebnToolkit.getColorTextFieldError());
                            ToolBarResidentNode.this.txtNameResident.setForeground(Color.WHITE);
                        } else {
                            ToolBarResidentNode.this.txtNameResident.setBackground(MebnToolkit.getColorTextFieldSelected());
                            ToolBarResidentNode.this.txtNameResident.setForeground(Color.BLACK);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.txtNameResident.addFocusListener(new FocusListenerTextField());
            MEBNEditionPane.this.txtArguments.setEditable(false);
            GridLayout grid = new GridLayout(1, 5);
            this.setLayout(grid);
            this.add(this.btnResidentActive);
            JToolBar barName = new JToolBar();
            barName.setFloatable(false);
            barName.add(this.txtNameResident);
            this.add(barName);
            JToolBar barOptions = new JToolBar();
            barOptions.setFloatable(false);
            barOptions.setLayout(new GridLayout(1, 5));
            JButton btnStateEdition = new JButton(MEBNEditionPane.this.iconController.getStateIcon());
            JButton btnEditTable = new JButton(MEBNEditionPane.this.iconController.getGridIcon());
            JButton btnEditArguments = new JButton(MEBNEditionPane.this.iconController.getArgumentsIcon());
            btnStateEdition.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.setResidentNodeTabActive();
                }
            });
            btnEditTable.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MEBNEditionPane.this.mebnController.setEnableTableEditionView();
                }
            });
            btnEditArguments.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MEBNEditionPane.this.setEditArgumentsTabActive();
                }
            });
            this.add(new EmptyPanel());
            this.add(new EmptyPanel());
            this.add(new EmptyPanel());
            this.setFloatable(false);
        }

        public JTextField getJTextFieldName() {
            return this.txtNameResident;
        }

        public void setNameResident(String txtNameResident) {
            this.txtNameResident.setText(txtNameResident);
        }
    }
}

