/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import unbbayes.controller.NetworkController;
import unbbayes.draw.DrawDashRectangle;
import unbbayes.draw.DrawElement;
import unbbayes.draw.IDrawable;
import unbbayes.gui.GraphAction;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.mebn.MultiEntityNode;
import unbbayes.prs.mebn.exception.CycleFoundException;
import unbbayes.prs.mebn.exception.MEBNConstructionException;
import unbbayes.prs.mebn.exception.MFragDoesNotExistException;
import unbbayes.util.GeometricUtil;

public class GraphPane
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 0L;
    private NetworkController controller;
    private List<Edge> edgeList;
    private ArrayList<Node> nodeList;
    private List<IDrawable> selectedGroup;
    private IDrawable selected;
    private Graphics2D graphBoard;
    private Point2D.Double startSelectionPoint;
    private Point2D.Double endSelectionPoint;
    private DrawElement drawSelection;
    private GraphAction action;
    private Node movingNode;
    private Edge movingEdge;
    private boolean bMoveEdge;
    private boolean bMoveNode;
    private static Color selectionColor;
    private static Color backgroundColor;
    private JViewport graphViewport;
    private Dimension visibleDimension;
    private Dimension graphDimension;
    private int direction;
    private JPopupMenu popup = new JPopupMenu();
    private static ResourceBundle resource;

    static {
        resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");
    }

    public GraphPane(final NetworkController controller, JViewport graphViewport) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(controller);
        this.controller = controller;
        this.setRequestFocusEnabled(true);
        this.graphViewport = graphViewport;
        this.setSize(800, 600);
        this.edgeList = controller.getGraph().getEdges();
        this.nodeList = controller.getGraph().getNodes();
        this.selectedGroup = new ArrayList<IDrawable>();
        this.startSelectionPoint = new Point2D.Double();
        this.endSelectionPoint = new Point2D.Double();
        this.drawSelection = new DrawDashRectangle(this.startSelectionPoint, this.endSelectionPoint);
        this.bMoveEdge = false;
        this.bMoveNode = false;
        selectionColor = Color.red;
        backgroundColor = Color.white;
        this.graphDimension = new Dimension(1500, 1500);
        this.visibleDimension = new Dimension(0, 0);
        this.action = GraphAction.NONE;
        JMenuItem item = new JMenuItem(resource.getString("properties"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                controller.showExplanationProperties((ProbabilisticNode)GraphPane.this.getSelected());
            }
        });
        this.popup.add(item);
    }

    public static void setSelectionColor(Color selectionColor) {
        GraphPane.selectionColor = selectionColor;
        DrawElement.setSelectionColor(selectionColor);
    }

    public void setBackgroundColor(Color backColor) {
        backgroundColor = backColor;
    }

    public void setGraphDimension(Dimension graphDimension) {
        this.graphDimension = graphDimension;
    }

    public Color getBackgroundColor() {
        return backgroundColor;
    }

    public static Color getSelectionColor() {
        return selectionColor;
    }

    public Object getSelected() {
        return this.selected;
    }

    public List getSelectedGroup() {
        return this.selectedGroup;
    }

    public Dimension getGraphDimension() {
        return this.graphDimension;
    }

    public Node getNode(double x, double y) {
        long width = Node.getWidth() / 2;
        long height = Node.getHeight() / 2;
        int i = 0;
        while (i < this.nodeList.size()) {
            Node nodeAux = this.nodeList.get(i);
            double x1 = nodeAux.getPosition().getX();
            double y1 = nodeAux.getPosition().getY();
            if (x >= x1 - (double)width && x <= x1 + (double)width && y >= y1 - (double)height && y <= y1 + (double)height) {
                return nodeAux;
            }
            ++i;
        }
        return null;
    }

    public boolean isFocusable() {
        return true;
    }

    public Edge getEdge(double x, double y) {
        int i = 0;
        while (i < this.edgeList.size()) {
            Edge arcoPegar = this.edgeList.get(i);
            double x1 = arcoPegar.getOriginNode().getPosition().getX();
            double y1 = arcoPegar.getOriginNode().getPosition().getY();
            double x2 = arcoPegar.getDestinationNode().getPosition().getX();
            double y2 = arcoPegar.getDestinationNode().getPosition().getY();
            double yTeste = (y2 - y1) / (x2 - x1) * x + (y1 - x1 * ((y2 - y1) / (x2 - x1)));
            double xTeste = (y - (y1 - x1 * ((y2 - y1) / (x2 - x1)))) / ((y2 - y1) / (x2 - x1));
            Node no1 = arcoPegar.getOriginNode();
            Node no2 = arcoPegar.getDestinationNode();
            Point2D.Double ponto1 = GeometricUtil.getCircunferenceTangentPoint(no1.getPosition(), no2.getPosition(), (Node.getWidth() + Node.getHeight()) / 4);
            Point2D.Double ponto2 = GeometricUtil.getCircunferenceTangentPoint(no2.getPosition(), no1.getPosition(), (Node.getWidth() + Node.getHeight()) / 4);
            if (ponto1.getX() < ponto2.getX() ? (y <= yTeste + 5.0 && y >= yTeste - 5.0 || x <= xTeste + 5.0 && x >= xTeste - 5.0) && (ponto1.getY() < ponto2.getY() ? y >= ponto1.getY() - 5.0 && y <= ponto2.getY() + 5.0 && x >= ponto1.getX() - 5.0 && x <= ponto2.getX() + 5.0 : y >= ponto2.getY() - 5.0 && y <= ponto1.getY() + 5.0 && x >= ponto1.getX() - 5.0 && x <= ponto2.getX() + 5.0) : (y <= yTeste + 5.0 && y >= yTeste - 5.0 || x <= xTeste + 5.0 && x >= xTeste - 5.0) && (ponto1.getY() < ponto2.getY() ? y >= ponto1.getY() - 5.0 && y <= ponto2.getY() + 5.0 && x >= ponto2.getX() - 5.0 && x <= ponto1.getX() + 5.0 : y >= ponto2.getY() - 5.0 && y <= ponto1.getY() + 5.0 && x >= ponto2.getX() - 5.0 && x <= ponto1.getX() + 5.0)) {
                return arcoPegar;
            }
            ++i;
        }
        return null;
    }

    public JViewport getGraphViewport() {
        return this.graphViewport;
    }

    public Point2D.Double getBiggestPoint() {
        double maiorX = 0.0;
        double maiorY = 0.0;
        long width = Node.getWidth() / 2;
        long height = Node.getHeight() / 2;
        int i = 0;
        while (i < this.nodeList.size()) {
            Node noAux = this.nodeList.get(i);
            if (maiorX < noAux.getPosition().getX() + (double)width) {
                maiorX = noAux.getPosition().getX() + (double)width;
            }
            if (maiorY < noAux.getPosition().getY() + (double)height) {
                maiorY = noAux.getPosition().getY() + (double)height;
            }
            ++i;
        }
        if (maiorX < this.visibleDimension.getWidth()) {
            maiorX = this.graphViewport.getViewSize().getWidth();
        }
        if (maiorY < this.visibleDimension.getHeight()) {
            maiorY = this.graphViewport.getViewSize().getHeight();
        }
        return new Point2D.Double(maiorX, maiorY);
    }

    public Rectangle getRectangleRepaint() {
        if (this.bMoveNode && this.selected instanceof Node) {
            Node noAux2;
            Node noAux = (Node)this.selected;
            double maiorX = noAux.getPosition().getX();
            double menorX = noAux.getPosition().getX();
            double maiorY = noAux.getPosition().getY();
            double menorY = noAux.getPosition().getY();
            int i = 0;
            while (i < noAux.getParents().size()) {
                noAux2 = noAux.getParents().get(i);
                if (maiorX < noAux2.getPosition().getX()) {
                    maiorX = noAux2.getPosition().getX();
                } else if (menorX > noAux2.getPosition().getX()) {
                    menorX = noAux2.getPosition().getX();
                }
                if (maiorY < noAux2.getPosition().getY()) {
                    maiorY = noAux2.getPosition().getY();
                } else if (menorY > noAux2.getPosition().getY()) {
                    menorY = noAux2.getPosition().getY();
                }
                ++i;
            }
            i = 0;
            while (i < noAux.getChildren().size()) {
                noAux2 = noAux.getChildren().get(i);
                if (maiorX < noAux2.getPosition().getX()) {
                    maiorX = noAux2.getPosition().getX();
                } else if (menorX > noAux2.getPosition().getX()) {
                    menorX = noAux2.getPosition().getX();
                }
                if (maiorY < noAux2.getPosition().getY()) {
                    maiorY = noAux2.getPosition().getY();
                } else if (menorY > noAux2.getPosition().getY()) {
                    menorY = noAux2.getPosition().getY();
                }
                ++i;
            }
            long width = Node.getWidth() / 2;
            long height = Node.getHeight() / 2;
            return new Rectangle((int)(menorX - (double)(6L * width)), (int)(menorY - (double)(6L * height)), (int)(maiorX - menorX + (double)(12L * width)), (int)(maiorY - menorY + (double)(12L * height)));
        }
        return new Rectangle(this.controller.getScreen().getJspGraph().getHorizontalScrollBar().getValue(), this.controller.getScreen().getJspGraph().getVerticalScrollBar().getValue(), (int)this.visibleDimension.getWidth(), (int)this.visibleDimension.getHeight());
    }

    public void update() {
        this.repaint(this.getRectangleRepaint());
    }

    public void mousePressed(MouseEvent e) {
        this.graphViewport.setScrollMode(1);
        if (e.getModifiers() == 16) {
            Node node = this.getNode(e.getX(), e.getY());
            Edge arc = this.getEdge(e.getX(), e.getY());
            switch (this.getAction()) {
                case CREATE_CONTINUOUS_NODE: {
                    this.controller.insertContinuousNode(e.getX(), e.getY());
                    return;
                }
                case CREATE_PROBABILISTIC_NODE: {
                    this.controller.insertProbabilisticNode(e.getX(), e.getY());
                    return;
                }
                case CREATE_DECISION_NODE: {
                    this.controller.insertDecisionNode(e.getX(), e.getY());
                    return;
                }
                case CREATE_UTILITY_NODE: {
                    this.controller.insertUtilityNode(e.getX(), e.getY());
                    return;
                }
                case CREATE_DOMAIN_MFRAG: {
                    this.controller.insertDomainMFrag();
                    return;
                }
                case CREATE_CONTEXT_NODE: {
                    try {
                        this.controller.insertContextNode(e.getX(), e.getY());
                        node = this.getNode(e.getX(), e.getY());
                        this.selectObject(node);
                        this.controller.selectNode(node);
                    }
                    catch (MEBNConstructionException exception) {
                        JOptionPane.showMessageDialog(this.controller.getScreen().getMebnEditionPane(), resource.getString("withoutMFrag"), resource.getString("operationError"), 2);
                    }
                    return;
                }
                case CREATE_RESIDENT_NODE: {
                    try {
                        this.controller.insertResidentNode(e.getX(), e.getY());
                        node = this.getNode(e.getX(), e.getY());
                        this.selectObject(node);
                        this.controller.selectNode(node);
                    }
                    catch (MEBNConstructionException exception) {
                        JOptionPane.showMessageDialog(this.controller.getScreen().getMebnEditionPane(), resource.getString("withoutMFrag"), resource.getString("operationError"), 2);
                    }
                    return;
                }
                case CREATE_INPUT_NODE: {
                    try {
                        this.controller.insertInputNode(e.getX(), e.getY());
                        node = this.getNode(e.getX(), e.getY());
                        this.selectObject(node);
                        this.controller.selectNode(node);
                    }
                    catch (MFragDoesNotExistException exception) {
                        JOptionPane.showMessageDialog(this.controller.getScreen().getMebnEditionPane(), resource.getString("withoutMFrag"), resource.getString("operationError"), 2);
                    }
                    return;
                }
                case CREATE_ORDINARYVARIABLE_NODE: {
                    try {
                        this.controller.getMebnController().insertOrdinaryVariable(e.getX(), e.getY());
                        node = this.getNode(e.getX(), e.getY());
                        this.selectObject(node);
                        this.controller.selectNode(node);
                    }
                    catch (MEBNConstructionException exception) {
                        JOptionPane.showMessageDialog(this.controller.getScreen().getMebnEditionPane(), resource.getString("withoutMFrag"), resource.getString("operationError"), 2);
                    }
                    return;
                }
                case CREATE_EDGE: {
                    if (node != null) {
                        this.bMoveEdge = true;
                        Node node2 = this.controller.getMebnController() != null ? new MultiEntityNode() : new ProbabilisticNode();
                        node2.setPosition(e.getX(), e.getY());
                        this.movingEdge = new Edge(node, node2);
                        this.movingEdge.setNew(true);
                    }
                    return;
                }
                case SELECT_MANY_OBJECTS: {
                    this.startSelectionPoint.setLocation(e.getX(), e.getY());
                    this.endSelectionPoint.setLocation(e.getX(), e.getY());
                    return;
                }
                case NONE: {
                    if (node != null) {
                        if (!node.isSelected()) {
                            this.selectObject(node);
                            this.controller.selectNode(node);
                            if (this.controller.getScreen().isCompiled()) {
                                int i = 0;
                                while (i < this.controller.getScreen().getEvidenceTree().getRowCount()) {
                                    if (this.controller.getScreen().getEvidenceTree().getPathForRow(i).getLastPathComponent().toString().equals(this.selected.toString())) {
                                        this.controller.getScreen().getEvidenceTree().setSelectionPath(this.controller.getScreen().getEvidenceTree().getPathForRow(i));
                                        break;
                                    }
                                    ++i;
                                }
                            }
                        }
                        if (this.selectedGroup.size() == 0) {
                            this.movingNode = node;
                            this.bMoveNode = true;
                            this.setCursor(new Cursor(13));
                        }
                    } else if (arc != null && !arc.isSelected()) {
                        this.selectObject(arc);
                    }
                    return;
                }
            }
        } else if (e.getModifiers() == 4) {
            this.setAction(GraphAction.NONE);
            this.controller.setResetButtonActive();
        }
        this.repaint(this.controller.getScreen().getJspGraph().getHorizontalScrollBar().getValue(), this.controller.getScreen().getJspGraph().getVerticalScrollBar().getValue(), (int)this.visibleDimension.getWidth(), (int)this.visibleDimension.getHeight());
    }

    public void mouseClicked(MouseEvent e) {
        this.requestFocus();
        Node node = this.getNode(e.getX(), e.getY());
        if (node != null) {
            if (e.getModifiers() == 16 && this.controller.getGraph() instanceof SingleEntityNetwork) {
                this.controller.createTable(node);
            }
        } else {
            Edge edge = this.getEdge(e.getX(), e.getY());
            if (edge != null && e.getModifiers() == 16 && e.getClickCount() == 2) {
                if (this.direction == 0 || this.direction == 1) {
                    ++this.direction;
                    edge.setDirection(true);
                    edge.changeDirection();
                } else if (this.direction == 2) {
                    this.direction = 0;
                    edge.setDirection(false);
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        Node destinationNode = this.getNode(e.getX(), e.getY());
        Edge edge = this.getEdge(e.getX(), e.getY());
        switch (this.getAction()) {
            case CREATE_EDGE: {
                if (e.getModifiers() != 16) break;
                Node originNode = this.movingEdge.getOriginNode();
                if (destinationNode != null && !originNode.equals(destinationNode) && this.controller.getGraph().hasEdge(originNode, destinationNode) == -1) {
                    this.movingEdge = new Edge(originNode, destinationNode);
                    this.insertEdge(this.movingEdge);
                }
                this.movingEdge = null;
                break;
            }
            case SELECT_MANY_OBJECTS: {
                this.endSelectionPoint.setLocation(e.getX(), e.getY());
                this.setSelectedGroup(this.startSelectionPoint, this.endSelectionPoint);
                this.startSelectionPoint.setLocation(-1.0, -1.0);
                this.endSelectionPoint.setLocation(-1.0, -1.0);
                break;
            }
            case NONE: {
                this.bMoveNode = false;
                this.setCursor(new Cursor(0));
                if (this.selected != null && (destinationNode != null && this.selected.equals(destinationNode) || edge != null && this.selected.equals(edge))) break;
                this.unselectAll();
                this.controller.unselectAll();
            }
        }
        if (this.bMoveEdge) {
            this.bMoveEdge = false;
        }
        if (e.getModifiers() == 4) {
            this.setAction(GraphAction.NONE);
        }
        this.update();
        if (e.isPopupTrigger() && this.getSelected() != null && !(this.getSelected() instanceof Edge) && ((Node)this.getSelected()).getInformationType() == 4) {
            this.popup.setEnabled(true);
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.bMoveNode && !this.bMoveEdge) {
            this.visibleDimension = new Dimension((int)this.controller.getScreen().getJspGraph().getSize().getWidth(), (int)this.controller.getScreen().getJspGraph().getSize().getHeight());
            this.graphViewport.setOpaque(true);
            this.graphViewport.scrollRectToVisible(new Rectangle(this.graphDimension));
            this.graphViewport.setPreferredSize(this.graphDimension);
            this.graphViewport.revalidate();
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.getAction() == GraphAction.SELECT_MANY_OBJECTS) {
            this.updateEndSelectionPoint(e.getX(), e.getY());
        }
        long width = Node.getWidth() / 2;
        long height = Node.getHeight() / 2;
        if ((double)e.getX() < this.graphDimension.getWidth() && (double)e.getY() < this.graphDimension.getHeight() && (double)((long)e.getX() + 2L * width) > this.visibleDimension.getWidth() + (double)this.controller.getScreen().getJspGraph().getHorizontalScrollBar().getValue() && (double)((long)e.getY() + 2L * height) > this.visibleDimension.getHeight() + (double)this.controller.getScreen().getJspGraph().getVerticalScrollBar().getValue()) {
            this.controller.getScreen().getJspGraph().getHorizontalScrollBar().setValue((int)((double)((long)e.getX() + 2L * width) - this.visibleDimension.getWidth()));
            this.controller.getScreen().getJspGraph().getVerticalScrollBar().setValue((int)((double)((long)e.getY() + 2L * height) - this.visibleDimension.getHeight()));
        } else if ((double)e.getX() < this.graphDimension.getWidth() && (double)((long)e.getX() + 2L * width) > this.visibleDimension.getWidth() + (double)this.controller.getScreen().getJspGraph().getHorizontalScrollBar().getValue() && (double)((long)e.getY() + 2L * height) <= this.visibleDimension.getHeight() + (double)this.controller.getScreen().getJspGraph().getVerticalScrollBar().getValue()) {
            this.controller.getScreen().getJspGraph().getHorizontalScrollBar().setValue((int)((double)((long)e.getX() + 2L * width) - this.visibleDimension.getWidth()));
        } else if ((double)e.getY() < this.graphDimension.getHeight() && (double)((long)e.getX() + 2L * width) <= this.visibleDimension.getWidth() + (double)this.controller.getScreen().getJspGraph().getHorizontalScrollBar().getValue() && (double)((long)e.getY() + 2L * height) > this.visibleDimension.getHeight() + (double)this.controller.getScreen().getJspGraph().getVerticalScrollBar().getValue()) {
            this.controller.getScreen().getJspGraph().getVerticalScrollBar().setValue((int)((double)((long)e.getY() + 2L * height) - this.visibleDimension.getHeight()));
        } else if (e.getX() > 0 && e.getY() > 0 && (long)e.getX() - width < (long)this.controller.getScreen().getJspGraph().getHorizontalScrollBar().getValue() && (long)e.getY() - height < (long)this.controller.getScreen().getJspGraph().getVerticalScrollBar().getValue()) {
            this.controller.getScreen().getJspGraph().getHorizontalScrollBar().setValue((int)((long)e.getX() - width));
            this.controller.getScreen().getJspGraph().getVerticalScrollBar().setValue((int)((long)e.getY() - height));
        } else if (e.getY() > 0 && (long)e.getX() - width >= (long)this.controller.getScreen().getJspGraph().getHorizontalScrollBar().getValue() && (long)e.getY() - height < (long)this.controller.getScreen().getJspGraph().getVerticalScrollBar().getValue()) {
            this.controller.getScreen().getJspGraph().getVerticalScrollBar().setValue((int)((long)e.getY() - height));
        } else if (e.getX() > 0 && (long)e.getX() - width < (long)this.controller.getScreen().getJspGraph().getHorizontalScrollBar().getValue() && (long)e.getY() - height >= (long)this.controller.getScreen().getJspGraph().getVerticalScrollBar().getValue()) {
            this.controller.getScreen().getJspGraph().getHorizontalScrollBar().setValue((int)((long)e.getX() - width));
        }
        if (e.getModifiers() == 16) {
            int compareX = 0;
            int compareY = 0;
            int x = -1;
            int y = -1;
            if (this.bMoveNode) {
                compareX = (int)width;
                compareY = (int)height;
            }
            if (e.getX() > compareX && e.getY() > compareY && (double)e.getX() < this.graphDimension.getWidth() - (double)compareX && (double)e.getY() < this.graphDimension.getHeight() - (double)compareY) {
                x = e.getX();
                y = e.getY();
            } else if (e.getX() <= compareX && e.getY() > compareY && (double)e.getX() < this.graphDimension.getWidth() - (double)compareX && (double)e.getY() < this.graphDimension.getHeight() - (double)compareY) {
                x = compareX;
                y = e.getY();
            } else if (e.getX() > compareX && e.getY() <= compareY && (double)e.getX() < this.graphDimension.getWidth() - (double)compareX && (double)e.getY() < this.graphDimension.getHeight() - (double)compareY) {
                x = e.getX();
                y = compareY;
            } else if (e.getX() <= compareX && e.getY() <= compareY && (double)e.getX() < this.graphDimension.getWidth() - (double)compareX && (double)e.getY() < this.graphDimension.getHeight() - (double)compareY) {
                x = compareX;
                y = compareY;
            } else if (e.getX() <= compareX && e.getY() > compareY && (double)e.getX() < this.graphDimension.getWidth() - (double)compareX && (double)e.getY() >= this.graphDimension.getHeight() - (double)compareY) {
                x = compareX;
                y = (int)this.graphDimension.getHeight() - compareY;
            } else if (e.getX() > compareX && e.getY() > compareY && (double)e.getX() < this.graphDimension.getWidth() - (double)compareX && (double)e.getY() >= this.graphDimension.getHeight() - (double)compareY) {
                x = e.getX();
                y = (int)this.graphDimension.getHeight() - compareY;
            } else if (e.getX() > compareX && e.getY() > compareY && (double)e.getX() >= this.graphDimension.getWidth() - (double)compareX && (double)e.getY() >= this.graphDimension.getHeight() - (double)compareY) {
                x = (int)this.graphDimension.getWidth() - compareX;
                y = (int)this.graphDimension.getHeight() - compareY;
            } else if (e.getX() > compareX && e.getY() > compareY && (double)e.getX() >= this.graphDimension.getWidth() - (double)compareX && (double)e.getY() < this.graphDimension.getHeight() - (double)compareY) {
                x = (int)this.graphDimension.getWidth() - compareX;
                y = e.getY();
            } else if (e.getX() > compareX && e.getY() <= compareY && (double)e.getX() >= this.graphDimension.getWidth() - (double)compareX && (double)e.getY() < this.graphDimension.getHeight() - (double)compareY) {
                x = (int)this.graphDimension.getWidth() - compareX;
                y = compareY;
            }
            if (x != -1 && y != -1) {
                if (this.getAction() == GraphAction.CREATE_EDGE && this.bMoveEdge) {
                    this.updateMovingEdge(x, y);
                } else if (this.bMoveNode) {
                    this.updateMovingNode(x, y);
                }
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void selectObject(IDrawable object) {
        this.unselectAll();
        object.setSelected(true);
        this.selected = object;
    }

    public void updateMovingEdge(double x, double y) {
        this.movingEdge.setDestinationPosition(x, y);
        this.update();
    }

    public void updateMovingNode(double x, double y) {
        this.movingNode.setPosition(x, y);
        this.update();
    }

    public void updateEndSelectionPoint(double x, double y) {
        this.endSelectionPoint.setLocation(x, y);
        this.update();
    }

    public void insertEdge(Edge edge) {
        try {
            this.controller.insertEdge(edge);
        }
        catch (MEBNConstructionException me) {
            JOptionPane.showMessageDialog(this.controller.getScreen().getMebnEditionPane(), me.getMessage(), resource.getString("error"), 0);
        }
        catch (CycleFoundException cycle) {
            JOptionPane.showMessageDialog(this.controller.getScreen().getMebnEditionPane(), cycle.getMessage(), resource.getString("error"), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        edge.setNew(false);
        this.update();
    }

    public void setSelectedGroup(Point2D.Double p1, Point2D.Double p2) {
        this.unselectAll();
        int i = 0;
        while (i < this.nodeList.size()) {
            Node nodeAux = this.nodeList.get(i);
            if ((p1.getX() <= p2.getX() && nodeAux.getPosition().getX() >= p1.getX() && nodeAux.getPosition().getX() <= p2.getX() || p2.getX() < p1.getX() && nodeAux.getPosition().getX() >= p2.getX() && nodeAux.getPosition().getX() <= p1.getX()) && (p1.getY() <= p2.getY() && nodeAux.getPosition().getY() >= p1.getY() && nodeAux.getPosition().getY() <= p2.getY() || p2.getY() < p1.getY() && nodeAux.getPosition().getY() >= p2.getY() && nodeAux.getPosition().getY() <= p1.getY())) {
                this.selectedGroup.add(nodeAux);
                nodeAux.setSelected(true);
            }
            ++i;
        }
        i = 0;
        while (i < this.edgeList.size()) {
            Edge arcAux = this.edgeList.get(i);
            Node nodeAux2 = arcAux.getDestinationNode();
            if ((p1.getX() <= p2.getX() && nodeAux2.getPosition().getX() >= p1.getX() && nodeAux2.getPosition().getX() <= p2.getX() || p2.getX() < p1.getX() && nodeAux2.getPosition().getX() >= p2.getX() && nodeAux2.getPosition().getX() <= p1.getX()) && (p1.getY() <= p2.getY() && nodeAux2.getPosition().getY() >= p1.getY() && nodeAux2.getPosition().getY() <= p2.getY() || p2.getY() < p1.getY() && nodeAux2.getPosition().getY() >= p2.getY() && nodeAux2.getPosition().getY() <= p1.getY())) {
                this.selectedGroup.add(arcAux);
                arcAux.setSelected(true);
            }
            ++i;
        }
    }

    public void unselectAll() {
        if (this.selected != null) {
            this.selected.setSelected(false);
            this.selected = null;
        }
        int i = 0;
        while (i < this.selectedGroup.size()) {
            this.selectedGroup.get(i).setSelected(false);
            ++i;
        }
        this.selectedGroup.clear();
    }

    public void setAction(GraphAction action) {
        switch (action) {
            case CREATE_CONTINUOUS_NODE: 
            case CREATE_PROBABILISTIC_NODE: 
            case CREATE_DECISION_NODE: 
            case CREATE_UTILITY_NODE: 
            case CREATE_CONTEXT_NODE: 
            case CREATE_INPUT_NODE: 
            case CREATE_RESIDENT_NODE: 
            case CREATE_ORDINARYVARIABLE_NODE: {
                this.setCursor(new Cursor(12));
                break;
            }
            case CREATE_EDGE: 
            case SELECT_MANY_OBJECTS: {
                this.setCursor(new Cursor(1));
                break;
            }
            default: {
                this.setCursor(new Cursor(0));
            }
        }
        this.action = action;
    }

    public GraphAction getAction() {
        return this.action;
    }

    public void resetGraph() {
        this.edgeList = this.controller.getGraph().getEdges();
        this.nodeList = this.controller.getGraph().getNodes();
        this.selectedGroup = new ArrayList<IDrawable>();
        this.startSelectionPoint = new Point2D.Double();
        this.endSelectionPoint = new Point2D.Double();
        this.drawSelection = new DrawDashRectangle(this.startSelectionPoint, this.endSelectionPoint);
        this.bMoveEdge = false;
        this.bMoveNode = false;
        this.graphDimension = new Dimension(1500, 1500);
        this.visibleDimension = new Dimension(0, 0);
        this.action = GraphAction.NONE;
        JMenuItem item = new JMenuItem(resource.getString("properties"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GraphPane.this.controller.showExplanationProperties((ProbabilisticNode)GraphPane.this.getSelected());
            }
        });
        this.popup.add(item);
        this.repaint();
    }

    public void showEmptyGraph() {
        this.edgeList = new ArrayList<Edge>();
        this.nodeList = new ArrayList();
        this.selectedGroup = new ArrayList<IDrawable>();
        this.startSelectionPoint = new Point2D.Double();
        this.endSelectionPoint = new Point2D.Double();
        this.drawSelection = new DrawDashRectangle(this.startSelectionPoint, this.endSelectionPoint);
        this.bMoveEdge = false;
        this.bMoveNode = false;
        this.graphDimension = new Dimension(1500, 1500);
        this.visibleDimension = new Dimension(0, 0);
        this.action = GraphAction.NONE;
        this.repaint();
    }

    public void paint(Graphics g) {
        this.graphBoard = (Graphics2D)g;
        this.graphBoard.setBackground(this.getBackgroundColor());
        this.graphBoard.clearRect(this.controller.getScreen().getJspGraph().getHorizontalScrollBar().getValue(), this.controller.getScreen().getJspGraph().getVerticalScrollBar().getValue(), (int)this.controller.getScreen().getJspGraph().getSize().getWidth(), (int)this.controller.getScreen().getJspGraph().getSize().getHeight());
        this.graphBoard.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.getAction() == GraphAction.SELECT_MANY_OBJECTS) {
            this.drawSelection.paint(this.graphBoard);
        }
        this.graphBoard.setStroke(new BasicStroke(1.0f));
        int i = 0;
        while (i < this.nodeList.size()) {
            this.nodeList.get(i).paint(this.graphBoard);
            ++i;
        }
        if (this.bMoveEdge) {
            this.movingEdge.paint(this.graphBoard);
        }
        for (Edge edge : this.edgeList) {
            edge.paint(this.graphBoard);
        }
    }
}

