/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import unbbayes.controller.IconController;

public class FileIcon
extends FileView {
    private JFileChooser fc;
    private Component observer;
    protected IconController iconController = IconController.getInstance();
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    public FileIcon(Component c) {
        this.observer = c;
        this.fc = new JFileChooser();
    }

    public String getDescription(File f) {
        return this.getTypeDescription(f);
    }

    public Icon getIcon(File f) {
        String name = f.getName();
        if (name.endsWith(".arff")) {
            return this.iconController.getArffFileIcon();
        }
        if (name.toLowerCase().endsWith(".txt")) {
            return this.iconController.getTxtFileIcon();
        }
        if (name.toLowerCase().endsWith(".net")) {
            return this.iconController.getNetFileIcon();
        }
        return this.fc.getIcon(f);
    }

    public String getName(File f) {
        String name = f.getName();
        return name.equals("") ? f.getPath() : name;
    }

    public String getTypeDescription(File f) {
        String name = f.getName().toLowerCase();
        if (f.isDirectory()) {
            return resource.getString("fileDirectoryType");
        }
        if (name.endsWith(".arff")) {
            return resource.getString("fileARFFType");
        }
        if (name.endsWith(".txt")) {
            return resource.getString("fileTXTType");
        }
        if (name.endsWith(".net")) {
            return resource.getString("fileNETType");
        }
        return resource.getString("fileGenericType");
    }

    public boolean isTranversable(File f) {
        return f.isDirectory();
    }

    public class Icon16
    extends ImageIcon {
        private static final long serialVersionUID = 0L;

        public Icon16(String f) {
            super(f);
            Image i = FileIcon.this.observer.createImage(16, 16);
            i.getGraphics().drawImage(this.getImage(), 0, 0, 16, 16, FileIcon.this.observer);
            this.setImage(i);
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawImage(this.getImage(), x, y, c);
        }
    }
}

